/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice.mobile;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.enums.UnitConvertDirEnum;
import kd.scmc.pm.mservice.mobile.IPmEntityService;

public class RequireApplyService
implements IPmEntityService {
    private static final String FIELD = "field";
    private static final String BILLENTRY_QTY = "billentry.qty";
    private static final String ENTRY_ID = "entryId";
    private static final String UNIT_CONVERT_DIR = "unitconvertdir";

    @Override
    public DynamicObject propChanged(DynamicObject bill, List<Map<String, Object>> changedFields) {
        for (Map<String, Object> changedField : changedFields) {
            String fieldKey = (String)changedField.get(FIELD);
            if (!BILLENTRY_QTY.equals(fieldKey)) continue;
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            Long entryId = (Long)changedField.get(ENTRY_ID);
            for (DynamicObject entry : billEntry) {
                Long pkValue = (Long)entry.getPkValue();
                if (entryId == null || entryId.compareTo(0L) == 0 || entryId.compareTo(pkValue) != 0) continue;
                this.changeQty(entry);
            }
        }
        return bill;
    }

    private void changeQty(DynamicObject entry) {
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject materialMaster = entry.getDynamicObject("materialmasterid");
        DynamicObject unit = entry.getDynamicObject("unit");
        if (materialMaster == null || unit == null) {
            return;
        }
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        DynamicObject auxUnit = entry.getDynamicObject("auxunit");
        if (baseUnit == null) {
            baseUnit = materialMaster.getDynamicObject("baseunit");
        }
        if (baseUnit != null) {
            Long materialMasterId = (Long)materialMaster.getPkValue();
            BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
            entry.set("baseqty", (Object)baseQty);
            if (auxUnit != null) {
                String unitConvertDir = materialMaster.getString(UNIT_CONVERT_DIR);
                if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                    entry.set("auxqty", (Object)auxQty);
                }
            }
        }
    }
}

