/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;

public class MaterialPurInfoBaseQtyUpdateServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(MaterialPurInfoBaseQtyUpdateServiceImpl.class);
    private static final int BATCHSIZE = 2000;
    private static final DBRoute SYSROUTE = new DBRoute("sys");
    private static final String FIDS_KEY = "FIDLIST_KEY";
    private static final BigDecimal MAXBIGDECIMAL = new BigDecimal("9999999999999.9999999999");
    private Map<String, UnitConvertInfo> cacheMaterialConvertRate = new HashMap<String, UnitConvertInfo>(10);
    private Map<Long, Map<String, Object>> unitInfoMap = new HashMap<Long, Map<String, Object>>(10);
    private List<UnitConvertInfo> commonUnitConvertInfoList = null;
    protected String noBaseQtySql = "SELECT FID,FMASTERID,FPURCHASEUNITID,FBASEUNITID,FMAXBILLQTY,FMAXBILLBASEQTY,FMINBILLQTY,FMINBILLBASEQTY,FPACKINGQTY,FPACKINGBASEQTY FROM T_BD_MATERIALPURINFO WHERE FID IN ( FIDLIST_KEY ) ";
    protected String updateQtySql = "UPDATE T_BD_MATERIALPURINFO SET  FPACKINGBASEQTY = ? ,FMAXBILLBASEQTY = ? ,FMINBILLBASEQTY = ?  WHERE FID = ?";
    protected String queryFidSql = "SELECT FID FROM T_BD_MATERIALPURINFO  WHERE  FPURCHASEUNITID <> FBASEUNITID AND ((FPACKINGBASEQTY = 0  AND FPACKINGQTY  <> 0 ) OR (FMAXBILLQTY <> 0 AND FMAXBILLBASEQTY = 0 ) OR (FMINBILLQTY <> 0 AND FMINBILLBASEQTY = 0 ))";
    String queryMatUnitSql = "SELECT FMATERIALID,FMEASUREUNITID,FNUMERATOR,FDENOMINATOR,FCONVERTTYPE FROM T_BD_MULTIMEASUREUNIT WHERE FCONVERTTYPE = '1' AND FMATERIALID IN ( FMATERIALMASTERID_KEY )";
    String queryCommonUnitSql = "SELECT FSRCMUID,FDESMUID,FDENOMINATOR,FNUMERATOR,FCONVERTTYPE FROM T_BD_MEASUREUNITCONV WHERE FCONVERTTYPE = '1' ";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        log.info("\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u57fa\u672c\u6570\u91cf\u6570\u636e\u5347\u7ea7\u670d\u52a1\u5f00\u59cb");
        UpgradeResult result = new UpgradeResult();
        ThreadPools.executeOnce((String)this.getClass().getName(), () -> this.updateBaseQty(result));
        return result;
    }

    private UpgradeResult updateBaseQty(UpgradeResult result) {
        this.unitInfoMap = this.getUsedUnitInfoMap();
        List<Long> fIdList = this.getUpdateEntryIds(this.queryFidSql);
        log.info("\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u57fa\u672c\u6570\u91cf\u6570\u636e\u5347\u7ea7\u670d\u52a1,\u672c\u6b21\u5f85\u5347\u7ea7\u6570\u636e\u91cf\u4e3a\uff1a" + fIdList.size());
        if (fIdList.isEmpty()) {
            return result;
        }
        List<List<Long>> batchs = this.splitList(fIdList);
        fIdList = null;
        Iterator<List<Long>> iterator = batchs.iterator();
        while (iterator.hasNext()) {
            List<Long> oneBatch = iterator.next();
            result = this.excuteOneBatchQty(oneBatch, result);
            if (!result.isSuccess()) {
                return result;
            }
            iterator.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpgradeResult excuteOneBatchQty(List<Long> oneBatch, UpgradeResult result) {
        if (oneBatch == null || oneBatch.isEmpty()) {
            return result;
        }
        String queryMatPurInfoSql = this.getQueryEntryInfoSql(this.noBaseQtySql, oneBatch, FIDS_KEY);
        if (queryMatPurInfoSql == null) {
            return result;
        }
        oneBatch = null;
        ArrayList<Object[]> sqlParam = new ArrayList<Object[]>(10);
        HashMap<Long, CalBaseQtyInfo> calQtyInfoMap = new HashMap<Long, CalBaseQtyInfo>(16);
        try (DataSet rows = null;){
            rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SYSROUTE, (String)queryMatPurInfoSql);
            for (Row row : rows) {
                Long baseunitId = row.getLong("FBASEUNITID");
                Long purUnitId = row.getLong("FPURCHASEUNITID");
                Long materialMasterId = row.getLong("FMASTERID");
                Long fid = row.getLong("FID");
                BigDecimal maxBaseQty = row.getBigDecimal("FMAXBILLBASEQTY");
                BigDecimal maxQty = row.getBigDecimal("FMAXBILLQTY");
                BigDecimal minBaseQty = row.getBigDecimal("FMINBILLBASEQTY");
                BigDecimal minQty = row.getBigDecimal("FMINBILLQTY");
                BigDecimal packingQty = row.getBigDecimal("FPACKINGQTY");
                BigDecimal packingBaseQty = row.getBigDecimal("FPACKINGBASEQTY");
                if (baseunitId == null || purUnitId == null || materialMasterId == null || packingQty == null || baseunitId.equals(0L) || purUnitId.equals(0L) || materialMasterId.equals(0L) || baseunitId.equals(purUnitId)) continue;
                calQtyInfoMap.put(fid, new CalBaseQtyInfo(purUnitId, baseunitId, materialMasterId, packingQty, packingBaseQty, minQty, minBaseQty, maxQty, maxBaseQty));
            }
        }
        if (!calQtyInfoMap.isEmpty()) {
            sqlParam.addAll(this.convertQtyByUnitRate(calQtyInfoMap));
        }
        calQtyInfoMap = null;
        if (sqlParam == null || sqlParam.isEmpty()) {
            return result;
        }
        return this.updateDB(sqlParam, this.updateQtySql);
    }

    private UpgradeResult updateDB(List<Object[]> sqlParam, String updateSql) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.required((String)this.getClass().getName());){
            try {
                DB.executeBatch((DBRoute)SYSROUTE, (String)updateSql, sqlParam);
                sqlParam = null;
                tx.commit();
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error("\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u57fa\u672c\u6570\u91cf\u5347\u7ea7\u6267\u884c\u5931\u8d25\u3002" + updateSql, e);
                result.setSuccess(false);
                String errorInfo = "database execution failed,errorInfo" + e.getMessage();
                result.setErrorInfo(errorInfo);
                result.setLog(errorInfo);
                UpgradeResult upgradeResult = result;
                if (tx != null) {
                    if (var5_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return upgradeResult;
            }
        }
        return result;
    }

    private Object[] getParamResult(Long fid, CalBaseQtyInfo info, Map<String, Object> baseUnitInfo, BigDecimal denominator, BigDecimal numerator) {
        BigDecimal maxOrderQty = info.getMaxOrderQty();
        BigDecimal maxOrderBaseQty = info.getMaxOrderBaseQty();
        BigDecimal minOrderQty = info.getMinOrderQty();
        BigDecimal minOrderBaseQty = info.getMinOrderBaseQty();
        BigDecimal packingQty = info.getPackingQty();
        BigDecimal packingBaseQty = info.getPackingBaseQty();
        if (packingQty != null && packingBaseQty != null && packingQty.compareTo(BigDecimal.ZERO) != 0 && packingBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            packingBaseQty = this.getDesQty(packingQty, numerator, denominator, baseUnitInfo);
        }
        if (maxOrderQty != null && maxOrderBaseQty != null && maxOrderQty.compareTo(BigDecimal.ZERO) != 0 && maxOrderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            maxOrderBaseQty = this.getDesQty(maxOrderQty, numerator, denominator, baseUnitInfo);
        }
        if (minOrderQty != null && minOrderBaseQty != null && minOrderQty.compareTo(BigDecimal.ZERO) != 0 && minOrderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            minOrderBaseQty = this.getDesQty(minOrderQty, numerator, denominator, baseUnitInfo);
        }
        return this.getParamArray(fid, packingBaseQty, maxOrderBaseQty, minOrderBaseQty);
    }

    private List<Object[]> convertQtyByUnitRate(Map<Long, CalBaseQtyInfo> unitConvertMap) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        Iterator<Map.Entry<Long, CalBaseQtyInfo>> iterator = unitConvertMap.entrySet().iterator();
        while (iterator.hasNext()) {
            UnitConvertInfo unitConvertInfo;
            String cacheKey;
            Map.Entry<Long, CalBaseQtyInfo> entry = iterator.next();
            CalBaseQtyInfo calBaseQtyInfo = entry.getValue();
            if (calBaseQtyInfo == null || StringUtils.isBlank((CharSequence)(cacheKey = this.getCacheKey(calBaseQtyInfo))) || (unitConvertInfo = this.cacheMaterialConvertRate.get(cacheKey)) == null) continue;
            Long denominator = unitConvertInfo.getDenominator();
            Long numerator = unitConvertInfo.getNumerator();
            Map<String, Object> unitMap = this.unitInfoMap.get(calBaseQtyInfo.getBaseUnitId());
            paramList.add(this.getParamResult(entry.getKey(), calBaseQtyInfo, unitMap, new BigDecimal(denominator), new BigDecimal(numerator)));
            iterator.remove();
        }
        if (unitConvertMap.isEmpty()) {
            return paramList;
        }
        Map<Long, List<UnitConvertInfo>> materialUnitMap = this.queryMaterialUnit(unitConvertMap);
        if (!materialUnitMap.isEmpty()) {
            paramList.addAll(this.calBaseQtyByMatUnitInfo(unitConvertMap, materialUnitMap));
        }
        if (unitConvertMap.isEmpty()) {
            return paramList;
        }
        if (this.commonUnitConvertInfoList == null) {
            this.commonUnitConvertInfoList = this.queryCommonUnitConvertInfos();
        }
        paramList.addAll(this.calBaseQtyByMatAndCommonUnitInfo(unitConvertMap, materialUnitMap, this.commonUnitConvertInfoList));
        return paramList;
    }

    private List<Object[]> calBaseQtyByMatAndCommonUnitInfo(Map<Long, CalBaseQtyInfo> unitConvertMap, Map<Long, List<UnitConvertInfo>> materialUnitMap, List<UnitConvertInfo> commonUnitConvertInfoList) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, CalBaseQtyInfo> next : unitConvertMap.entrySet()) {
            CalBaseQtyInfo calInfo = next.getValue();
            Long baseUnitId = calInfo.getBaseUnitId();
            Long unitId = calInfo.getUnitId();
            Map<String, Object> baseUnitInfo = this.unitInfoMap.get(baseUnitId);
            if (baseUnitInfo == null) continue;
            Long materialMasterId = calInfo.getMaterialMasterId();
            UnitConvertInfo unitConvertInfo = this.getMatchUnitInfo(unitId, baseUnitId, commonUnitConvertInfoList);
            if (unitConvertInfo == null) {
                List<Object> unitConvertInfos = materialUnitMap.get(materialMasterId) == null ? new ArrayList(10) : materialUnitMap.get(materialMasterId);
                unitConvertInfos.addAll(commonUnitConvertInfoList);
                unitConvertInfos = this.combindResultList(unitConvertInfos);
                unitConvertInfo = this.getMatchUnitInfo(unitId, baseUnitId, unitConvertInfos);
                if (unitConvertInfo != null) {
                    String cacheKey = this.getCacheKey(calInfo);
                    this.cacheMaterialConvertRate.put(cacheKey, unitConvertInfo);
                }
            }
            if (unitConvertInfo == null) continue;
            paramList.add(this.getParamResult(next.getKey(), calInfo, baseUnitInfo, new BigDecimal(unitConvertInfo.getDenominator()), new BigDecimal(unitConvertInfo.getNumerator())));
        }
        return paramList;
    }

    private List<UnitConvertInfo> combindResultList(List<UnitConvertInfo> unitConvertInfos) {
        if (null == unitConvertInfos || unitConvertInfos.isEmpty()) {
            return unitConvertInfos;
        }
        ArrayList<UnitConvertInfo> mirroList = new ArrayList<UnitConvertInfo>(unitConvertInfos.size());
        for (UnitConvertInfo convertInfo : unitConvertInfos) {
            UnitConvertInfo info = new UnitConvertInfo(convertInfo.getDesUnitId(), convertInfo.getSrcUnitId(), convertInfo.getDenominator(), convertInfo.getNumerator(), convertInfo.getConvertTYpe());
            mirroList.add(info);
        }
        unitConvertInfos.addAll(mirroList);
        return unitConvertInfos;
    }

    private UnitConvertInfo getMatchUnitInfo(Long srcUnitId, Long tarUnitId, List<UnitConvertInfo> unitInfoList) {
        if (unitInfoList == null || unitInfoList.isEmpty()) {
            return null;
        }
        UnitConvertInfo result = null;
        for (UnitConvertInfo unitInfo : unitInfoList) {
            Long sUnitId = unitInfo.getSrcUnitId();
            Long desUnitId = unitInfo.getDesUnitId();
            if (sUnitId == null || desUnitId == null || srcUnitId == null || tarUnitId == null) continue;
            if (srcUnitId.compareTo(sUnitId) == 0 && desUnitId.compareTo(tarUnitId) == 0) {
                result = unitInfo;
                break;
            }
            if (sUnitId.compareTo(tarUnitId) != 0 || desUnitId.compareTo(srcUnitId) != 0) continue;
            result = new UnitConvertInfo(unitInfo.getDenominator(), unitInfo.getNumerator());
            break;
        }
        if (result == null) {
            Long[] conv;
            Long old_numerator = 1L;
            Long old_denominator = 1L;
            Long old_convertType = 1L;
            Map<String, Long[]> allConv = new HashMap<String, Long[]>();
            if ((allConv = this.indirectConv(srcUnitId, unitInfoList, old_numerator, old_denominator, old_convertType, allConv, srcUnitId)) != null && null != (conv = allConv.get(srcUnitId + "-" + tarUnitId))) {
                result = new UnitConvertInfo(conv[0], conv[1]);
            }
        }
        return result;
    }

    private Map<String, Long[]> indirectConv(Long srcmuid, List<UnitConvertInfo> unitInfoList, Long old_numerator, Long old_denominator, Long oLdConvertType, Map<String, Long[]> allConv, Long initSrcId) {
        Long[] conv = null;
        for (UnitConvertInfo info : unitInfoList) {
            Long srcId = info.getSrcUnitId();
            Long desId = info.getDesUnitId();
            if (srcmuid == null || srcId == null || !srcmuid.equals(srcId) || allConv.containsKey(initSrcId + "-" + desId)) continue;
            Long numerator = info.getNumerator();
            Long denominator = info.getDenominator();
            numerator = old_numerator * numerator;
            denominator = old_denominator * denominator;
            Long convertTYpe = Long.parseLong(info.getConvertTYpe());
            conv = new Long[]{numerator, denominator, convertTYpe};
            allConv.put(initSrcId + "-" + desId, conv);
            this.indirectConv(desId, unitInfoList, numerator, denominator, convertTYpe, allConv, initSrcId);
        }
        return allConv;
    }

    private List<UnitConvertInfo> queryCommonUnitConvertInfos() {
        ArrayList<UnitConvertInfo> infoList = new ArrayList<UnitConvertInfo>(10);
        try (DataSet rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SYSROUTE, (String)this.queryCommonUnitSql);){
            for (Row row : rows) {
                Long srcmuid = row.getLong("FSRCMUID");
                Long desmuid = row.getLong("FDESMUID");
                Long numerator = row.getLong("FNUMERATOR");
                Long denominator = row.getLong("FDENOMINATOR");
                String convertType = row.getString("FCONVERTTYPE");
                UnitConvertInfo info = new UnitConvertInfo(srcmuid, desmuid, numerator, denominator, convertType);
                infoList.add(info);
            }
        }
        return infoList;
    }

    private List<Object[]> calBaseQtyByMatUnitInfo(Map<Long, CalBaseQtyInfo> unitConvertMap, Map<Long, List<UnitConvertInfo>> materialUnitMap) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        Iterator<Map.Entry<Long, CalBaseQtyInfo>> iterator = unitConvertMap.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Long materialMasterId;
            List<UnitConvertInfo> unitConvertInfos;
            Map.Entry<Long, CalBaseQtyInfo> entry = iterator.next();
            CalBaseQtyInfo calBaseQtyInfo = entry.getValue();
            if (calBaseQtyInfo == null || (unitConvertInfos = materialUnitMap.get(materialMasterId = calBaseQtyInfo.getMaterialMasterId())) == null || unitConvertInfos.isEmpty()) continue;
            Long baseUnitId = calBaseQtyInfo.getBaseUnitId();
            Long unitId = calBaseQtyInfo.getUnitId();
            for (UnitConvertInfo convertInfo : unitConvertInfos) {
                Long srcUnitId = convertInfo.getSrcUnitId();
                if (unitId == null || srcUnitId == null || !unitId.equals(srcUnitId)) continue;
                Long denominator = convertInfo.getDenominator();
                Long numerator = convertInfo.getNumerator();
                Map<String, Object> baseUnitMap = this.unitInfoMap.get(baseUnitId);
                paramList.add(this.getParamResult(entry.getKey(), calBaseQtyInfo, baseUnitMap, new BigDecimal(denominator), new BigDecimal(numerator)));
                iterator.remove();
                continue block0;
            }
        }
        return paramList;
    }

    private Map<Long, List<UnitConvertInfo>> queryMaterialUnit(Map<Long, CalBaseQtyInfo> unitConvertMap) {
        HashMap<Long, List<UnitConvertInfo>> resultMap = new HashMap<Long, List<UnitConvertInfo>>(10);
        HashMap materialMasterIdAndBaseUntiIdMap = new HashMap(10);
        unitConvertMap.values().forEach(info -> {
            if (info != null) {
                materialMasterIdAndBaseUntiIdMap.put(info.getMaterialMasterId(), info.getBaseUnitId());
            }
        });
        this.queryMatUnitSql = this.getQueryEntryInfoSql(this.queryMatUnitSql, new ArrayList<Long>(materialMasterIdAndBaseUntiIdMap.keySet()), "FMATERIALMASTERID_KEY");
        try (DataSet rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SYSROUTE, (String)this.queryMatUnitSql);){
            for (Row row : rows) {
                Long materialMasterId = row.getLong("FMATERIALID");
                ArrayList<UnitConvertInfo> unitConvertInfos = (ArrayList<UnitConvertInfo>)resultMap.get(materialMasterId);
                if (unitConvertInfos == null) {
                    unitConvertInfos = new ArrayList<UnitConvertInfo>(10);
                }
                Long srcmuid = row.getLong("FMEASUREUNITID");
                Long baseUnitId = (Long)materialMasterIdAndBaseUntiIdMap.get(materialMasterId);
                Long numerator = row.getLong("FNUMERATOR");
                Long denominator = row.getLong("FDENOMINATOR");
                String convertType = row.getString("FCONVERTTYPE");
                UnitConvertInfo info2 = new UnitConvertInfo(srcmuid, baseUnitId, numerator, denominator, convertType);
                unitConvertInfos.add(info2);
                resultMap.put(materialMasterId, unitConvertInfos);
            }
        }
        return resultMap;
    }

    private String getCacheKey(CalBaseQtyInfo calBaseQtyInfo) {
        String cacheKey = "";
        Long materialMasterId = calBaseQtyInfo.getMaterialMasterId();
        Long unitId = calBaseQtyInfo.getUnitId();
        if (materialMasterId != null && unitId != null) {
            cacheKey = materialMasterId.toString() + "_" + unitId;
        }
        return cacheKey;
    }

    private Map<Long, Map<String, Object>> getUsedUnitInfoMap() {
        String queryUnitSql = "SELECT FID , FPRECISIONTYPE , FPRECISION FROM T_BD_MEASUREUNIT ;";
        HashMap<Long, Map<String, Object>> unitInfoMap = new HashMap<Long, Map<String, Object>>(100);
        try (DataSet unitDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SYSROUTE, (String)queryUnitSql);){
            for (Row row : unitDataSet) {
                Long fid = row.getLong("FID");
                Integer fprecision = row.getInteger("FPRECISION");
                String fprecisiontype = row.getString("FPRECISIONTYPE");
                HashMap<String, Object> oneUnitInfo = new HashMap<String, Object>(3);
                oneUnitInfo.put("precision", fprecision);
                oneUnitInfo.put("id", fid);
                oneUnitInfo.put("precisiontype", fprecisiontype);
                unitInfoMap.put(fid, oneUnitInfo);
            }
        }
        return unitInfoMap;
    }

    private BigDecimal getDesQty(BigDecimal srcQty, BigDecimal numerator, BigDecimal denominator, Map<String, Object> baseUnitInfo) {
        if (srcQty == null || numerator == null || denominator == null || baseUnitInfo == null || srcQty.compareTo(BigDecimal.ZERO) == 0 || numerator.compareTo(BigDecimal.ZERO) == 0 || denominator.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        int precision = baseUnitInfo.get("precision") == null ? 10 : (Integer)baseUnitInfo.get("precision");
        String precisionAccount = baseUnitInfo.get("precisiontype") == null ? "1" : (String)baseUnitInfo.get("precisiontype");
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if ("3".equals(precisionAccount)) {
            roundingMode = RoundingMode.UP;
        } else if ("2".equals(precisionAccount)) {
            roundingMode = RoundingMode.DOWN;
        }
        BigDecimal desQty = srcQty.multiply(numerator).divide(denominator, precision, roundingMode);
        if (desQty != null && desQty.compareTo(MAXBIGDECIMAL) > 0) {
            desQty = BigDecimal.ZERO;
            log.error(String.format("\u8f6c\u6362\u540e\u6570\u91cf\u8d85\u5927\uff0c\u8bf7\u4fee\u590d\uff0c\u6e90\u6570\u91cf\u4e3a %s \u8f6c\u6362\u540e\u6570\u91cf\u4e3a %s \u3002", srcQty, desQty));
        }
        return desQty;
    }

    private Object[] getParamArray(Long fid, BigDecimal packingBaseQty, BigDecimal maxBaseQty, BigDecimal minBaseQty) {
        Object[] param = new Object[]{packingBaseQty, maxBaseQty, minBaseQty, fid};
        return param;
    }

    private String getQueryEntryInfoSql(String sql, List<Long> oneBatch, String key) {
        if (oneBatch == null || oneBatch.isEmpty()) {
            return null;
        }
        String entryIds = StringUtils.strip((String)oneBatch.toString(), (String)"[]");
        String queryBillEntryInfoSql = sql.replace(key, entryIds);
        return queryBillEntryInfoSql;
    }

    private List<Long> getUpdateEntryIds(String queryEntryIdSql) {
        DataSet entryIdDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SYSROUTE, (String)queryEntryIdSql);
        ArrayList<Long> entryIdList = new ArrayList<Long>(1000);
        for (Row row : entryIdDataSet) {
            entryIdList.add(row.getLong("FID"));
        }
        return entryIdList;
    }

    private List<List<Long>> splitList(List<Long> list) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>(10);
        if (list == null || list.size() == 0) {
            return result;
        }
        int size = list.size();
        int count = (size + 2000 - 1) / 2000;
        for (int i = 0; i < count; ++i) {
            List<Long> subList = list.subList(i * 2000, (i + 1) * 2000 > size ? size : 2000 * (i + 1));
            result.add(subList);
        }
        return result;
    }

    static class CalBaseQtyInfo {
        private Long materialMasterId;
        private Long unitId;
        private Long baseUnitId;
        private BigDecimal packingQty;
        private BigDecimal packingBaseQty;
        private BigDecimal minOrderQty;
        private BigDecimal minOrderBaseQty;
        private BigDecimal maxOrderQty;
        private BigDecimal maxOrderBaseQty;

        public CalBaseQtyInfo(Long unitId, Long baseUnitId, Long materialMasterId, BigDecimal packingQty, BigDecimal packingBaseQty, BigDecimal minOrderQty, BigDecimal minOrderBaseQty, BigDecimal maxOrderQty, BigDecimal maxOrderBaseQty) {
            this.unitId = unitId;
            this.baseUnitId = baseUnitId;
            this.minOrderQty = minOrderQty;
            this.minOrderBaseQty = minOrderBaseQty;
            this.maxOrderQty = maxOrderQty;
            this.maxOrderBaseQty = maxOrderBaseQty;
            this.materialMasterId = materialMasterId;
            this.packingQty = packingQty;
            this.packingBaseQty = packingBaseQty;
        }

        public BigDecimal getPackingQty() {
            return this.packingQty;
        }

        public BigDecimal getPackingBaseQty() {
            return this.packingBaseQty;
        }

        public Long getUnitId() {
            return this.unitId;
        }

        public Long getBaseUnitId() {
            return this.baseUnitId;
        }

        public BigDecimal getMinOrderQty() {
            return this.minOrderQty;
        }

        public BigDecimal getMinOrderBaseQty() {
            return this.minOrderBaseQty;
        }

        public BigDecimal getMaxOrderQty() {
            return this.maxOrderQty;
        }

        public BigDecimal getMaxOrderBaseQty() {
            return this.maxOrderBaseQty;
        }

        public Long getMaterialMasterId() {
            return this.materialMasterId;
        }
    }

    static class UnitConvertInfo {
        Long srcUnitId;
        Long desUnitId;
        Long numerator;
        Long denominator;
        String convertTYpe;

        public UnitConvertInfo(Long numerator, Long denominator) {
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public UnitConvertInfo(Long srcUnitId, Long desUnitId, Long numerator, Long denominator, String convertTYpe) {
            this.srcUnitId = srcUnitId;
            this.desUnitId = desUnitId;
            this.numerator = numerator;
            this.denominator = denominator;
            this.convertTYpe = convertTYpe;
        }

        public Long getDesUnitId() {
            return this.desUnitId;
        }

        public Long getSrcUnitId() {
            return this.srcUnitId;
        }

        public Long getNumerator() {
            return this.numerator;
        }

        public Long getDenominator() {
            return this.denominator;
        }

        public String getConvertTYpe() {
            return this.convertTYpe;
        }
    }
}

