/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.threads.ThreadPools;

public class SourceListUpgradeBaseUnitAndBaseQtyService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(SourceListUpgradeBaseUnitAndBaseQtyService.class);
    private static final int BATCHSIZE = 2000;
    private static final DBRoute SCMROUTE = new DBRoute("scm");
    private static final DBRoute SYSROUTE = new DBRoute("sys");
    private static final String ENTRYIDS_KEY = "ENTRYIDLIST_KEY";
    private static final BigDecimal MAXBIGDECIMAL = new BigDecimal("9999999999999.9999999999");
    private Map<String, UnitConvertInfo> cacheMaterialConvertRate = new HashMap<String, UnitConvertInfo>(10);
    private Map<Long, Map<String, Object>> unitInfoMap = new HashMap<Long, Map<String, Object>>(10);
    private List<UnitConvertInfo> commonUnitConvertInfoList = null;
    protected String noBaseQtySql = "SELECT FENTRYID,FMATERIALMASTERID,FUNITID,FBASEUNITID,FMAXBILLQTY,FMAXBILLBASEQTY,FMINBILLQTY,FMINBILLBASEQTY,FPACKAGEBATCHQTY FROM T_PM_SOURCELISTENTRY WHERE FENTRYID IN ( ENTRYIDLIST_KEY ) ";
    protected String updateQtySql = "UPDATE T_PM_SOURCELISTENTRY SET FPACKINGQTY = ? , FPACKINGBASEQTY = ? ,FMAXBILLBASEQTY = ? ,FMINBILLBASEQTY = ?  WHERE FENTRYID = ?";
    protected String queryEntryIdSql = "SELECT FENTRYID FROM T_PM_SOURCELISTENTRY  WHERE  FTYPE = 'A' AND ((FPACKINGBASEQTY = 0  AND FPACKINGQTY = 0 AND FPACKAGEBATCHQTY <> 0 ) OR (FMAXBILLQTY <> 0 AND FMAXBILLBASEQTY = 0 ) OR (FMINBILLQTY <> 0 AND FMINBILLBASEQTY = 0 ))";
    String queryMatUnitSql = "SELECT FMATERIALID,FMEASUREUNITID,FNUMERATOR,FDENOMINATOR,FCONVERTTYPE FROM T_BD_MULTIMEASUREUNIT WHERE FCONVERTTYPE = '1' AND FMATERIALID IN ( FMATERIALMASTERID_KEY )";
    String queryCommonUnitSql = "SELECT FSRCMUID,FDESMUID,FDENOMINATOR,FNUMERATOR,FCONVERTTYPE FROM T_BD_MEASUREUNITCONV WHERE FCONVERTTYPE = '1' ";
    protected String queryMaterialMasterIdSql = "SELECT FENTRYID,FMATERIALMASTERID FROM T_PM_SOURCELISTENTRY WHERE FENTRYID IN ( ENTRYIDLIST_KEY ) ";
    protected String updateBaseUnitSql = "UPDATE T_PM_SOURCELISTENTRY SET FBASEUNITID = ?   WHERE FENTRYID = ?";
    protected String queryNoBaseUnitEntryIdSql = "SELECT FENTRYID FROM T_PM_SOURCELISTENTRY  WHERE  FTYPE = 'A' AND FMATERIALMASTERID <> 0 AND FBASEUNITID = 0 ";
    protected String queryMaterialMasterIdBaseUnitSql = "SELECT FBaseUnit,FID  FROM T_BD_Material  WHERE FID IN ( ENTRYIDLIST_KEY )";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        log.info("\u8d27\u6e90\u6e05\u5355\u5305\u88c5\u6279\u91cf\u6570\u636e\u5347\u7ea7\u670d\u52a1\u5f00\u59cb");
        UpgradeResult result = new UpgradeResult();
        ThreadPools.executeOnce((String)this.getClass().getName(), () -> this.doUpgrade(result));
        return result;
    }

    private UpgradeResult doUpgrade(UpgradeResult result) {
        this.updateBaseUnit(result);
        this.updateQty(result);
        return result;
    }

    private UpgradeResult updateQty(UpgradeResult result) {
        this.unitInfoMap = this.getUsedUnitInfoMap();
        List<Long> entryIdList = this.getUpdateEntryIds(this.queryEntryIdSql);
        if (entryIdList.isEmpty()) {
            return result;
        }
        List<List<Long>> batchs = this.splitList(entryIdList);
        entryIdList = null;
        Iterator<List<Long>> iterator = batchs.iterator();
        while (iterator.hasNext()) {
            List<Long> oneBatch = iterator.next();
            result = this.excuteOneBatchQty(oneBatch, result);
            if (!result.isSuccess()) {
                return result;
            }
            iterator.remove();
        }
        return result;
    }

    private UpgradeResult updateBaseUnit(UpgradeResult result) {
        List<Long> entryIdList = this.getUpdateEntryIds(this.queryNoBaseUnitEntryIdSql);
        if (entryIdList.isEmpty()) {
            return result;
        }
        List<List<Long>> batchs = this.splitList(entryIdList);
        entryIdList = null;
        Iterator<List<Long>> iterator = batchs.iterator();
        while (iterator.hasNext()) {
            List<Long> oneBatch = iterator.next();
            result = this.excuteOneBatchUnit(oneBatch, result);
            if (!result.isSuccess()) {
                return result;
            }
            iterator.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpgradeResult excuteOneBatchUnit(List<Long> oneBatch, UpgradeResult result) {
        if (oneBatch == null || oneBatch.isEmpty()) {
            return result;
        }
        String queryEntryInfoSql = this.getQueryEntryInfoSql(this.queryMaterialMasterIdSql, oneBatch, ENTRYIDS_KEY);
        if (queryEntryInfoSql == null) {
            return result;
        }
        oneBatch = null;
        ArrayList<Object[]> sqlParam = new ArrayList<Object[]>(10);
        HashSet<Long> materialMasterIdSet = new HashSet<Long>(16);
        HashMap<Long, Long> entryIdAndMaterialMasterIdMap = new HashMap<Long, Long>(16);
        try (DataSet rows = null;){
            rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SCMROUTE, (String)queryEntryInfoSql);
            for (Row row : rows) {
                Long materialMasterId = row.getLong("FMATERIALMASTERID");
                Long fentryid = row.getLong("FENTRYID");
                if (materialMasterId == null || materialMasterId.equals(0L)) continue;
                materialMasterIdSet.add(materialMasterId);
                entryIdAndMaterialMasterIdMap.put(fentryid, materialMasterId);
            }
        }
        if (!materialMasterIdSet.isEmpty() && !entryIdAndMaterialMasterIdMap.isEmpty()) {
            sqlParam.addAll(this.getMatBaseUnitParam(materialMasterIdSet, entryIdAndMaterialMasterIdMap));
        }
        if (sqlParam == null || sqlParam.isEmpty()) {
            return result;
        }
        return this.updateDB(sqlParam, this.updateBaseUnitSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object[]> getMatBaseUnitParam(Set<Long> materialMasterIdSet, Map<Long, Long> entryIdAndMaterialMasterIdMap) {
        ArrayList<Object[]> sqlParam = new ArrayList<Object[]>(10);
        DataSet rows = null;
        String queryBaseUnitSql = this.getQueryEntryInfoSql(this.queryMaterialMasterIdBaseUnitSql, new ArrayList<Long>(materialMasterIdSet), ENTRYIDS_KEY);
        HashMap<Long, Long> materialMasterIdAndBaseUnitMap = new HashMap<Long, Long>(10);
        try {
            rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SYSROUTE, (String)queryBaseUnitSql);
            for (Row row : rows) {
                Long materialMasterId = row.getLong("FID");
                Long fBaseUnit = row.getLong("FBaseUnit");
                if (materialMasterId == null || materialMasterId.equals(0L)) continue;
                materialMasterIdAndBaseUnitMap.put(materialMasterId, fBaseUnit);
            }
        }
        catch (Throwable ex) {
            log.error("\u8d27\u6e90\u6e05\u5355\u57fa\u672c\u5355\u4f4d\u6570\u636e\u5347\u7ea7\u670d\u52a1\u6267\u884c\u5931\u8d25\u3002", ex);
            ArrayList<Object[]> row = sqlParam;
            return row;
        }
        finally {
            if (rows != null) {
                rows.close();
            }
        }
        if (materialMasterIdAndBaseUnitMap.isEmpty()) {
            return sqlParam;
        }
        for (Map.Entry<Long, Long> entry : entryIdAndMaterialMasterIdMap.entrySet()) {
            Long baseUnitId;
            Long entryId = entry.getKey();
            Long masterId = entry.getValue();
            if (entryId == null || masterId == null || (baseUnitId = (Long)materialMasterIdAndBaseUnitMap.get(masterId)) == null || Long.compare(baseUnitId, 0L) == 0) continue;
            Object[] param = new Object[]{baseUnitId, entryId};
            sqlParam.add(param);
        }
        return sqlParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpgradeResult excuteOneBatchQty(List<Long> oneBatch, UpgradeResult result) {
        if (oneBatch == null || oneBatch.isEmpty()) {
            return result;
        }
        String queryEntryInfoSql = this.getQueryEntryInfoSql(this.noBaseQtySql, oneBatch, ENTRYIDS_KEY);
        if (queryEntryInfoSql == null) {
            return result;
        }
        oneBatch = null;
        ArrayList<Object[]> sqlParam = new ArrayList<Object[]>(10);
        HashMap<Long, CalPackingBaseQtyInfo> calQtyInfoMap = new HashMap<Long, CalPackingBaseQtyInfo>(16);
        try (DataSet rows = null;){
            rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SCMROUTE, (String)queryEntryInfoSql);
            for (Row row : rows) {
                Long baseunitId = row.getLong("FBASEUNITID");
                Long unitId = row.getLong("FUNITID");
                Long materialMasterId = row.getLong("FMATERIALMASTERID");
                Long fentryid = row.getLong("FENTRYID");
                BigDecimal maxBaseQty = row.getBigDecimal("FMAXBILLBASEQTY");
                BigDecimal maxQty = row.getBigDecimal("FMAXBILLQTY");
                BigDecimal minBaseQty = row.getBigDecimal("FMINBILLBASEQTY");
                BigDecimal minQty = row.getBigDecimal("FMINBILLQTY");
                BigDecimal packageBatchqty = row.getBigDecimal("FPACKAGEBATCHQTY");
                if (baseunitId == null || unitId == null || materialMasterId == null || packageBatchqty == null || baseunitId.equals(0L) || unitId.equals(0L) || materialMasterId.equals(0L) || packageBatchqty.compareTo(MAXBIGDECIMAL) > 0) continue;
                if (baseunitId.equals(unitId)) {
                    sqlParam.add(this.getParamArray(fentryid, packageBatchqty, packageBatchqty, maxQty, minQty));
                    continue;
                }
                calQtyInfoMap.put(fentryid, new CalPackingBaseQtyInfo(unitId, baseunitId, materialMasterId, packageBatchqty, minQty, minBaseQty, maxQty, maxBaseQty));
            }
        }
        if (!calQtyInfoMap.isEmpty()) {
            sqlParam.addAll(this.getCalQtyParam(calQtyInfoMap));
        }
        calQtyInfoMap = null;
        if (sqlParam == null || sqlParam.isEmpty()) {
            return result;
        }
        return this.updateDB(sqlParam, this.updateQtySql);
    }

    private UpgradeResult updateDB(List<Object[]> sqlParam, String updateSql) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.required((String)this.getClass().getName());){
            try {
                DB.executeBatch((DBRoute)SCMROUTE, (String)updateSql, sqlParam);
                sqlParam = null;
                tx.commit();
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error("\u8d27\u6e90\u6e05\u5355\u5347\u7ea7\u6267\u884c\u5931\u8d25\u3002" + updateSql, e);
                result.setSuccess(false);
                String errorInfo = "database execution failed,errorInfo" + e.getMessage();
                result.setErrorInfo(errorInfo);
                result.setLog(errorInfo);
                UpgradeResult upgradeResult = result;
                if (tx != null) {
                    if (var5_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return upgradeResult;
            }
        }
        return result;
    }

    private List<Object[]> getCalQtyParam(Map<Long, CalPackingBaseQtyInfo> calQtyInfoMap) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        HashMap<Long, CalPackingBaseQtyInfo> unitConvertMap = new HashMap<Long, CalPackingBaseQtyInfo>(10);
        for (Map.Entry<Long, CalPackingBaseQtyInfo> entry : calQtyInfoMap.entrySet()) {
            Long entryId = entry.getKey();
            CalPackingBaseQtyInfo info = entry.getValue();
            Long baseUnitId = info.getBaseUnitId();
            BigDecimal packingQtyLong = info.getPackingQtyInt();
            BigDecimal maxOrderQty = info.getMaxOrderQty();
            BigDecimal maxOrderBaseQty = info.getMaxOrderBaseQty();
            BigDecimal minOrderQty = info.getMinOrderQty();
            BigDecimal minOrderBaseQty = info.getMinOrderBaseQty();
            Map<String, Object> baseUnitInfo = this.unitInfoMap.get(baseUnitId);
            if (!(baseUnitInfo != null && (packingQtyLong != null && BigDecimal.ZERO.compareTo(packingQtyLong) != 0 || minOrderQty != null && BigDecimal.ZERO.compareTo(minOrderQty) != 0 || maxOrderQty != null && BigDecimal.ZERO.compareTo(maxOrderQty) != 0))) continue;
            BigDecimal calSrcQty = BigDecimal.ZERO;
            BigDecimal calSrcBaseQty = BigDecimal.ZERO;
            if (maxOrderQty != null && maxOrderBaseQty != null && maxOrderBaseQty.compareTo(BigDecimal.ZERO) != 0 && maxOrderQty.compareTo(BigDecimal.ZERO) != 0) {
                calSrcQty = maxOrderQty;
                calSrcBaseQty = maxOrderBaseQty;
            } else if (minOrderQty != null && minOrderBaseQty != null && minOrderBaseQty.compareTo(BigDecimal.ZERO) != 0 && minOrderQty.compareTo(BigDecimal.ZERO) != 0) {
                calSrcQty = minOrderQty;
                calSrcBaseQty = minOrderBaseQty;
            } else {
                unitConvertMap.put(entryId, entry.getValue());
                continue;
            }
            if (calSrcQty.compareTo(BigDecimal.ZERO) == 0 || calSrcBaseQty.compareTo(BigDecimal.ZERO) == 0) continue;
            paramList.add(this.getParamResult(entryId, info, baseUnitInfo, calSrcQty, calSrcBaseQty));
        }
        if (!unitConvertMap.isEmpty()) {
            paramList.addAll(this.convertQtyByUnitRate(unitConvertMap));
        }
        return paramList;
    }

    private Object[] getParamResult(Long entryId, CalPackingBaseQtyInfo info, Map<String, Object> baseUnitInfo, BigDecimal denominator, BigDecimal numerator) {
        BigDecimal maxOrderQty = info.getMaxOrderQty();
        BigDecimal maxOrderBaseQty = info.getMaxOrderBaseQty();
        BigDecimal minOrderQty = info.getMinOrderQty();
        BigDecimal minOrderBaseQty = info.getMinOrderBaseQty();
        BigDecimal packingQtyInt = info.getPackingQtyInt();
        BigDecimal packingBaseQty = this.getDesQty(info.getPackingQtyInt(), numerator, denominator, baseUnitInfo);
        if (maxOrderQty != null && maxOrderBaseQty != null && maxOrderQty.compareTo(BigDecimal.ZERO) != 0 && maxOrderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            maxOrderBaseQty = this.getDesQty(maxOrderQty, numerator, denominator, baseUnitInfo);
        }
        if (minOrderQty != null && minOrderBaseQty != null && minOrderQty.compareTo(BigDecimal.ZERO) != 0 && minOrderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            minOrderBaseQty = this.getDesQty(minOrderQty, numerator, denominator, baseUnitInfo);
        }
        return this.getParamArray(entryId, packingQtyInt, packingBaseQty, maxOrderBaseQty, minOrderBaseQty);
    }

    private List<Object[]> convertQtyByUnitRate(Map<Long, CalPackingBaseQtyInfo> unitConvertMap) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        Iterator<Map.Entry<Long, CalPackingBaseQtyInfo>> iterator = unitConvertMap.entrySet().iterator();
        while (iterator.hasNext()) {
            UnitConvertInfo unitConvertInfo;
            String cacheKey;
            Map.Entry<Long, CalPackingBaseQtyInfo> entry = iterator.next();
            CalPackingBaseQtyInfo calPackingBaseQtyInfo = entry.getValue();
            if (calPackingBaseQtyInfo == null || StringUtils.isBlank((CharSequence)(cacheKey = this.getCacheKey(calPackingBaseQtyInfo))) || (unitConvertInfo = this.cacheMaterialConvertRate.get(cacheKey)) == null) continue;
            Long denominator = unitConvertInfo.getDenominator();
            Long numerator = unitConvertInfo.getNumerator();
            Map<String, Object> unitMap = this.unitInfoMap.get(calPackingBaseQtyInfo.getBaseUnitId());
            paramList.add(this.getParamResult(entry.getKey(), calPackingBaseQtyInfo, unitMap, new BigDecimal(denominator), new BigDecimal(numerator)));
            iterator.remove();
        }
        if (unitConvertMap.isEmpty()) {
            return paramList;
        }
        Map<Long, List<UnitConvertInfo>> materialUnitMap = this.queryMaterialUnit(unitConvertMap);
        if (!materialUnitMap.isEmpty()) {
            paramList.addAll(this.calBaseQtyByMatUnitInfo(unitConvertMap, materialUnitMap));
        }
        if (unitConvertMap.isEmpty()) {
            return paramList;
        }
        if (this.commonUnitConvertInfoList == null) {
            this.commonUnitConvertInfoList = this.queryCommonUnitConvertInfos();
        }
        paramList.addAll(this.calBaseQtyByMatAndCommonUnitInfo(unitConvertMap, materialUnitMap, this.commonUnitConvertInfoList));
        return paramList;
    }

    private List<Object[]> calBaseQtyByMatAndCommonUnitInfo(Map<Long, CalPackingBaseQtyInfo> unitConvertMap, Map<Long, List<UnitConvertInfo>> materialUnitMap, List<UnitConvertInfo> commonUnitConvertInfoList) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, CalPackingBaseQtyInfo> next : unitConvertMap.entrySet()) {
            CalPackingBaseQtyInfo calInfo = next.getValue();
            String cacheKey = this.getCacheKey(calInfo);
            Long baseUnitId = calInfo.getBaseUnitId();
            Long unitId = calInfo.getUnitId();
            Map<String, Object> baseUnitInfo = this.unitInfoMap.get(baseUnitId);
            Long materialMasterId = calInfo.getMaterialMasterId();
            UnitConvertInfo unitConvertInfo = this.getMatchUnitInfo(unitId, baseUnitId, commonUnitConvertInfoList);
            if (unitConvertInfo == null) {
                List<Object> unitConvertInfos = materialUnitMap.get(materialMasterId) == null ? new ArrayList(10) : materialUnitMap.get(materialMasterId);
                unitConvertInfos.addAll(commonUnitConvertInfoList);
                unitConvertInfos = this.combindResultList(unitConvertInfos);
                unitConvertInfo = this.getMatchUnitInfo(unitId, baseUnitId, unitConvertInfos);
                if (unitConvertInfo != null) {
                    this.cacheMaterialConvertRate.put(cacheKey, unitConvertInfo);
                }
            }
            if (unitConvertInfo == null) continue;
            paramList.add(this.getParamResult(next.getKey(), calInfo, baseUnitInfo, new BigDecimal(unitConvertInfo.getDenominator()), new BigDecimal(unitConvertInfo.getNumerator())));
        }
        return paramList;
    }

    private List<UnitConvertInfo> combindResultList(List<UnitConvertInfo> unitConvertInfos) {
        if (null == unitConvertInfos || unitConvertInfos.isEmpty()) {
            return unitConvertInfos;
        }
        ArrayList<UnitConvertInfo> mirroList = new ArrayList<UnitConvertInfo>(unitConvertInfos.size());
        for (UnitConvertInfo convertInfo : unitConvertInfos) {
            UnitConvertInfo info = new UnitConvertInfo(convertInfo.getDesUnitId(), convertInfo.getSrcUnitId(), convertInfo.getDenominator(), convertInfo.getNumerator(), convertInfo.getConvertTYpe());
            mirroList.add(info);
        }
        unitConvertInfos.addAll(mirroList);
        return unitConvertInfos;
    }

    private UnitConvertInfo getMatchUnitInfo(Long srcUnitId, Long tarUnitId, List<UnitConvertInfo> unitInfoList) {
        if (unitInfoList == null || unitInfoList.isEmpty()) {
            return null;
        }
        UnitConvertInfo result = null;
        for (UnitConvertInfo unitInfo : unitInfoList) {
            Long sUnitId = unitInfo.getSrcUnitId();
            Long desUnitId = unitInfo.getDesUnitId();
            if (sUnitId == null || desUnitId == null || srcUnitId == null || tarUnitId == null) continue;
            if (srcUnitId.compareTo(sUnitId) == 0 && desUnitId.compareTo(tarUnitId) == 0) {
                result = unitInfo;
                break;
            }
            if (sUnitId.compareTo(tarUnitId) != 0 || desUnitId.compareTo(srcUnitId) != 0) continue;
            result = new UnitConvertInfo(unitInfo.getDenominator(), unitInfo.getNumerator());
            break;
        }
        if (result == null) {
            Long[] conv;
            Long old_numerator = 1L;
            Long old_denominator = 1L;
            Long old_convertType = 1L;
            Map<String, Long[]> allConv = new HashMap<String, Long[]>();
            if ((allConv = this.indirectConv(srcUnitId, unitInfoList, old_numerator, old_denominator, old_convertType, allConv, srcUnitId)) != null && null != (conv = allConv.get(srcUnitId + "-" + tarUnitId))) {
                result = new UnitConvertInfo(conv[0], conv[1]);
            }
        }
        return result;
    }

    private Map<String, Long[]> indirectConv(Long srcmuid, List<UnitConvertInfo> unitInfoList, Long old_numerator, Long old_denominator, Long oLdConvertType, Map<String, Long[]> allConv, Long initSrcId) {
        Long[] conv = null;
        for (UnitConvertInfo info : unitInfoList) {
            Long srcId = info.getSrcUnitId();
            Long desId = info.getDesUnitId();
            if (srcmuid == null || srcId == null || !srcmuid.equals(srcId) || allConv.containsKey(initSrcId + "-" + desId)) continue;
            Long numerator = info.getNumerator();
            Long denominator = info.getDenominator();
            numerator = old_numerator * numerator;
            denominator = old_denominator * denominator;
            Long convertTYpe = Long.parseLong(info.getConvertTYpe());
            conv = new Long[]{numerator, denominator, convertTYpe};
            allConv.put(initSrcId + "-" + desId, conv);
            this.indirectConv(desId, unitInfoList, numerator, denominator, convertTYpe, allConv, initSrcId);
        }
        return allConv;
    }

    private List<UnitConvertInfo> queryCommonUnitConvertInfos() {
        ArrayList<UnitConvertInfo> infoList = new ArrayList<UnitConvertInfo>(10);
        try (DataSet rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SYSROUTE, (String)this.queryCommonUnitSql);){
            for (Row row : rows) {
                Long srcmuid = row.getLong("FSRCMUID");
                Long desmuid = row.getLong("FDESMUID");
                Long numerator = row.getLong("FNUMERATOR");
                Long denominator = row.getLong("FDENOMINATOR");
                String convertType = row.getString("FCONVERTTYPE");
                UnitConvertInfo info = new UnitConvertInfo(srcmuid, desmuid, numerator, denominator, convertType);
                infoList.add(info);
            }
        }
        return infoList;
    }

    private List<Object[]> calBaseQtyByMatUnitInfo(Map<Long, CalPackingBaseQtyInfo> unitConvertMap, Map<Long, List<UnitConvertInfo>> materialUnitMap) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        Iterator<Map.Entry<Long, CalPackingBaseQtyInfo>> iterator = unitConvertMap.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Long materialMasterId;
            List<UnitConvertInfo> unitConvertInfos;
            Map.Entry<Long, CalPackingBaseQtyInfo> entry = iterator.next();
            CalPackingBaseQtyInfo calPackingBaseQtyInfo = entry.getValue();
            if (calPackingBaseQtyInfo == null || (unitConvertInfos = materialUnitMap.get(materialMasterId = calPackingBaseQtyInfo.getMaterialMasterId())) == null || unitConvertInfos.isEmpty()) continue;
            Long baseUnitId = calPackingBaseQtyInfo.getBaseUnitId();
            Long unitId = calPackingBaseQtyInfo.getUnitId();
            for (UnitConvertInfo convertInfo : unitConvertInfos) {
                Long srcUnitId = convertInfo.getSrcUnitId();
                if (unitId == null || srcUnitId == null || !unitId.equals(srcUnitId)) continue;
                Long denominator = convertInfo.getDenominator();
                Long numerator = convertInfo.getNumerator();
                Map<String, Object> unitMap = this.unitInfoMap.get(baseUnitId);
                BigDecimal packingBaseQty = this.getDesQty(calPackingBaseQtyInfo.getPackingQtyInt(), numerator, denominator, unitMap);
                BigDecimal minOrderQty = calPackingBaseQtyInfo.getMinOrderQty();
                BigDecimal minOrderBaseQty = calPackingBaseQtyInfo.getMinOrderBaseQty();
                if (minOrderQty != null && minOrderBaseQty != null && minOrderBaseQty.compareTo(BigDecimal.ZERO) == 0 && minOrderQty.compareTo(BigDecimal.ZERO) != 0) {
                    minOrderBaseQty = this.getDesQty(minOrderQty, numerator, denominator, unitMap);
                }
                BigDecimal maxOrderQty = calPackingBaseQtyInfo.getMaxOrderQty();
                BigDecimal maxOrderBaseQty = calPackingBaseQtyInfo.getMaxOrderBaseQty();
                if (maxOrderBaseQty != null && maxOrderQty != null && maxOrderBaseQty.compareTo(BigDecimal.ZERO) == 0 && maxOrderQty.compareTo(BigDecimal.ZERO) != 0) {
                    maxOrderBaseQty = this.getDesQty(maxOrderQty, numerator, denominator, unitMap);
                }
                paramList.add(this.getParamResult(calPackingBaseQtyInfo.getPackingQtyInt(), packingBaseQty, maxOrderBaseQty, minOrderBaseQty, entry.getKey()));
                iterator.remove();
                continue block0;
            }
        }
        return paramList;
    }

    private Object[] getParamResult(BigDecimal packingQty, BigDecimal packingBaseQty, BigDecimal maxBillBaseQty, BigDecimal minBillBaseQty, Long entryId) {
        Object[] param = new Object[]{packingQty, packingBaseQty, maxBillBaseQty, minBillBaseQty, entryId};
        return param;
    }

    private Map<Long, List<UnitConvertInfo>> queryMaterialUnit(Map<Long, CalPackingBaseQtyInfo> unitConvertMap) {
        HashMap<Long, List<UnitConvertInfo>> resultMap = new HashMap<Long, List<UnitConvertInfo>>(10);
        HashMap materialMasterIdAndBaseUntiIdMap = new HashMap(10);
        unitConvertMap.values().forEach(info -> {
            if (info != null) {
                materialMasterIdAndBaseUntiIdMap.put(info.getMaterialMasterId(), info.getBaseUnitId());
            }
        });
        this.queryMatUnitSql = this.getQueryEntryInfoSql(this.queryMatUnitSql, new ArrayList<Long>(materialMasterIdAndBaseUntiIdMap.keySet()), "FMATERIALMASTERID_KEY");
        try (DataSet rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SYSROUTE, (String)this.queryMatUnitSql);){
            for (Row row : rows) {
                Long materialMasterId = row.getLong("FMATERIALID");
                ArrayList<UnitConvertInfo> unitConvertInfos = (ArrayList<UnitConvertInfo>)resultMap.get(materialMasterId);
                if (unitConvertInfos == null) {
                    unitConvertInfos = new ArrayList<UnitConvertInfo>(10);
                }
                Long srcmuid = row.getLong("FMEASUREUNITID");
                Long baseUnitId = (Long)materialMasterIdAndBaseUntiIdMap.get(materialMasterId);
                Long numerator = row.getLong("FNUMERATOR");
                Long denominator = row.getLong("FDENOMINATOR");
                String convertType = row.getString("FCONVERTTYPE");
                UnitConvertInfo info2 = new UnitConvertInfo(srcmuid, baseUnitId, numerator, denominator, convertType);
                unitConvertInfos.add(info2);
                resultMap.put(materialMasterId, unitConvertInfos);
            }
        }
        return resultMap;
    }

    private String getCacheKey(CalPackingBaseQtyInfo calPackingBaseQtyInfo) {
        String cacheKey = "";
        Long materialMasterId = calPackingBaseQtyInfo.getMaterialMasterId();
        Long unitId = calPackingBaseQtyInfo.getUnitId();
        if (materialMasterId != null && unitId != null) {
            cacheKey = materialMasterId.toString() + "_" + unitId;
        }
        return cacheKey;
    }

    private Map<Long, Map<String, Object>> getUsedUnitInfoMap() {
        String queryUnitSql = "SELECT FID , FPRECISIONTYPE , FPRECISION FROM T_BD_MEASUREUNIT ;";
        HashMap<Long, Map<String, Object>> unitInfoMap = new HashMap<Long, Map<String, Object>>(100);
        try (DataSet unitDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SYSROUTE, (String)queryUnitSql);){
            for (Row row : unitDataSet) {
                Long fid = row.getLong("FID");
                Integer fprecision = row.getInteger("FPRECISION");
                String fprecisiontype = row.getString("FPRECISIONTYPE");
                HashMap<String, Object> oneUnitInfo = new HashMap<String, Object>(3);
                oneUnitInfo.put("precision", fprecision);
                oneUnitInfo.put("id", fid);
                oneUnitInfo.put("precisiontype", fprecisiontype);
                unitInfoMap.put(fid, oneUnitInfo);
            }
        }
        return unitInfoMap;
    }

    private BigDecimal getDesQty(BigDecimal srcQty, BigDecimal numerator, BigDecimal denominator, Map<String, Object> baseUnitInfo) {
        if (srcQty == null || numerator == null || denominator == null || baseUnitInfo == null || srcQty.compareTo(BigDecimal.ZERO) == 0 || numerator.compareTo(BigDecimal.ZERO) == 0 || denominator.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        int precision = baseUnitInfo.get("precision") == null ? 10 : (Integer)baseUnitInfo.get("precision");
        String precisionAccount = baseUnitInfo.get("precisiontype") == null ? "1" : (String)baseUnitInfo.get("precisiontype");
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if ("3".equals(precisionAccount)) {
            roundingMode = RoundingMode.UP;
        } else if ("2".equals(precisionAccount)) {
            roundingMode = RoundingMode.DOWN;
        }
        BigDecimal desQty = srcQty.multiply(numerator).divide(denominator, precision, roundingMode);
        if (desQty != null && desQty.compareTo(MAXBIGDECIMAL) > 0) {
            desQty = BigDecimal.ZERO;
            log.error(String.format("\u8f6c\u6362\u540e\u6570\u91cf\u8d85\u5927\uff0c\u8bf7\u4fee\u590d\uff0c\u6e90\u6570\u91cf\u4e3a %s \u8f6c\u6362\u540e\u6570\u91cf\u4e3a %s \u3002", srcQty, desQty));
        }
        return desQty;
    }

    private BigDecimal getDesQty(BigDecimal srcQty, Long numerator, Long denominator, Map<String, Object> baseUnitInfo) {
        if (srcQty == null || numerator == null || denominator == null || baseUnitInfo == null || srcQty.compareTo(BigDecimal.ZERO) == 0 || Long.compare(numerator, 0L) == 0 || Long.compare(denominator, 0L) == 0) {
            return BigDecimal.ZERO;
        }
        return this.getDesQty(srcQty, new BigDecimal(numerator), new BigDecimal(denominator), baseUnitInfo);
    }

    private Object[] getParamArray(Long entryId, BigDecimal packageBatchQty, BigDecimal packingBaseQty, BigDecimal maxQty, BigDecimal minQty) {
        Object[] param = new Object[]{packageBatchQty, packingBaseQty, maxQty, minQty, entryId};
        return param;
    }

    private String getQueryEntryInfoSql(String sql, List<Long> oneBatch, String key) {
        if (oneBatch == null || oneBatch.isEmpty()) {
            return null;
        }
        String entryIds = org.apache.commons.lang.StringUtils.strip((String)oneBatch.toString(), (String)"[]");
        String queryBillEntryInfoSql = sql.replace(key, entryIds);
        return queryBillEntryInfoSql;
    }

    private List<Long> getUpdateEntryIds(String queryEntryIdSql) {
        DataSet entryIdDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SCMROUTE, (String)queryEntryIdSql);
        ArrayList<Long> entryIdList = new ArrayList<Long>(1000);
        for (Row row : entryIdDataSet) {
            entryIdList.add(row.getLong("FENTRYID"));
        }
        return entryIdList;
    }

    private List<List<Long>> splitList(List<Long> list) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>(10);
        if (list == null || list.size() == 0) {
            return result;
        }
        int size = list.size();
        int count = (size + 2000 - 1) / 2000;
        for (int i = 0; i < count; ++i) {
            List<Long> subList = list.subList(i * 2000, (i + 1) * 2000 > size ? size : 2000 * (i + 1));
            result.add(subList);
        }
        return result;
    }

    public Map<String, Object> updateSourceListBaseQty() {
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        List<Long> entryIdList = this.getUpdateEntryIds(this.queryEntryIdSql);
        result.put("success", Boolean.TRUE);
        result.put("allcount", entryIdList.size());
        if (entryIdList.isEmpty()) {
            return result;
        }
        List<List<Long>> batchs = this.splitList(entryIdList);
        entryIdList = null;
        Iterator<List<Long>> iterator = batchs.iterator();
        int updateCount = 0;
        while (iterator.hasNext()) {
            List<Long> oneBatch = iterator.next();
            updateCount += this.excuteUpdateBaseQty(oneBatch);
        }
        result.put("updateCount", updateCount);
        return result;
    }

    private int excuteUpdateBaseQty(List<Long> oneBatch) {
        QFilter entryIdFilter = new QFilter("entryentity.id", "in", oneBatch);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        int updateCount = 0;
        this.unitInfoMap = this.getUsedUnitInfoMap();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_sourcelist", (String)"entryentity.id entryid,entryentity.materialmasterid materialmasterid,entryentity.purchaseunit purchaseunit,entryentity.baseunit baseunit,entryentity.packagebatchqty packagebatchqty,entryentity.maxbillqty maxbillqty,entryentity.maxbillbaseqty maxbillbaseqty,entryentity.minbillqty minbillqty,entryentity.minbillbaseqty minbillbaseqty", (QFilter[])new QFilter[]{entryIdFilter}, null);){
            UpgradeResult upgradeResult;
            for (Row row : dataSet) {
                DynamicObject muConv;
                Long materialmasterid = row.getLong("materialmasterid");
                Long baseunit = row.getLong("baseunit");
                Long unit = row.getLong("purchaseunit");
                Long entryid = row.getLong("entryid");
                BigDecimal packagebatch = row.getBigDecimal("packagebatchqty");
                BigDecimal maxOrderQty = row.getBigDecimal("maxbillqty");
                BigDecimal maxOrderBaseQty = row.getBigDecimal("maxbillbaseqty");
                BigDecimal minOrderQty = row.getBigDecimal("minbillqty");
                BigDecimal minOrderBaseQty = row.getBigDecimal("minbillbaseqty");
                if (baseunit == null || unit == null || materialmasterid == null || baseunit.equals(0L) || unit.equals(0L) || materialmasterid.equals(0L) || packagebatch.compareTo(MAXBIGDECIMAL) > 0 || null == (muConv = BaseDataServiceHelper.getMUConv((Long)materialmasterid, (Long)unit, (Long)baseunit)) || 0L == muConv.getLong("numerator")) continue;
                BigDecimal numerator = BigDecimal.valueOf(muConv.getInt("numerator"));
                BigDecimal denominator = BigDecimal.valueOf(muConv.getInt("denominator"));
                Map<String, Object> unitMap = this.unitInfoMap.get(baseunit);
                if (unit == null) continue;
                BigDecimal packingBaseQty = this.getDesQty(packagebatch, numerator, denominator, unitMap);
                if (minOrderQty != null && minOrderBaseQty != null && minOrderBaseQty.compareTo(BigDecimal.ZERO) == 0 && minOrderQty.compareTo(BigDecimal.ZERO) != 0) {
                    minOrderBaseQty = this.getDesQty(minOrderQty, numerator, denominator, unitMap);
                }
                if (maxOrderBaseQty != null && maxOrderQty != null && maxOrderBaseQty.compareTo(BigDecimal.ZERO) == 0 && maxOrderQty.compareTo(BigDecimal.ZERO) != 0) {
                    maxOrderBaseQty = this.getDesQty(maxOrderQty, numerator, denominator, unitMap);
                }
                paramList.add(this.getParamResult(packagebatch, packingBaseQty, maxOrderBaseQty, minOrderBaseQty, entryid));
            }
            if (!paramList.isEmpty() && (upgradeResult = this.updateDB(paramList, this.updateQtySql)).isSuccess()) {
                updateCount = paramList.size();
            }
        }
        return updateCount;
    }

    public Map<String, Object> updateSourceListBaseUnit() {
        UpgradeResult upgradeResult = this.updateBaseUnit(new UpgradeResult());
        return upgradeResult.toMap();
    }

    static class CalPackingBaseQtyInfo {
        private Long materialMasterId;
        private Long unitId;
        private Long baseUnitId;
        private BigDecimal packingQtyInt;
        private BigDecimal minOrderQty;
        private BigDecimal minOrderBaseQty;
        private BigDecimal maxOrderQty;
        private BigDecimal maxOrderBaseQty;

        public CalPackingBaseQtyInfo(Long unitId, Long baseUnitId, Long materialMasterId, BigDecimal packingQtyInt, BigDecimal minOrderQty, BigDecimal minOrderBaseQty, BigDecimal maxOrderQty, BigDecimal maxOrderBaseQty) {
            this.unitId = unitId;
            this.baseUnitId = baseUnitId;
            this.minOrderQty = minOrderQty;
            this.minOrderBaseQty = minOrderBaseQty;
            this.maxOrderQty = maxOrderQty;
            this.maxOrderBaseQty = maxOrderBaseQty;
            this.materialMasterId = materialMasterId;
            this.packingQtyInt = packingQtyInt;
        }

        public BigDecimal getPackingQtyInt() {
            return this.packingQtyInt;
        }

        public Long getUnitId() {
            return this.unitId;
        }

        public Long getBaseUnitId() {
            return this.baseUnitId;
        }

        public BigDecimal getMinOrderQty() {
            return this.minOrderQty;
        }

        public BigDecimal getMinOrderBaseQty() {
            return this.minOrderBaseQty;
        }

        public BigDecimal getMaxOrderQty() {
            return this.maxOrderQty;
        }

        public BigDecimal getMaxOrderBaseQty() {
            return this.maxOrderBaseQty;
        }

        public Long getMaterialMasterId() {
            return this.materialMasterId;
        }

        public void setMaterialMasterId(Long materialMasterId) {
            this.materialMasterId = materialMasterId;
        }
    }

    static class UnitConvertInfo {
        Long srcUnitId;
        Long desUnitId;
        Long numerator;
        Long denominator;
        String convertTYpe;

        public UnitConvertInfo(Long numerator, Long denominator) {
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public UnitConvertInfo(Long srcUnitId, Long desUnitId, Long numerator, Long denominator, String convertTYpe) {
            this.srcUnitId = srcUnitId;
            this.desUnitId = desUnitId;
            this.numerator = numerator;
            this.denominator = denominator;
            this.convertTYpe = convertTYpe;
        }

        public Long getDesUnitId() {
            return this.desUnitId;
        }

        public Long getSrcUnitId() {
            return this.srcUnitId;
        }

        public Long getNumerator() {
            return this.numerator;
        }

        public Long getDenominator() {
            return this.denominator;
        }

        public String getConvertTYpe() {
            return this.convertTYpe;
        }
    }
}

