/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice.upgrade.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;

public class BizTypeUpgradeService
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(BizTypeUpgradeService.class);
    private static final int batchSizeNum = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult doUpdate(DBRoute dbRoute, UpgradeResult result, String entityNo, String billTypeParamNo, String billTypeKey, String bizTypeKey, String t_bizType) {
        if (dbRoute == null || result == null || StringUtils.isBlank((CharSequence)entityNo) || StringUtils.isBlank((CharSequence)billTypeParamNo) || StringUtils.isBlank((CharSequence)billTypeKey) || StringUtils.isBlank((CharSequence)t_bizType)) {
            throw new KDBizException("BizTypeUpgradeService execution failed,Please check param and try again.");
        }
        String serviceName = entityNo + this.getClass().getName();
        logger.info(serviceName + " \u6267\u884c\u670d\u52a1\u5165\u53c2\uff1aDBRoute " + dbRoute + " UpgradeResult " + result + " entityNo " + entityNo + " billTypeParamNo " + billTypeParamNo + " billTypeKey " + billTypeKey + " bizTypeKey " + bizTypeKey + " t_bizType " + t_bizType);
        try (DataSet queryDataSet = null;){
            String sql = "select fid as id," + billTypeKey + "," + bizTypeKey + " from " + t_bizType + " where " + bizTypeKey + "= 0 and " + billTypeKey + "!= 0";
            queryDataSet = DB.queryDataSet((String)"BizTypeUpgradeService", (DBRoute)dbRoute, (String)sql);
            HashSet<Long> billTypeSet = new HashSet<Long>(16);
            HashMap<Long, Long> id_billtype_Map = new HashMap<Long, Long>();
            if (queryDataSet != null) {
                for (Row row : queryDataSet) {
                    if (row == null || row.getLong("id") == null || row.get(billTypeKey) == null) continue;
                    Long billTypeId = row.getLong(billTypeKey);
                    billTypeSet.add(billTypeId);
                    id_billtype_Map.put(row.getLong("id"), billTypeId);
                }
            }
            HashMap<Long, Long> billType_bizType_Map = new HashMap<Long, Long>(16);
            for (Long billTypeId : billTypeSet) {
                Long defaultBizType;
                if (billTypeId == null || (defaultBizType = BizTypeHelper.getDefaultBizType((String)entityNo, (Long)billTypeId, (String)billTypeParamNo)) == null) continue;
                billType_bizType_Map.put(billTypeId, defaultBizType);
            }
            ArrayList<Object[]> sqlParam = new ArrayList<Object[]>(1000);
            int count = 0;
            for (Map.Entry map : id_billtype_Map.entrySet()) {
                if (map != null && map.getValue() != null && map.getKey() != null && billType_bizType_Map.get(map.getValue()) != null) {
                    Long[] param = new Long[]{(Long)billType_bizType_Map.get(map.getValue()), (Long)map.getKey()};
                    sqlParam.add(param);
                }
                if (sqlParam.size() <= 0 || ++count <= 1000) continue;
                this.updateBizTypeSql(dbRoute, result, t_bizType, sqlParam);
                sqlParam.clear();
                count = 0;
            }
            if (sqlParam.size() > 0 && count > 0) {
                this.updateBizTypeSql(dbRoute, result, t_bizType, sqlParam);
                sqlParam.clear();
                count = 0;
            }
            billTypeSet.clear();
            id_billtype_Map.clear();
            billType_bizType_Map.clear();
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private UpgradeResult updateBizTypeSql(DBRoute dbRoute, UpgradeResult result, String t_bizType, List<Object[]> sqlParam) {
        StringBuilder sql_update = new StringBuilder(" UPDATE ");
        sql_update.append(t_bizType).append(" SET FBIZTYPEID =? ").append(" WHERE FID =? AND FBIZTYPEID = 0 ");
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                DB.executeBatch((DBRoute)dbRoute, (String)sql_update.toString(), sqlParam);
            }
            catch (Throwable e) {
                h.markRollback();
                result.setSuccess(false);
                String message = "database execution failed,errorInfo" + e.getMessage();
                result.setErrorInfo(message);
                result.setLog(message);
                logger.error(message);
                UpgradeResult upgradeResult = result;
                if (h != null) {
                    if (var7_7 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        return result;
    }
}

