/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.provider;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.util.StringUtils;

public class MateriaListDataProvider
extends ListDataProvider {
    private final String KEY_MaterialName;
    private final String KEY_Material;

    public MateriaListDataProvider(String materialName, String material) {
        this.KEY_MaterialName = materialName;
        this.KEY_Material = material;
    }

    public DynamicObjectCollection getData(int arg0, int arg1) {
        DynamicObjectCollection rows = super.getData(arg0, arg1);
        if (rows.isEmpty() || StringUtils.isEmpty((String)this.KEY_MaterialName) || StringUtils.isEmpty((String)this.KEY_Material)) {
            return rows;
        }
        DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
        if (properties.containsKey((Object)this.KEY_MaterialName) && properties.containsKey((Object)this.KEY_Material)) {
            String materialType = null;
            for (DynamicObject row : rows) {
                DynamicObject mateial = (DynamicObject)row.get(this.KEY_Material);
                if (!StringUtils.isEmpty((String)row.getString(this.KEY_MaterialName)) || !Objects.nonNull(mateial)) continue;
                if (materialType == null) {
                    materialType = mateial.getDynamicObjectType().getName();
                }
                ILocaleString localeString = null;
                if (materialType.equals("bd_material")) {
                    localeString = mateial.getLocaleString("name");
                } else if (materialType.equals("bd_materialpurchaseinfo") && mateial.get("masterid") != null) {
                    localeString = mateial.getLocaleString("masterid.name");
                }
                if (localeString == null) continue;
                row.set(this.KEY_MaterialName, (Object)localeString.toString());
            }
        }
        return rows;
    }
}

