/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IPageCache;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.report.helper.PurRptHelper;
import kd.scmc.pm.utils.DateUtil;

public class OpenOrderBillRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit bizType;
        BasedataEdit project;
        BasedataEdit material;
        BasedataEdit supplier;
        IReportView view = this.getView();
        BasedataEdit org = (BasedataEdit)view.getControl("headorg");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)view.getControl("headsupplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)view.getControl("headmaterial")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((project = (BasedataEdit)view.getControl("project")) != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizType = (BasedataEdit)view.getControl("headbiztype")) != null) {
            bizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        this.setDefaultValue();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String keyName = beforeF7SelectEvent.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("headorg");
        switch (keyName) {
            case "headorg": {
                List<Long> hasPermissionOrgList = this.getHasPermissionOrgListFromCache();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", hasPermissionOrgList));
                break;
            }
            case "headsupplier": 
            case "headmaterial": 
            case "project": {
                if (this.checkOrgIsNull(org)) {
                    beforeF7SelectEvent.setCancel(true);
                }
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        switch (keyName = e.getProperty().getName()) {
            case "headorg": {
                this.orgChangeEvent();
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo == null || filterInfo.getDynamicObject("headorg") == null) {
            this.showOrgTip();
            return false;
        }
        String calcStandard = filterInfo.getString("opencalcstandard");
        if (calcStandard == null || "".equals(calcStandard)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5728\u9014\u8ba1\u7b97\u6807\u51c6\u3002", (String)"OpenOrderBillRptPlugin_0", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getDate("startdate") == null || filterInfo.getDate("enddate") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"OpenOrderBillRptPlugin_4", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        this.showColumns(this.getShowFields(filterInfo));
    }

    protected void setDefaultValue() {
        String openCalcStandard;
        Date startDate;
        Date endDate;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("headorg");
        if (org == null) {
            long orgId = RequestContext.get().getOrgId();
            List<Long> hasPermissionOrgList = this.getHasPermissionOrgListFromCache();
            Long defaultOrg = PurRptHelper.getDefaultOrg(hasPermissionOrgList, orgId);
            if (defaultOrg != null) {
                this.setValue("headorg", defaultOrg);
            }
        }
        if ((endDate = (Date)model.getValue("enddate")) == null) {
            endDate = new Date();
            this.setValue("enddate", endDate);
        }
        if ((startDate = (Date)model.getValue("startdate")) == null) {
            this.setValue("startdate", DateUtil.localDateToDate((LocalDate)DateUtil.getStartOfYear((int)DateUtil.dateToLocalDate((Date)endDate).getYear())));
        }
        if ((openCalcStandard = (String)model.getValue("opencalcstandard")) == null) {
            this.setValue("opencalcstandard", "A");
        }
    }

    protected List<Long> getHasPermissionOrgListFromCache() {
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null) {
            List hasPermissionOrgList = OrgHelper.getHasPermissionOrg((String)"pm_openorderbillrpt", (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
            return hasPermissionOrgList;
        }
        String hasPermissionPurOrgKey = "hasPermissionPurOrg";
        String permissionOrgStr = pageCache.get(hasPermissionPurOrgKey);
        if (permissionOrgStr == null) {
            List hasPermissionOrgList = OrgHelper.getHasPermissionOrg((String)"pm_openorderbillrpt", (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
            if (hasPermissionOrgList == null || hasPermissionOrgList.size() == 0) {
                return null;
            }
            StringJoiner joiner = new StringJoiner(",", "", "");
            for (Long orgId : hasPermissionOrgList) {
                joiner.add(orgId.toString());
            }
            pageCache.put(hasPermissionPurOrgKey, joiner.toString());
            return hasPermissionOrgList;
        }
        return this.splitStringAndPutIdList(permissionOrgStr);
    }

    protected List<Long> splitStringAndPutIdList(String str) {
        String[] split = str.split(",");
        if (split.length == 0) {
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>(split.length);
        for (String orgIdStr : split) {
            idList.add(Long.valueOf(orgIdStr));
        }
        return idList;
    }

    protected Set<String> getShowFields(FilterInfo filterInfo) {
        if (filterInfo == null) {
            return null;
        }
        HashSet<String> showFieldSet = new HashSet<String>(16);
        boolean isCountByUnit = filterInfo.getBoolean("countbyunit");
        if (isCountByUnit) {
            showFieldSet.add("unit");
            showFieldSet.add("qty");
            showFieldSet.add("receiveqty");
            showFieldSet.add("invqty");
            showFieldSet.add("openqty");
        } else {
            showFieldSet.add("baseunit");
            showFieldSet.add("baseqty");
            showFieldSet.add("receivebaseqty");
            showFieldSet.add("invbaseqty");
            showFieldSet.add("openbaseqty");
        }
        String sumFoundations = filterInfo.getString("sumfoundation");
        if (sumFoundations != null && sumFoundations.length() > 0) {
            Set<String> sumFoundationSet = PurRptHelper.multipleChoiceStrToSetExcludeEmpty(sumFoundations, ",");
            for (String sumFoundation : sumFoundationSet) {
                showFieldSet.add(sumFoundation.substring(sumFoundation.indexOf(46) + 1));
            }
        }
        return showFieldSet;
    }

    protected void showColumns(Set<String> toShowColumnSet) {
        if (toShowColumnSet == null || toShowColumnSet.size() == 0) {
            return;
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        if (reportList == null) {
            return;
        }
        List columns = reportList.getColumns();
        for (AbstractReportColumn abstractReportColumn : columns) {
            ReportColumn column;
            String fieldKey;
            if (!(abstractReportColumn instanceof ReportColumn) || !toShowColumnSet.contains(fieldKey = (column = (ReportColumn)abstractReportColumn).getFieldKey())) continue;
            column.setHide(false);
        }
    }

    protected void orgChangeEvent() {
        this.setValue("headsupplier", null);
        this.setValue("headmaterial", null);
        this.setValue("project", null);
    }

    protected void showOrgTip() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"OpenOrderBillRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
    }

    protected boolean checkOrgIsNull(DynamicObject org) {
        if (org == null) {
            this.showOrgTip();
            return true;
        }
        return false;
    }

    protected void setValue(String key, Object value) {
        this.getModel().setValue(key, value);
    }
}

