/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.report.helper.PurRptHelper;
import kd.scmc.pm.utils.DateUtil;

public class OpenOrderBillRptQuery
extends AbstractReportListDataPlugin {
    private static final String[] SUM_FOUNDATION_ORDER_ARRAY = new String[]{"supplier", "entryreqorg", "entryrecorg"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        return PurRptHelper.countInvokeTime("pm_openorderbillrpt", this::doQuery, filterInfo);
    }

    protected DataSet doQuery(FilterInfo filterInfo) {
        QFilter[] qFilters = this.getQFilter(filterInfo);
        boolean isCountByUnit = filterInfo.getBoolean("countbyunit");
        String sumFoundations = filterInfo.getString("sumfoundation");
        StringJoiner selectFieldJoiner = new StringJoiner(",", "", "");
        this.getFields(filterInfo, selectFieldJoiner, isCountByUnit, sumFoundations);
        if (qFilters == null || qFilters.length == 0 || selectFieldJoiner.length() == 0) {
            return null;
        }
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"pm_openorderbillrpt", (String)"pm_purorderbill", (String)selectFieldJoiner.toString(), (QFilter[])qFilters, null);
        if (queryDataSet == null) {
            return null;
        }
        return this.dealDataSet(queryDataSet, isCountByUnit, sumFoundations, filterInfo);
    }

    protected QFilter[] getQFilter(FilterInfo filterInfo) {
        String changeStatus;
        DynamicObjectCollection projects;
        DynamicObjectCollection bizTypes;
        DynamicObject reqOrg;
        DynamicObject recOrg;
        DynamicObjectCollection materials;
        DynamicObjectCollection suppliers;
        Date endDate;
        if (filterInfo == null) {
            return null;
        }
        DynamicObject org = filterInfo.getDynamicObject("headorg");
        if (org == null) {
            return null;
        }
        QFilter qFilter = new QFilter("org", "=", org.getPkValue());
        qFilter.and("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        qFilter.and("closestatus", "=", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
        qFilter.and("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
        Date startDate = filterInfo.getDate("startdate");
        if (startDate != null) {
            qFilter.and("biztime", ">=", (Object)DateUtil.getStartOfDay((Date)startDate));
        }
        if ((endDate = filterInfo.getDate("enddate")) != null) {
            qFilter.and("biztime", "<=", (Object)DateUtil.getEndOfDay((Date)endDate));
        }
        if ((suppliers = filterInfo.getDynamicObjectCollection("headsupplier")) != null && suppliers.size() > 0) {
            qFilter.and("supplier", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(suppliers));
        }
        if ((materials = filterInfo.getDynamicObjectCollection("headmaterial")) != null && materials.size() > 0) {
            qFilter.and("billentry.material", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(materials));
        }
        if ((recOrg = filterInfo.getDynamicObject("headrecorg")) != null) {
            qFilter.and("billentry.entryrecorg", "=", recOrg.getPkValue());
        }
        if ((reqOrg = filterInfo.getDynamicObject("headreqorg")) != null) {
            qFilter.and("billentry.entryreqorg", "=", reqOrg.getPkValue());
        }
        if ((bizTypes = filterInfo.getDynamicObjectCollection("headbiztype")) != null && bizTypes.size() > 0) {
            qFilter.and("biztype", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(bizTypes));
        }
        if ((projects = filterInfo.getDynamicObjectCollection("project")) != null && projects.size() > 0) {
            qFilter.and("billentry.project", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(projects));
        }
        if ((changeStatus = filterInfo.getString("changestatus")) != null && !"".equals(changeStatus)) {
            qFilter.and("changestatus", "in", (Object)PurRptHelper.multipleChoiceStrToArrayExcludeEmpty(changeStatus, ","));
        }
        return qFilter.toArray();
    }

    protected void getFields(FilterInfo filterInfo, StringJoiner selectFieldJoiner, boolean isCountByUnit, String sumFoundations) {
        String openSubtraction;
        String asSql = " as ";
        String openCalcStandard = filterInfo.getString("opencalcstandard");
        if ("A".equals(openCalcStandard)) {
            openSubtraction = this.orderBillEntityFieldWithPrefix("receive");
        } else if ("B".equals(openCalcStandard)) {
            openSubtraction = this.orderBillEntityFieldWithPrefix("inv");
        } else {
            return;
        }
        selectFieldJoiner.add("'A'" + asSql + "rowtype").add("org").add("biztype").add(this.orderBillEntityFieldWithPrefix("material") + asSql + "material");
        String openQtyExpression = this.getOpenQtyExpression(isCountByUnit, openSubtraction);
        if (isCountByUnit) {
            selectFieldJoiner.add(this.orderBillEntityFieldWithPrefix("unit") + asSql + "unit").add(this.orderBillEntityFieldWithPrefix("qty") + asSql + "qty").add(this.orderBillEntityFieldWithPrefix("receiveqty") + asSql + "receiveqty").add(this.orderBillEntityFieldWithPrefix("invqty") + asSql + "invqty").add(openQtyExpression + asSql + "openqty");
        } else {
            selectFieldJoiner.add("billentry.baseunit" + asSql + "baseunit").add("billentry.baseqty" + asSql + "baseqty").add("billentry.receivebaseqty" + asSql + "receivebaseqty").add("billentry.invbaseqty" + asSql + "invbaseqty").add(openQtyExpression + asSql + "openbaseqty");
        }
        if (sumFoundations != null && !"".equals(sumFoundations)) {
            Set<String> sumFoundationSet = PurRptHelper.multipleChoiceStrToSetExcludeEmpty(sumFoundations, ",");
            if (sumFoundationSet.size() == 0) {
                return;
            }
            for (String sumFoundation : sumFoundationSet) {
                String showSumFoundation = sumFoundation.substring(sumFoundation.indexOf(46) + 1);
                selectFieldJoiner.add(sumFoundation + asSql + showSumFoundation);
            }
        }
    }

    protected DataSet dealDataSet(DataSet dataSet, boolean isCountByUnit, String sumFoundations, FilterInfo filterInfo) {
        ArrayList<String> orderByList = new ArrayList<String>();
        orderByList.add("material");
        orderByList.add(isCountByUnit ? "unit" : "baseunit");
        orderByList.add("rowtype");
        String[] countFields = this.getCountFields(isCountByUnit);
        ArrayList<String> groupByList = new ArrayList<String>();
        groupByList.add("material");
        groupByList.add(isCountByUnit ? "unit" : "baseunit");
        groupByList.add("biztype");
        groupByList.add("org");
        this.sumFoundationsGroupOrder(sumFoundations, groupByList, orderByList);
        dataSet = PurRptHelper.getDataSetGroupSum(dataSet, groupByList.toArray(new String[0]), countFields, "rowtype", "A");
        dataSet = this.dataSetShowCondition(dataSet, filterInfo, isCountByUnit);
        String countItem = filterInfo.getString("countitem");
        boolean isShowSum = countItem != null && !"".equals(countItem);
        DataSet dataSetSum = null;
        if (isShowSum) {
            String[] sumGroupByArray = new String[]{"material", isCountByUnit ? "unit" : "baseunit"};
            dataSetSum = PurRptHelper.getDataSetGroupSum(dataSet, sumGroupByArray, countFields, "rowtype", "B");
        }
        boolean isShowTotal = filterInfo.getBoolean("showtotal");
        DataSet dataSetTotal = null;
        if (isShowTotal) {
            dataSetTotal = PurRptHelper.getDataSetTotal(dataSet, countFields, "rowtype", "C");
        }
        if (isShowSum) {
            dataSet = dataSet.union(dataSetSum);
        }
        orderByList.add("biztype");
        dataSet = dataSet.orderBy(orderByList.toArray(new String[0]));
        return isShowTotal ? dataSet.union(dataSetTotal) : dataSet;
    }

    protected DataSet dataSetShowCondition(DataSet dataSet, FilterInfo filterInfo, boolean isCountByUnit) {
        String conditions = filterInfo.getString("filtercondition");
        if (conditions == null || "".equals(conditions)) {
            return dataSet;
        }
        Set<String> conditionSet = PurRptHelper.multipleChoiceStrToSetExcludeEmpty(conditions, ",");
        String dataSetWhereDelimiter = " and ";
        if (isCountByUnit) {
            return dataSet.where(String.join((CharSequence)dataSetWhereDelimiter, conditionSet));
        }
        StringJoiner joiner = new StringJoiner(dataSetWhereDelimiter, "", "");
        for (String condition : conditionSet) {
            joiner.add(condition.replaceAll("qty", "baseqty"));
        }
        return dataSet.where(joiner.toString());
    }

    protected void sumFoundationsGroupOrder(String sumFoundations, List<String> groupByList, List<String> orderByList) {
        if (sumFoundations != null && !"".equals(sumFoundations)) {
            Set<String> foundationSet = PurRptHelper.multipleChoiceStrToSetExcludeEmpty(sumFoundations, ",");
            for (String foundation : foundationSet) {
                String fieldName = foundation.substring(foundation.indexOf(46) + 1);
                groupByList.add(fieldName);
            }
            for (String foundation : SUM_FOUNDATION_ORDER_ARRAY) {
                if (!foundationSet.contains(foundation)) continue;
                orderByList.add(foundation);
            }
        }
    }

    protected String[] getCountFields(boolean isCountByUnit) {
        if (isCountByUnit) {
            return new String[]{"qty", "receiveqty", "invqty", "openqty"};
        }
        return new String[]{"baseqty", "receivebaseqty", "invbaseqty", "openbaseqty"};
    }

    protected String orderBillEntityFieldWithPrefix(String entityField) {
        return "billentry." + entityField;
    }

    protected String getOpenQtyExpression(boolean isCountByUnit, String subtrahendPrefix) {
        String subtrahend;
        String minuend;
        if (isCountByUnit) {
            minuend = "qty";
            subtrahend = subtrahendPrefix + "qty";
        } else {
            minuend = "baseqty";
            subtrahend = subtrahendPrefix + "baseqty";
        }
        return "(" + this.orderBillEntityFieldWithPrefix(minuend) + "-" + subtrahend + ")";
    }
}

