/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.report.helper.PurReceivingRptHelper;

public class PmReceivingTimeRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";

    public void registerListener(EventObject e) {
        BasedataEdit bizoperatorgroup;
        BasedataEdit bizoperator;
        BasedataEdit supplier;
        super.registerListener(e);
        BasedataEdit purorg = (BasedataEdit)this.getView().getControl("purorg");
        if (purorg != null) {
            purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperator = (BasedataEdit)this.getView().getControl("operator")) != null) {
            bizoperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperatorgroup = (BasedataEdit)this.getView().getControl("operategroup")) != null) {
            bizoperatorgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("operategroup");
        if (operateGroup == null || operateGroup.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"operator"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"operator"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        long orgId = RequestContext.get().getOrgId();
        List purorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (purorgList != null && !purorgList.isEmpty()) {
            if (purorgList.contains(orgId)) {
                model.setValue("purorg", (Object)orgId);
            } else {
                model.setValue("purorg", purorgList.get(0));
            }
            this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)purorgList));
            Object startdate = model.getValue("startdate");
            Object enddate = model.getValue("enddate");
            if (startdate == null && enddate == null) {
                this.setdefaultDate();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject orghead = (DynamicObject)this.getModel().getValue("purorg");
        switch (fieldKey) {
            case "purorg": {
                String purpkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (purpkSet == null || purpkSet.length() < 1) {
                    List orgList = OrgHelper.getHasPermissionOrg((String)"pm_vmi_settlementsumrpt", (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)purpkSet, List.class)));
                break;
            }
            case "supplier": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PmReceivingTimeRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)orghead.getPkValue()));
                showParameter.getListFilterParameter().setFilter(filter);
                showParameter.setCustomParam("useOrg", (Object)orghead.getPkValue().toString());
                showParameter.setShowApproved(false);
                break;
            }
            case "operategroup": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PmReceivingTimeRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long userId = UserServiceHelper.getCurrentUserId();
                List<Long> orgGrpList = PurReceivingRptHelper.getOperatorGroupByOrg(Long.parseLong(orghead.getPkValue().toString()));
                Object operatorGroupIsolate = AppParameterHelper.getPmAppParameter((Long)Long.parseLong(orghead.getPkValue().toString()), (String)"foperatorgroupisolate");
                if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                    List<Long> userGrpList = PurReceivingRptHelper.getOperatorGroupByUser(userId);
                    List<Long> grpList = PurReceivingRptHelper.getValidOperatorGroup(orgGrpList, userGrpList);
                    QFilter f = new QFilter("id", "in", grpList);
                    showParameter.getListFilterParameter().setFilter(f);
                    break;
                }
                QFilter f = new QFilter("id", "in", orgGrpList);
                showParameter.getListFilterParameter().setFilter(f);
                break;
            }
            case "operator": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PmReceivingTimeRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("operategroup");
                if (operateGroup == null || operateGroup.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u3002", (String)"PmReceivingTimeRptPlugin_2", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<String> groups = PmReceivingTimeRptPlugin.getBaseDataPkIds(operateGroup);
                PmReceivingTimeRptPlugin.getOperatorGroupByUser(groups, showParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "purorg": {
                this.getModel().setValue("supplier", null);
                this.getModel().setValue("operator", null);
                this.getModel().setValue("operategroup", null);
                break;
            }
            case "operategroup": {
                this.changeOperatorGroup((DynamicObjectCollection)newValue);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("purorg");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PmReceivingTimeRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"PmReceivingTimeRptPlugin_3", (String)"scmc-pm-report", (Object[])new Object[0]));
        return false;
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }

    private static List<String> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<String> pkIds = new ArrayList<String>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add(baseData.get("fbasedataid_id").toString());
        }
        return pkIds;
    }

    private static void getOperatorGroupByUser(List<String> list, ListShowParameter showParameter) {
        if (list != null && list.size() > 0) {
            ArrayList<Long> operatorGroupList = new ArrayList<Long>();
            for (String operateGroup : list) {
                operatorGroupList.add(Long.valueOf(operateGroup));
            }
            QFilter filter1 = new QFilter("operatorgrpid", "in", operatorGroupList);
            showParameter.getListFilterParameter().setFilter(filter1);
        }
    }

    public static List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        List orgAdminiDeptIds = OrgUnitServiceHelper.getAllToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (boolean)isIncludeFromOrgSelf);
        return orgAdminiDeptIds;
    }

    private void changeOperatorGroup(DynamicObjectCollection operatorGroup) {
        if (operatorGroup == null || operatorGroup.size() == 0) {
            this.getModel().setValue("operator", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"operator"});
        } else {
            this.getModel().setValue("operator", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"operator"});
        }
    }
}

