/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.CommonUtils;

public class PurApplyRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";

    public void registerListener(EventObject e) {
        BasedataEdit selectbill;
        BasedataEdit project;
        BasedataEdit bizuser;
        BasedataEdit dept;
        BasedataEdit material;
        BasedataEdit purorg = (BasedataEdit)this.getView().getControl("headorg");
        if (purorg != null) {
            purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((dept = (BasedataEdit)this.getView().getControl("headdept")) != null) {
            dept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizuser = (BasedataEdit)this.getView().getControl("headbizuser")) != null) {
            bizuser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((project = (BasedataEdit)this.getView().getControl("headproject")) != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((selectbill = (BasedataEdit)this.getView().getControl("selectbill")) != null) {
            selectbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        long orgId = RequestContext.get().getOrgId();
        List purorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (purorgList != null && !purorgList.isEmpty()) {
            if (purorgList.contains(orgId)) {
                model.setValue("headorg", (Object)orgId);
            } else {
                model.setValue("headorg", purorgList.get(0));
            }
            Object startdate = model.getValue("startdate");
            Object enddate = model.getValue("enddate");
            if (startdate == null && enddate == null) {
                this.setdefaultDate();
            }
        }
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject orghead = (DynamicObject)this.getModel().getValue("headorg");
        switch (fieldKey) {
            case "headorg": {
                String purpkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (purpkSet == null || purpkSet.length() < 1) {
                    List<Long> orgList = PurApplyRptPlugin.getHasPermissionOrg("pm_purapplyrpt", OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)purpkSet, List.class)));
                break;
            }
            case "headdept": {
                if (orghead != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurApplyRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "material": 
            case "headproject": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurApplyRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "selectbill": {
                if (orghead == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurApplyRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
                QFilter qFilterOrg = new QFilter("org", "=", orghead.getPkValue());
                qfilters.add(qFilterOrg);
                Date startdate = (Date)this.getModel().getValue("startdate");
                Date enddate = (Date)this.getModel().getValue("enddate");
                if (startdate != null && enddate != null) {
                    QFilter qFilterStartDate = new QFilter("biztime", ">=", (Object)this.getStartOrEndDate(startdate, false));
                    qfilters.add(qFilterStartDate);
                    QFilter qFilterEndDate = new QFilter("biztime", "<=", (Object)this.getStartOrEndDate(enddate, true));
                    qfilters.add(qFilterEndDate);
                }
                qfilters.add(new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.AUDIT.getValue()}));
                showParameter.getListFilterParameter().setQFilters(qfilters);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("headorg");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurApplyRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"PurApplyRptPlugin_2", (String)"scmc-pm-report", (Object[])new Object[0]));
        return false;
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        switch (key = e.getProperty().getName()) {
            case "headorg": {
                model.setValue("headdept", null);
                model.setValue("material", null);
                model.setValue("headproject", null);
            }
        }
    }

    private Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }
}

