/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.report.helper.PurOrderRptHelper;
import kd.scmc.pm.utils.CommonUtils;

public class PurOrderBillRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
ItemClickListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";
    protected static final String ORGF7 = "ischange";

    public void registerListener(EventObject e) {
        BasedataEdit selectbill;
        BasedataEdit bizdept;
        BasedataEdit bizoperatorgroup;
        BasedataEdit bizoperator;
        BasedataEdit material;
        BasedataEdit supplier;
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("orgfield");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplierfield")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("materialfield")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperator = (BasedataEdit)this.getView().getControl("bizoperatorfield")) != null) {
            bizoperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperatorgroup = (BasedataEdit)this.getView().getControl("bizoperatorgroupfield")) != null) {
            bizoperatorgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizdept = (BasedataEdit)this.getView().getControl("bizdeptfield")) != null) {
            bizdept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((selectbill = (BasedataEdit)this.getView().getControl("selectbill")) != null) {
            selectbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        String pkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
        long orgId = RequestContext.get().getOrgId();
        Object org = this.getModel().getValue("orgfield");
        if (org == null) {
            List orgList;
            if (pkSet == null || pkSet.length() < 1) {
                orgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
                this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)orgList));
                if (orgList != null && !orgList.isEmpty()) {
                    if (orgList.contains(orgId)) {
                        model.setValue("orgfield", (Object)orgId);
                    } else {
                        model.setValue("orgfield", orgList.get(0));
                    }
                }
            } else {
                orgList = (List)SerializationUtils.fromJsonString((String)pkSet, List.class);
                if (orgList != null && !orgList.isEmpty()) {
                    if (orgList.contains(orgId)) {
                        model.setValue("orgfield", (Object)orgId);
                    } else {
                        model.setValue("orgfield", orgList.get(0));
                    }
                }
            }
        }
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (startdate == null && enddate == null) {
            this.setdefaultDate();
        }
        this.controlBillStatusEnable(model);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgfield");
        switch (fieldKey) {
            case "orgfield": {
                String pkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (pkSet == null || pkSet.length() < 1) {
                    List orgList = OrgHelper.getHasPermissionOrg((String)showParameter.getFormId(), (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)orgList));
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
                } else {
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ORGF7);
                showParameter.setCloseCallBack(closeCallBack);
                break;
            }
            case "supplierfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBillRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)org.getPkValue()));
                showParameter.setShowApproved(false);
                showParameter.setCustomParam("useOrg", (Object)org.getPkValue().toString());
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "bizoperatorfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBillRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("bizoperatorgroupfield");
                if (operateGroup == null || operateGroup.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u3002", (String)"PurOrderBillRptPlugin_4", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<Long> groups = this.getBaseDataPkIds(operateGroup);
                PurOrderBillRptPlugin.getOperatorGroupByUser(groups, showParameter);
                break;
            }
            case "bizoperatorgroupfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBillRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long userId = UserServiceHelper.getCurrentUserId();
                List<Long> orgGrpList = PurOrderRptHelper.getOperatorGroupByOrg(Long.parseLong(org.getPkValue().toString()));
                Object operatorGroupIsolate = AppParameterHelper.getPmAppParameter((Long)Long.parseLong(org.getPkValue().toString()), (String)"foperatorgroupisolate");
                if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                    List<Long> userGrpList = PurOrderRptHelper.getOperatorGroupByUser(userId);
                    List<Long> grpList = PurOrderRptHelper.getValidOperatorGroup(orgGrpList, userGrpList);
                    QFilter f = new QFilter("id", "in", grpList);
                    showParameter.getListFilterParameter().setFilter(f);
                    break;
                }
                QFilter f = new QFilter("id", "in", orgGrpList);
                showParameter.getListFilterParameter().setFilter(f);
                break;
            }
            case "materialfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBillRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "selectbill": {
                List<Long> supplierIds;
                DynamicObjectCollection supplier;
                DynamicObject billtype;
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBillRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
                QFilter qFilterOrg = new QFilter("org", "=", org.getPkValue());
                qfilters.add(qFilterOrg);
                Date startdate = (Date)this.getModel().getValue("startdate");
                Date enddate = (Date)this.getModel().getValue("enddate");
                if (startdate != null && enddate != null) {
                    QFilter qFilterStartDate = new QFilter("biztime", ">=", (Object)this.getStartOrEndDate(startdate, false));
                    qfilters.add(qFilterStartDate);
                    QFilter qFilterEndDate = new QFilter("biztime", "<=", (Object)this.getStartOrEndDate(enddate, true));
                    qfilters.add(qFilterEndDate);
                }
                if ((billtype = (DynamicObject)this.getModel().getValue("billtypefield")) != null) {
                    QFilter qFilterbilltype = new QFilter("billtype", "=", billtype.getPkValue());
                    qfilters.add(qFilterbilltype);
                }
                if ((supplier = (DynamicObjectCollection)this.getModel().getValue("supplierfield")) != null && supplier.size() > 0 && (supplierIds = this.getBaseDataPkIds(supplier)) != null && supplierIds.size() > 0) {
                    QFilter qFilterSupplier = new QFilter("supplier", "in", supplierIds);
                    qfilters.add(qFilterSupplier);
                }
                qfilters.add(new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.AUDIT.getValue(), StatusEnum.SUBMIT.getValue()}));
                showParameter.getListFilterParameter().setQFilters(qfilters);
                break;
            }
            case "bizdeptfield": {
                if (org != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBillRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (key) {
            case "orgfield": {
                if (newValue != null && newValue.equals(oldValue)) {
                    return;
                }
                if (!"1".equals(this.getPageCache().get(ORGF7)) && newValue != null) break;
                model.setValue("materialfield", null);
                model.setValue("supplierfield", null);
                model.setValue("bizoperatorfield", null);
                model.setValue("bizoperatorgroupfield", null);
                model.setValue("bizdeptfield", null);
                model.setValue("selectbill", null);
                this.getPageCache().put(ORGF7, "0");
                break;
            }
            case "billstatusfield": {
                this.controlBillStatusEnable(model);
                break;
            }
            case "billtypefield": {
                if (newValue == null || newValue == oldValue) break;
                model.setValue("selectbill", null);
                break;
            }
            case "bizoperatorgroupfield": {
                model.setValue("bizoperatorfield", null);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "ischange": {
                if (closedCallBackEvent.getReturnData() == null) break;
                ListSelectedRowCollection returnValue = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                this.getPageCache().put(ORGF7, "1");
                this.getModel().setValue("orgfield", returnValue.getPrimaryKeyValues()[0]);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("orgfield");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBillRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"PurOrderBillRptPlugin_3", (String)"scmc-pm-report", (Object[])new Object[0]));
        return false;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        if ("billno".equals(evt.getFieldName())) {
            Object data = rowData.get("id");
            if (CommonUtils.isNull((Object)data.toString().trim())) {
                return;
            }
            Long billid = Long.valueOf(data.toString());
            this.showOneBillInfo("pm_purorderbill", billid);
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject rowData = packageDataEvent.getRowData();
        if ("3".equalsIgnoreCase(rowData.getString("summarytype"))) {
            // empty if block
        }
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }

    private List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add(baseData.getLong("fbasedataid_id"));
        }
        return pkIds;
    }

    private void showOneBillInfo(String entityid, Long billTypeID) {
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId(entityid);
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setPkId((Object)billTypeID);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void controlBillStatusEnable(IDataModel model) {
        String value = (String)this.getModel().getValue("billstatusfield");
        if (!StatusEnum.AUDIT.getValue().equals(value) && !"A".equals(value)) {
            model.setValue("closestatusfield", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
            model.setValue("rowstatusfield", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            this.getView().setEnable(Boolean.FALSE, new String[]{"closestatusfield"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"rowstatusfield"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"closestatusfield"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"rowstatusfield"});
        }
    }

    private static void getOperatorGroupByUser(List<Long> list, ListShowParameter showParameter) {
        if (list != null && list.size() > 0) {
            ArrayList<Long> operatorGroupList = new ArrayList<Long>();
            for (Long operateGroup : list) {
                operatorGroupList.add(operateGroup);
            }
            QFilter filter1 = new QFilter("operatorgrpid", "in", operatorGroupList);
            showParameter.getListFilterParameter().setFilter(filter1);
        }
    }
}

