/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class SelectBillPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SelectBillPlugin.class);
    private static final String CUSTPARAM_ORGID = "ORGID";
    private static final String CUSTPARAM_SUPPLIER = "SUPPLIER";
    private static final String CUSTPARAM_STARTDATE = "STARTDATE";
    private static final String CUSTPARAM_ENDDATE = "ENDDATE";
    private static final String BILLLIST = "billlistap";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getControl(BTN_OK);
        if (button != null) {
            button.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ORGID);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        String suppliers = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_SUPPLIER);
        if (suppliers != null && suppliers.trim().length() > 0) {
            filter = filter.and(new QFilter("supplier", "in", (Object)suppliers.split(",")));
        }
        String startdate = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_STARTDATE);
        String enddate = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENDDATE);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (startdate != null && enddate != null && startdate.trim().length() > 0 && enddate.trim().length() > 0) {
            Date start = null;
            Date end = null;
            try {
                start = sdf.parse(startdate);
                end = sdf.parse(enddate);
            }
            catch (ParseException e1) {
                log.info("\u51fa\u73b0\u5f02\u5e38-->" + e1.getMessage());
            }
            filter = filter.and(new QFilter("biztime", ">=", (Object)start).and(new QFilter("biztime", "<=", (Object)end)));
        }
        BillList billList = (BillList)this.getView().getControl(BILLLIST);
        billList.setFilter(filter);
        billList.refresh();
    }

    public void click(EventObject e) {
        BillList billList;
        ListSelectedRowCollection selectedRows;
        super.click(e);
        Control c = (Control)e.getSource();
        String key = c.getKey().toLowerCase();
        if (BTN_OK.equals(key) && (selectedRows = (billList = (BillList)this.getView().getControl(BILLLIST)).getSelectedRows()) != null && selectedRows.size() > 0) {
            ArrayList<String> list = new ArrayList<String>(selectedRows.size());
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow listSelectedRow = selectedRows.get(i);
                String billNo = listSelectedRow.getBillNo();
                list.add(billNo);
            }
            this.getView().returnDataToParent((Object)String.join((CharSequence)",", list));
        }
        this.getView().close();
    }
}

