/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.business.pojo.SupplierABCInfo;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.DateUtil;

public class SupplierABCRptQuery
extends AbstractReportListDataPlugin {
    private BigDecimal ALLAMOUNT = new BigDecimal(0);
    private BigDecimal PROPORTIONA = new BigDecimal(0);
    private BigDecimal PROPORTIONB = new BigDecimal(0);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        this.PROPORTIONA = filterInfo.getBigDecimal("proportiona");
        this.PROPORTIONB = filterInfo.getBigDecimal("proportionb");
        List<QFilter> filters = SupplierABCRptQuery.getFilters(filterInfo);
        String selectField = SupplierABCRptQuery.getSelectField();
        DataSet purOrder = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)selectField, (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        DataSet dataSet = purOrder.groupBy(new String[]{"supplier", "currency"}).sum("amount").finish().orderBy(new String[]{"amount desc"});
        DataSet amount = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)"billentry.curamountandtax as allamount", (QFilter[])filters.toArray(new QFilter[filters.size()]), null).groupBy().sum("allamount").finish();
        for (Row row : amount) {
            this.ALLAMOUNT = row.getBigDecimal("allamount");
        }
        dataSet = dataSet.select(this.getShowField());
        ArrayList<SupplierABCInfo> list = new ArrayList<SupplierABCInfo>();
        BigDecimal purproportion = BigDecimal.ZERO;
        for (Row row : dataSet) {
            SupplierABCInfo supplierABCInfo = new SupplierABCInfo();
            supplierABCInfo.setAmount(row.getBigDecimal("amount"));
            supplierABCInfo.setSupplier(row.getLong("supplier").longValue());
            supplierABCInfo.setPurproportion(row.getBigDecimal("purproportion"));
            supplierABCInfo.setCurrency(row.getLong("currency").longValue());
            purproportion = purproportion.add(row.getBigDecimal("purproportion"));
            BigDecimal rowpurproportion = row.getBigDecimal("purproportion");
            if (purproportion.compareTo(this.PROPORTIONA) < 0) {
                supplierABCInfo.setGroup("A");
            } else if (purproportion.compareTo(this.PROPORTIONA) >= 0 && purproportion.subtract(rowpurproportion).compareTo(this.PROPORTIONA) < 0) {
                supplierABCInfo.setGroup("A");
            } else if (purproportion.compareTo(this.PROPORTIONA) >= 0 && purproportion.subtract(rowpurproportion).compareTo(this.PROPORTIONB.add(this.PROPORTIONA)) < 0) {
                supplierABCInfo.setGroup("B");
            } else {
                supplierABCInfo.setGroup("C");
            }
            list.add(supplierABCInfo);
        }
        DataSet dataSet1 = this.createDataSet(list);
        return dataSet1;
    }

    private DataSet createDataSet(List<SupplierABCInfo> list) {
        List<Object[]> rows = this.createRow(list);
        Algo algo = Algo.create((String)(((Object)((Object)this)).getClass().getName() + ".query"));
        DataSetBuilder builder = algo.createDataSetBuilder(this.getRowMeta());
        if (rows != null && rows.size() > 0) {
            for (Object[] values : rows) {
                builder.append(values);
            }
        }
        return builder.build();
    }

    private RowMeta getRowMeta() {
        return new RowMeta(this.getRowMetaField().toArray(new Field[0]));
    }

    private List<Field> getRowMetaField() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("supplier", (DataType)DataType.LongType));
        fields.add(new Field("amount", (DataType)DataType.BigDecimalType));
        fields.add(new Field("purproportion", (DataType)DataType.BigDecimalType));
        fields.add(new Field("group", (DataType)DataType.StringType));
        fields.add(new Field("currency", (DataType)DataType.LongType));
        return fields;
    }

    private List<Object[]> createRow(List<SupplierABCInfo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(16);
        for (int i = 0; i < list.size(); ++i) {
            SupplierABCInfo info = list.get(i);
            Object[] row = new Object[]{info.getSupplier(), info.getAmount(), info.getPurproportion(), info.getGroup(), info.getCurrency()};
            rows.add(row);
        }
        return rows;
    }

    private String getShowField() {
        return "supplier,amount, currency, amount / " + this.ALLAMOUNT + " * 100  as purproportion";
    }

    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(3);
        selectorSet.add("supplier");
        selectorSet.add("billentry.curamountandtax as amount");
        selectorSet.add("currency as currency");
        return String.join((CharSequence)",", selectorSet);
    }

    private static List<QFilter> getFilters(FilterInfo filterInfo) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
        filters.add(new QFilter("billentry.curamountandtax", "<>", (Object)new BigDecimal(0)));
        DynamicObject purOrg = filterInfo.getDynamicObject("org");
        if (purOrg != null) {
            filters.add(new QFilter("org", "=", purOrg.getPkValue()));
        }
        return filters;
    }
}

