/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.DateUtil;

public class SupplierTradeSumRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List<QFilter> filters = this.getFilters(filterInfo);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)SupplierTradeSumRptQuery.getSelectField(), (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        dataSet = dataSet.groupBy(new String[]{"org", "supplier", "currency", "paidallamount", "billno"}).sum("curamount").sum("curtaxamount").sum("curamountandtax").sum("priceandtax").sum("purincuramount").sum("payableamount").sum("returnamount").finish();
        dataSet = dataSet.groupBy(new String[]{"org", "supplier", "currency"}).sum("paidallamount").sum("curamount").sum("curtaxamount").sum("curamountandtax").sum("priceandtax").sum("purincuramount").sum("payableamount").sum("returnamount").finish();
        return dataSet.select(this.getShowField());
    }

    public List<QFilter> getFilters(FilterInfo filterInfo) {
        Date endDate;
        Date startDate;
        DynamicObjectCollection supplers;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("headorg");
        if (org != null) {
            filters.add(new QFilter("org", "=", org.getPkValue()));
        }
        if ((supplers = filterInfo.getDynamicObjectCollection("headsupplier")) != null && supplers.size() > 0) {
            Object[] supplerids = SupplierTradeSumRptQuery.getBaseDataPkIds(supplers);
            filters.add(new QFilter("supplier", "in", (Object)supplerids));
        }
        if ((startDate = filterInfo.getDate("startdate")) != null) {
            filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        }
        if ((endDate = filterInfo.getDate("enddate")) != null) {
            filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        }
        filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
        return filters;
    }

    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(13);
        selectorSet.add("org");
        selectorSet.add("supplier");
        selectorSet.add("currency");
        selectorSet.add("billno");
        selectorSet.add("exchangerate");
        selectorSet.add("exchangetype");
        selectorSet.add("case when exchangetype = '0' then paidallamount * exchangerate  when exchangetype = '1' then paidallamount / exchangerate  end as paidallamount");
        selectorSet.add("billentry.curamount as curamount");
        selectorSet.add("billentry.curtaxamount as curtaxamount");
        selectorSet.add("billentry.curamountandtax as curamountandtax");
        selectorSet.add("billentry.priceandtax as priceandtax");
        selectorSet.add("case when exchangetype = '0' then billentry.invqty * billentry.priceandtax * exchangerate  when exchangetype = '1' then billentry.invqty * billentry.priceandtax / exchangerate  end as purincuramount");
        selectorSet.add("case when exchangetype = '0' then billentry.payablepriceqty * billentry.priceandtax * exchangerate  when exchangetype = '1' then billentry.payablepriceqty * billentry.priceandtax / exchangerate  end as payableamount");
        selectorSet.add("case when exchangetype = '0' then billentry.returnqty * billentry.priceandtax * exchangerate  when exchangetype = '1' then billentry.returnqty * billentry.priceandtax / exchangerate  end as returnamount");
        return String.join((CharSequence)",", selectorSet);
    }

    private String getShowField() {
        return "org, supplier, currency, curamount, curtaxamount, paidallamount, curamountandtax, purincuramount, payableamount, returnamount";
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

