/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.RowStatusRptEnum;
import kd.scmc.pm.enums.RowTerminateStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.report.helper.PurRptHelper;
import kd.scmc.pm.utils.DateUtil;

public class PurOrderRptHelper {
    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(36);
        selectorSet.add("id");
        selectorSet.add("org");
        selectorSet.add("billtype");
        selectorSet.add("dept");
        selectorSet.add("operatorgroup");
        selectorSet.add("operator");
        selectorSet.add("billno");
        selectorSet.add("biztime");
        selectorSet.add("supplier");
        selectorSet.add("supplier.name as suppliername");
        selectorSet.add("billentry.seq as rowseq");
        selectorSet.add("billentry.material.masterid as material");
        selectorSet.add("billentry.material.masterid.name as materialname");
        selectorSet.add("billentry.material.masterid.modelnum as modelnum");
        selectorSet.add("case when " + String.format(ResManager.loadKDString((String)"%1$s.material.masterid.materialtype='1' then '\u5e38\u89c4'  ", (String)"PurOrderRptHelper_0", (String)"scmc-pm-report", (Object[])new Object[0]), "billentry") + " when  " + String.format(ResManager.loadKDString((String)"%1$s.material.masterid.materialtype='2' then '\u865a\u62df'  ", (String)"PurOrderRptHelper_1", (String)"scmc-pm-report", (Object[])new Object[0]), "billentry") + " when  " + String.format(ResManager.loadKDString((String)"%1$s.material.masterid.materialtype='3' then '\u5957\u4ef6'  ", (String)"PurOrderRptHelper_2", (String)"scmc-pm-report", (Object[])new Object[0]), "billentry") + " when  " + String.format(ResManager.loadKDString((String)"%1$s.material.masterid.materialtype='4' then '\u53ef\u914d\u7f6e\u4ef6'  ", (String)"PurOrderRptHelper_3", (String)"scmc-pm-report", (Object[])new Object[0]), "billentry") + " when  " + String.format(ResManager.loadKDString((String)"%1$s.material.masterid.materialtype='5' then '\u7279\u5f81\u4ef6'  ", (String)"PurOrderRptHelper_4", (String)"scmc-pm-report", (Object[])new Object[0]), "billentry") + " when  " + String.format(ResManager.loadKDString((String)"%1$s.material.masterid.materialtype='6' then '\u8d44\u4ea7'  ", (String)"PurOrderRptHelper_5", (String)"scmc-pm-report", (Object[])new Object[0]), "billentry") + " when  " + String.format(ResManager.loadKDString((String)"%1$s.material.masterid.materialtype='7' then '\u8d39\u7528'  ", (String)"PurOrderRptHelper_6", (String)"scmc-pm-report", (Object[])new Object[0]), "billentry") + " when  " + String.format(ResManager.loadKDString((String)"%1$s.material.masterid.materialtype='8' then '\u8d44\u4ea7'  ", (String)"PurOrderRptHelper_7", (String)"scmc-pm-report", (Object[])new Object[0]), "billentry") + " when  " + String.format(ResManager.loadKDString((String)"%1$s.material.masterid.materialtype='9' then '\u670d\u52a1'  end as materialtype ", (String)"PurOrderRptHelper_8", (String)"scmc-pm-report", (Object[])new Object[0]), "billentry"));
        selectorSet.add("billentry.auxpty as auxpty");
        selectorSet.add("billentry.unit as unit");
        selectorSet.add("billentry.qty as qty");
        selectorSet.add("billentry.auxunit as auxunit");
        selectorSet.add("billentry.auxqty as auxqty");
        selectorSet.add("billentry.deliverdate as deliverdate");
        selectorSet.add("billentry.entryreqorg as entryreqorg");
        selectorSet.add("settlecurrency");
        selectorSet.add("billentry.priceandtax as priceandtax");
        selectorSet.add("billentry.amount as amount");
        selectorSet.add("billentry.amountandtax as amountandtax");
        selectorSet.add("billentry.receiveqty as receiveqty");
        selectorSet.add("billentry.invqty   as invqty");
        selectorSet.add("billentry.returnqty   as returnqty");
        selectorSet.add("billentry.payablepriceqty as payablepriceqty");
        selectorSet.add("case when billentry.rowclosestatus = '" + RowCloseStatusEnum.UNROWCLOSE.getValue() + "' then '" + RowCloseStatusEnum.UNROWCLOSE.getName() + "' when " + "billentry" + ".rowclosestatus = '" + RowCloseStatusEnum.ROWCLOSE.getValue() + "' then '" + RowCloseStatusEnum.ROWCLOSE.getName() + "'   end as rowclosestatus");
        selectorSet.add("case when billentry.rowterminatestatus = '" + RowTerminateStatusEnum.UNROWTERMINATE.getValue() + "' then '" + RowTerminateStatusEnum.UNROWTERMINATE.getName() + "'  when " + "billentry" + ".rowterminatestatus = '" + RowTerminateStatusEnum.ROWTERMINATE.getValue() + "' then '" + RowTerminateStatusEnum.ROWTERMINATE.getName() + "' end as rowterminatestatus");
        selectorSet.add("'0' as summarytype");
        selectorSet.add("billentry.entrycomment as entrycomment");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObject billtype;
        DynamicObjectCollection bizdepts;
        DynamicObjectCollection bizoperatorgroups;
        DynamicObjectCollection bizoperators;
        DynamicObjectCollection materials;
        DynamicObjectCollection purOrderBillNo;
        DynamicObjectCollection supplers;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        DynamicObject org = filterInfo.getDynamicObject("orgfield");
        if (org != null) {
            filters.add(new QFilter("org", "=", org.getPkValue()));
        }
        if ((supplers = filterInfo.getDynamicObjectCollection("supplierfield")) != null && supplers.size() > 0) {
            Object[] supplerids = PurOrderRptHelper.getBaseDataPkIds(supplers);
            filters.add(new QFilter("supplier", "in", (Object)supplerids));
        }
        if ((purOrderBillNo = filterInfo.getDynamicObjectCollection("selectbill")) != null && purOrderBillNo.size() > 0) {
            Object[] billNo = PurOrderRptHelper.getBaseDataPkIds(purOrderBillNo);
            filters.add(new QFilter("id", "in", (Object)billNo));
        }
        if ((materials = filterInfo.getDynamicObjectCollection("materialfield")) != null && materials.size() > 0) {
            Object[] materialIds = PurOrderRptHelper.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        }
        if ((bizoperators = filterInfo.getDynamicObjectCollection("bizoperatorfield")) != null && bizoperators.size() > 0) {
            Object[] bizoperatorIds = PurOrderRptHelper.getBaseDataPkIds(bizoperators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorIds));
        }
        if ((bizoperatorgroups = filterInfo.getDynamicObjectCollection("bizoperatorgroupfield")) != null && bizoperatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = PurOrderRptHelper.getBaseDataPkIds(bizoperatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((bizdepts = filterInfo.getDynamicObjectCollection("bizdeptfield")) != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = PurOrderRptHelper.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((billtype = filterInfo.getDynamicObject("billtypefield")) != null && billtype.getPkValue() != null) {
            filters.add(new QFilter("billtype", "=", billtype.getPkValue()));
        }
        List<QFilter> statusfilters = PurOrderRptHelper.getStatusFilter(filterInfo);
        filters.addAll(statusfilters);
        filters.add(new QFilter("billentry.material", "!=", null));
        filters.add(new QFilter("billentry.material.masterid", "!=", null));
        return filters;
    }

    private static List<QFilter> getStatusFilter(FilterInfo filterInfo) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String billstatus = filterInfo.getString("billstatusfield");
        if ("A".equals(billstatus)) {
            filters.add(new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.AUDIT.getValue(), StatusEnum.SUBMIT.getValue()}));
        } else if ("B".equals(billstatus)) {
            filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.SUBMIT.getValue()));
        } else {
            filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
        }
        String closestatus = filterInfo.getString("closestatusfield");
        if (BizCloseStatusEnum.CLOSE.getValue().equals(closestatus) || BizCloseStatusEnum.UNCLOSE.getValue().equals(closestatus)) {
            filters.add(new QFilter("closestatus", "=", (Object)closestatus));
        }
        String rowstatus = filterInfo.getString("rowstatusfield");
        if (RowStatusRptEnum.FINISH.getValue().equals(rowstatus)) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.ROWCLOSE.getValue());
            qFilter.or(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.ROWTERMINATE.getValue()));
            filters.add(qFilter);
        } else if (RowStatusRptEnum.UNFINISH.getValue().equals(rowstatus)) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            qFilter.and(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue()));
            filters.add(qFilter);
        }
        return filters;
    }

    public static List<Long> getOperatorGroupByOrg(long orgId) {
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "in", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue())});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }

    public static List<Long> getOperatorGroupByOrg(List<Long> allOrg) {
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", allOrg, (boolean)true);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "in", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue())});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }

    public static List<Long> getOperatorGroupByUser(long userID) {
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = new QFilter("operatorid", "=", (Object)userID);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_operator", (String)"id,operatorid,opergrptype,operatorgrpid", (QFilter[])new QFilter[]{q1, q2 = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue())});
        if (load != null && load.length > 0) {
            operatorGroupList = new ArrayList<Long>(load.length);
            for (DynamicObject dyn : load) {
                if (dyn == null) continue;
                operatorGroupList.add(dyn.getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }

    public static List<Long> getValidOperatorGroup(List<Long> orgGrpList, List<Long> userGrpList) {
        ArrayList<Long> grpList = new ArrayList<Long>();
        if (orgGrpList == null || orgGrpList.size() == 0) {
            return userGrpList;
        }
        if (userGrpList == null || userGrpList.size() == 0) {
            return null;
        }
        for (Long orgGrp : orgGrpList) {
            if (!userGrpList.contains(orgGrp)) continue;
            grpList.add(orgGrp);
        }
        return grpList;
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }

    public static List<QFilter> getFilters(Map<String, Object> params) {
        DynamicObject billtype;
        DynamicObjectCollection bizdepts;
        DynamicObjectCollection bizoperatorgroups;
        DynamicObjectCollection bizoperators;
        DynamicObjectCollection materials;
        DynamicObjectCollection purOrderBillNo;
        DynamicObjectCollection supplers;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Date startDate = (Date)params.get("startdate");
        filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = (Date)params.get("enddate");
        filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        DynamicObjectCollection org = (DynamicObjectCollection)params.get("orgfield");
        if (org != null && org.size() > 0) {
            Object[] orgs = PurOrderRptHelper.getBaseDataPkIds(org);
            filters.add(new QFilter("org", "in", (Object)orgs));
        }
        if ((supplers = (DynamicObjectCollection)params.get("supplierfield")) != null && supplers.size() > 0) {
            Object[] supplerids = PurRptHelper.getMasterIds(supplers);
            filters.add(new QFilter("supplier.masterid", "in", (Object)supplerids));
        }
        if ((purOrderBillNo = (DynamicObjectCollection)params.get("selectbill")) != null && purOrderBillNo.size() > 0) {
            Object[] billNo = PurOrderRptHelper.getBaseDataPkIds(purOrderBillNo);
            filters.add(new QFilter("id", "in", (Object)billNo));
        }
        if ((materials = (DynamicObjectCollection)params.get("materialfield")) != null && materials.size() > 0) {
            Object[] materialIds = PurOrderRptHelper.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        }
        if ((bizoperators = (DynamicObjectCollection)params.get("bizoperatorfield")) != null && bizoperators.size() > 0) {
            Object[] bizoperatorIds = PurOrderRptHelper.getBaseDataPkIds(bizoperators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorIds));
        }
        if ((bizoperatorgroups = (DynamicObjectCollection)params.get("bizoperatorgroupfield")) != null && bizoperatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = PurOrderRptHelper.getBaseDataPkIds(bizoperatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((bizdepts = (DynamicObjectCollection)params.get("bizdeptfield")) != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = PurOrderRptHelper.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((billtype = (DynamicObject)params.get("billtypefield")) != null && billtype.getPkValue() != null) {
            filters.add(new QFilter("billtype", "=", billtype.getPkValue()));
        }
        List<QFilter> statusfilters = PurOrderRptHelper.getStatusFilter(params);
        filters.addAll(statusfilters);
        filters.add(new QFilter("billentry.material", "!=", null));
        filters.add(new QFilter("billentry.material.masterid", "!=", null));
        return filters;
    }

    private static List<QFilter> getStatusFilter(Map<String, Object> params) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String billstatus = (String)params.get("billstatusfield");
        if ("A".equals(billstatus)) {
            filters.add(new QFilter("billstatus", "in", (Object)new String[]{StatusEnum.AUDIT.getValue(), StatusEnum.SUBMIT.getValue()}));
        } else if ("B".equals(billstatus)) {
            filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.SUBMIT.getValue()));
        } else {
            filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
        }
        String closestatus = (String)params.get("closestatusfield");
        if (BizCloseStatusEnum.CLOSE.getValue().equals(closestatus) || BizCloseStatusEnum.UNCLOSE.getValue().equals(closestatus)) {
            filters.add(new QFilter("closestatus", "=", (Object)closestatus));
        }
        String rowstatus = (String)params.get("rowstatusfield");
        if (RowStatusRptEnum.FINISH.getValue().equals(rowstatus)) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.ROWCLOSE.getValue());
            qFilter.or(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.ROWTERMINATE.getValue()));
            filters.add(qFilter);
        } else if (RowStatusRptEnum.UNFINISH.getValue().equals(rowstatus)) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            qFilter.and(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue()));
            filters.add(qFilter);
        }
        return filters;
    }
}

