/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class PurRptHelper {
    private static final Log log = LogFactory.getLog(PurRptHelper.class);
    public static final String DELIMITER = ",";
    public static final char POINT_STR = '.';
    public static final String EMPTY_STR = "";

    public static Object[] dynamicObjectCollectionToIdArray(DynamicObjectCollection collection) {
        return collection.stream().map(DataEntityBase::getPkValue).toArray(Object[]::new);
    }

    public static Set<String> multipleChoiceStrToSetExcludeEmpty(String multipleChoiceStr, String delimiter) {
        String[] values;
        HashSet<String> dropDownSet = new HashSet<String>(16);
        if (multipleChoiceStr == null || multipleChoiceStr.length() == 0) {
            return dropDownSet;
        }
        for (String value : values = multipleChoiceStr.split(delimiter)) {
            if (value == null || EMPTY_STR.equals(value)) continue;
            dropDownSet.add(value);
        }
        return dropDownSet;
    }

    public static String[] multipleChoiceStrToArrayExcludeEmpty(String multipleChoiceStr, String delimiter) {
        return PurRptHelper.multipleChoiceStrToSetExcludeEmpty(multipleChoiceStr, delimiter).toArray(new String[0]);
    }

    public static DataSet getDataSetTotal(DataSet dataSet, String[] countTotalFields, String totalFieldName, String totalFieldValue) {
        if (countTotalFields == null || countTotalFields.length == 0) {
            return dataSet;
        }
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        HashSet<String> countFieldSet = new HashSet<String>(32);
        GroupbyDataSet groupbyDataSet = PurRptHelper.dataSetGroupSum(dataSet, null, countTotalFields, countFieldSet);
        return groupbyDataSet.finish().select(PurRptHelper.getSumDataSetAllSelectFields(fieldNames, countFieldSet, totalFieldName, totalFieldValue));
    }

    public static DataSet getDataSetGroupSum(DataSet dataSet, String[] groupBy, String[] sumFields, String sumFieldName, String sumFieldValue) {
        if (groupBy == null || groupBy.length == 0 || sumFields == null || sumFields.length == 0) {
            return dataSet;
        }
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        HashSet<String> showFieldSet = new HashSet<String>(32);
        GroupbyDataSet groupbyDataSet = PurRptHelper.dataSetGroupSum(dataSet, groupBy, sumFields, showFieldSet);
        return groupbyDataSet.finish().select(PurRptHelper.getSumDataSetAllSelectFields(fieldNames, showFieldSet, sumFieldName, sumFieldValue));
    }

    public static Long getDefaultOrg(List<Long> hasPermissionOrgList, long orgId) {
        if (hasPermissionOrgList != null && hasPermissionOrgList.size() > 0) {
            for (Long org : hasPermissionOrgList) {
                if (orgId != org) continue;
                return orgId;
            }
            return hasPermissionOrgList.get(0);
        }
        return null;
    }

    private static GroupbyDataSet dataSetGroupSum(DataSet dataSet, String[] groupBy, String[] sumFields, Set<String> showFields) {
        GroupbyDataSet groupbyDataSet;
        if (groupBy == null || groupBy.length == 0) {
            groupbyDataSet = dataSet.groupBy();
        } else {
            groupbyDataSet = dataSet.groupBy(groupBy);
            showFields.addAll(Arrays.asList(groupBy));
        }
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
            showFields.add(sumField);
        }
        return groupbyDataSet;
    }

    private static String getSumDataSetAllSelectFields(String[] allFields, Set<String> includedField, String specialFieldName, String specialFieldValue) {
        StringJoiner joiner = new StringJoiner(DELIMITER, EMPTY_STR, EMPTY_STR);
        for (String fieldName : allFields) {
            if (fieldName.equals(specialFieldName)) {
                joiner.add("'" + specialFieldValue + "' as " + fieldName);
                continue;
            }
            if (includedField.contains(fieldName)) {
                joiner.add(fieldName);
                continue;
            }
            joiner.add("null as " + fieldName);
        }
        return joiner.toString();
    }

    public static <P, R> R countInvokeTime(String key, Function<P, R> function, P param) {
        long t1 = System.currentTimeMillis();
        R result = function.apply(param);
        long t2 = System.currentTimeMillis();
        log.info(key + "\u6267\u884c\u5b8c\u6210\uff0c\u8017\u65f6\uff1a\u3010" + (t2 - t1) + "\u3011\u6beb\u79d2\u3002");
        return result;
    }

    public static boolean hasField(RowMeta rowMeta, String[] fields) {
        for (String field : fields) {
            Field metaField = rowMeta.getField(field, false);
            if (metaField != null) continue;
            return false;
        }
        return true;
    }

    public static String[] removeUnOrderField(RowMeta rowMeta, String[] orderByFields) {
        if (orderByFields == null) {
            return new String[0];
        }
        String[] rowMetaFields = rowMeta.getFieldNames();
        List<String> rowMetaList = Arrays.asList(rowMetaFields);
        ArrayList<String> orderByField = new ArrayList<String>();
        for (String fieldStr : orderByFields) {
            String[] fields = fieldStr.split(" ");
            String field = fields[0];
            if (!rowMetaList.contains(field)) continue;
            orderByField.add(fieldStr);
        }
        return orderByField.toArray(new String[0]);
    }

    public static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add(Long.parseLong(baseData.getPkValue().toString()));
        }
        return pkIds;
    }

    public static QFilter getBaseDataFilter(String entityID, List<Long> orgIdList) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, orgIdList, (boolean)true);
    }

    public static List<Long> getAllOrg(Object org, boolean isQuery) {
        ArrayList<Long> listOrgId = new ArrayList<Long>();
        if (org instanceof DynamicObject) {
            DynamicObject orgObj = (DynamicObject)org;
            listOrgId.add((Long)orgObj.getPkValue());
        } else if (org instanceof DynamicObjectCollection) {
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                listOrgId.add(dynamicObject.getLong(isQuery ? "id" : "fbasedataid_id"));
            }
        }
        return listOrgId;
    }

    public static Object[] getMasterIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.get("masterid");
        }
        return pkIds;
    }

    public static Object[] getMaterialMasterIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject material;
            DynamicObject baseData = (DynamicObject)col.get(i);
            if (baseData == null || (material = baseData.getDynamicObject("masterid")) == null) continue;
            pkIds[i] = material.get("masterid");
        }
        return pkIds;
    }
}

