/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.materialabc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.report.helper.PurRptHelper;
import kd.scmc.pm.report.helper.transform.OrderByTransform;
import kd.scmc.pm.report.materialabc.MaterialABCTransform;
import kd.scmc.pm.utils.DateUtil;

public class MaterialABCRptHandle
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> filters = MaterialABCRptHandle.getFilters(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"pm_purorderbill".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("amount");
        repoColFilter.add("material");
        repoColFilter.add("currency");
        repoColFilter.add("purproportion");
        repoColFilter.add("group");
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        GroupPlan groupPlan = ctx.getGroupPlan();
        Collection QtyCols = groupPlan.getQtyCols();
        Collection keyCols = groupPlan.getKeyCols();
        groupPlan.setKeyCols(keyCols);
        groupPlan.setQtyCols(QtyCols);
        ctx.setGroupPlans(groupPlan);
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        BigDecimal PROPORTIONA = (BigDecimal)ctx.getParam("proportiona");
        BigDecimal PROPORTIONB = (BigDecimal)ctx.getParam("proportionb");
        transCollector.add(new MaterialABCTransform(PROPORTIONA, PROPORTIONB));
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        ArrayList<String> orderByFieldList = new ArrayList<String>();
        orderByFieldList.add("group asc");
        orderByFieldList.add("amount desc");
        orderByFieldList.add("purproportion desc");
        Set sumKeyCols = ctx.getSumKeyCols();
        transCollector.add(new OrderByTransform(orderByFieldList, sumKeyCols));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ArrayList<AbstractReportColumn> showCols = new ArrayList<AbstractReportColumn>(cols.size());
        ReportColumn reportCol = null;
        for (AbstractReportColumn abstractReportColumn : cols) {
            if (!(abstractReportColumn instanceof ReportColumn)) continue;
            reportCol = (ReportColumn)abstractReportColumn;
            String fieldKey = reportCol.getFieldKey();
            if ("material_ref_name".equals(fieldKey)) {
                reportCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"MaterialABCRptHandle_0", (String)"scmc-pm-report", (Object[])new Object[0])));
            } else if ("purproportion".equals(fieldKey)) {
                reportCol.setNoDisplayScaleZero(false);
                reportCol.setZeroShow(true);
                reportCol.setScale(2);
            }
            showCols.add((AbstractReportColumn)reportCol);
        }
        return showCols;
    }

    private static List<QFilter> getFilters(Map<String, Object> params) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date startDate = (Date)params.get("startdate");
        filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = (Date)params.get("enddate");
        filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
        filters.add(new QFilter("billentry.curamountandtax", "<>", (Object)new BigDecimal(0)));
        DynamicObjectCollection purOrg = (DynamicObjectCollection)params.get("purorg");
        if (purOrg != null && purOrg.size() > 0) {
            List<Long> baseDataPkIds = PurRptHelper.getBaseDataPkIds(purOrg);
            filters.add(new QFilter("org", "in", baseDataPkIds));
        }
        return filters;
    }
}

