/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.materialabc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.utils.CommonUtils;

public class MaterialABCRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";

    public void registerListener(EventObject e) {
        BasedataEdit purorg = (BasedataEdit)this.getView().getControl("purorg");
        if (purorg != null) {
            purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        queryParam.getCustomParam().put("purorg", filterInfo.getDynamicObjectCollection("purorg"));
        queryParam.getCustomParam().put("startdate", filterInfo.getDate("startdate"));
        queryParam.getCustomParam().put("enddate", filterInfo.getDate("enddate"));
        queryParam.getCustomParam().put("proportiona", filterInfo.getBigDecimal("proportiona"));
        queryParam.getCustomParam().put("proportionb", filterInfo.getBigDecimal("proportionb"));
        queryParam.getCustomParam().put("proportionc", filterInfo.getBigDecimal("proportionc"));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        long orgId = RequestContext.get().getOrgId();
        List purorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (purorgList != null && !purorgList.isEmpty()) {
            if (purorgList.contains(orgId)) {
                model.setValue("purorg", (Object)new Object[]{orgId});
            } else {
                model.setValue("purorg", (Object)new Object[]{purorgList.get(0)});
            }
            Object startdate = model.getValue("startdate");
            Object enddate = model.getValue("enddate");
            if (startdate == null && enddate == null) {
                this.setdefaultDate();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "purorg": {
                String purpkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (purpkSet == null || purpkSet.length() < 1) {
                    List<Long> orgListNew = MaterialABCRptPlugin.getHasPermissionOrg("pm_material_abcrpt_new", OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString(orgListNew));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgListNew));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)purpkSet, List.class)));
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        Object org = filter.getValue("purorg");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"MaterialABCRptPlugin_0", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        BigDecimal proportionA = filter.getBigDecimal("proportiona");
        BigDecimal proportionB = filter.getBigDecimal("proportionb");
        BigDecimal proportionC = filter.getBigDecimal("proportionc");
        if (proportionA.add(proportionB).add(proportionC).compareTo(new BigDecimal(100)) != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"ABC\u7c7b\u6bd4\u4f8b\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100\u3002", (String)"MaterialABCRptPlugin_4", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"MaterialABCRptPlugin_5", (String)"scmc-pm-report", (Object[])new Object[0]));
        return false;
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }
}

