/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.openorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.scmc.pm.report.helper.PurRptHelper;
import kd.scmc.pm.report.helper.transform.OrderByTransform;
import kd.scmc.pm.report.openorder.OpenOrderBillTransform;
import kd.scmc.pm.utils.DateUtil;

public class OpenOrderBillRptHandle
implements IReportDataHandle {
    private static final String[] qtyFields = new String[]{"qty", "receiveqty", "invqty", "openqty", "baseqty", "receivebaseqty", "invbaseqty", "openbaseqty"};

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        QFilter[] filters = this.getQFilter(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"pm_purorderbill".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("orgfield");
        repoColFilter.add("biztype");
        repoColFilter.add("material");
        repoColFilter.add("baseunit");
        repoColFilter.add("unit");
        repoColFilter.add("org");
        repoColFilter.add("rowtype");
        repoColFilter.add("openbaseqty");
        repoColFilter.add("baseqty");
        repoColFilter.add("receivebaseqty");
        repoColFilter.add("invbaseqty");
        repoColFilter.add("qty");
        repoColFilter.add("receiveqty");
        repoColFilter.add("invqty");
        repoColFilter.add("openqty");
        repoColFilter.add("supplier");
        repoColFilter.add("headrecorg");
        repoColFilter.add("headreqorg");
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        GroupPlan groupPlan = ctx.getGroupPlan();
        Collection qtyCols = groupPlan.getQtyCols();
        Collection keyCols = groupPlan.getKeyCols();
        for (String qtyField : qtyFields) {
            if (qtyCols.contains(qtyField)) continue;
            qtyCols.add(qtyField);
        }
        boolean isCountByUnit = (Boolean)ctx.getParam("countbyunit");
        if (isCountByUnit) {
            if (!keyCols.contains("unit")) {
                keyCols.add("unit");
            }
            keyCols.remove("baseunit");
        } else {
            if (!keyCols.contains("baseunit")) {
                keyCols.add("baseunit");
            }
            keyCols.remove("unit");
        }
        if (!keyCols.contains("org")) {
            keyCols.add("org");
        }
        if (!keyCols.contains("material")) {
            keyCols.add("material");
        }
        if (!keyCols.contains("biztype")) {
            keyCols.add("biztype");
        }
        groupPlan.setQtyCols(qtyCols);
        groupPlan.setKeyCols(keyCols);
        ctx.setGroupPlans(groupPlan);
    }

    public void beforeAddSumRow(ReportDataCtx ctx) {
        Set sumKeyCols = ctx.getSumKeyCols();
        Set sumKeyCols4Count = ctx.getSumKeyCols4Count();
        boolean isCountByUnit = (Boolean)ctx.getParam("countbyunit");
        if (isCountByUnit && sumKeyCols.contains("material")) {
            sumKeyCols4Count.add("unit");
            sumKeyCols.add("unit");
            sumKeyCols4Count.remove("baseunit");
        } else if (sumKeyCols.contains("material")) {
            sumKeyCols4Count.add("baseunit");
            sumKeyCols.add("baseunit");
            sumKeyCols4Count.remove("unit");
        }
        ctx.setSumKeyCols4Count(sumKeyCols4Count);
        ctx.setSumKeyCols(sumKeyCols);
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new OpenOrderBillTransform(ctx));
        List<String> orderByFieldList = this.getOrderByFieldList(ctx);
        Set sumKeyCols = ctx.getSumKeyCols();
        transCollector.add(new OrderByTransform(orderByFieldList, sumKeyCols));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        boolean isCountByUnit = (Boolean)ctx.getParam("countbyunit");
        List<String> isHideFields = this.getFields(isCountByUnit);
        ArrayList<AbstractReportColumn> showCols = new ArrayList<AbstractReportColumn>(cols.size());
        ReportColumn reportCol = null;
        for (AbstractReportColumn abstractReportColumn : cols) {
            if (!(abstractReportColumn instanceof ReportColumn)) continue;
            reportCol = (ReportColumn)abstractReportColumn;
            String fieldKey = reportCol.getFieldKey();
            if ("material_ref_modelnum".equals(fieldKey)) {
                reportCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"OpenOrderBillRptHandle_0", (String)"scmc-pm-report", (Object[])new Object[0])));
            }
            if ("material_ref_name".equals(fieldKey)) {
                reportCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"MaterialABCRptHandle_0", (String)"scmc-pm-report", (Object[])new Object[0])));
            }
            if (isHideFields.contains(fieldKey)) {
                reportCol.setHide(true);
            }
            if ("linetype".equals(reportCol.getFieldKey())) {
                if (!this.isSumAgain(ctx)) continue;
                showCols.add((AbstractReportColumn)reportCol);
                continue;
            }
            showCols.add((AbstractReportColumn)reportCol);
        }
        return showCols;
    }

    private QFilter[] getQFilter(Map<String, Object> params) {
        String changeStatus;
        DynamicObjectCollection projects;
        DynamicObjectCollection bizTypes;
        DynamicObject reqOrg;
        DynamicObject recOrg;
        DynamicObjectCollection materials;
        DynamicObjectCollection suppliers;
        Date endDate;
        if (params == null) {
            return null;
        }
        DynamicObjectCollection org = (DynamicObjectCollection)params.get("headorg");
        if (org == null || org.size() == 0) {
            return null;
        }
        List<Long> baseDataPkIds = PurRptHelper.getBaseDataPkIds(org);
        QFilter qFilter = new QFilter("org", "in", baseDataPkIds);
        Date startDate = (Date)params.get("startdate");
        if (startDate != null) {
            qFilter.and("biztime", ">=", (Object)DateUtil.getStartOfDay((Date)startDate));
        }
        if ((endDate = (Date)params.get("enddate")) != null) {
            qFilter.and("biztime", "<=", (Object)DateUtil.getEndOfDay((Date)endDate));
        }
        if ((suppliers = (DynamicObjectCollection)params.get("headsupplier")) != null && suppliers.size() > 0) {
            qFilter.and("supplier.masterid", "in", (Object)PurRptHelper.getMasterIds(suppliers));
        }
        if ((materials = (DynamicObjectCollection)params.get("headmaterial")) != null && materials.size() > 0) {
            qFilter.and("billentry.material.masterid", "in", (Object)PurRptHelper.getMaterialMasterIds(materials));
        }
        if ((recOrg = (DynamicObject)params.get("headrecorg")) != null) {
            qFilter.and("billentry.entryrecorg", "=", recOrg.getPkValue());
        }
        if ((reqOrg = (DynamicObject)params.get("headreqorg")) != null) {
            qFilter.and("billentry.entryreqorg", "=", reqOrg.getPkValue());
        }
        if ((bizTypes = (DynamicObjectCollection)params.get("headbiztype")) != null && bizTypes.size() > 0) {
            qFilter.and("biztype", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(bizTypes));
        }
        if ((projects = (DynamicObjectCollection)params.get("project")) != null && projects.size() > 0) {
            qFilter.and("billentry.project", "in", (Object)PurRptHelper.dynamicObjectCollectionToIdArray(projects));
        }
        if ((changeStatus = (String)params.get("changestatus")) != null && !"".equals(changeStatus)) {
            qFilter.and("changestatus", "in", (Object)PurRptHelper.multipleChoiceStrToArrayExcludeEmpty(changeStatus, ","));
        }
        return qFilter.toArray();
    }

    private List<String> getFields(boolean isCountByUnit) {
        ArrayList<String> fields = new ArrayList<String>(5);
        if (isCountByUnit) {
            fields.add("baseunit");
            fields.add("baseqty");
            fields.add("receivebaseqty");
            fields.add("invbaseqty");
            fields.add("openbaseqty");
        } else {
            fields.add("unit");
            fields.add("qty");
            fields.add("receiveqty");
            fields.add("invqty");
            fields.add("openqty");
        }
        return fields;
    }

    private List<String> getOrderByFieldList(ReportDataCtx ctx) {
        boolean isCountByUnit = (Boolean)ctx.getParam("countbyunit");
        String unit = isCountByUnit ? "unit" : "baseunit";
        ArrayList<String> orderByList = new ArrayList<String>();
        Set sumKeyCols = ctx.getSumKeyCols();
        if (sumKeyCols.size() == 0) {
            orderByList.add(this.getOrderByField("material", "asc"));
        }
        for (String field : sumKeyCols) {
            if (orderByList.contains(field)) continue;
            orderByList.add(this.getOrderByField(field, "asc"));
        }
        orderByList.add(this.getOrderByField(unit, "desc"));
        return orderByList;
    }

    private String getOrderByField(String orderByField, String ascOrDesc) {
        if (orderByField != null && ascOrDesc != null) {
            return orderByField + " " + ascOrDesc;
        }
        return orderByField;
    }

    private boolean isSumAgain(ReportDataCtx ctx) {
        Map param = ctx.getParams() != null ? ctx.getParams() : new HashMap();
        return Boolean.TRUE.equals(param.get("showtotalqty"));
    }
}

