/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.purorderquery;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pm.report.purorderquery.JoinFinApBillFunction;

public class JoinFinApBillTransform
implements IDataXTransform {
    public ReportDataCtx ctx;

    public JoinFinApBillTransform(ReportDataCtx ctx) {
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        List srcBlockConf = this.ctx.getReportConf().getSrcBlockConf();
        SrcBlockConf orderBlockConf = null;
        for (SrcBlockConf blockConf : srcBlockConf) {
            if (!"pm_purorderbill".equals(blockConf.getSrcEntity())) continue;
            orderBlockConf = blockConf;
        }
        if (orderBlockConf != null) {
            Grouper groupby = srcData.groupBy(new String[]{"invoicesupplier"});
            srcData = groupby.reduceGroup((GroupReduceFunction)new JoinFinApBillFunction(srcData.getRowMeta(), this.getShowFields(orderBlockConf)));
        }
        return srcData;
    }

    private String[] getShowFields(SrcBlockConf blockConf) {
        Set<String> allFields = this.getBigTableFields(this.ctx);
        HashSet<String> showFields = new HashSet<String>();
        Map repoColSrcColMap = blockConf.getRepoColFullSrcColMap();
        for (String key : repoColSrcColMap.keySet()) {
            if (!allFields.contains(key)) continue;
            showFields.add(key);
        }
        return showFields.toArray(new String[showFields.size()]);
    }

    private Set<String> getBigTableFields(ReportDataCtx ctx) {
        HashSet<String> bigTableCols = new HashSet<String>(32);
        bigTableCols.addAll(ctx.getShowKeyCols());
        bigTableCols.addAll(ctx.getShowQtyCols());
        ReportConf reportConf = ctx.getReportConf();
        for (IReportDataHandle plugin : reportConf.getPlugins()) {
            plugin.handleBigtableCols(bigTableCols, ctx);
        }
        return bigTableCols;
    }
}

