/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.purorderquery;

import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.scmc.pm.enums.MaterialTypeEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.RowTerminateStatusEnum;

public class PurOrderBillRptFunction
extends GroupReduceFunction {
    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowMeta rowMeta = this.getSourceRowMeta();
        Iterator<RowX> iterator = iterable.iterator();
        int losesFieldIndex = rowMeta.getFieldIndex("rowclosestatus");
        int termFieldIndex = rowMeta.getFieldIndex("rowterminatestatus");
        int materialTypeIndex = rowMeta.getFieldIndex("materialtype");
        while (iterator.hasNext()) {
            RowX rowX = iterator.next();
            String rowCloseStatus = rowX.getString(losesFieldIndex);
            String rowTerminateStatus = rowX.getString(termFieldIndex);
            String materialType = rowX.getString(materialTypeIndex);
            if (rowCloseStatus != null) {
                rowX.set(losesFieldIndex, (Object)RowCloseStatusEnum.getName((String)rowCloseStatus));
            }
            if (rowTerminateStatus != null) {
                rowX.set(termFieldIndex, (Object)RowTerminateStatusEnum.getName((String)rowTerminateStatus));
            }
            if (materialType != null) {
                String name = MaterialTypeEnum.getName((String)materialType);
                rowX.set(materialTypeIndex, (Object)name);
            }
            collector.collect(rowX);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }
}

