/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.purorderquery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pm.report.helper.PurOrderRptHelper;
import kd.scmc.pm.report.helper.transform.OrderByTransform;
import kd.scmc.pm.report.purorderquery.JoinFinApBillTransform;

public class PurOrderBillRptHandle
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> filters = PurOrderRptHelper.getFilters(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"pm_purorderbill".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("id");
        repoColFilter.add("billentryid");
        repoColFilter.add("entrysettleorg");
        repoColFilter.add("invoicesupplier");
        repoColFilter.add("settlecurrency");
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new JoinFinApBillTransform(ctx));
        transCollector.add(new IDataXTransform(){

            public DataSetX doTransform(DataSetX srcData) {
                return srcData.removeFields(new String[]{"billentryid", "entrysettleorg", "invoicesupplier"});
            }
        });
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("pm_purorderbill".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("rowclosestatus", "billentry.rowclosestatus");
            repoColFullSrcColMap.putIfAbsent("rowterminatestatus", "billentry.rowterminatestatus");
            repoColFullSrcColMap.putIfAbsent("materialtype", "billentry.material.masterid.materialtype");
            repoColFullSrcColMap.putIfAbsent("rowseq", "billentry.seq");
            repoColFullSrcColMap.putIfAbsent("id", "id");
            repoColFullSrcColMap.putIfAbsent("billentryid", "billentry.id");
        }
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        Collection keyCols = ctx.getGroupPlan().getKeyCols();
        if (!keyCols.contains("settlecurrency")) {
            keyCols.add("settlecurrency");
        }
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        ArrayList<String> orderByFieldList = new ArrayList<String>();
        orderByFieldList.add(this.getOrderByField("billno", "desc"));
        orderByFieldList.add(this.getOrderByField("rowseq", "asc"));
        Set sumKeyCols = ctx.getSumKeyCols();
        transCollector.add(new OrderByTransform(orderByFieldList, sumKeyCols));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ReportColumn reportCol = null;
        for (AbstractReportColumn col : cols) {
            if (!(col instanceof ReportColumn)) continue;
            reportCol = (ReportColumn)col;
            String fieldKey = reportCol.getFieldKey();
            if ("billno".equals(fieldKey)) {
                reportCol.setHyperlink(true);
            }
            if (!"summarytype".equals(fieldKey)) continue;
            reportCol.setZeroShow(true);
        }
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (!"linetype".equals(((ReportColumn)cols.get(i)).getFieldKey()) || this.isSumAgain(ctx)) continue;
            cols.remove(i);
        }
        return cols;
    }

    private String getOrderByField(String orderByField, String ascOrDesc) {
        if (orderByField != null && ascOrDesc != null) {
            return orderByField + " " + ascOrDesc;
        }
        return orderByField;
    }

    private boolean isSumAgain(ReportDataCtx ctx) {
        Map param = ctx.getParams() != null ? ctx.getParams() : new HashMap();
        return Boolean.TRUE.equals(param.get("showtotalqty"));
    }
}

