/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.receiverate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class ReceiveTimeRateFunction
extends GroupReduceFunction {
    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowMeta rowMeta = this.getSourceRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        int expireOrderNumIndex = rowMeta.getFieldIndex("expireordernum");
        int onTimeNumIndex = rowMeta.getFieldIndex("ontimenum");
        Iterator<RowX> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            RowX x = new RowX(fieldNames.length + 1);
            RowX rowX = iterator.next();
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                int fieldIndex = rowMeta.getFieldIndex(fieldName);
                Object value = rowX.get(fieldIndex);
                x.set(i, value);
            }
            Integer expireOrderNum = rowX.getInteger(expireOrderNumIndex);
            Integer onTimeNum = rowX.getInteger(onTimeNumIndex);
            if (expireOrderNum != null && expireOrderNum != 0 && onTimeNum != null && onTimeNum != 0) {
                BigDecimal delivertimerate = new BigDecimal(onTimeNum).divide(new BigDecimal(expireOrderNum), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                x.set(fieldNames.length, (Object)delivertimerate);
            } else {
                x.set(fieldNames.length, (Object)BigDecimal.ZERO);
            }
            collector.collect(x);
        }
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = this.getSourceRowMeta();
        Field[] fields = sourceRowMeta.getFields();
        Field[] newFields = new Field[fields.length + 1];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        newFields[fields.length] = new Field("delivertimerate", (DataType)DataType.BigDecimalType);
        RowMeta rowMeta = new RowMeta(newFields);
        return rowMeta;
    }
}

