/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.receiverate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pm.report.receiverate.ReceiveTimeRateTransform;

public class ReceiveTimeRateRptHandle
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        for (SrcBlockConf srcBlockConf : blockCollector) {
            Set supplierPks;
            List operatorPks;
            List operatorGroupPks;
            List orgPks;
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"pm_purorderbill".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            if ((orgPks = (List)params.get("org")) != null && orgPks.size() > 0) {
                dataFs.and(new QFilter("org", "in", (Object)orgPks));
            }
            if ((operatorGroupPks = (List)params.get("operatorgroup")) != null && operatorGroupPks.size() > 0) {
                dataFs.and(new QFilter("operatorgroup", "in", (Object)operatorGroupPks));
            }
            if ((operatorPks = (List)params.get("operator")) != null && operatorPks.size() > 0) {
                dataFs.and(new QFilter("operator", "in", (Object)operatorPks));
            }
            if ((supplierPks = (Set)params.get("supplier")) != null && supplierPks.size() > 0) {
                dataFs.and(new QFilter("supplier.masterid", "in", (Object)supplierPks));
            }
            Date startDate = this.getStartDate((Date)ctx.getParam("startdate"));
            Date endDate = this.getEndDate((Date)ctx.getParam("enddate"));
            if (startDate == null || endDate == null) continue;
            QFilter deliveryRangeFilter = new QFilter("billentry.deliverdate", "<=", (Object)endDate).and(new QFilter("billentry.deliverdate", ">=", (Object)startDate));
            QFilter deliveryTodayFilter = new QFilter("billentry.deliverdate", "=", (Object)ReceiveTimeRateRptHandle.getDate(TimeServiceHelper.today()));
            dataFs.and(deliveryRangeFilter.or(deliveryTodayFilter));
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("id");
        repoColFilter.add("entryid");
        repoColFilter.add("auditdate");
        repoColFilter.add("closestatus");
        repoColFilter.add("unit");
        repoColFilter.add("qty");
        repoColFilter.add("invqty");
        repoColFilter.add("deliverdate");
        repoColFilter.add("rowclosestatus");
        repoColFilter.add("rowterminatestatus");
        repoColFilter.add("expireordernum");
        repoColFilter.add("todaynum");
        repoColFilter.add("overduenum");
        repoColFilter.add("ontimenum");
        repoColFilter.add("overnum");
        repoColFilter.add("delivertimerate");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("pm_purorderbill".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("id", "id");
            repoColFullSrcColMap.putIfAbsent("entryid", "billentry.id");
            Map repoColSrcColMap = blockConf.getRepoColSrcColMap();
            repoColSrcColMap.putIfAbsent("id", "id");
            repoColSrcColMap.putIfAbsent("entryid", "entryid");
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new ReceiveTimeRateTransform(ctx));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new IDataTransform(){

            public DataSet doTransform(DataSet srcData) {
                if (this.hasField(srcData.getRowMeta(), new String[]{"suppliernumber", "operatorgroup", "operator"})) {
                    return srcData.orderBy(new String[]{"suppliernumber", "operatorgroup", "operator"});
                }
                return srcData;
            }

            private boolean hasField(RowMeta rowMeta, String[] fields) {
                for (String field : fields) {
                    Field metaField = rowMeta.getField(field, false);
                    if (metaField != null) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        LinkedList<AbstractReportColumn> showCols = new LinkedList<AbstractReportColumn>();
        LinkedList<AbstractReportColumn> shippingColumns = new LinkedList<AbstractReportColumn>();
        LinkedList<AbstractReportColumn> deliveredColumns = new LinkedList<AbstractReportColumn>();
        AbstractReportColumn rate = null;
        for (AbstractReportColumn col : cols) {
            ReportColumn column = (ReportColumn)col;
            String fieldKey = column.getFieldKey();
            if ("todaynum".equals(fieldKey) || "overduenum".equals(fieldKey)) {
                shippingColumns.add(col);
                continue;
            }
            if ("ontimenum".equals(fieldKey) || "overnum".equals(fieldKey)) {
                deliveredColumns.add(col);
                continue;
            }
            if ("delivertimerate".equals(fieldKey)) {
                rate = col;
                continue;
            }
            showCols.add(col);
        }
        LocaleString shipCaption = ResManager.getLocaleString((String)"\u5f85\u6536\u8d27", (String)"DeliveryTimeRateRptHandle_0", (String)"scmc-sm-report");
        ReportColumnGroup dropShipping = this.createColumnGroup("dropshipping", shipCaption, shippingColumns);
        showCols.add((AbstractReportColumn)dropShipping);
        LocaleString deliveredCaption = ResManager.getLocaleString((String)"\u5df2\u6536\u8d27", (String)"DeliveryTimeRateRptHandle_1", (String)"scmc-sm-report");
        ReportColumnGroup delivered = this.createColumnGroup("delivered", deliveredCaption, deliveredColumns);
        showCols.add((AbstractReportColumn)delivered);
        showCols.add(rate);
        return showCols;
    }

    private ReportColumnGroup createColumnGroup(String groupKey, LocaleString caption, List<AbstractReportColumn> columns) {
        ReportColumnGroup columnGroup = new ReportColumnGroup();
        columnGroup.setCaption(caption);
        columnGroup.setFieldKey(groupKey);
        columnGroup.getChildren().addAll(columns);
        return columnGroup;
    }

    private Date getStartDate(Date date) {
        return ReceiveTimeRateRptHandle.getDate(date);
    }

    public static Date getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getEndDate(Date date) {
        Date endDate = new Date();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String format = sdf.format(date) + " 23:59:59";
        try {
            endDate = sdf1.parse(format);
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
        return endDate;
    }
}

