/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.receiverate;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.report.helper.PurOrderRptHelper;
import kd.scmc.pm.report.helper.PurRptHelper;

public class ReceiveTimeRateRptPlugin
extends AbstractReportFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";
    private static final String HEAD_ORG = "org_h";
    private static final String HEAD_SUPPLIER = "supplier_h";
    private static final String HEAD_OPERATOR = "operator_h";
    private static final String HEAD_OPERATORGROUP = "operatorgroup_h";

    public void registerListener(EventObject e) {
        BasedataEdit bizoperatorgroup;
        BasedataEdit bizoperator;
        BasedataEdit supplier;
        super.registerListener(e);
        BasedataEdit purorg = (BasedataEdit)this.getView().getControl(HEAD_ORG);
        if (purorg != null) {
            purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl(HEAD_SUPPLIER)) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperator = (BasedataEdit)this.getView().getControl(HEAD_OPERATOR)) != null) {
            bizoperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizoperatorgroup = (BasedataEdit)this.getView().getControl(HEAD_OPERATORGROUP)) != null) {
            bizoperatorgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue(HEAD_OPERATORGROUP);
        if (operateGroup == null || operateGroup.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{HEAD_OPERATOR});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{HEAD_OPERATOR});
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        long orgId = RequestContext.get().getOrgId();
        List purorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (purorgList != null && !purorgList.isEmpty()) {
            if (purorgList.contains(orgId)) {
                model.setValue(HEAD_ORG, (Object)new Object[]{orgId});
            } else {
                model.setValue(HEAD_ORG, (Object)new Object[]{purorgList.get(0)});
            }
            this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)purorgList));
            Object startdate = model.getValue("startdate");
            Object enddate = model.getValue("enddate");
            if (startdate == null && enddate == null) {
                this.setdefaultDate();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObjectCollection orghead = (DynamicObjectCollection)this.getModel().getValue(HEAD_ORG);
        List<Long> orgIds = ReceiveTimeRateRptPlugin.getBaseDataPkIds(orghead);
        switch (fieldKey) {
            case "org_h": {
                String purpkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (purpkSet == null || purpkSet.length() < 1) {
                    List orgList = OrgHelper.getHasPermissionOrg((String)"pm_vmi_settlementsumrpt", (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)purpkSet, List.class)));
                break;
            }
            case "supplier_h": {
                if (orgIds == null || orgIds.size() <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PmReceivingTimeRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", orgIds, (boolean)true);
                showParameter.getListFilterParameter().setFilter(filter);
                showParameter.setCustomParam("useOrgs", orgIds);
                showParameter.setShowApproved(false);
                break;
            }
            case "operatorgroup_h": {
                if (orgIds == null || orgIds.size() <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PmReceivingTimeRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter q1 = PurRptHelper.getBaseDataFilter("bd_operatorgroup", orgIds);
                QFilter q2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
                showParameter.getListFilterParameter().setFilter(q1.and(q2));
                break;
            }
            case "operator_h": {
                if (orgIds == null || orgIds.size() <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PmReceivingTimeRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue(HEAD_OPERATORGROUP);
                if (operateGroup == null || operateGroup.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u3002", (String)"PmReceivingTimeRptPlugin_2", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<Long> groups = ReceiveTimeRateRptPlugin.getBaseDataPkIds(operateGroup);
                ReceiveTimeRateRptPlugin.getOperatorGroupByUser(groups, showParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "org_h": {
                this.getModel().setValue(HEAD_SUPPLIER, null);
                this.getModel().setValue(HEAD_OPERATOR, null);
                this.getModel().setValue(HEAD_OPERATORGROUP, null);
                break;
            }
            case "operatorgroup_h": {
                this.changeOperatorGroup((DynamicObjectCollection)newValue);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection org = filter.getDynamicObjectCollection(HEAD_ORG);
        if (org == null || org != null && org.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PmReceivingTimeRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"PmReceivingTimeRptPlugin_3", (String)"scmc-pm-report", (Object[])new Object[0]));
        return false;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection org;
        Date endDate;
        super.beforeQuery(queryParam);
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        Map customParam = queryParam.getCustomParam();
        Date startDate = data.getDate("startdate");
        if (startDate != null) {
            customParam.put("startdate", startDate);
        }
        if ((endDate = data.getDate("enddate")) != null) {
            customParam.put("enddate", endDate);
        }
        if ((org = data.getDynamicObjectCollection(HEAD_ORG)) != null && org.size() > 0) {
            customParam.put("org", ReceiveTimeRateRptPlugin.getBaseDataPkIds(org));
        } else {
            customParam.put("org", null);
        }
        DynamicObjectCollection supplier = data.getDynamicObjectCollection(HEAD_SUPPLIER);
        if (supplier != null && supplier.size() > 0) {
            customParam.put("supplier", this.getMasterIDs(supplier));
        } else {
            customParam.put("supplier", null);
        }
        DynamicObjectCollection operatorGroup = data.getDynamicObjectCollection(HEAD_OPERATORGROUP);
        if (operatorGroup != null && operatorGroup.size() > 0) {
            customParam.put("operatorgroup", ReceiveTimeRateRptPlugin.getBaseDataPkIds(operatorGroup));
        } else {
            customParam.put("operatorgroup", null);
        }
        DynamicObjectCollection operator = data.getDynamicObjectCollection(HEAD_OPERATOR);
        if (operator != null && operator.size() > 0) {
            customParam.put("operator", ReceiveTimeRateRptPlugin.getBaseDataPkIds(operator));
        } else {
            customParam.put("operator", null);
        }
    }

    private Set<Object> getMasterIDs(DynamicObjectCollection fields) {
        return fields.stream().map(a -> a.getLong("fbasedataid.masterid")).collect(Collectors.toSet());
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }

    private static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.get("fbasedataid_id"));
        }
        return pkIds;
    }

    private static void getOperatorGroupByUser(List<Long> list, ListShowParameter showParameter) {
        if (list != null && list.size() > 0) {
            QFilter filter1 = new QFilter("operatorgrpid", "in", list);
            showParameter.getListFilterParameter().setFilter(filter1);
        }
    }

    public static List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        List orgAdminiDeptIds = OrgUnitServiceHelper.getAllToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (boolean)isIncludeFromOrgSelf);
        return orgAdminiDeptIds;
    }

    private void changeOperatorGroup(DynamicObjectCollection operatorGroup) {
        if (operatorGroup == null || operatorGroup.size() == 0) {
            this.getModel().setValue(HEAD_OPERATOR, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{HEAD_OPERATOR});
        } else {
            this.getModel().setValue(HEAD_OPERATOR, null);
            this.getView().setEnable(Boolean.TRUE, new String[]{HEAD_OPERATOR});
        }
    }

    private void findFilterField(Container cont, List<FieldEdit> fieldList, List<FilterGrid> filterGridList) {
        for (Control ctrl : cont.getItems()) {
            if (ctrl instanceof FieldEdit) {
                fieldList.add((FieldEdit)ctrl);
                continue;
            }
            if (ctrl instanceof FilterGrid) {
                filterGridList.add((FilterGrid)ctrl);
                continue;
            }
            if (!(ctrl instanceof Container) || ctrl instanceof EntryGrid) continue;
            this.findFilterField((Container)ctrl, fieldList, filterGridList);
        }
    }

    private static QFilter getOperatorGroupQFilter(List<Long> allOrg) {
        if (allOrg == null) {
            return null;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> orgNoIsolate = new ArrayList<Long>();
        ArrayList<Long> orgIsolate = new ArrayList<Long>();
        Map map = SysParamHelper.batchGetSysParam((String)"/JJVO8XV9MVB", (String)"02", allOrg, (String)"foperatorgroupisolate");
        for (Long orgLong : allOrg) {
            Object operatorGroupIsolate = map.get(String.valueOf(orgLong));
            if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                orgIsolate.add(orgLong);
                continue;
            }
            orgNoIsolate.add(orgLong);
        }
        List<Long> orgGrpList = PurOrderRptHelper.getOperatorGroupByOrg(orgNoIsolate);
        List operatorGrpList = OperatorGroupHelper.getAllOperatorGroupByOrgsAndUser(orgIsolate, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue(), (Long)userId);
        return new QFilter("id", "in", (Object)operatorGrpList.addAll(orgGrpList));
    }
}

