/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.receiverate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.pm.report.receiverate.DateEqualsFilterFunction;
import kd.scmc.pm.report.receiverate.DateRangeFilterFunction;
import kd.scmc.pm.report.receiverate.ReceiveMaxTimeFunction;
import kd.scmc.pm.report.receiverate.ReceiveNumberFunction;
import kd.scmc.pm.report.receiverate.ReceiveTimeRateFunction;

public class ReceiveTimeRateTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private static String[] allFields = new String[]{"overduenum", "ontimenum", "overnum", "todaynum", "expireordernum"};

    public ReceiveTimeRateTransform(ReportDataCtx ctx) {
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.hasField(srcData.getRowMeta(), new String[]{"suppliernumber", "suppliername", "org", "operatorgroup", "operator", "deliverdate", "expireordernum", "todaynum", "overduenum", "ontimenum", "overnum"})) {
            Date startDate = this.getStartDate((Date)this.ctx.getParam("startdate"));
            Date endDate = this.getEndDate((Date)this.ctx.getParam("enddate"));
            srcData = srcData.reduceGroup((GroupReduceFunction)new ReceiveMaxTimeFunction()).reduceGroup((GroupReduceFunction)new ReceiveNumberFunction(startDate, endDate));
            DataSetX expire = srcData.filter((FilterFunction)new DateRangeFilterFunction("deliverdate", startDate, endDate));
            DataSetX expireNum = this.sum(expire, new String[]{"suppliernumber", "suppliername", "operatorgroup", "operator", "org"}, new String[]{"expireordernum"});
            DataSetX today = srcData.filter((FilterFunction)new DateEqualsFilterFunction("deliverdate", this.getDate(TimeServiceHelper.today())));
            DataSetX todayNum = this.sum(today, new String[]{"suppliernumber", "suppliername", "org", "operatorgroup", "operator"}, new String[]{"todaynum"});
            DataSetX overDueNum = this.sum(srcData, new String[]{"suppliernumber", "suppliername", "org", "operatorgroup", "operator"}, new String[]{"overduenum", "ontimenum", "overnum"});
            DataSetX union = expireNum.union(todayNum).union(overDueNum).groupBy(new String[]{"suppliernumber", "suppliername", "org", "operatorgroup", "operator"}).sum("expireordernum").sum("todaynum").sum("overduenum").sum("ontimenum").sum("overnum");
            union = union.filter("overduenum!=0 or ontimenum!=0 or overnum!=0 or todaynum!=0 or expireordernum!=0");
            DataSetX result = union.reduceGroup((GroupReduceFunction)new ReceiveTimeRateFunction());
            return result;
        }
        return srcData;
    }

    private DataSetX sum(DataSetX dataSetX, String[] groupBy, String[] sum) {
        ArrayList<String> needFields = new ArrayList<String>();
        Grouper grouper = dataSetX.groupBy(groupBy);
        for (int i = 0; i < sum.length; ++i) {
            dataSetX = i == 0 ? grouper.sum(sum[i]) : dataSetX.sum(sum[i]);
        }
        ArrayList<String> list = new ArrayList<String>(groupBy.length + sum.length);
        for (String g : groupBy) {
            list.add(g);
        }
        for (String s : sum) {
            list.add(s);
        }
        for (String field : allFields) {
            if (list.contains(field)) continue;
            needFields.add(field);
        }
        if (needFields.size() > 0) {
            Field[] fields = new Field[needFields.size()];
            Object[] values = new Object[needFields.size()];
            for (int i = 0; i < needFields.size(); ++i) {
                String name = (String)needFields.get(i);
                fields[i] = new Field(name, (DataType)DataType.IntegerType);
                values[i] = 0;
            }
            dataSetX = dataSetX.addFields(fields, values);
        }
        return dataSetX.select(new String[]{"suppliernumber", "suppliername", "operatorgroup", "operator", "org", "overduenum", "ontimenum", "overnum", "todaynum", "expireordernum"});
    }

    private Date getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private boolean hasField(RowMeta rowMeta, String[] fields) {
        for (String field : fields) {
            Field metaField = rowMeta.getField(field, false);
            if (metaField != null) continue;
            return false;
        }
        return true;
    }

    private Date getStartDate(Date date) {
        return this.getDate(date);
    }

    private Date getEndDate(Date date) {
        Date endDate = new Date();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String format = sdf.format(date) + " 23:59:59";
        try {
            endDate = sdf1.parse(format);
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
        return endDate;
    }
}

