/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.recplan;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class RecPlanMapFunc
extends MapFunction {
    private static final long serialVersionUID = -4608626409625090570L;
    private final RowMeta rowMeta;
    private static final String ON_TIME_FILED = "ontimefield";
    private static final String OUT_TIME_FILED = "outtimefield";
    private static final String UNFINISHED_FILED = "unfinishedfield";
    private static final String BILL_CLOSE_STATUS_FILED = "billclosestatusfield";
    private static final String ROW_CLOSE_STATUS_FILED = "rowclosestatusfield";
    private static final String ROW_TERM_STATUS_FILED = "rowtermstatusfield";
    private static final String REC_QTY_FIELD = "recqtyfield";
    private static final String PLAN_REC_QTY_FIELD = "planrecqtyfield";
    private static final String REC_DATE_FIELD = "recdatefield";
    private static final String PLAN_REC_DATE_FIELD = "planrecdatefield";
    private static final int UNFINISHED_TIME = -1;
    private static final int ON_TIME = 0;
    private static final int OUT_TIME = 1;

    public RowX map(RowX rowX) {
        int unfinishedIndex;
        int outTimeIndex;
        int onTimeIndex;
        Integer recResult = this.getRecResult(rowX);
        if (recResult == null) {
            return rowX;
        }
        if (0 == recResult && (onTimeIndex = this.rowMeta.getFieldIndex(ON_TIME_FILED, false)) != -1) {
            rowX.set(onTimeIndex, (Object)1);
        }
        if (1 == recResult && (outTimeIndex = this.rowMeta.getFieldIndex(OUT_TIME_FILED, false)) != -1) {
            rowX.set(outTimeIndex, (Object)1);
        }
        if (-1 == recResult && (unfinishedIndex = this.rowMeta.getFieldIndex(UNFINISHED_FILED, false)) != -1) {
            rowX.set(unfinishedIndex, (Object)1);
        }
        return rowX;
    }

    private Integer getRecResult(RowX rowX) {
        Boolean isClosed = this.isClosed(rowX);
        BigDecimal recQty = this.getBigDecimalField(rowX, REC_QTY_FIELD);
        BigDecimal planRecQty = this.getBigDecimalField(rowX, PLAN_REC_QTY_FIELD);
        Date recDate = this.getDateField(rowX, REC_DATE_FIELD);
        Date planRecDate = this.getDateField(rowX, PLAN_REC_DATE_FIELD);
        boolean isRecQtyFinished = this.isRecQtyFinished(planRecQty, recQty);
        boolean isRecOutTime = this.isRecOutTime(planRecDate, recDate);
        if (isClosed == null || planRecDate == null || planRecQty == null) {
            return null;
        }
        if (isClosed.booleanValue()) {
            return isRecOutTime ? 1 : 0;
        }
        if (isRecQtyFinished) {
            return isRecOutTime ? 1 : 0;
        }
        return -1;
    }

    private boolean isRecOutTime(Date planRecDate, Date recDate) {
        if (planRecDate == null || recDate == null) {
            return false;
        }
        return recDate.after(planRecDate);
    }

    private boolean isRecQtyFinished(BigDecimal planRecQty, BigDecimal recQty) {
        if (planRecQty == null || recQty == null) {
            return false;
        }
        return recQty.compareTo(planRecQty) >= 0;
    }

    private Date getDateField(RowX rowX, String fieldName) {
        int fieldIndex = this.rowMeta.getFieldIndex(fieldName, false);
        if (fieldIndex == -1) {
            return null;
        }
        return rowX.getDate(fieldIndex);
    }

    private BigDecimal getBigDecimalField(RowX rowX, String fieldName) {
        int fieldIndex = this.rowMeta.getFieldIndex(fieldName, false);
        if (fieldIndex == -1) {
            return null;
        }
        return rowX.getBigDecimal(fieldIndex);
    }

    private Boolean isClosed(RowX rowX) {
        int rowTermStatusIndex;
        int rowCloseStatusIndex;
        int closeStatusIndex = this.rowMeta.getFieldIndex(BILL_CLOSE_STATUS_FILED, false);
        boolean fieldMiss = true;
        if (closeStatusIndex != -1) {
            fieldMiss = false;
            String billClose = rowX.getString(closeStatusIndex);
            if ("B".equals(billClose)) {
                return Boolean.TRUE;
            }
        }
        if ((rowCloseStatusIndex = this.rowMeta.getFieldIndex(ROW_CLOSE_STATUS_FILED, false)) != -1) {
            fieldMiss = false;
            String rowClose = rowX.getString(rowCloseStatusIndex);
            if ("B".equals(rowClose)) {
                return Boolean.TRUE;
            }
        }
        if ((rowTermStatusIndex = this.rowMeta.getFieldIndex(ROW_TERM_STATUS_FILED, false)) != -1) {
            fieldMiss = false;
            String rowTerm = rowX.getString(rowTermStatusIndex);
            if ("B".equals(rowTerm)) {
                return Boolean.TRUE;
            }
        }
        if (fieldMiss) {
            return null;
        }
        return Boolean.FALSE;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RecPlanMapFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }
}

