/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.supplierabc;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pm.report.supplierabc.SupplierABCTransForm;
import kd.scmc.pm.utils.DateUtil;

public class SupplierABCRptHandle
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        QFilter filter = SupplierABCRptHandle.getFilter(params);
        for (SrcBlockConf conf : blockCollector) {
            String srcEntity = conf.getSrcEntity();
            if (!"pm_purorderbill".equalsIgnoreCase(srcEntity)) continue;
            conf.getDataFs().and(filter);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("curamountandtax");
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new IDataTransform(){

            public DataSet doTransform(DataSet srcData) {
                return srcData.orderBy(new String[]{"curamountandtax desc"});
            }
        });
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SupplierABCTransForm(ctx));
    }

    private static QFilter getFilter(Map<String, Object> filterInfo) {
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        Date startDate = (Date)filterInfo.get("startdate");
        filter.and(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filter.and(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        filter.and(new QFilter("billentry.curamountandtax", "<>", (Object)new BigDecimal(0)));
        List purOrgPk = (List)filterInfo.get("org");
        if (purOrgPk != null && purOrgPk.size() > 0) {
            filter.and(new QFilter("org", "in", (Object)purOrgPk));
        }
        return filter;
    }
}

