/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.suppliertradesum;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pm.report.helper.PurRptHelper;
import kd.scmc.pm.report.helper.transform.OrderByTransform;
import kd.scmc.pm.report.suppliertradesum.SupplierTradeSumRptTransform;
import kd.scmc.pm.utils.DateUtil;

public class SupplierTradeSumRptHandle
implements IReportDataHandle {
    private static final String[] quantityField = new String[]{"curamount", "curtaxamount", "curamountandtax", "purincuramount", "purincuramount", "payableamount", "paidallamount", "returnamount"};

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> filters = this.getFilters(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"pm_purorderbill".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("curamount");
        repoColFilter.add("curamountandtax");
        repoColFilter.add("curtaxamount");
        repoColFilter.add("purincuramount");
        repoColFilter.add("payableamount");
        repoColFilter.add("paidallamount");
        repoColFilter.add("returnamount");
        repoColFilter.add("priceandtax");
        repoColFilter.add("billno");
        repoColFilter.add("exchangerate");
        repoColFilter.add("invqty");
        repoColFilter.add("payablepriceqty");
        repoColFilter.add("returnqty");
        repoColFilter.add("currency");
        repoColFilter.add("supplier");
        repoColFilter.add("org");
        repoColFilter.add("quotation");
        repoColFilter.add("discounttype");
        repoColFilter.add("discountrate");
        repoColFilter.add("taxrateid");
        repoColFilter.add("price");
        repoColFilter.add("istax");
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new SupplierTradeSumRptTransform());
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        ArrayList<String> orderByFieldList = new ArrayList<String>();
        orderByFieldList.add(this.getOrderByField("supplier", "asc"));
        Set sumKeyCols = ctx.getSumKeyCols();
        transCollector.add(new OrderByTransform(orderByFieldList, sumKeyCols));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ReportColumn reportCol = null;
        ArrayList<AbstractReportColumn> showCols = new ArrayList<AbstractReportColumn>(cols.size());
        for (AbstractReportColumn col : cols) {
            if (!(col instanceof ReportColumn)) continue;
            reportCol = (ReportColumn)col;
            String fieldKey = reportCol.getFieldKey();
            if (fieldKey.equals("supplier_ref_name")) {
                reportCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u540d\u79f0", (String)"SupplierTradeSumRptHandle_0", (String)"scmc-pm-report", (Object[])new Object[0])));
            }
            if (this.fieldKeyINFields(fieldKey, quantityField)) {
                reportCol.setCurrencyField("currency");
                reportCol.setNoDisplayScaleZero(false);
                reportCol.setScale(4);
            }
            showCols.add((AbstractReportColumn)reportCol);
        }
        return showCols;
    }

    private boolean fieldKeyINFields(String fieldKey, String[] Fields) {
        for (String field : Fields) {
            if (!field.equals(fieldKey)) continue;
            return true;
        }
        return false;
    }

    private String getOrderByField(String orderByField, String ascOrDesc) {
        if (orderByField != null && ascOrDesc != null) {
            return orderByField + " " + ascOrDesc;
        }
        return orderByField;
    }

    public List<QFilter> getFilters(Map<String, Object> params) {
        Date endDate;
        Date startDate;
        DynamicObjectCollection supplers;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObjectCollection org = (DynamicObjectCollection)params.get("headorg");
        List<Long> orgList = PurRptHelper.getBaseDataPkIds(org);
        if (orgList.size() > 0) {
            filters.add(new QFilter("org", "in", orgList));
        }
        if ((supplers = (DynamicObjectCollection)params.get("headsupplier")) != null && supplers.size() > 0) {
            filters.add(new QFilter("supplier.masterid", "in", (Object)PurRptHelper.getMasterIds(supplers)));
        }
        if ((startDate = (Date)params.get("startdate")) != null) {
            filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        }
        if ((endDate = (Date)params.get("enddate")) != null) {
            filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        }
        return filters;
    }
}

