/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.suppliertradesum;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.report.helper.PurRptHelper;
import kd.scmc.pm.utils.CommonUtils;

public class SupplierTradeSumRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";

    public void registerListener(EventObject e) {
        BasedataEdit supplier;
        BasedataEdit purorg = (BasedataEdit)this.getView().getControl("headorg");
        if (purorg != null) {
            purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("headsupplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        long orgId = RequestContext.get().getOrgId();
        List purorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (purorgList != null && !purorgList.isEmpty()) {
            if (purorgList.contains(orgId)) {
                model.setValue("headorg", (Object)new Object[]{orgId});
            } else {
                model.setValue("headorg", (Object)new Object[]{purorgList.get(0)});
            }
            Object startdate = model.getValue("startdate");
            Object enddate = model.getValue("enddate");
            if (startdate == null && enddate == null) {
                this.setdefaultDate();
            }
        }
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObjectCollection orghead = (DynamicObjectCollection)this.getModel().getValue("headorg");
        List<Long> listOrgId = null;
        listOrgId = orghead != null ? PurRptHelper.getAllOrg(orghead, false) : new ArrayList<Long>();
        switch (fieldKey) {
            case "headorg": {
                String purpkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (purpkSet == null || purpkSet.length() < 1) {
                    List<Long> orgList = SupplierTradeSumRptPlugin.getHasPermissionOrg("pm_suppliertradesummary_n", OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)purpkSet, List.class)));
                break;
            }
            case "headsupplier": {
                if (orghead == null || orghead.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"SupplierTradeSumRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter filter = PurRptHelper.getBaseDataFilter("bd_supplier", listOrgId);
                showParameter.getListFilterParameter().getQFilters().add(filter);
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        switch (key = e.getProperty().getName()) {
            case "headorg": {
                model.setValue("headsupplier", null);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection org = filter.getDynamicObjectCollection("headorg");
        if (org == null || org.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"SupplierTradeSumRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"SupplierTradeSumRptPlugin_2", (String)"scmc-pm-report", (Object[])new Object[0]));
        return false;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        queryParam.getCustomParam().put("headorg", filterInfo.getValue("headorg"));
        queryParam.getCustomParam().put("headsupplier", filterInfo.getValue("headsupplier"));
        queryParam.getCustomParam().put("startdate", filterInfo.getValue("startdate"));
        queryParam.getCustomParam().put("enddate", filterInfo.getValue("enddate"));
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }
}

