/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.report.pureshistoricalprice;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class ComputHistoryPriceFunction
extends GroupReduceFunction {
    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        RowMeta rowMeta = this.getSourceRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        int curhistorypriceIndex = rowMeta.getFieldIndex("curhistoryprice");
        int recordhighpriceIndex = rowMeta.getFieldIndex("recordhighprice");
        int recordlowpriceIndex = rowMeta.getFieldIndex("recordlowprice");
        int recordavgpriceIndex = rowMeta.getFieldIndex("recordavgprice");
        while (iterator.hasNext()) {
            RowX x = new RowX(fieldNames.length + 1);
            RowX next = iterator.next();
            for (int index = 0; index < fieldNames.length; ++index) {
                String fieldName = fieldNames[index];
                Object value = next.get(rowMeta.getFieldIndex(fieldName));
                x.set(index, value);
            }
            int historypriceIndex = fieldNames.length;
            BigDecimal historyprice = next.getBigDecimal(curhistorypriceIndex);
            BigDecimal recordhighprice = next.getBigDecimal(recordhighpriceIndex);
            BigDecimal recordlowprice = next.getBigDecimal(recordlowpriceIndex);
            BigDecimal recordavgprice = next.getBigDecimal(recordavgpriceIndex);
            if (historyprice.compareTo(recordavgprice) == 0) {
                x.set(historypriceIndex, (Object)"C");
            } else if (historyprice.compareTo(recordhighprice) >= 0) {
                x.set(historypriceIndex, (Object)"A");
            } else if (historyprice.compareTo(recordlowprice) <= 0) {
                x.set(historypriceIndex, (Object)"B");
            } else if (historyprice.compareTo(recordavgprice) > 0) {
                x.set(historypriceIndex, (Object)"D");
            } else {
                x.set(historypriceIndex, (Object)"E");
            }
            collector.collect(x);
        }
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = this.getSourceRowMeta();
        Field[] fields = sourceRowMeta.getFields();
        Field[] newFields = new Field[fields.length + 1];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        newFields[fields.length] = new Field("compared", (DataType)DataType.StringType);
        RowMeta rowMeta = new RowMeta(newFields);
        return rowMeta;
    }
}

