/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.servicehelper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class ServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new KDBizException(String.format(ServiceFactory.getServiceFactoryServerImplStr(), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    private static String getServiceFactoryServerImplStr() {
        return ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_1", (String)"scmc-sbs-servicehelper", (Object[])new Object[0]);
    }

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    static {
        serviceMap.put("ReserveService", "kd.scmc.sbs.mservice.ReserveServiceImpl");
        serviceMap.put("NewReserveService", "kd.scmc.sbs.mservice.ReserveServiceImpl");
        serviceMap.put("SNService", "kd.scmc.sbs.mservice.SNServiceDataSetImpl");
        serviceMap.put("SerialNumberService", "kd.scmc.sbs.mservice.SerialNumberServiceImpl");
        serviceMap.put("BillSNRelationService", "kd.scmc.sbs.mservice.BillSNRelationServiceImpl");
        serviceMap.put("SnInvaccRelRestoreService", "kd.scmc.sbs.mservice.SnInvaccRelRestoreServiceImpl");
        serviceMap.put("SerialNumberAuditECService", "kd.scmc.sbs.mservice.SerialNumberAuditECService");
        serviceMap.put("ReserveScmParamUpgradeService", "kd.scmc.sbs.mservice.ReserveScmParamUpgradeServiceImpl");
        serviceMap.put("PriceModelScmParamInitService", "kd.scmc.sbs.mservice.PriceModelScmParamInitServiceImpl");
        serviceMap.put("BalanceinvSchemeUpdateService", "kd.scmc.sbs.mservice.BalanceinvSchemeUpdateServiceImpl");
        serviceMap.put("CarryingSerialNumberService", "kd.scmc.sbs.mservice.CarryingSerialNumberServiceImpl");
        serviceMap.put("DeleteMoveTrackService", "kd.scmc.sbs.mservice.DeleteMoveTrackService");
    }
}

