/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.reservation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.sbs.common.pagemodel.ImInvacc;
import kd.scmc.sbs.common.util.F7Utils;
import org.apache.commons.lang3.StringUtils;

public class ReserveHelper {
    private static final String[] STRINGS = new String[]{"id", "baseqty", "reservebaseqty", "qty", "reserveqty", "qty2nd", "reserveunit2ndqty"};
    private static String[] LEFT_COLS = new String[]{"id", "baseqty", "qty", "qty2nd", "lockbaseqty", "lockqty", "lockqty2nd"};
    private static final String[] RIGHT_COLS = new String[]{"reservebaseqty", "reserveqty", "reserveunit2ndqty"};
    private static final String[] CASE_COLS = new String[]{"case when reservebaseqty is Null then 0 else reservebaseqty end as reservebaseqty", "case when reserveqty is Null then 0 else reserveqty end as reserveqty", "case when reserveunit2ndqty is Null then 0 else reserveunit2ndqty end as reserveunit2ndqty"};
    private static final String[] AVBQTY_COLS = new String[]{"(baseqty-reservebaseqty) as avbbaseqty", "(qty-reserveqty) as avbbqty", "(qty2nd-reserveunit2ndqty) as avbbtndqty"};

    public static Map<Object, List<Object>> getReserveRecords(List<Object> billEntryIds, boolean isContainSrcbill) {
        QFilter fs = new QFilter("entryid", "in", billEntryIds);
        if (!isContainSrcbill) {
            fs.and("type", "!=", (Object)"1");
        }
        HashMap<Object, List<Object>> entryMap = new HashMap<Object, List<Object>>(billEntryIds.size());
        QFilter recordFs = new QFilter("reservebaseqty", ">", (Object)0);
        try (DataSet datas = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_entry_reserve", (String)"entryid,reserveid", (QFilter[])fs.toArray(), null);
             DataSet record = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_reservation", (String)"id", (QFilter[])recordFs.toArray(), null);
             DataSet result = datas.join(record, JoinType.INNER).on("reserveid", "id").select(new String[]{"entryid", "reserveid"}).finish();){
            ArrayList<Object> reserveIds = null;
            Object entryId = null;
            if (result != null) {
                for (Row row : result) {
                    entryId = row.get("entryid");
                    reserveIds = (ArrayList<Object>)entryMap.get(entryId);
                    if (reserveIds == null) {
                        reserveIds = new ArrayList<Object>();
                        entryMap.put(entryId, reserveIds);
                    }
                    reserveIds.add(row.get("reserveid"));
                }
            }
        }
        return entryMap;
    }

    public static Map<Object, List<Object>> getReserveRecords(List<Object> billEntryIds) {
        return ReserveHelper.getReserveRecords(billEntryIds, true);
    }

    public static Set<Object> filterNoReserveRecordByEntryIds(List<Object> billEntryIds) {
        return ReserveHelper.filterNoReserve(billEntryIds, "entryid");
    }

    public static Set<Object> filterNoReserveRecordByBillIds(List<Object> billIds) {
        return ReserveHelper.filterNoReserve(billIds, "billid");
    }

    private static Set<Object> filterNoReserve(List<Object> ids, String idCol) {
        HashSet<Object> noReserveIds = new HashSet<Object>(ids);
        QFilter fs = new QFilter(idCol, "in", ids);
        QFilter recordFs = new QFilter("reservebaseqty", ">", (Object)0);
        try (DataSet datas = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_entry_reserve", (String)(idCol + ",reserveid"), (QFilter[])fs.toArray(), null);
             DataSet record = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_reservation", (String)"id", (QFilter[])recordFs.toArray(), null);
             DataSet result = datas.join(record, JoinType.INNER).on("reserveid", "id").select(new String[]{idCol, "reserveid"}).finish();){
            if (result != null) {
                for (Row row : result) {
                    noReserveIds.remove(row.get(idCol));
                }
            }
        }
        return noReserveIds;
    }

    public static List<DynamicObject> getUnAutoScheme(Long mainOrgId, String requireBillName) {
        List<DynamicObject> schemes = ReserveHelper.matchScheme(mainOrgId, requireBillName, false);
        return schemes;
    }

    public static Long getAutoScheme(Long mainOrgId, String requireBillName) {
        List<DynamicObject> schemes = ReserveHelper.matchScheme(mainOrgId, requireBillName, true);
        Long scheme = null;
        DynamicObject tempScheme = null;
        int len = schemes.size();
        for (int i = 0; i < len; ++i) {
            tempScheme = schemes.get(i);
            if (i == 0) {
                scheme = tempScheme.getLong("id");
            }
            if (!mainOrgId.equals(tempScheme.getLong("createorg"))) continue;
            scheme = tempScheme.getLong("id");
            break;
        }
        return scheme;
    }

    public static Map<Object, List<Object>> getBotpUpPath4BillIds(String entityNumber, String entryKey, Long[] entryIds) {
        return ReserveHelper.getBotpUpPath(entityNumber, entryKey, entryIds, true);
    }

    public static Map<Object, List<Object>> getBotpUpPath4EntryId(String entityNumber, String entryKey, Long[] entryIds) {
        return ReserveHelper.getBotpUpPath(entityNumber, entryKey, entryIds, false);
    }

    private static Map<Object, List<Object>> getBotpUpPath(String entityNumber, String entryKey, Long[] entryIds, boolean isBillIdPath) {
        List rows = BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)entryKey, (Long[])entryIds);
        HashMap<Object, List<Object>> map = new HashMap<Object, List<Object>>(rows.size());
        for (BFRowLinkUpNode row : rows) {
            List nodes = row.findAllSourceNodes();
            ArrayList<Object> ids = new ArrayList<Object>(nodes.size());
            for (BFRowLinkUpNode node : nodes) {
                ids.add(ReserveHelper.getNodeId(node, isBillIdPath));
            }
            map.put(ReserveHelper.getNodeId(row, isBillIdPath), ids);
        }
        return map;
    }

    private static Object getNodeId(BFRowLinkUpNode node, boolean isBillIdPath) {
        return isBillIdPath ? node.getRowId().getBillId() : node.getRowId().getEntryId();
    }

    private static List<DynamicObject> matchScheme(Long mainOrgId, String requireBillName, boolean isAutoScheme) {
        QFilter fs = new QFilter("requirebill", "=", (Object)requireBillName);
        fs.and("datastatus", "=", (Object)"1");
        fs.and("isautoreserve", "=", (Object)(isAutoScheme ? "1" : "0"));
        fs.and(ReserveHelper.getCUFilter(mainOrgId));
        String selectCols = F7Utils.getSelectCols("createorg", "name", "number", "id");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"sbs_reserve_st", (String)selectCols, (QFilter[])fs.toArray(), (String)"number ASC ");
        return query;
    }

    private static QFilter getCUFilter(Long mainOrgId) {
        BaseDataService service = new BaseDataService();
        return service.getBaseDataFilter("sbs_reserve_st", mainOrgId);
    }

    public static Map<Object, BigDecimal> getReservedQtyByEntryId(Object[] entryIds) {
        HashMap<Object, BigDecimal> mapEntrydHasReserveQty = new HashMap<Object, BigDecimal>();
        List<DynamicObject> reservedRecords = ReserveHelper.getReserveRescords(entryIds);
        for (Object entryId : entryIds) {
            BigDecimal hasReservedQty = BigDecimal.ZERO;
            for (DynamicObject reserve : reservedRecords) {
                String demandEntryId = reserve.getString("demandentryid");
                if (!String.valueOf(entryId).equals(demandEntryId)) continue;
                hasReservedQty = hasReservedQty.add(reserve.getBigDecimal("reservebaseqty"));
            }
            if (hasReservedQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            mapEntrydHasReserveQty.put(entryId, hasReservedQty);
        }
        return mapEntrydHasReserveQty;
    }

    private static List<DynamicObject> getReserveRescords(Object[] ids) {
        QFilter demandIdFilter = new QFilter("demandentryid", "in", (Object)ids);
        QFilter reserveQtyFilter = new QFilter("reservebaseqty", ">", (Object)0);
        Map reserveRescords = BusinessDataServiceHelper.loadFromCache((String)"sbs_reservation", (QFilter[])new QFilter[]{demandIdFilter, reserveQtyFilter});
        return new ArrayList<DynamicObject>(reserveRescords.values());
    }

    public static void checkAvailadQtyByAccId(Map<String, BigDecimal> invaccNeedQty) {
        Boolean isAvailable = ReserveHelper.isAvailableInvaccQty(invaccNeedQty);
        if (!isAvailable.booleanValue()) {
            throw new KDBizException(ReserveHelper.getMsgReserveHelperNumError());
        }
    }

    private static String getMsgReserveHelperNumError() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u91cf\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u9884\u7559\u6570\u91cf\u3002", (String)"ReserveHelper_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    public static boolean isAvailableInvaccQty(Map<String, BigDecimal> invaccNeedQty) {
        List<String> invAcctIds = ReserveHelper.getAcctIds(invaccNeedQty);
        ArrayList<Long> ids = new ArrayList<Long>(invAcctIds.size());
        for (String id : invAcctIds) {
            ids.add(Long.parseLong(id));
        }
        QFilter[] accFilters = new QFilter[]{new QFilter("id", "in", (Object)ids.toArray())};
        ArrayList<String> invFields = new ArrayList<String>(Arrays.asList("id", "baseqty", "qty", "qty2nd"));
        DataSet invaccData = QueryServiceHelper.queryDataSet((String)"ReserveHelper.getInvaccQtyByInvaccId", (String)ImInvacc.getBalTb(), (String)String.join((CharSequence)",", invFields), (QFilter[])accFilters, null);
        QFilter f1 = new QFilter("supplybillid", "in", invaccNeedQty.keySet());
        QFilter f3 = new QFilter("supplyformid", "=", (Object)ImInvacc.getBalTb());
        QFilter[] reserveFilters = new QFilter[]{f1, f3};
        List<String> resFields = Arrays.asList("supplybillid", "reservebaseqty", "reserveqty", "reserveunit2ndqty");
        DataSet reserveDatas = QueryServiceHelper.queryDataSet((String)"ReserveHelper.getReserveQtyByInvaccId", (String)"sbs_reservation", (String)String.join((CharSequence)",", resFields), (QFilter[])reserveFilters, null);
        DataSet dataSet = reserveDatas.groupBy(new String[]{"supplybillid"}).sum("reservebaseqty").sum("reserveqty").sum("reserveunit2ndqty").finish();
        invFields.remove("id");
        DataSet invacc = invaccData.select("Cast(id as String) id," + String.join((CharSequence)",", invFields));
        DataSet finish = invacc.join(dataSet, JoinType.LEFT).on("id", "supplybillid").select(STRINGS).finish();
        for (Row row : finish) {
            String invaccId = row.getString("id");
            BigDecimal hasReservedBaseQty = ObjectUtils.isEmpty((Object)row.getBigDecimal("reservebaseqty")) ? BigDecimal.ZERO : row.getBigDecimal("reservebaseqty");
            BigDecimal canReserveBaseQty = row.getBigDecimal("baseqty").subtract(hasReservedBaseQty);
            BigDecimal hasReservedQty = ObjectUtils.isEmpty((Object)row.getBigDecimal("reserveqty")) ? BigDecimal.ZERO : row.getBigDecimal("reserveqty");
            BigDecimal canReserveQty = row.getBigDecimal("qty").subtract(hasReservedQty);
            BigDecimal hasReserved2ndQty = ObjectUtils.isEmpty((Object)row.getBigDecimal("reserveunit2ndqty")) ? BigDecimal.ZERO : row.getBigDecimal("reserveunit2ndqty");
            BigDecimal canReserve2ndQty = row.getBigDecimal("qty2nd").subtract(hasReserved2ndQty);
            if (invaccNeedQty.get(invaccId + "," + "reservebaseqty").compareTo(canReserveBaseQty) > 0) {
                return false;
            }
            if (invaccNeedQty.get(invaccId + "," + "reserveqty").compareTo(canReserveQty) > 0) {
                return false;
            }
            if (invaccNeedQty.get(invaccId + "," + "reserveunit2ndqty").compareTo(canReserve2ndQty) <= 0) continue;
            return false;
        }
        return true;
    }

    public static void doUnAutoReserve(String billName, List<Object> ids) {
        ArrayList<String> pks = new ArrayList<String>(ids.size());
        for (Object id : ids) {
            pks.add(id.toString());
        }
        QFilter f1 = new QFilter("demandid", "in", pks);
        QFilter f2 = new QFilter("demandformid", "=", (Object)billName);
        QFilter f3 = new QFilter("reserveprctype", "=", (Object)"1");
        QFilter f4 = new QFilter("reservebaseqty", ">", (Object)0);
        CharSequence[] selectFileds = new String[]{"demandnumber", "demandseq"};
        try (DataSet set = QueryServiceHelper.queryDataSet((String)"ReserveHelper", (String)"sbs_reservation", (String)String.join((CharSequence)",", selectFileds), (QFilter[])new QFilter[]{f1, f2, f3, f4}, null);){
            StringBuilder sb = new StringBuilder();
            while (set.hasNext()) {
                Row row = set.next();
                sb.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u884c\u53f7\uff1a%2$s\uff0c\u5b58\u5728\u624b\u5de5\u9884\u7559\u8bb0\u5f55\uff0c\u8bf7\u5148\u89e3\u9664\u624b\u5de5\u9884\u7559\uff0c\u518d\u505a\u76f8\u5173\u64cd\u4f5c\uff1b", (String)"ReserveHelper_4", (String)"scmc-sbs-form", (Object[])new Object[0]), row.get("demandnumber"), row.get("demandseq")));
            }
            if (StringUtils.isNotEmpty((CharSequence)sb.toString())) {
                throw new KDBizException(sb.toString());
            }
        }
        var9_9 = null;
        try (TXHandle tx = TX.requiresNew((String)"deleteReserveRecord");){
            DeleteServiceHelper.delete((String)"sbs_reservation", (QFilter[])new QFilter[]{f1, f2});
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    public static DataSet getReserveDataSet(Collection<Long> accIds) {
        QFilter fs = new QFilter("supplyformid", "=", (Object)ImInvacc.getBalTb());
        if (accIds != null) {
            ArrayList<String> idStr = new ArrayList<String>(accIds.size());
            for (Long id : accIds) {
                idStr.add(id.toString());
            }
            fs.and("supplybillid", "in", idStr);
        }
        DataSet data = QueryServiceHelper.queryDataSet((String)"ReserveHelper", (String)"sbs_reservation", (String)"supplybillid,reserveqty,reservebaseqty,reserveunit2ndqty", (QFilter[])fs.toArray(), null).filter("reservebaseqty > 0").select("Cast(supplybillid as Long)supplybillid,reserveqty,reservebaseqty,reserveunit2ndqty");
        data = data.groupBy(new String[]{"supplybillid"}).sum("reserveqty").sum("reservebaseqty").sum("reserveunit2ndqty").finish();
        return data;
    }

    public static DataSet getInvaccAvbQtys(String[] accCols, Collection<Long> accIds) {
        if (accCols != null) {
            LEFT_COLS = ReserveHelper.appendArray(LEFT_COLS, accCols);
        }
        QFilter fs = new QFilter("id", "in", accIds);
        DataSet accData = QueryServiceHelper.queryDataSet((String)"ReserveHelper", (String)ImInvacc.getBalTb(), (String)StringUtils.join((Object[])LEFT_COLS, (String)","), (QFilter[])fs.toArray(), null);
        DataSet reserveData = ReserveHelper.getReserveDataSet(accIds);
        accData = accData.leftJoin(reserveData).on("id", "supplybillid").select(LEFT_COLS, RIGHT_COLS).finish();
        String[] selectCols = ReserveHelper.appendArray(LEFT_COLS, CASE_COLS);
        accData = accData.select(selectCols);
        String[] fieldNames = accData.getRowMeta().getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i].equals("reserveqty")) {
                fieldNames[i] = "lockqty + reserveqty AS reserveqty";
            }
            if (fieldNames[i].equals("reservebaseqty")) {
                fieldNames[i] = "lockbaseqty + reservebaseqty AS reservebaseqty";
            }
            if (!fieldNames[i].equals("reserveunit2ndqty")) continue;
            fieldNames[i] = "lockqty2nd + reserveunit2ndqty AS reserveunit2ndqty";
        }
        accData = accData.select(fieldNames);
        String[] cols = accData.getRowMeta().getFieldNames();
        selectCols = ReserveHelper.appendArray(cols, AVBQTY_COLS);
        accData = accData.select(selectCols);
        return accData;
    }

    private static String[] appendArray(String[] leftCols, String[] rightCols) {
        String[] dest = new String[leftCols.length + rightCols.length];
        System.arraycopy(leftCols, 0, dest, 0, leftCols.length);
        System.arraycopy(rightCols, 0, dest, leftCols.length, rightCols.length);
        return dest;
    }

    @Deprecated
    public static DataSet getInvaccAvbbaseqty(QFilter[] qFilters) {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("id");
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ImInvacc.getBalTb());
        selectorSet.addAll(dt.getAllFields().keySet());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"ReserveHelper", (String)ImInvacc.getBalTb(), (String)String.join((CharSequence)",", selectorSet), (QFilter[])qFilters, null);
        return ReserveHelper.getAvbbaseqty(ds);
    }

    public static DataSet getAvbbaseqty(DataSet ds) {
        DataSet reserveData = QueryServiceHelper.queryDataSet((String)"ReserveHelper", (String)"sbs_reservation", (String)"supplybillid,reserveqty,reservebaseqty,reserveunit2ndqty", (QFilter[])new QFilter[]{new QFilter("supplyformid", "=", (Object)ImInvacc.getBalTb())}, null);
        DataSet invaccSumReserve = reserveData.select("Cast(supplybillid as Long) supplybillid,reservebaseqty,reserveqty,reserveunit2ndqty").groupBy(new String[]{"supplybillid"}).sum("reservebaseqty").sum("reserveqty").sum("reserveunit2ndqty").finish();
        List<String> invaccFields = ReserveHelper.getDataSetCols(ds);
        List<String> reserveFields = ReserveHelper.getDataSetCols(invaccSumReserve);
        JoinHint hint = new JoinHint();
        hint.setNullAsZero(true);
        DataSet qty = ds.join(invaccSumReserve, JoinType.LEFT).on("id", "supplybillid").hint(hint).select(invaccFields.toArray(new String[0]), reserveFields.toArray(new String[0])).finish();
        invaccFields.add("case when reserveqty is Null then 0 else reserveqty end as reserveqty");
        invaccFields.add("case when reservebaseqty is Null then 0 else reservebaseqty end as reservebaseqty");
        invaccFields.add("case when reserveunit2ndqty is Null then 0 else reserveunit2ndqty end as reserveunit2ndqty");
        DataSet avbbaseqty = qty.select(invaccFields.toArray(new String[0]));
        String[] fieldNames = avbbaseqty.getRowMeta().getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i].equals("reserveqty")) {
                fieldNames[i] = "lockqty + reserveqty AS reserveqty";
            }
            if (fieldNames[i].equals("reservebaseqty")) {
                fieldNames[i] = "lockbaseqty + reservebaseqty AS reservebaseqty";
            }
            if (!fieldNames[i].equals("reserveunit2ndqty")) continue;
            fieldNames[i] = "lockqty2nd + reserveunit2ndqty AS reserveunit2ndqty";
        }
        avbbaseqty = avbbaseqty.select(fieldNames);
        List<String> invaccFields1 = ReserveHelper.getDataSetCols(avbbaseqty);
        invaccFields1.add("(baseqty-reservebaseqty) as avbbaseqty");
        invaccFields1.add("(qty-reserveqty) as avbbqty");
        invaccFields1.add("(qty2nd-reserveunit2ndqty) as avbbtndqty");
        invaccFields1.add("reservebaseqty as reservoeqty");
        invaccFields1.remove("avbbaseqty");
        DataSet finish = avbbaseqty.select(invaccFields1.toArray(new String[0]));
        return finish;
    }

    private static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        int count = fields.length;
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            list.add(fields[i].getName().toLowerCase());
        }
        return list;
    }

    public static void unDoReleaseReserve(String opName, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)opName)) {
            throw new KDBizException(ReserveHelper.getMsgOpNameError());
        }
        for (Long billId : billIds) {
            ReserveHelper.unReleaseOneBill(billId, opName);
        }
        QFilter delFs = new QFilter("billid", "in", (Object)billIds);
        delFs.and("op", "=", (Object)opName);
        DeleteServiceHelper.delete((String)"sbs_reserve_release", (QFilter[])delFs.toArray());
    }

    private static String getMsgOpNameError() {
        return ResManager.loadKDString((String)"opName\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReserveHelper_2", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static void unReleaseOneBill(Long billId, String opName) {
        QFilter fs = new QFilter("billid", "=", (Object)billId);
        fs.and("op", "=", (Object)opName);
        DataSet releaseData = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_reserve_release", (String)"reserveid,releaseqty,reservereleaseqty,releaseunit2ndqty", (QFilter[])fs.toArray(), null);
        DataSet reserveData = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_reservation", (String)"supplybillid,id", null, null);
        JoinDataSet join = releaseData.join(reserveData, JoinType.INNER);
        DataSet finish = join.on("reserveid", "id").select(new String[]{"Cast(supplybillid as Long) supplybillid", "releaseqty", "reservereleaseqty", "releaseunit2ndqty"}).finish();
        DataSet groupBy = finish.groupBy(new String[]{"supplybillid"}).sum("releaseqty").sum("reservereleaseqty").sum("releaseunit2ndqty").finish();
        HashMap<Long, BigDecimal[]> valueMap = new HashMap<Long, BigDecimal[]>();
        BigDecimal[] value = null;
        for (Row row : groupBy) {
            value = new BigDecimal[]{row.getBigDecimal("releaseqty"), row.getBigDecimal("reservereleaseqty"), row.getBigDecimal("releaseunit2ndqty")};
            valueMap.put(row.getLong("supplybillid"), value);
        }
        if (valueMap.isEmpty()) {
            return;
        }
        DataSet invaccAvbQtys = ReserveHelper.getInvaccAvbQtys(null, valueMap.keySet()).select(new String[]{"id", "avbbaseqty", "avbbqty", "avbbtndqty"});
        Long accId = null;
        for (Row row : invaccAvbQtys) {
            accId = row.getLong("id");
            value = (BigDecimal[])valueMap.get(accId);
            if (row.getBigDecimal("avbbaseqty").subtract(value[0]).compareTo(BigDecimal.ZERO) >= 0 && row.getBigDecimal("avbbqty").subtract(value[1]).compareTo(BigDecimal.ZERO) >= 0 && row.getBigDecimal("avbbtndqty").subtract(value[2]).compareTo(BigDecimal.ZERO) >= 0) continue;
            return;
        }
        QFilter releaseFs = new QFilter("billid", "=", (Object)billId);
        releaseFs.and("op", "=", (Object)opName);
        DataSet unDoReleaseData = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_reserve_release", (String)"reserveid,releaseqty,reservereleaseqty,releaseunit2ndqty", (QFilter[])releaseFs.toArray(), null);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Row row : unDoReleaseData) {
            Object[] param = new Object[]{row.getBigDecimal("releaseqty"), row.getBigDecimal("reservereleaseqty"), row.getBigDecimal("releaseunit2ndqty"), row.getLong("reserveid")};
            params.add(param);
        }
        if (!params.isEmpty()) {
            String sql = "update t_sbs_reservation set freservebaseqty = freservebaseqty + ?,freserveqty = freserveqty + ?,freserveunit2ndqty = freserveunit2ndqty + ? where  fid = ? ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, params);
        }
    }

    public static void unReleaseOneBillByEntryIds(String opName, Long[] entryIds) {
        QFilter fs = new QFilter("entryid", "in", (Object)entryIds);
        fs.and("op", "=", (Object)opName);
        DataSet releaseData = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_reserve_release", (String)"reserveid,releaseqty,reservereleaseqty,releaseunit2ndqty", (QFilter[])fs.toArray(), null);
        DataSet reserveData = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_reservation", (String)"supplybillid,id", null, null);
        JoinDataSet join = releaseData.join(reserveData, JoinType.INNER);
        DataSet finish = join.on("reserveid", "id").select(new String[]{"Cast(supplybillid as Long) supplybillid", "releaseqty", "reservereleaseqty", "releaseunit2ndqty"}).finish();
        DataSet groupBy = finish.groupBy(new String[]{"supplybillid"}).sum("releaseqty").sum("reservereleaseqty").sum("releaseunit2ndqty").finish();
        HashMap<Long, BigDecimal[]> valueMap = new HashMap<Long, BigDecimal[]>();
        BigDecimal[] value = null;
        for (Row row : groupBy) {
            value = new BigDecimal[]{row.getBigDecimal("releaseqty"), row.getBigDecimal("reservereleaseqty"), row.getBigDecimal("releaseunit2ndqty")};
            valueMap.put(row.getLong("supplybillid"), value);
        }
        if (valueMap.isEmpty()) {
            return;
        }
        DataSet invaccAvbQtys = ReserveHelper.getInvaccAvbQtys(null, valueMap.keySet()).select(new String[]{"id", "avbbaseqty", "avbbqty", "avbbtndqty"});
        Long accId = null;
        for (Row row : invaccAvbQtys) {
            accId = row.getLong("id");
            value = (BigDecimal[])valueMap.get(accId);
            if (row.getBigDecimal("avbbaseqty").subtract(value[0]).compareTo(BigDecimal.ZERO) >= 0 && row.getBigDecimal("avbbqty").subtract(value[1]).compareTo(BigDecimal.ZERO) >= 0 && row.getBigDecimal("avbbtndqty").subtract(value[2]).compareTo(BigDecimal.ZERO) >= 0) continue;
            return;
        }
        QFilter releaseFs = new QFilter("entryid", "in", (Object)entryIds);
        releaseFs.and("op", "=", (Object)opName);
        DataSet unDoReleaseData = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_reserve_release", (String)"reserveid,releaseqty,reservereleaseqty,releaseunit2ndqty", (QFilter[])releaseFs.toArray(), null);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Row row : unDoReleaseData) {
            Object[] param = new Object[]{row.getBigDecimal("releaseqty"), row.getBigDecimal("reservereleaseqty"), row.getBigDecimal("releaseunit2ndqty"), row.getLong("reserveid")};
            params.add(param);
        }
        if (!params.isEmpty()) {
            String sql = "update t_sbs_reservation set freservebaseqty = freservebaseqty + ?,freserveqty = freserveqty + ?,freserveunit2ndqty = freserveunit2ndqty + ? where  fid = ? ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, params);
        }
        DeleteServiceHelper.delete((String)"sbs_reserve_release", (QFilter[])fs.toArray());
    }

    public static void doReleaseReserve(String billName, Long[] idArr, String opName) {
        List<String> idStrs = ReserveHelper.getStrings(idArr);
        QFilter fs = new QFilter("demandid", "in", idStrs);
        fs.and("demandformid", "=", (Object)billName);
        fs.and("reservebaseqty", ">", (Object)0);
        try (DataSet record = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_reservation", (String)"demandid,demandentryid,reservebaseqty,reserveqty,reserveunit2ndqty,id", (QFilter[])fs.toArray(), null);){
            ArrayList<DynamicObject> relaseInfos = new ArrayList<DynamicObject>();
            DynamicObject relaseInfo = null;
            idStrs = new ArrayList<String>(idArr.length);
            for (Row row : record) {
                relaseInfo = BusinessDataServiceHelper.newDynamicObject((String)"sbs_reserve_release");
                relaseInfo.set("entryid", (Object)Long.valueOf(row.getString("demandentryid")));
                relaseInfo.set("releaseqty", row.get("reservebaseqty"));
                relaseInfo.set("reservereleaseqty", row.get("reserveqty"));
                relaseInfo.set("releaseunit2ndqty", row.get("reserveunit2ndqty"));
                relaseInfo.set("reserveid", row.get("id"));
                relaseInfo.set("billid", (Object)Long.valueOf(row.getString("demandid")));
                relaseInfo.set("op", (Object)opName);
                relaseInfos.add(relaseInfo);
                idStrs.add(row.getString("demandid"));
            }
            if (!relaseInfos.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])relaseInfos.toArray(new DynamicObject[relaseInfos.size()]));
                StringBuffer sb = new StringBuffer();
                sb.append("UPDATE t_sbs_reservation SET freservebaseqty = 0,freserveqty = 0,freserveunit2ndqty = 0 WHERE fdemandformid = ? and fdemandid in (");
                Object[] param = new Object[idStrs.size() + 1];
                param[0] = billName;
                int len = idStrs.size();
                for (int i = 0; i < len; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append('?');
                    param[i + 1] = idStrs.get(i);
                }
                sb.append(')');
                DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sb.toString(), (Object[])param);
            }
        }
    }

    public static void doReleaseReserveOneBillByEntryIds(String billName, Long[] idArr, String opName) {
        List<String> idStrs = ReserveHelper.getStrings(idArr);
        QFilter fs = new QFilter("demandentryid", "in", idStrs);
        fs.and("demandformid", "=", (Object)billName);
        fs.and("reservebaseqty", ">", (Object)0);
        try (DataSet record = QueryServiceHelper.queryDataSet((String)ReserveHelper.class.getName(), (String)"sbs_reservation", (String)"demandid,demandentryid,reservebaseqty,reserveqty,reserveunit2ndqty,id", (QFilter[])fs.toArray(), null);){
            ArrayList<DynamicObject> relaseInfos = new ArrayList<DynamicObject>();
            DynamicObject relaseInfo = null;
            idStrs = new ArrayList<String>(idStrs.size());
            for (Row row : record) {
                relaseInfo = BusinessDataServiceHelper.newDynamicObject((String)"sbs_reserve_release");
                relaseInfo.set("entryid", (Object)Long.valueOf(row.getString("demandentryid")));
                relaseInfo.set("releaseqty", row.get("reservebaseqty"));
                relaseInfo.set("reservereleaseqty", row.get("reserveqty"));
                relaseInfo.set("releaseunit2ndqty", row.get("reserveunit2ndqty"));
                relaseInfo.set("reserveid", row.get("id"));
                relaseInfo.set("billid", (Object)Long.valueOf(row.getString("demandid")));
                relaseInfo.set("op", (Object)opName);
                relaseInfos.add(relaseInfo);
                idStrs.add(row.getString("demandentryid"));
            }
            if (!relaseInfos.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])relaseInfos.toArray(new DynamicObject[relaseInfos.size()]));
                StringBuffer sb = new StringBuffer();
                sb.append("UPDATE t_sbs_reservation SET freservebaseqty = 0,freserveqty = 0,freserveunit2ndqty = 0 WHERE fdemandformid = ? and fdemandentryid in (");
                Object[] param = new Object[idStrs.size() + 1];
                param[0] = billName;
                int len = idStrs.size();
                for (int i = 0; i < len; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append('?');
                    param[i + 1] = idStrs.get(i);
                }
                sb.append(')');
                DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sb.toString(), (Object[])param);
            }
        }
    }

    private static List<String> getStrings(Long[] idArr) {
        ArrayList<String> idStrs = new ArrayList<String>(idArr.length);
        for (Long item : idArr) {
            idStrs.add(item.toString());
        }
        return idStrs;
    }

    private static List<String> getAcctIds(Map<String, BigDecimal> invaccNeedQty) {
        ArrayList<String> invAcctIds = new ArrayList<String>(invaccNeedQty.size());
        for (String invId : invaccNeedQty.keySet()) {
            invAcctIds.add(invId.split(",")[0]);
        }
        return invAcctIds;
    }

    public static BigDecimal getUnitRateConv(DynamicObject materialDyc, DynamicObject srcUnitDyc, DynamicObject desUnitDyc) {
        BigDecimal unitRate = BigDecimal.ZERO;
        if (materialDyc != null && srcUnitDyc != null && desUnitDyc != null) {
            Long srcUnitId = (Long)srcUnitDyc.getPkValue();
            Long desUnitId = (Long)desUnitDyc.getPkValue();
            if (srcUnitId.longValue() == desUnitId.longValue()) {
                unitRate = BigDecimal.ONE;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)materialDyc.getPkValue()), (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("numerator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
                }
            }
        }
        return unitRate;
    }

    public static DynamicObject getInvMaterial(DynamicObject orgDyc, DynamicObject materialDyc) {
        if (materialDyc == null || orgDyc == null) {
            return null;
        }
        Object masterId = null;
        masterId = "bd_materialinventoryinfo".equals(materialDyc.getDataEntityType().getName()) || "bd_materialpurchaseinfo".equals(materialDyc.getDataEntityType().getName()) || "bd_materialsalinfo".equals(materialDyc.getDataEntityType().getName()) ? materialDyc.getDynamicObject("masterid").getPkValue() : materialDyc.getPkValue();
        QFilter masterIdf = new QFilter("masterid", "=", masterId);
        DynamicObjectCollection invMatDycs = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)((Long)orgDyc.getPkValue()), (QFilter)masterIdf, (String)"masterid.auxptyunit,unitconvertdir");
        return invMatDycs.isEmpty() ? null : (DynamicObject)invMatDycs.get(0);
    }

    public static DynamicObject getMasterMaterial(DynamicObject materialDyc) {
        if (materialDyc == null) {
            return null;
        }
        if ("bd_materialinventoryinfo".equals(materialDyc.getDataEntityType().getName()) || "bd_materialpurchaseinfo".equals(materialDyc.getDataEntityType().getName()) || "bd_materialsalinfo".equals(materialDyc.getDataEntityType().getName())) {
            materialDyc = materialDyc.getDynamicObject("masterid");
        }
        return materialDyc;
    }

    public static List<Object> getReserveIds(String formId, List<Object> ids) {
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        Map<Long, Set<Long>> srcIdsMap = ReserveHelper.getSrcBotpIds(formId, ids.toArray(new Long[ids.size()]));
        for (Set<Long> srcIds : srcIdsMap.values()) {
            srcBillIds.addAll(srcIds);
        }
        if (srcBillIds.isEmpty()) {
            return ids;
        }
        QFilter reF = new QFilter("bill_id", "in", srcBillIds);
        DataSet reserveRecords = QueryServiceHelper.queryDataSet((String)(ReserveHelper.class.getName() + ":checkSrcReserve"), (String)"msmod_reserve_record", (String)"bill_id", (QFilter[])reF.toArray(), null);
        HashSet<Long> reserveBillIds = new HashSet<Long>(16);
        while (reserveRecords.hasNext()) {
            Row row = reserveRecords.next();
            reserveBillIds.add(row.getLong("bill_id"));
        }
        if (reserveBillIds.isEmpty()) {
            return ids;
        }
        ArrayList<Object> resBillIds = new ArrayList<Object>(ids.size());
        for (Object pkId : ids) {
            Set<Long> srcIds = srcIdsMap.get(pkId);
            if (srcIds == null || srcIds.isEmpty()) {
                resBillIds.add(pkId);
                continue;
            }
            if (srcIds.removeAll(reserveBillIds)) continue;
            resBillIds.add(pkId);
        }
        return resBillIds;
    }

    private static Map<Long, Set<Long>> getSrcBotpIds(String formId, Long[] billIds) {
        HashMap<Long, Set<Long>> srcBillIds = new HashMap<Long, Set<Long>>(16);
        Map linkUpNodes = BFTrackerServiceHelper.loadBillLinkUpNodes((String)formId, (Long[])billIds, (boolean)false);
        for (Map.Entry UpNode : linkUpNodes.entrySet()) {
            List srcNodes = ((BFRowLinkUpNode)UpNode.getValue()).findAllSourceNodes();
            HashSet<Long> ids = new HashSet<Long>(srcNodes.size());
            for (BFRowLinkUpNode row : srcNodes) {
                ids.add(row.getRowId().getBillId());
            }
            srcBillIds.put((Long)UpNode.getKey(), (Set<Long>)ids);
        }
        return srcBillIds;
    }
}

