/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.reservation;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.MaterielProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.FilterParser;
import kd.scmc.sbs.business.reservation.model.ReserveSchemeInfo;
import kd.scmc.sbs.common.pagemodel.ImInvacc;
import kd.scmc.sbs.common.util.F7Utils;
import org.apache.commons.lang3.StringUtils;

public class ReserveSchemeHander {
    private ReserveSchemeInfo schemeInfo;
    private Object requireBillId;
    private List<String> billCols;
    private List<String> stockCols;

    private String getBillEntryIdFlag() {
        Map<String, String> colsMap = this.schemeInfo.getColsMap();
        String billentry = colsMap.get("billentry");
        if (StringUtils.isBlank((CharSequence)billentry)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u9884\u7559\u65b9\u6848\u914d\u7f6e\u7684\u5355\u636e\u8bbe\u7f6e\u65b9\u6848\u4e2d\u914d\u7f6e\u5206\u5f55\u6807\u8bc6\u6620\u5c04\u3002", (String)"ReserveSchemeHander_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
        }
        return billentry + ".id";
    }

    public ReserveSchemeHander(DynamicObject scheme, Object requireBillId) {
        this(new ReserveSchemeInfo(scheme), requireBillId);
    }

    public ReserveSchemeHander(ReserveSchemeInfo schemeInfo, Object requireBillId) {
        this.schemeInfo = schemeInfo;
        this.requireBillId = requireBillId;
    }

    public Map<Object, List<Object>> matchInvStock() {
        try {
            return this.matchIdMap();
        }
        catch (Exception e) {
            throw new KDBizException(StringUtils.join((Object[])new String[]{this.getMsgReserveSchemeHanderError(), e.getMessage()}));
        }
    }

    public Map<Object, List<Object>> matchInvStockForNoSave(DynamicObject requireBill) {
        HashMap<Object, List<Object>> idMaps = new HashMap<Object, List<Object>>(8);
        try (DataSet invStockData = null;){
            if (!FilterParser.execExcelFormula((String)this.schemeInfo.getScheme().getString("reservefilter"), (DynamicObject)requireBill)) {
                HashMap<Object, List<Object>> hashMap = idMaps;
                return hashMap;
            }
            invStockData = this.queryInvStockData();
            String[] orderBy = this.getInvStockOrderBy();
            if (orderBy != null) {
                invStockData = invStockData.orderBy(orderBy);
            }
            Map<String, String> colsMap = this.schemeInfo.getColsMap();
            String billEntryFlag = colsMap.get("billentry");
            List<DynamicObject> requestEntryList = this.getValidateRequestEntry(requireBill, billEntryFlag);
            Map<Object, List<Object>> map = this.matchEntryAndInvStock(requireBill, invStockData, billEntryFlag, requestEntryList);
            return map;
        }
    }

    private List<DynamicObject> getValidateRequestEntry(DynamicObject requireBill, String billEntryFlag) {
        DynamicObjectCollection entryCol = requireBill.getDynamicObjectCollection(billEntryFlag);
        HashSet materialIdSet = new HashSet(entryCol.size());
        String materialFieldName = this.getRequireBillMaterielCol().replace(billEntryFlag + ".", "") + "_id";
        entryCol.forEach(entry -> materialIdSet.add(entry.getLong(materialFieldName)));
        QFilter qFilter = new QFilter("isreserve", "=", (Object)"1");
        qFilter.and("masterid", "in", materialIdSet);
        DataSet materialData = QueryServiceHelper.queryDataSet((String)"", (String)"bd_materialinventoryinfo", (String)"id,masterid", (QFilter[])qFilter.toArray(), null);
        materialData = materialData.groupBy(new String[]{"masterid"}).finish();
        ArrayList<DynamicObject> requestEntryList = new ArrayList<DynamicObject>(8);
        block0: for (DynamicObject entry2 : entryCol) {
            for (Row row : materialData.copy()) {
                if (!row.getLong("masterid").equals(entry2.getLong(materialFieldName))) continue;
                requestEntryList.add(entry2);
                continue block0;
            }
        }
        return requestEntryList;
    }

    private Map<Object, List<Object>> matchEntryAndInvStock(DynamicObject requireBill, DataSet invStockData, String billEntryFlag, List<DynamicObject> requestEntryList) {
        HashMap<Object, List<Object>> idMaps = new HashMap<Object, List<Object>>();
        String invStockIdFlag = this.getAlias4Right("id");
        JSONArray billMatchCols = this.schemeInfo.getBillMatchCols();
        JSONArray stockMatchCols = this.schemeInfo.getStockMatchCols();
        for (DynamicObject entry : requestEntryList) {
            Object entryId = entry.get("id");
            ArrayList<Object> invStockIds = (ArrayList<Object>)idMaps.get(entryId);
            if (invStockIds == null) {
                invStockIds = new ArrayList<Object>();
                idMaps.put(entryId, invStockIds);
            }
            for (Row row : invStockData.copy()) {
                String[] orgFlagArray;
                DynamicObject org = requireBill.getDynamicObject(this.schemeInfo.getOrgMatchCol());
                if (org == null && (orgFlagArray = this.schemeInfo.getOrgMatchCol().split("\\.")).length == 2) {
                    org = ((DynamicObject)requireBill.getDynamicObjectCollection(orgFlagArray[0]).get(0)).getDynamicObject(orgFlagArray[1]);
                }
                if (org == null || !org.get("id").equals(row.get(this.getAlias4Right("org")))) continue;
                boolean isFind = true;
                if (billMatchCols != null && stockMatchCols != null) {
                    for (int i = 0; i < billMatchCols.size(); ++i) {
                        String billFieldName = billMatchCols.getString(i);
                        if (billFieldName.startsWith(billEntryFlag)) {
                            if (entry.get(billFieldName = billFieldName.replace(billEntryFlag + ".", "")) instanceof DynamicObject) {
                                billFieldName = billFieldName + "_id";
                            }
                            if (entry.get(billFieldName).equals(row.get(this.getAlias4Right(stockMatchCols.getString(i))))) continue;
                            isFind = false;
                            break;
                        }
                        if (requireBill.get(billFieldName) instanceof DynamicObject) {
                            billFieldName = billFieldName + "_id";
                        }
                        if (requireBill.get(billFieldName).equals(row.get(this.getAlias4Right(stockMatchCols.getString(i))))) continue;
                        isFind = false;
                        break;
                    }
                }
                if (!isFind) continue;
                invStockIds.add(row.get(invStockIdFlag));
            }
        }
        return idMaps;
    }

    private String getMsgReserveSchemeHanderError() {
        return ResManager.loadKDString((String)"\u9884\u7559\u65b9\u6848\u5339\u914d\u5373\u65f6\u5e93\u5b58\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u914d\u7f6e\u3002", (String)"ReserveSchemeHander_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, List<Object>> matchIdMap() {
        DataSet billData = null;
        DataSet invStockData = null;
        DataSet finish = null;
        try {
            billData = this.queryBillData();
            invStockData = this.queryInvStockData();
            JoinDataSet join = billData.join(invStockData, JoinType.LEFT);
            join = join.on(this.getAlias4Left(this.schemeInfo.getOrgMatchCol()), this.getAlias4Right("org"));
            JSONArray billMatchCols = this.schemeInfo.getBillMatchCols();
            JSONArray stockMatchCols = this.schemeInfo.getStockMatchCols();
            if (billMatchCols != null && stockMatchCols != null) {
                int size = billMatchCols.size();
                for (int i = 0; i < size; ++i) {
                    join = join.on(this.getAlias4Left(billMatchCols.getString(i)), this.getAlias4Right(stockMatchCols.getString(i)));
                }
            }
            List<String> leftCols = this.getLeftAlias(this.getBillCols4Select());
            List<String> rightCols = this.getRightAlias(this.getStockCols4Select());
            join.select(leftCols.toArray(new String[leftCols.size()]), rightCols.toArray(new String[rightCols.size()]));
            finish = join.finish();
            String[] orderBy = this.getInvStockOrderBy();
            if (orderBy != null) {
                finish = finish.orderBy(orderBy);
            }
            Map<Object, List<Object>> map = this.handerReSult(finish);
            return map;
        }
        finally {
            if (finish != null) {
                finish.close();
            } else if (invStockData != null) {
                invStockData.close();
            } else if (billData != null) {
                billData.close();
            }
        }
    }

    private Map<Object, List<Object>> handerReSult(DataSet finish) {
        String entryIdFlag = this.getAlias4Left(this.getBillEntryIdFlag());
        String invStockIdFlag = this.getAlias4Right("id");
        HashMap<Object, List<Object>> idMaps = new HashMap<Object, List<Object>>();
        for (Row row : finish) {
            Object entryId = row.get(entryIdFlag);
            ArrayList<Object> invStockIds = (ArrayList<Object>)idMaps.get(entryId);
            if (invStockIds == null) {
                invStockIds = new ArrayList<Object>();
                idMaps.put(entryId, invStockIds);
            }
            if (row.get(invStockIdFlag) == null) continue;
            invStockIds.add(row.get(invStockIdFlag));
        }
        return idMaps;
    }

    private List<String> appendLeftAlias(List<String> cols) {
        ArrayList<String> alias = new ArrayList<String>(cols.size());
        for (String col : cols) {
            alias.add(this.addAlias4Left(col));
        }
        return alias;
    }

    private List<String> appendRightAlias(List<String> cols) {
        ArrayList<String> alias = new ArrayList<String>(cols.size());
        for (String col : cols) {
            alias.add(this.addAlias4Right(col));
        }
        return alias;
    }

    private List<String> getLeftAlias(List<String> cols) {
        ArrayList<String> alias = new ArrayList<String>(cols.size());
        for (String col : cols) {
            alias.add(this.getAlias4Left(col));
        }
        return alias;
    }

    private List<String> getRightAlias(List<String> cols) {
        ArrayList<String> alias = new ArrayList<String>(cols.size());
        for (String col : cols) {
            alias.add(this.getAlias4Right(col));
        }
        return alias;
    }

    private String addAlias4Left(String col) {
        return col + " " + this.getAlias4Left(col);
    }

    private String addAlias4Right(String col) {
        return col + " " + this.getAlias4Right(col);
    }

    private String getAlias4Left(String col) {
        return "L" + col.replace(".", "");
    }

    private String getAlias4Right(String col) {
        return "R" + col.replace(".", "");
    }

    private String[] getInvStockOrderBy() {
        JSONArray orderByCols = this.schemeInfo.getOrderByCols();
        JSONArray orderByType = this.schemeInfo.getOrderByType();
        if (orderByCols == null || orderByType == null) {
            return null;
        }
        int size = orderByCols.size();
        if (size == 0) {
            return null;
        }
        String[] orderBys = new String[size];
        for (int i = 0; i < size; ++i) {
            orderBys[i] = this.getAlias4Right(orderByCols.getString(i)) + " " + ("A".equals(orderByType.getString(i)) ? "asc" : "desc");
        }
        return orderBys;
    }

    private List<String> getBillCols4Select() {
        if (this.billCols == null) {
            JSONArray billMatchCols = this.schemeInfo.getBillMatchCols();
            int len = billMatchCols.size();
            this.billCols = new ArrayList<String>(len + 3);
            this.billCols.add(this.getBillEntryIdFlag());
            this.billCols.add("id");
            this.billCols.add(this.schemeInfo.getOrgMatchCol());
            for (int i = 0; i < len; ++i) {
                this.billCols.add(billMatchCols.getString(i));
            }
        }
        return this.billCols;
    }

    private List<String> getStockCols4Select() {
        if (this.stockCols == null) {
            JSONArray orderByCols;
            this.stockCols = new ArrayList<String>();
            this.stockCols.add("id");
            this.stockCols.add("org");
            JSONArray stockMatchCols = this.schemeInfo.getStockMatchCols();
            if (stockMatchCols != null) {
                int len = stockMatchCols.size();
                for (int i = 0; i < len; ++i) {
                    this.stockCols.add(stockMatchCols.getString(i));
                }
            }
            if ((orderByCols = this.schemeInfo.getOrderByCols()) != null) {
                int len = orderByCols.size();
                for (int i = 0; i < len; ++i) {
                    this.stockCols.add(orderByCols.getString(i));
                }
            }
        }
        return this.stockCols;
    }

    private DataSet queryInvStockData() {
        QFilter fs = this.schemeInfo.getStockFilter();
        if (fs == null) {
            fs = new QFilter("1", "=", (Object)1);
        }
        List<String> colList = this.appendRightAlias(this.getStockCols4Select());
        String cols = F7Utils.getSelectCols(colList);
        DataSet data = QueryServiceHelper.queryDataSet((String)ReserveSchemeHander.class.getName(), (String)ImInvacc.getBalTb(), (String)cols, (QFilter[])fs.toArray(), null);
        return data;
    }

    private DataSet queryBillData() {
        List<String> colList = this.appendLeftAlias(this.getBillCols4Select());
        String cols = F7Utils.getSelectCols(colList);
        String orgCol = this.schemeInfo.getOrgMatchCol();
        String masterid = this.getRequireBillMaterielCol();
        String leftCols = cols + "," + orgCol + "," + masterid;
        QFilter billFilter = this.getBillFilter();
        DataSet leftData = QueryServiceHelper.queryDataSet((String)ReserveSchemeHander.class.getName(), (String)this.schemeInfo.getRequireBillName(), (String)leftCols, (QFilter[])billFilter.toArray(), null);
        QFilter leftFs = new QFilter("isreserve", "=", (Object)"1");
        DataSet reghtData = QueryServiceHelper.queryDataSet((String)"", (String)"bd_materialinventoryinfo", (String)"id,masterid as r_masterid", (QFilter[])leftFs.toArray(), null);
        JoinDataSet joinData = leftData.join(reghtData, JoinType.INNER);
        joinData = joinData.on(masterid, "r_masterid");
        List<String> selectCols = this.getBillCols4Select();
        String[] colArr = new String[selectCols.size()];
        for (int i = 0; i < selectCols.size(); ++i) {
            colArr[i] = this.getAlias4Left(selectCols.get(i));
        }
        joinData.select(colArr);
        return joinData.finish();
    }

    public DataSet filterRequireBillEntry() {
        QFilter billFilter = this.getBillFilter();
        String orgCol = this.schemeInfo.getOrgMatchCol();
        String masterid = this.getRequireBillMaterielCol() + ".masterid";
        String selectCols = this.getBillEntryIdFlag() + "," + orgCol + "," + masterid;
        DataSet leftData = QueryServiceHelper.queryDataSet((String)"", (String)this.schemeInfo.getRequireBillName(), (String)selectCols, (QFilter[])billFilter.toArray(), null);
        QFilter fs = new QFilter("isreserve", "=", (Object)"1");
        DataSet reghtData = QueryServiceHelper.queryDataSet((String)"", (String)"bd_materialinventoryinfo", (String)"masterid as r_masterid,useorg as r_useorg", (QFilter[])fs.toArray(), null);
        JoinDataSet joinData = leftData.join(reghtData, JoinType.INNER);
        joinData = joinData.on(orgCol, "r_useorg").on(masterid, "r_masterid");
        joinData = joinData.select(new String[]{this.getBillEntryIdFlag()});
        return joinData.finish();
    }

    private QFilter getBillFilter() {
        Object id = this.requireBillId;
        QFilter fs = new QFilter("id", "=", (Object)Long.parseLong(id.toString()));
        QFilter billFilter = this.schemeInfo.getBillFilter();
        if (billFilter != null) {
            fs.and(billFilter);
        }
        return fs;
    }

    public ReserveSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    private String getRequireBillMaterielCol() {
        Map<String, String> colsMap = this.schemeInfo.getColsMap();
        String materiel = colsMap.get("materiel");
        if (StringUtils.isBlank((CharSequence)materiel)) {
            throw new KDBizException(this.getMsgReserveMaterielError());
        }
        String materielKey = materiel.replace(colsMap.get("billentry") + ".", "");
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)this.schemeInfo.getRequireBillName()).getAllFields().get(materielKey);
        if (dataEntityProperty instanceof MaterielProp && !((MaterielProp)dataEntityProperty).getBaseEntityId().equals("bd_material")) {
            materiel = materiel + ".masterid";
        }
        return materiel;
    }

    private String getMsgReserveMaterielError() {
        return ResManager.loadKDString((String)"\u5355\u636e\u8bbe\u7f6e\u6ca1\u6709\u914d\u7f6e\u201c\u7269\u6599\u5b57\u6bb5\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReserveSchemeHander_1", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }
}

