/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.reservation.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.scmc.sbs.common.pagemodel.ImInvacc;
import org.apache.commons.lang3.StringUtils;

public class ReserveSchemeInfo {
    private DynamicObject scheme;
    private String requireBillName;
    private QFilter billFilter;
    private QFilter stockFilter;
    private String orgMatchCol;
    private JSONArray billMatchCols;
    private JSONArray stockMatchCols;
    private JSONArray orderByCols;
    private JSONArray orderByType;
    private Map<String, String> colsMap;

    public Map<String, String> getColsMap() {
        if (this.colsMap == null) {
            this.loadColsMap();
        }
        return this.colsMap;
    }

    private void loadColsMap() {
        DynamicObject data = this.scheme.getDynamicObject("billsetting");
        if (data == null) {
            throw new KDBizException(this.getMsgReserveSchemeNoSet());
        }
        String infoStr = data.getString("colmap");
        Map<String, String> colsMap = this.parseColsMap(infoStr);
        this.colsMap = colsMap;
    }

    private String getMsgReserveSchemeNoSet() {
        return ResManager.loadKDString((String)"\u9884\u7559\u65b9\u6848\u201c%s\u201d\u6ca1\u6709\u53ef\u7528\u7684\u5355\u636e\u6620\u5c04\u8bbe\u7f6e\u3002", (String)"ReserveSchemeInfo_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private Map<String, String> parseColsMap(String infoStr) {
        JSONObject info = JSON.parseObject((String)infoStr);
        JSONArray ids = info.getJSONArray("reservebillcolno");
        JSONArray values = info.getJSONArray("requirebillcolno");
        int len = ids.size();
        HashMap<String, String> colsMap = new HashMap<String, String>(len);
        for (int i = 0; i < len; ++i) {
            colsMap.put(ids.getString(i), values.getString(i));
        }
        return colsMap;
    }

    public ReserveSchemeInfo(DynamicObject scheme) {
        if (scheme == null) {
            throw new KDBizException(this.getMsgReserveSchemeError());
        }
        this.init(scheme);
    }

    private String getMsgReserveSchemeError() {
        return ResManager.loadKDString((String)"ReserveSchemeInfo:\u9884\u7559\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReserveSchemeInfo_1", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private void init(DynamicObject scheme) {
        JSONObject info;
        this.scheme = scheme;
        this.orgMatchCol = scheme.getString("requirestockorgno");
        this.requireBillName = scheme.getDynamicObject("requirebill").getString("number");
        String tempStr = scheme.getString("reservefilter");
        if (StringUtils.isNotBlank((CharSequence)tempStr)) {
            this.billFilter = this.parseFilter(tempStr, this.requireBillName);
        }
        if (StringUtils.isNotBlank((CharSequence)(tempStr = scheme.getString("stockfilter")))) {
            this.stockFilter = this.parseFilter(tempStr, ImInvacc.getBalTb());
        }
        if (StringUtils.isNotBlank((CharSequence)(tempStr = scheme.getString("stockseq")))) {
            info = JSON.parseObject((String)tempStr);
            this.orderByCols = info.getJSONArray("stocksortno");
            this.orderByType = info.getJSONArray("sorttype");
        }
        if (StringUtils.isNotBlank((CharSequence)(tempStr = scheme.getString("stockmatch")))) {
            info = JSON.parseObject((String)tempStr);
            this.billMatchCols = info.getJSONArray("requirebillmatchno");
            this.stockMatchCols = info.getJSONArray("invaccountno");
        }
    }

    private QFilter parseFilter(String jsonCondition, String entityNo) {
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNo), condition);
        fb.buildFilter();
        return fb.getQFilter();
    }

    public DynamicObject getScheme() {
        return this.scheme;
    }

    public String getRequireBillName() {
        return this.requireBillName;
    }

    public QFilter getBillFilter() {
        return this.billFilter;
    }

    public QFilter getStockFilter() {
        return this.stockFilter;
    }

    public String getOrgMatchCol() {
        return this.orgMatchCol;
    }

    public JSONArray getBillMatchCols() {
        return this.billMatchCols;
    }

    public JSONArray getStockMatchCols() {
        return this.stockMatchCols;
    }

    public JSONArray getOrderByCols() {
        return this.orderByCols;
    }

    public JSONArray getOrderByType() {
        return this.orderByType;
    }
}

