/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.reservation.singleaction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.paramentity.bizrule.reserve.pojo.ReserveOrBillInfo;
import kd.scmc.sbs.business.reservation.ReserveHelper;
import kd.scmc.sbs.business.reservation.model.ReserveContext;
import kd.scmc.sbs.business.reservation.model.ReserveLinkDeamndRow;
import kd.scmc.sbs.business.reservation.model.ReserveLinkSelectRow;
import kd.scmc.sbs.business.reservation.model.ReserveLinkSupplyRow;
import kd.scmc.sbs.business.reservation.model.ReserveSchemeInfo;
import kd.scmc.sbs.business.reservation.singleaction.ReserveLogicaUnit;
import kd.scmc.sbs.common.consts.ReservePrcType;
import kd.scmc.sbs.common.consts.ReserveType;

public class ConvertBillToLinkAction
extends ReserveLogicaUnit {
    private Map<String, String> paramSetting;
    private static final String KEY_OEBILLINFO_SEQ = "seq";

    private static String getChkBaseUit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"ConvertBillToLinkAction_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getChkUit() {
        return ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ConvertBillToLinkAction_1", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getChk2ndUit() {
        return ResManager.loadKDString((String)"\u8f85\u52a9\u5355\u4f4d", (String)"ConvertBillToLinkAction_2", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    public ConvertBillToLinkAction(ReserveContext reserveContext) {
        this.context = reserveContext;
        this.reserveOperateResult = reserveContext.getResult();
    }

    @Override
    public void doAction() {
        if (this.reserveOperateResult.isSuceese()) {
            this.paramSetting = this.context.getParamSetting();
            List<DynamicObject> lstOrBillObjs = this.context.getLstOrBillObjs();
            ArrayList<ReserveLinkSelectRow> selectReserveRows = new ArrayList<ReserveLinkSelectRow>();
            for (DynamicObject orbillObj : lstOrBillObjs) {
                List<ReserveLinkSelectRow> selectRow = this.createReserveLinkSelectRow(orbillObj);
                selectReserveRows.addAll(selectRow);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.reserveOperateResult.getErrorMessage())) {
                throw new KDBizException(this.reserveOperateResult.getErrorMessage());
            }
            this.context.setLinkSelectRows(selectReserveRows);
        }
    }

    private List<ReserveLinkSelectRow> createReserveLinkSelectRow(DynamicObject orbillObj) {
        ArrayList<ReserveLinkSelectRow> reserveLinkSelectRows = new ArrayList<ReserveLinkSelectRow>();
        Map<Object, List<Object>> matchInvaccs = this.context.getMatchInvacc();
        ArrayList<DynamicObject> notMatchAccs = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection entrys = orbillObj.getDynamicObjectCollection(this.paramSetting.get("billentry"));
        for (DynamicObject item : entrys) {
            boolean is2ndZero;
            Long demandEntryId = (Long)item.getPkValue();
            List<Object> invaccIds = matchInvaccs.get(demandEntryId);
            if (invaccIds == null) continue;
            if (invaccIds.isEmpty()) {
                notMatchAccs.add(item);
                continue;
            }
            ReserveLinkSelectRow selectRow = new ReserveLinkSelectRow();
            ReserveLinkDeamndRow demnadRow = selectRow.getDemand();
            this.setReserveLinkDeamndRow(orbillObj, item, demnadRow);
            BigDecimal reservedBaseQty = (BigDecimal)this.context.getMapHaveReserve().computeIfAbsent((Long)((Object)(demandEntryId + "," + "reservebaseqty")), k -> BigDecimal.ZERO);
            BigDecimal reservedUnitQty = (BigDecimal)this.context.getMapHaveReserve().computeIfAbsent((Long)((Object)(demandEntryId + "," + "reserveqty")), k -> BigDecimal.ZERO);
            BigDecimal reserved2ndQty = (BigDecimal)this.context.getMapHaveReserve().computeIfAbsent((Long)((Object)(demandEntryId + "," + "reserveunit2ndqty")), k -> BigDecimal.ZERO);
            BigDecimal realDemBaseQty = demnadRow.getBaseDemandQty().subtract(reservedBaseQty);
            BigDecimal realDemQty = demnadRow.getDemandQty().subtract(reservedUnitQty);
            BigDecimal realDem2ndQty = demnadRow.getDemand2ndQty().subtract(reserved2ndQty);
            boolean isBaseZero = realDemBaseQty.compareTo(BigDecimal.ZERO) == 0;
            boolean isZero = realDemQty.compareTo(BigDecimal.ZERO) == 0;
            boolean bl = is2ndZero = realDem2ndQty.compareTo(BigDecimal.ZERO) == 0;
            if (isBaseZero && isZero && is2ndZero) continue;
            demnadRow.setBaseDemandQty(demnadRow.getBaseDemandQty().subtract(reservedBaseQty));
            demnadRow.setDemandQty(demnadRow.getDemandQty().subtract(reservedUnitQty));
            demnadRow.setDemand2ndQty(demnadRow.getDemand2ndQty().subtract(reserved2ndQty));
            List<ReserveLinkSupplyRow> supplyRows = this.getReserveLinkSupplyRow(demnadRow, invaccIds, item);
            selectRow.getSupplyRows().addAll(supplyRows);
            BigDecimal supplyBaseQty = supplyRows.stream().map(ReserveLinkSupplyRow::getBaseSupplyQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal supplyQty = supplyRows.stream().map(ReserveLinkSupplyRow::getSupplyQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal supply2ndQty = supplyRows.stream().map(ReserveLinkSupplyRow::getSupply2ndQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            demnadRow.setBaseDemandQty(supplyBaseQty);
            demnadRow.setDemandQty(supplyQty);
            demnadRow.setDemand2ndQty(supply2ndQty);
            reserveLinkSelectRows.add(selectRow);
        }
        if (!notMatchAccs.isEmpty()) {
            this.setChkMessage(orbillObj, notMatchAccs);
        }
        return reserveLinkSelectRows;
    }

    private BigDecimal getHasReserveQtyByEntryId(DynamicObject orbillObj, DynamicObject entryBillInfo) {
        BigDecimal reserveQty = new BigDecimal(0);
        Map<Long, BigDecimal> mapHaveRserve = this.context.getMapHaveReserve();
        Long demandId = (Long)orbillObj.getPkValue();
        Long demandEntryId = (Long)entryBillInfo.getPkValue();
        List lstEntrydReserveQty = (List)((Object)mapHaveRserve.get(demandId));
        for (Map entrydReserveQty : lstEntrydReserveQty) {
            if (!entrydReserveQty.containsKey(demandEntryId)) continue;
            reserveQty = reserveQty.add(mapHaveRserve.get(demandEntryId));
        }
        return reserveQty;
    }

    private List<DynamicObject> getInvStockInfos(List<Object> invaccIds) {
        ArrayList<DynamicObject> infos = new ArrayList<DynamicObject>(invaccIds.size());
        Map<Object, DynamicObject> invStockInfos = this.context.getInvStockInos();
        DynamicObject data = null;
        for (Object invaccId : invaccIds) {
            data = invStockInfos.get(invaccId);
            if (data == null) continue;
            infos.add(data);
        }
        return infos;
    }

    private List<ReserveLinkSupplyRow> getReserveLinkSupplyRow(ReserveLinkDeamndRow demnadRow, List<Object> invaccIds, DynamicObject demand) {
        List<DynamicObject> invStockInos = this.getInvStockInfos(invaccIds);
        ArrayList<ReserveLinkSupplyRow> supplyRows = new ArrayList<ReserveLinkSupplyRow>(invStockInos.size());
        BigDecimal realDemandQty = demnadRow.getBaseDemandQty();
        BigDecimal realDemandUnitQty = demnadRow.getDemandQty();
        BigDecimal realDemand2ndQty = demnadRow.getDemand2ndQty();
        for (DynamicObject invObj : invStockInos) {
            BigDecimal supplyBaseQty = invObj.getBigDecimal("avbbaseqty");
            BigDecimal supplyQty = invObj.getBigDecimal("avbqty");
            BigDecimal supply2ndQty = invObj.getBigDecimal("avbqty2nd");
            ReserveLinkSupplyRow supplyRow = new ReserveLinkSupplyRow();
            this.setReserveLinkSupplyRow(invObj, supplyRow);
            BigDecimal reserveBaseQty = realDemandQty.compareTo(supplyBaseQty) > 0 ? supplyBaseQty : realDemandQty;
            BigDecimal reserveQty = realDemandUnitQty.compareTo(supplyQty) > 0 ? supplyQty : realDemandUnitQty;
            BigDecimal reserve2ndQty = realDemand2ndQty.compareTo(supply2ndQty) > 0 ? supply2ndQty : realDemand2ndQty;
            supplyRow.setBaseSupplyQty(reserveBaseQty);
            supplyRow.setSupplyQty(reserveQty);
            supplyRow.setSupply2ndQty(reserve2ndQty);
            supplyRows.add(supplyRow);
            invObj.set("avbbaseqty", (Object)supplyBaseQty.subtract(reserveBaseQty));
            invObj.set("avbqty", (Object)supplyQty.subtract(reserveQty));
            invObj.set("avbqty2nd", (Object)supply2ndQty.subtract(reserve2ndQty));
            realDemandQty = realDemandQty.subtract(reserveBaseQty);
            realDemandUnitQty = realDemandUnitQty.subtract(reserveQty);
            realDemand2ndQty = realDemand2ndQty.subtract(reserve2ndQty);
            demnadRow.setBaseDemandQty(realDemandQty);
            demnadRow.setDemandQty(realDemandUnitQty);
            demnadRow.setDemand2ndQty(realDemand2ndQty);
            if (realDemandQty.compareTo(BigDecimal.ZERO) != 0 || realDemandUnitQty.compareTo(BigDecimal.ZERO) != 0 || realDemand2ndQty.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        this.checkQtyBySchemeInfos(demnadRow, demand);
        return supplyRows;
    }

    private void checkQtyBySchemeInfos(ReserveLinkDeamndRow demnadRow, DynamicObject demand) {
        ReserveSchemeInfo schemeInfo = this.context.getSchemeInfo();
        String autoReserveMsg = schemeInfo.getScheme().getString("autoreservemsg");
        BigDecimal demandBaseQty = this.getDecimalAbs((BigDecimal)this.getValuesByKey(null, demand, "demandbaseunitqty"));
        BigDecimal demandQty = this.getDecimalAbs((BigDecimal)this.getValuesByKey(null, demand, "demandqty"));
        BigDecimal demand2ndQty = this.getDecimalAbs((BigDecimal)this.getValuesByKey(null, demand, "demandunit2ndqty"));
        this.setChkMessage(demnadRow, autoReserveMsg, demandBaseQty, demnadRow.getBaseDemandQty(), ConvertBillToLinkAction.getChkBaseUit());
        this.setChkMessage(demnadRow, autoReserveMsg, demandQty, demnadRow.getDemandQty(), ConvertBillToLinkAction.getChkUit());
        this.setChkMessage(demnadRow, autoReserveMsg, demand2ndQty, demnadRow.getDemand2ndQty(), ConvertBillToLinkAction.getChk2ndUit());
    }

    private String getNotMatchMsg(DynamicObject orbillObj, List<DynamicObject> notMatchAccs, String msgType) {
        StringBuilder sb = new StringBuilder();
        String msg = ResManager.loadKDString((String)"\u5355\u636e\u201c{0}\u201d\u5206\u5f55{1}\u6ca1\u6709\u5339\u914d\u7684\u5e93\u5b58\u8bb0\u5f55\u3002", (String)"ConvertBillToLinkAction_6", (String)"scmc-sbs-form", (Object[])new Object[0]);
        for (DynamicObject item : notMatchAccs) {
            sb.append(String.format(msg, this.getValuesByKey(orbillObj, item, "demandnumber"), item.get(KEY_OEBILLINFO_SEQ))).append(msgType).append(",");
        }
        return sb.toString();
    }

    private void setChkMessage(DynamicObject orbillObj, List<DynamicObject> notMatchAccs) {
        ReserveSchemeInfo schemeInfo = this.context.getSchemeInfo();
        String autoReserveMsg = schemeInfo.getScheme().getString("autoreservemsg");
        String msg = null;
        switch (autoReserveMsg) {
            case "A": {
                msg = this.getNotMatchMsg(orbillObj, notMatchAccs, ResManager.loadKDString((String)"\u4e0d\u505a\u9884\u7559\u5904\u7406\uff1b", (String)"ConvertBillToLinkAction_7", (String)"scmc-sbs-form", (Object[])new Object[0]));
                this.reserveOperateResult.setSuceese(false);
                this.reserveOperateResult.setMessage(this.reserveOperateResult.getMessage() + msg);
                break;
            }
            case "D": {
                msg = this.getNotMatchMsg(orbillObj, notMatchAccs, ResManager.loadKDString((String)"\u65e0\u6cd5\u9884\u7559\uff1b", (String)"ConvertBillToLinkAction_8", (String)"scmc-sbs-form", (Object[])new Object[0]));
                this.reserveOperateResult.setSuceese(false);
                this.reserveOperateResult.setErrorMessage(this.reserveOperateResult.getErrorMessage() + msg);
                break;
            }
            case "B": {
                break;
            }
            case "C": {
                this.reserveOperateResult.setSuceese(true);
                msg = this.getNotMatchMsg(orbillObj, notMatchAccs, ResManager.loadKDString((String)"\u4e0d\u505a\u9884\u7559\u5904\u7406\uff1b", (String)"ConvertBillToLinkAction_7", (String)"scmc-sbs-form", (Object[])new Object[0]));
                this.reserveOperateResult.setMessage(this.reserveOperateResult.getMessage() + msg);
            }
        }
    }

    private void setChkMessage(ReserveLinkDeamndRow demnadRow, String autoreservemsg, BigDecimal demandQty, BigDecimal demandDiffQty, String unitName) {
        if (demandDiffQty.compareTo(BigDecimal.ZERO) > 0) {
            String msg = "";
            String demandQtyStr = demandQty.stripTrailingZeros().toPlainString();
            String avbQtyStr = demandQty.subtract(demandDiffQty).stripTrailingZeros().toPlainString();
            String demandDiffQtyStr = demandDiffQty.stripTrailingZeros().toPlainString();
            switch (autoreservemsg) {
                case "A": {
                    msg = String.format(this.getMsgConvertBillToLinkActionDone(), demnadRow.getDemandInfo().getBillNo(), demnadRow.getDemandSeq(), demandQtyStr, avbQtyStr, demandDiffQtyStr);
                    this.reserveOperateResult.setSuceese(false);
                    this.reserveOperateResult.setMessage(this.reserveOperateResult.getMessage().concat(msg.replace("$$", unitName)));
                    break;
                }
                case "D": {
                    msg = String.format(this.getMsgConvertBillToLinkActionNoQty(), demnadRow.getDemandInfo().getBillNo(), demnadRow.getDemandSeq(), demandQtyStr, avbQtyStr, demandDiffQtyStr);
                    this.reserveOperateResult.setSuceese(false);
                    this.reserveOperateResult.setErrorMessage(this.reserveOperateResult.getErrorMessage() + msg.replace("$$", unitName));
                    break;
                }
                case "B": {
                    break;
                }
                case "C": {
                    this.reserveOperateResult.setSuceese(true);
                    msg = String.format(this.getMsgConvertBillToLinkActionPartQty(), demnadRow.getDemandInfo().getBillNo(), demnadRow.getDemandSeq(), demandQtyStr, avbQtyStr, demandDiffQtyStr);
                    this.reserveOperateResult.setMessage(this.reserveOperateResult.getMessage().concat(msg.replace("$$", unitName)));
                }
            }
        }
    }

    private String getMsgConvertBillToLinkActionDone() {
        return ResManager.loadKDString((String)"%1$s:\u5206\u5f55%2$s\uff0c%3$s (%4$s)\uff0c\u9884\u7559\u77ed\u7f3a%5$s\u4e2a\uff0c\u4e0d\u505a\u9884\u7559\u5904\u7406\uff1b", (String)"ConvertBillToLinkAction_3", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private String getMsgConvertBillToLinkActionNoQty() {
        return ResManager.loadKDString((String)"%1$s:\u5206\u5f55%2$s\uff0c%3$s (%4$s)\uff0c\u9884\u7559\u77ed\u7f3a%5$s\u4e2a\uff0c\u65e0\u6cd5\u9884\u7559\uff1b", (String)"ConvertBillToLinkAction_9", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private String getMsgConvertBillToLinkActionPartQty() {
        return ResManager.loadKDString((String)"%1$s:\u5206\u5f55%2$s\uff0c%3$s (%4$s)\uff0c\u9884\u7559\u77ed\u7f3a%5$s\u4e2a\uff0c\u8fdb\u884c\u90e8\u5206\u9884\u7559\uff1b", (String)"ConvertBillToLinkAction_5", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private void setReserveLinkDeamndRow(DynamicObject orbillObj, DynamicObject demand, ReserveLinkDeamndRow demnadRow) {
        Long demandId = (Long)orbillObj.getPkValue();
        String formId = orbillObj.getDataEntityType().getName();
        String billNo = (String)this.getValuesByKey(orbillObj, demand, "demandnumber");
        ReserveOrBillInfo demandOrBillInfo = demnadRow.getDemandInfo();
        demandOrBillInfo.setInterID(demandId.toString());
        demandOrBillInfo.setBillNo(billNo);
        demandOrBillInfo.setFormId(formId);
        demandOrBillInfo.setEntryID(demand.getPkValue().toString());
        demnadRow.setDemandOrgID(this.getDynamicPk(this.getValuesByKey(orbillObj, demand, "demandorg"), 0L));
        demnadRow.setDemandDate((Date)this.getValuesByKey(orbillObj, demand, "demanddate"));
        demnadRow.setDemandMaterialID(this.getDynamicPk(this.getValuesByKey(orbillObj, demand, "materiel"), 0L));
        demnadRow.setBaseUnitId(this.getDynamicPk(this.getValuesByKey(orbillObj, demand, "demanbasedunit"), 0L));
        demnadRow.setUnitId(this.getDynamicPk(this.getValuesByKey(orbillObj, demand, "demandunit"), 0L));
        demnadRow.setUnit2ndId(this.getDynamicPk(this.getValuesByKey(orbillObj, demand, "demandunit2nd"), 0L));
        demnadRow.setDemandSeq(demand.getLong(KEY_OEBILLINFO_SEQ));
        demnadRow.setBaseDemandQty(this.getDecimalAbs((BigDecimal)this.getValuesByKey(orbillObj, demand, "demandbaseunitqty")));
        demnadRow.setDemandQty(this.getDecimalAbs((BigDecimal)this.getValuesByKey(orbillObj, demand, "demandqty")));
        demnadRow.setDemand2ndQty(this.getDecimalAbs((BigDecimal)this.getValuesByKey(orbillObj, demand, "demandunit2ndqty")));
        demnadRow.setReserveType(ReserveType.BILLRESERVE.getNumber());
        demnadRow.setReservecust(this.getDynamicPk(this.getValuesByKey(orbillObj, demand, "reservecust"), 0L));
        demnadRow.setReveredept(this.getDynamicPk(this.getValuesByKey(orbillObj, demand, "reveredept"), 0L));
        demnadRow.setReserveoperate(this.getDynamicPk(this.getValuesByKey(orbillObj, demand, "reserveoperate"), 0L));
    }

    private Object getValuesByKey(DynamicObject demandinfo, DynamicObject demandEntryinfo, String setValueKey) {
        Object obj = null;
        String entryKey = this.paramSetting.get("billentry");
        String mapKey = this.paramSetting.get(setValueKey);
        if (mapKey != null) {
            if (mapKey.contains(entryKey)) {
                String[] key = mapKey.split("\\.");
                String field = key[key.length - 1];
                if (setValueKey.equals("materiel")) {
                    obj = demandEntryinfo.get(mapKey.replace(entryKey + ".", ""));
                    obj = ReserveHelper.getMasterMaterial((DynamicObject)obj);
                } else {
                    obj = demandEntryinfo.get(field);
                }
            } else if (demandinfo != null) {
                obj = demandinfo.get(mapKey);
            }
        }
        return obj;
    }

    private void setReserveLinkSupplyRow(DynamicObject supply, ReserveLinkSupplyRow supplyRow) {
        supplyRow.setSupplyOrgID(this.getDynamicPk(supply, "org", 0L));
        supplyRow.setReservePcType(ReservePrcType.AUTORESREVE.getNumber());
        supplyRow.setBaseSupplyUnitID(this.getDynamicPk(supply, "baseunit", 0L));
        supplyRow.setSupplyUnitID(this.getDynamicPk(supply, "unit", 0L));
        supplyRow.setSupplyUnit2ndID(this.getDynamicPk(supply, "unit2nd", 0L));
        supplyRow.setSupplyLotNumber(supply.getString("lotnum"));
        supplyRow.setSupplyStockID(this.getDynamicPk(supply, "warehouse", 0L));
        supplyRow.setSupplyStockLocID(this.getDynamicPk(supply, "location", 0L));
        ReserveOrBillInfo supplyOrBillInfo = supplyRow.getSupplyBillInfo();
        supplyOrBillInfo.setFormId(supply.getDataEntityType().getName());
        supplyOrBillInfo.setInterID(String.valueOf(supply.getPkValue()));
        supplyOrBillInfo.setEntryID(String.valueOf(supply.getPkValue()));
        supplyRow.setSupplyAuxpropID(this.getDynamicPk(supply, "auxpty", 0L));
    }

    private <T> T getDynamicPk(Object obj, T t) {
        if (obj instanceof DynamicObject) {
            return (T)(ObjectUtils.isEmpty((Object)obj) ? t : ((DynamicObject)obj).getPkValue());
        }
        return t;
    }

    private <T> T getDynamicPk(DynamicObject obj, String key, T t) {
        return (T)(ObjectUtils.isEmpty((Object)obj.getDynamicObject(key)) ? t : obj.getDynamicObject(key).getPkValue());
    }

    private BigDecimal getDecimalAbs(BigDecimal value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value.abs();
    }
}

