/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.reservation.singleaction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.scmc.sbs.business.reservation.model.BalReserveQtyArgs;
import kd.scmc.sbs.business.reservation.model.ReserveContext;
import kd.scmc.sbs.business.reservation.model.ReserveLinkDeamndRow;
import kd.scmc.sbs.business.reservation.model.ReserveLinkSelectRow;
import kd.scmc.sbs.business.reservation.model.ReserveLinkSupplyRow;
import kd.scmc.sbs.business.reservation.model.ReserveSchemeInfo;
import kd.scmc.sbs.business.reservation.singleaction.ReserveLogicaUnit;

public class CreateReserveLinkAction
extends ReserveLogicaUnit {
    private static Set<String> billModelFieldSet = new HashSet<String>(16);
    private static Set<String> balModelFieldSet = new HashSet<String>(16);

    public CreateReserveLinkAction(ReserveContext reserveContext) {
        this.context = reserveContext;
        this.reserveOperateResult = reserveContext.getResult();
    }

    @Override
    public void doAction() {
        if (!this.reserveOperateResult.isSuceese()) {
            return;
        }
        CreateReserveLinkAction.initSelectInfo();
        MainEntityType recordType = EntityMetadataCache.getDataEntityType((String)"msmod_reserve_record");
        List<ReserveLinkSelectRow> linkSelectRows = this.context.getLinkSelectRows();
        ArrayList<DynamicObject> reserveLinkDatas = new ArrayList<DynamicObject>(linkSelectRows.size());
        HashMap<Object, BalReserveQtyArgs> balQtyMap = new HashMap<Object, BalReserveQtyArgs>(linkSelectRows.size());
        Date now = TimeServiceHelper.now();
        Long creator = Long.valueOf(RequestContext.getOrCreate().getUserId());
        DynamicObject reqInfoDynamicObject = this.getReqInfoDynamicObject(linkSelectRows);
        Map<Object, DynamicObject> supInfoDynamicMap = this.getSupInfoDynamicMap(linkSelectRows);
        String balObjId = "im_inv_realbalance";
        for (ReserveLinkSelectRow reserveLinkSelectRow : linkSelectRows) {
            List<ReserveLinkSupplyRow> supplyRows = reserveLinkSelectRow.getSupplyRows();
            for (ReserveLinkSupplyRow supplyRow : supplyRows) {
                Long interID = Long.valueOf(supplyRow.getSupplyBillInfo().getInterID());
                DynamicObject reserveRecord = (DynamicObject)recordType.createInstance();
                reserveRecord.set("create_date", (Object)now);
                reserveRecord.set("bal_obj", (Object)balObjId);
                reserveRecord.set("creater", (Object)creator);
                this.buildNewReserveRecord(reserveRecord, reserveLinkSelectRow.getDemand(), supplyRow, balQtyMap, reqInfoDynamicObject);
                this.putRequestInfo(reserveRecord, this.context, reserveLinkSelectRow, reqInfoDynamicObject);
                this.putSuppleInfo(reserveRecord, this.context, supplyRow, supInfoDynamicMap.get(interID));
                if (reserveRecord.getBigDecimal("qty").compareTo(BigDecimal.ZERO) == 0 && reserveRecord.getBigDecimal("base_qty").compareTo(BigDecimal.ZERO) == 0) continue;
                reserveLinkDatas.add(reserveRecord);
            }
        }
        ReserveRecordHandler.createReserveRecord(reserveLinkDatas);
    }

    private Map<Object, DynamicObject> getSupInfoDynamicMap(List<ReserveLinkSelectRow> linkSelectRows) {
        HashMap<Object, DynamicObject> supBillMap = new HashMap<Object, DynamicObject>(16);
        if (linkSelectRows.size() != 0) {
            String formId;
            ArrayList<ReserveLinkSupplyRow> supplyRows = new ArrayList<ReserveLinkSupplyRow>(8);
            for (ReserveLinkSelectRow selectRow : linkSelectRows) {
                supplyRows.addAll(selectRow.getSupplyRows());
            }
            HashMap<Object, Set> formIdToIdsMapping = new HashMap<Object, Set>(supplyRows.size());
            for (ReserveLinkSupplyRow reserveLinkSupplyRow : supplyRows) {
                formId = reserveLinkSupplyRow.getSupplyBillInfo().getFormId();
                Long interID = Long.valueOf(reserveLinkSupplyRow.getSupplyBillInfo().getInterID());
                Set billIds = formIdToIdsMapping.computeIfAbsent(formId, k -> new HashSet(16));
                billIds.add(interID);
            }
            for (Map.Entry entry : formIdToIdsMapping.entrySet()) {
                formId = entry.getKey();
                Set billIds = (Set)entry.getValue();
                Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)formId.toString(), (QFilter[])new QFilter("id", "in", (Object)billIds).toArray());
                supBillMap.putAll(dynamicObjectMap);
            }
        }
        return supBillMap;
    }

    private DynamicObject getReqInfoDynamicObject(List<ReserveLinkSelectRow> linkSelectRows) {
        if (linkSelectRows.size() == 0) {
            return null;
        }
        String formId = linkSelectRows.get(0).getDemand().getDemandInfo().getFormId();
        String interID = linkSelectRows.get(0).getDemand().getDemandInfo().getInterID();
        return BusinessDataServiceHelper.loadSingleFromCache((String)formId, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(interID))});
    }

    private void putSuppleInfo(DynamicObject reserveRecord, ReserveContext context, ReserveLinkSupplyRow supplyRow, DynamicObject dynamicObject) {
        kd.mpscmm.msbd.reserve.business.ReserveContext reserveContext = new kd.mpscmm.msbd.reserve.business.ReserveContext();
        ColsMap supColsMap = reserveContext.getSupColsMap("im_inv_realbalance");
        Map balColMap = supColsMap.getBalColMap();
        Long balId = Long.valueOf(supplyRow.getSupplyBillInfo().getInterID());
        Map<Object, DynamicObject> invStockInos = context.getInvStockInos();
        DynamicObject suppleBill = null;
        if (invStockInos == null) {
            suppleBill = dynamicObject;
        } else {
            for (Map.Entry<Object, DynamicObject> entry : invStockInos.entrySet()) {
                if (!balId.equals(entry.getKey())) continue;
                suppleBill = entry.getValue();
            }
        }
        this.SetSupAndResBillInfo(balModelFieldSet, balColMap, reserveRecord, suppleBill, balId);
    }

    private void putRequestInfo(DynamicObject reserveRecord, ReserveContext context, ReserveLinkSelectRow SelectRows, DynamicObject reqInfoDynamicObject) {
        String resformId = SelectRows.getDemand().getDemandInfo().getFormId();
        kd.mpscmm.msbd.reserve.business.ReserveContext reserveContext = new kd.mpscmm.msbd.reserve.business.ReserveContext();
        ColsMap demandColsMap = reserveContext.getDemandColsMap(resformId);
        Map billColMap = demandColsMap.getBalColMap();
        DynamicObject requesBill = null;
        requesBill = context.getLstOrBillObjs() == null ? reqInfoDynamicObject : context.getLstOrBillObjs().get(0);
        long entryId = reserveRecord.getLong("billentry_id");
        this.SetSupAndResBillInfo(billModelFieldSet, billColMap, reserveRecord, requesBill, entryId);
    }

    private void SetSupAndResBillInfo(Set<String> billAndBalModelFieldSet, Map<String, String> billOrBalColMap, DynamicObject reserveRecord, DynamicObject reqAndSupBill, long entryId) {
        Iterator<String> iterator = billAndBalModelFieldSet.iterator();
        while (iterator.hasNext()) {
            String billkey;
            String modleInfo;
            String fild = modleInfo = iterator.next();
            if (modleInfo.startsWith("r_") || modleInfo.startsWith("s_")) {
                fild = modleInfo.substring(2);
            }
            if ((billkey = billOrBalColMap.get(fild)) == null || billkey.length() <= 0) continue;
            if (billkey.startsWith("billentry.")) {
                billkey = billkey.substring(10);
                DynamicObjectCollection billentrys = reqAndSupBill.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentrys) {
                    Long entry = billentry.getLong("id");
                    if (!entry.equals(entryId)) continue;
                    Object value = billentry.get(billkey);
                    reserveRecord.set(modleInfo, value);
                }
                continue;
            }
            Object value = reqAndSupBill.get(billkey);
            reserveRecord.set(modleInfo, value);
        }
    }

    protected void buildNewReserveRecord(DynamicObject reserveRecord, ReserveLinkDeamndRow deamndRow, ReserveLinkSupplyRow supplyRow, Map<Object, BalReserveQtyArgs> balQtyMap, DynamicObject reqInfoDynamicObject) {
        BigDecimal baseSupplyQty = supplyRow.getBaseSupplyQty();
        BigDecimal supplyQty = supplyRow.getSupplyQty();
        BigDecimal supply2ndQty = supplyRow.getSupply2ndQty();
        ReserveSchemeInfo schemeInfo = this.context.getSchemeInfo();
        Long balId = Long.valueOf(supplyRow.getSupplyBillInfo().getInterID());
        BalReserveQtyArgs reserveQtyArgs = balQtyMap.get(balId);
        if (reserveQtyArgs == null) {
            reserveQtyArgs = new BalReserveQtyArgs();
            balQtyMap.put(balId, reserveQtyArgs);
        }
        reserveQtyArgs.addBaseQty(baseSupplyQty);
        reserveQtyArgs.addQty(supplyQty);
        reserveQtyArgs.addQty2nd(supply2ndQty);
        String entryKey = deamndRow.getDemandInfo().getEntryKey();
        if (StringUtils.isBlank((CharSequence)entryKey) && schemeInfo != null) {
            entryKey = schemeInfo.getColsMap().get("billentry");
        }
        reserveRecord.set("bill_obj", (Object)deamndRow.getDemandInfo().getFormId());
        reserveRecord.set("bill_no", (Object)deamndRow.getDemandInfo().getBillNo());
        if (StringUtils.isEmpty((CharSequence)deamndRow.getDemandInfo().getBillNo())) {
            reserveRecord.set("bill_no", reqInfoDynamicObject.get("billno"));
        }
        reserveRecord.set("bill_id", (Object)Long.valueOf(deamndRow.getDemandInfo().getInterID()));
        reserveRecord.set("billentry_id", (Object)Long.valueOf(deamndRow.getDemandInfo().getEntryID()));
        reserveRecord.set("bill_source", (Object)"1");
        reserveRecord.set("reserveprctype", (Object)supplyRow.getReservePcType());
        reserveRecord.set("entry_name", (Object)entryKey);
        reserveRecord.set("billentry_seq", (Object)deamndRow.getDemandSeq());
        reserveRecord.set("bal_id", (Object)balId);
        reserveRecord.set("bal_entryid", (Object)balId);
        reserveRecord.set("base_qty", (Object)baseSupplyQty);
        reserveRecord.set("qty", (Object)supplyQty);
        reserveRecord.set("qty2nd", (Object)supply2ndQty);
        reserveRecord.set("bal_source", (Object)"1");
    }

    private static void initSelectInfo() {
        Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getAllFields();
        billModelFieldSet = new HashSet<String>();
        balModelFieldSet = new HashSet<String>(16);
        for (String key : allFieldMap.keySet()) {
            if (key.startsWith("r_")) {
                billModelFieldSet.add(key);
                continue;
            }
            if (!key.startsWith("s_")) continue;
            balModelFieldSet.add(key);
        }
    }
}

