/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.sn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.sbs.common.model.sn.InvCounterEntity;

public class SNBillConfigHelper {
    private static String GLOBAL_UNIQUE_VAL = ",0,";

    public static Set<String> getSnUnqctrl() {
        DynamicObject snumberCfg = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_sndimension", (QFilter[])new QFilter("number", "=", (Object)"SNUMBER").toArray());
        String sncheckrange = snumberCfg.getString("sncheckrange");
        if (sncheckrange == null || sncheckrange.isEmpty() || GLOBAL_UNIQUE_VAL.equals(sncheckrange)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(sncheckrange.substring(1, sncheckrange.length() - 1).split(",")));
    }

    public static Map<Integer, Map<String, Object>> getSndims() {
        DynamicObjectCollection dimobjs = QueryServiceHelper.query((String)"bd_sndimension", (String)"id,name,sncheckrange,relcolumn", (QFilter[])new QFilter("number", "!=", (Object)"SNUMBER").and("enable", "=", (Object)Boolean.TRUE).toArray(), (String)"id");
        if (dimobjs.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Integer, Map<String, Object>> dims = new LinkedHashMap<Integer, Map<String, Object>>(dimobjs.size());
        int index = 1;
        for (DynamicObject dimobj : dimobjs) {
            Integer seq = index;
            Long id = dimobj.getLong("id");
            String name = dimobj.getString("name");
            String relcolumn = dimobj.getString("relcolumn").replaceFirst("entryentity.", "");
            HashMap<String, Object> dimcfgs = new HashMap<String, Object>(4);
            dimcfgs.put("id", id);
            dimcfgs.put("name", name);
            dimcfgs.put("relcolumn", relcolumn);
            String sncheckrange = dimobj.getString("sncheckrange");
            Set<Object> checkranges = null;
            checkranges = sncheckrange == null || sncheckrange.isEmpty() || GLOBAL_UNIQUE_VAL.equals(sncheckrange) ? Collections.emptySet() : new HashSet<String>(Arrays.asList(sncheckrange.substring(1, sncheckrange.length() - 1).split(",")));
            dimcfgs.put("sncheckrange", checkranges);
            dims.put(seq, dimcfgs);
            ++index;
        }
        return dims;
    }

    public static Collection<DynamicObject> getSNBillConfig(String billtype) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"sbs_snbillconfig", (QFilter[])new QFilter("srcbillobj", "=", (Object)billtype).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return cfgs.values().stream().sorted((cfg1, cfg2) -> {
            Long result = (Long)cfg1.getPkValue() - (Long)cfg2.getPkValue();
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }).collect(Collectors.toList());
    }

    public static Collection<DynamicObject> getSNBillConfig(String billtype, String entrytype) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"sbs_snbillconfig", (QFilter[])new QFilter("srcbillobj", "=", (Object)billtype).and("srcbillentry", "=", (Object)entrytype).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return cfgs.values().stream().sorted((cfg1, cfg2) -> {
            Long result = (Long)cfg1.getPkValue() - (Long)cfg2.getPkValue();
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }).collect(Collectors.toList());
    }

    public static DynamicObject getSNBillConfigByBillId(String billtype, String entrytype, Long billid) {
        Collection<DynamicObject> cfgs = SNBillConfigHelper.getSNBillConfig(billtype, entrytype);
        for (DynamicObject cfg : cfgs) {
            DynamicObject result;
            QFilter filter = new QFilter("id", "=", (Object)billid);
            QFilter cfgFilter = SNBillConfigHelper.parseBillFilter(cfg.getString("billfilter"), billtype);
            if (cfgFilter != null) {
                filter.and(cfgFilter);
            }
            if ((result = QueryServiceHelper.queryOne((String)billtype, (String)"id", (QFilter[])filter.toArray())) == null) continue;
            return cfg;
        }
        return null;
    }

    public static Map<String, Set<String>> getBillCfgsMatchMap(String billtype, Collection<DynamicObject> cfgs, List<Long> billIds) {
        HashMap<String, Set<String>> billCfgsMap = new HashMap<String, Set<String>>(billIds.size() * 2);
        for (DynamicObject cfg : cfgs) {
            String identPre = cfg.getString("srcbillentry") + '.';
            QFilter filter = new QFilter("id", "in", billIds);
            QFilter cfgFilter = SNBillConfigHelper.parseBillFilter(cfg.getString("billfilter"), billtype);
            if (cfgFilter != null) {
                filter.and(cfgFilter);
            }
            DynamicObjectCollection bills = QueryServiceHelper.query((String)billtype, (String)"id", (QFilter[])filter.toArray());
            for (DynamicObject bill : bills) {
                Long billId = bill.getLong("id");
                String ident = identPre + billId;
                Set cfgSet = billCfgsMap.getOrDefault(ident, new HashSet(3));
                cfgSet.add(cfg.getString("number"));
                if (billCfgsMap.containsKey(ident)) continue;
                billCfgsMap.put(ident, cfgSet);
            }
        }
        return billCfgsMap;
    }

    public static boolean isDynamicObjectMatchCfg(String billtype, DynamicObject billObj, DynamicObject cfg) {
        String jsonCondition = cfg.getString("billfilter");
        if (jsonCondition == null || jsonCondition.isEmpty() || billtype == null) {
            return true;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        if (filterCondition.getFilterRow().isEmpty()) {
            return true;
        }
        MainEntityType mainType = (MainEntityType)billObj.getDataEntityType();
        FilterBuilder builder = new FilterBuilder(mainType, filterCondition);
        String[] script = builder.buildFilterScript();
        BOSExpression expr = new BOSExpression(script[0]);
        RowDataModel rowModel = new RowDataModel(billtype, mainType);
        BOSExpressionContext expContext = new BOSExpressionContext(rowModel);
        expContext.getRowDataModel().setRowContext((Object)billObj, 0);
        Boolean result = (Boolean)CalcExprParser.getExpressionValue((BOSExpression)expr, (ExpressionContext)expContext, (FunctionManage)FunctionManage.get());
        return result;
    }

    public static QFilter parseBillFilter(String jsonCondition, String billtype) {
        if (jsonCondition == null || jsonCondition.isEmpty() || billtype == null) {
            return null;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billtype), condition);
        fb.buildFilter();
        return fb.getQFilter();
    }

    public static Map<String, Object> getCfgOpeAttrMap(DynamicObject cfg, String operate) {
        if (cfg == null || operate == null) {
            return null;
        }
        HashMap<String, Object> opeAttrMap = new HashMap<String, Object>(7);
        opeAttrMap.put("invflu", cfg.getString("invflu"));
        opeAttrMap.put("istran", cfg.getBoolean("istran"));
        opeAttrMap.put("snreqbill", cfg.getBoolean("snreqbill"));
        opeAttrMap.put("snstatus", SNBillConfigHelper.getSnstatus(cfg));
        opeAttrMap.put("gensn", cfg.getBoolean("gensn"));
        opeAttrMap.put("allowempty", cfg.getBoolean("allowempty"));
        opeAttrMap.put("occupymove", cfg.getBoolean("occupymove"));
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("operateentry");
        String snservices = null;
        List<Object> snServicesList = Collections.emptyList();
        for (DynamicObject entry : entries) {
            String cfgOperate = entry.getString("operate");
            if (!cfgOperate.equals(operate)) continue;
            snservices = entry.getString("snservices");
            snServicesList = Arrays.asList(snservices.substring(1, snservices.length() - 1).split(","));
            break;
        }
        opeAttrMap.put("snservices", snServicesList);
        return opeAttrMap;
    }

    public static LinkedHashMap<String, String> getSNMainfMaps(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("snmainfentry");
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>(entries.size());
        for (DynamicObject entry : entries) {
            if ("material".equals(entry.getString("snmainfcol")) || "invorg".equals(entry.getString("snmainfcol")) || "lotnumber".equals(entry.getString("snmainfcol"))) continue;
            maps.put(entry.getString("snmainfcol"), entry.getString("snmainfsrcbillcol"));
        }
        return maps;
    }

    public static LinkedHashMap<String, String> getSNTrackMaps(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("sntrackentry");
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>(entries.size());
        for (DynamicObject entry : entries) {
            maps.put(entry.getString("sntrackcol"), entry.getString("sntracksrcbillcol"));
        }
        return maps;
    }

    public static Map<String, Map<String, String>> getSNTrackColNames(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("sntrackentry");
        HashMap<String, Map<String, String>> maps = new HashMap<String, Map<String, String>>(entries.size());
        for (DynamicObject entry : entries) {
            HashMap<String, String> names = new HashMap<String, String>(2);
            names.put("sntrackcolno", entry.getString("sntrackcolno"));
            names.put("sntracksrcbillcolno", entry.getString("sntracksrcbillcolno"));
            maps.put(entry.getString("sntrackcol"), names);
        }
        return maps;
    }

    public static Map<String, String> getSNTrackValMaps(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("sntrkvalentry");
        HashMap<String, String> maps = new HashMap<String, String>(entries.size());
        for (DynamicObject entry : entries) {
            maps.put(entry.getString("sntrkvalcol"), entry.getString("sntrkvalsrcbillcol"));
        }
        return maps;
    }

    public static Map<String, Map<String, String>> getSNTrackValColNames(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("sntrkvalentry");
        HashMap<String, Map<String, String>> maps = new HashMap<String, Map<String, String>>(entries.size());
        for (DynamicObject entry : entries) {
            HashMap<String, String> names = new HashMap<String, String>(2);
            names.put("sntrkvalcolno", entry.getString("sntrkvalcolno"));
            names.put("sntrkvalsrcbillcolno", entry.getString("sntrkvalsrcbillcolno"));
            maps.put(entry.getString("sntrkvalcol"), names);
        }
        return maps;
    }

    public static String getSnBaseqtyCol(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        return cfg.getString("snbaseqtycol");
    }

    public static String getMaterialCol(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        return cfg.getString("materialcol");
    }

    public static Set<String> getSnstatus(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        String snstatus = cfg.getString("snstatus");
        if (snstatus == null || snstatus.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(snstatus.substring(1, snstatus.length() - 1).split(",")));
    }

    public static String getInvOrgSrcCol(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("snmainfentry");
        for (DynamicObject entry : entries) {
            if (!"invorg".equals(entry.getString("snmainfcol"))) continue;
            return entry.getString("snmainfsrcbillcol");
        }
        return "";
    }

    public static String getLotNumSrcCol(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("snmainfentry");
        for (DynamicObject entry : entries) {
            if (!"lotnumber".equals(entry.getString("snmainfcol"))) continue;
            return entry.getString("snmainfsrcbillcol");
        }
        return "";
    }

    public static String getEntryPath(String billtype, String entrytype) {
        if (billtype == null || entrytype == null) {
            return null;
        }
        MainEntityType meta = MetadataServiceHelper.getDataEntityType((String)billtype);
        EntityType entry = (EntityType)meta.getAllEntities().get(entrytype);
        IDataEntityType parent = entry.getParent();
        if (parent instanceof MainEntityType) {
            return entrytype;
        }
        return parent.getName() + '.' + entrytype;
    }

    public static Map<String, Object> getBalanceInfo(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObject balancetype = cfg.getDynamicObject("balancetype");
        if (balancetype != null) {
            HashMap<String, Object> balanceMap = new HashMap<String, Object>(4);
            balanceMap.put("balancetype", balancetype.getString("number"));
            balanceMap.put("tablename", balancetype.getString("tablename"));
            balanceMap.put("snapshottable", balancetype.getString("snapshottable"));
            balanceMap.put("balancedbroute", "scm");
            return balanceMap;
        }
        return null;
    }

    public static String getSnStatusBySubmit(Map<String, Object> opeAttrMap) {
        String invflu = (String)opeAttrMap.get("invflu");
        if (invflu.equals("1")) {
            return "A";
        }
        if (invflu.equals("2")) {
            return "C";
        }
        return "C";
    }

    public static InvCounterEntity getInvCounterEntity(Map<String, Object> opeAttrMap) {
        boolean isreqbill = (Boolean)opeAttrMap.get("snreqbill");
        if (isreqbill) {
            return new InvCounterEntity(0, 0, 0, 0);
        }
        String invflu = (String)opeAttrMap.get("invflu");
        Boolean isTran = (Boolean)opeAttrMap.get("istran");
        if (isTran.booleanValue()) {
            if (invflu.equals("1")) {
                return new InvCounterEntity(1, 0, 1, 0);
            }
            if (invflu.equals("2")) {
                return new InvCounterEntity(0, 1, 0, 1);
            }
            if (invflu.equals("3")) {
                return new InvCounterEntity(1, 1, 1, 1);
            }
        } else {
            if (invflu.equals("1")) {
                return new InvCounterEntity(1, 0, 0, 0);
            }
            if (invflu.equals("2")) {
                return new InvCounterEntity(0, 1, 0, 0);
            }
            if (invflu.equals("3")) {
                return new InvCounterEntity(1, 1, 0, 0);
            }
        }
        return new InvCounterEntity();
    }

    public static InvCounterEntity getNegInvCounterEntity(Map<String, Object> opeAttrMap) {
        InvCounterEntity invCounter = SNBillConfigHelper.getInvCounterEntity(opeAttrMap);
        invCounter.setInvIncrease(-invCounter.getInvIncrease());
        invCounter.setInvSubstract(-invCounter.getInvSubstract());
        invCounter.setTransInvIncrease(-invCounter.getTransInvIncrease());
        invCounter.setTransInvSubstract(-invCounter.getTransInvSubstract());
        return invCounter;
    }

    public static Collection<DynamicObject> getSNRelExtConfigs(DynamicObject cfg) {
        DynamicObjectCollection dimobjs = QueryServiceHelper.query((String)"bd_sndimension", (String)"relcolumn", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
        ArrayList<String> dimcols = new ArrayList<String>(dimobjs.size());
        for (DynamicObject dimobj : dimobjs) {
            dimcols.add(dimobj.getString("relcolumn"));
        }
        String invflu = cfg.getString("invflu");
        Map relextCfgs = BusinessDataServiceHelper.loadFromCache((String)"sbs_snrelextconfig", (QFilter[])new QFilter("invflu", "like", (Object)("%," + invflu + ",%")).and("billsncol", "not in", dimcols).toArray());
        return relextCfgs.values();
    }

    public static long genId(String tablename) {
        return DB.genLongId((String)tablename);
    }

    public static long[] batchGenId(String tablename, int count) {
        return DB.genLongIds((String)tablename, (int)count);
    }

    public static LinkedList<DynamicObject> getSnEnterMaps(DynamicObject cfg) {
        if (cfg == null) {
            return new LinkedList<DynamicObject>();
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("inputsnentity");
        if (entries == null || entries.size() == 0) {
            return new LinkedList<DynamicObject>();
        }
        return new LinkedList<DynamicObject>((Collection<DynamicObject>)entries);
    }

    public static Map<String, IDataEntityProperty> getBillRelationProperties(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        String type = SNBillConfigHelper.getLayoutType(cfg);
        return MetadataServiceHelper.getDataEntityType((String)type).getAllFields();
    }

    public static String getLayoutType(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObject layout = cfg.getDynamicObject("enterlayout");
        if (layout == null) {
            return "sbs_billsnrelation";
        }
        return layout.getString("id");
    }

    public static String getMaterialMasterCol(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        return cfg.getString("materialmastercol");
    }

    public static Long getMaterialMasterId(Long materialid) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"bd_materialinventoryinfo", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)materialid)});
        return object.getLong("masterid");
    }

    public static Long getMaterialInvInfoId(Long materialMasterId, Long invOrgId) {
        DynamicObject materialInvInfo = SNBillConfigHelper.getMaterialInvInfo(materialMasterId, invOrgId);
        if (materialInvInfo == null) {
            return 0L;
        }
        return materialInvInfo.getLong("id");
    }

    public static DynamicObject getMaterialInvInfo(Long materialMasterId, Long invOrgId) {
        QFilter qFilter = new QFilter("masterid", "=", (Object)materialMasterId).and("enableserial", "=", (Object)true).and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)invOrgId));
        Map bdMaterialInventoryInfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (QFilter[])qFilter.toArray());
        if (bdMaterialInventoryInfo == null || bdMaterialInventoryInfo.isEmpty()) {
            return null;
        }
        List objects = bdMaterialInventoryInfo.keySet().stream().sorted().collect(Collectors.toList());
        return (DynamicObject)bdMaterialInventoryInfo.get(objects.get(objects.size() - 1));
    }

    public static Collection<DynamicObject> getSNBillConfigByBillType(String billType) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"sbs_snbillconfig", (QFilter[])new QFilter("srcbillobj", "=", (Object)billType).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return cfgs.values().stream().sorted((cfg1, cfg2) -> {
            Long result = (Long)cfg1.getPkValue() - (Long)cfg2.getPkValue();
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }).collect(Collectors.toList());
    }
}

