/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.sn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sbs.business.sn.InvBillCommonHelper;
import kd.scmc.sbs.business.sn.billFiledMapper.BillFieldMapper;
import kd.scmc.sbs.business.sn.billFiledMapper.BillFieldMapperFactory;
import kd.scmc.sbs.business.sn.relation.BillSNRelationHelper;

public class SNCarryingConfigHelper {
    public static List<DynamicObject> getConfigByType(String sourceType, String billType) {
        Map cfg = BusinessDataServiceHelper.loadFromCache((String)"sbs_sncarryingconfig", (String)"sourcebilltype,targetbilltype,preconditionfilter,preconditionfilter_tag,snrangefilter,snrangefilter_tag,mainfilefilter,trackfilter,mainfilefilter_tag,trackfilter_tag", (QFilter[])new QFilter("targetbilltype", "=", (Object)billType).and("sourcebilltype", "=", (Object)sourceType).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return new ArrayList<DynamicObject>(cfg.values());
    }

    public static DynamicObjectCollection getSNCarryConfigByType(String sourceType, String billType) {
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"sbs_sncarryingconfig", (String)"id,name,sourcebilltype,targetbilltype,preconditionfilter,preconditionfilter_tag,snrangefilter,snrangefilter_tag,mainfilefilter,trackfilter,mainfilefilter_tag,trackfilter_tag", (QFilter[])new QFilter("targetbilltype", "=", (Object)billType).and("sourcebilltype", "=", (Object)sourceType).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return configs;
    }

    public static void generateSNByBotpPush(DynamicObject[] targetBills) {
        Map<String, List<DynamicObject>> parseBillEntryBySerailNumber;
        DataSet snAllCarryRelationDataSet;
        BillFieldMapper mapper;
        String billType = targetBills[0].getDataEntityType().getName();
        String sourceType = SNCarryingConfigHelper.getSourceType(targetBills[0], billType, (mapper = BillFieldMapperFactory.getBillFieldMapper(billType)).getBillEntryKey());
        if (StringUtils.isEmpty((String)sourceType)) {
            return;
        }
        ArrayList<DynamicObject> allCarryBills = new ArrayList<DynamicObject>(8);
        HashMap<Long, List> conditionCarryBillsMap = new HashMap<Long, List>();
        StringBuilder errInfo = new StringBuilder();
        ArrayList<Long> targetBillIds = new ArrayList<Long>(((DynamicObject[])targetBills).length);
        for (Object targetBill : targetBills) {
            targetBillIds.add((Long)targetBill.getPkValue());
        }
        HashMap<Long, Set> configAgreeBills = new HashMap<Long, Set>();
        HashMap<Long, DynamicObject> configs = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection snCarryConfigs = SNCarryingConfigHelper.getSNCarryConfigByType(sourceType, billType);
        if (snCarryConfigs == null || snCarryConfigs.size() == 0) {
            allCarryBills.addAll(Arrays.asList(targetBills));
        } else {
            for (DynamicObject config : snCarryConfigs) {
                long configId = config.getLong("id");
                configs.put(configId, config);
                configAgreeBills.computeIfAbsent(configId, k -> new HashSet());
                String preconditionFilter = config.getString("preconditionfilter_tag");
                QFilter preQFilter = SNCarryingConfigHelper.parseBillFilter(preconditionFilter, billType);
                if (preQFilter == null) {
                    ((Set)configAgreeBills.get(configId)).addAll(targetBillIds);
                    continue;
                }
                preQFilter.and("id", "in", targetBillIds);
                DynamicObjectCollection agreeBills = QueryServiceHelper.query((String)billType, (String)"id", (QFilter[])new QFilter[]{preQFilter});
                if (agreeBills == null || agreeBills.size() == 0) continue;
                for (DynamicObject agreeBill : agreeBills) {
                    ((Set)configAgreeBills.get(configId)).add(agreeBill.getLong("id"));
                }
            }
        }
        ArrayList agreeConfigIds = new ArrayList();
        for (DynamicObject targetBill : targetBills) {
            Long billId = (Long)targetBill.getPkValue();
            agreeConfigIds.clear();
            for (Map.Entry entry : configAgreeBills.entrySet()) {
                if (!((Set)entry.getValue()).contains(billId)) continue;
                agreeConfigIds.add(entry.getKey());
            }
            if (agreeConfigIds.size() == 0) {
                allCarryBills.add(targetBill);
                continue;
            }
            if (agreeConfigIds.size() == 1) {
                Long configId = (Long)agreeConfigIds.get(0);
                conditionCarryBillsMap.computeIfAbsent(configId, k -> new ArrayList()).add(targetBill);
                continue;
            }
            StringBuilder configInfo = new StringBuilder();
            for (Long configId : agreeConfigIds) {
                DynamicObject agreeConfig = (DynamicObject)configs.get(configId);
                configInfo.append(agreeConfig.getString("name")).append(",");
            }
            errInfo.append(ResManager.loadKDString((String)"\u5355\u636e[{0}]\u643a\u5e26\u4e0a\u6e38\u5355\u636e\u7684\u5e8f\u5217\u53f7\u5931\u8d25\uff0c\u540c\u65f6\u5339\u914d\u5230\u591a\u6761\u5e8f\u5217\u53f7\u643a\u5e26\u914d\u7f6e\uff08{1}\uff09\uff0c\u8bf7\u5220\u9664\u6216\u7981\u7528\u591a\u4f59\u7684\u914d\u7f6e\u3002", (String)"SNCarryingConfigHelper_1", (String)"scmc-sbs-form", (Object[])new Object[]{targetBill.getString("billno"), configInfo.substring(0, configInfo.length() - 1)})).append("\n");
            throw new KDBizException(errInfo.toString());
        }
        DataSet upSNRelationDataSet = null;
        if (!allCarryBills.isEmpty() && (snAllCarryRelationDataSet = BillSNRelationHelper.getUpSNRelationDataSet(parseBillEntryBySerailNumber = InvBillCommonHelper.parseBillEntryBySerailNumber(Arrays.asList(targetBills), mapper), billType)) != null && snAllCarryRelationDataSet.hasNext()) {
            upSNRelationDataSet = snAllCarryRelationDataSet;
        }
        if (!conditionCarryBillsMap.isEmpty()) {
            for (Map.Entry obj : conditionCarryBillsMap.entrySet()) {
                DynamicObject config;
                Long configId = (Long)obj.getKey();
                List snCarryTargetBills = (List)obj.getValue();
                DataSet conditionBillSNRelationDataSet = BillSNRelationHelper.getUpSNRelationFilterDataSet(snCarryTargetBills, mapper, billType, config = (DynamicObject)configs.get(configId));
                if (conditionBillSNRelationDataSet == null || !conditionBillSNRelationDataSet.hasNext()) continue;
                if (upSNRelationDataSet == null) {
                    upSNRelationDataSet = conditionBillSNRelationDataSet;
                    continue;
                }
                upSNRelationDataSet = upSNRelationDataSet.union(conditionBillSNRelationDataSet);
            }
        }
        BillSNRelationHelper.saveSerialNumberDataSet(upSNRelationDataSet, billType);
    }

    private static boolean checkAgree(DynamicObject config, String billType, Long billId) {
        String preconditionFilter = config.getString("preconditionfilter_tag");
        if (StringUtils.isEmpty((String)preconditionFilter)) {
            return true;
        }
        QFilter preQFilter = SNCarryingConfigHelper.parseBillFilter(preconditionFilter, billType);
        if (preQFilter == null) {
            return true;
        }
        preQFilter.and("id", "=", (Object)billId);
        DynamicObject bill = QueryServiceHelper.queryOne((String)billType, (String)"id", (QFilter[])new QFilter[]{preQFilter});
        return bill != null;
    }

    private static String getSourceType(DynamicObject targetBill, String billType, String billEntryKey) {
        DynamicObjectCollection dynamicObjectCollection = targetBill.getDynamicObjectCollection(billEntryKey);
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            return null;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("botp_track_only_dirt_link", "true");
        List rows = BFTrackerServiceHelper.loadSourceRowIds((String)billType, (String)billEntryKey, (Long[])new Long[]{(Long)targetBill.getPkValue()}, (Long[])new Long[]{(Long)((DynamicObject)dynamicObjectCollection.get(0)).getPkValue()}, (OperateOption)option);
        if (rows.isEmpty()) {
            return null;
        }
        BFRow row = (BFRow)rows.get(0);
        BFRowId sId = row.getSId();
        return ConvertMetaServiceHelper.loadTableDefine((Long)sId.getMainTableId()).getEntityKey();
    }

    public static QFilter parseBillFilter(String jsonCondition, String billType) {
        if (jsonCondition == null || jsonCondition.isEmpty() || billType == null) {
            return null;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billType), condition);
        fb.buildFilter();
        return fb.getQFilter();
    }
}

