/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.sn.biz;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;
import kd.scmc.sbs.business.sn.mainfile.SNMainFileStatusCalHelper;
import kd.scmc.sbs.business.sn.relation.BillSNRelationHelper;
import kd.scmc.sbs.common.model.sn.InvCounterEntity;

public class SerialNumberOldOperator {
    private String billtype;
    private String entrytype;
    private String entrypath;
    private Set<Long> billIds;
    private Map<Long, DynamicObject> billentriesMap;
    private String materialmastercol;
    private String operate;
    private Map<String, Object> opeAttrMap;

    public SerialNumberOldOperator(String billtype, String entrytype, String entrypath, Set<Long> billIds, Map<Long, DynamicObject> billentriesMap, String materialmastercol, String operate, Map<String, Object> opeAttrMap) {
        this.billtype = billtype;
        this.entrytype = entrytype;
        this.entrypath = entrypath;
        this.billIds = billIds;
        this.billentriesMap = billentriesMap;
        this.materialmastercol = materialmastercol;
        this.operate = operate;
        this.opeAttrMap = opeAttrMap;
    }

    public void handleOldmovetrack() {
        if (QueryServiceHelper.exists((String)"bd_snmovetrack", (QFilter[])new QFilter("billid", "in", this.billIds).and("snmainfile", "!=", (Object)0).toArray())) {
            String snmainfUpdateSql = null;
            ArrayList<Object[]> snmainfUpdateParams = new ArrayList<Object[]>(1000);
            InvCounterEntity invCounter = null;
            SNMainFileStatusCalHelper statusCalHelper = new SNMainFileStatusCalHelper();
            ArrayList<Long> sntrackDeleteIds = new ArrayList<Long>(1000);
            ArrayList<Long> sntrackUpdateIds = new ArrayList<Long>(1000);
            switch (this.operate) {
                case "2": {
                    invCounter = new InvCounterEntity(0, 0, 0, 0);
                    snmainfUpdateSql = "update t_bd_snmainfile set fsnstatus = ?,foccupybillid = ?,foccupybillentryid = ?,foccupybilltype = ?,foccupybillentrytype = ? where fid = ?";
                    break;
                }
                case "3": {
                    invCounter = SNBillConfigHelper.getInvCounterEntity(this.opeAttrMap);
                    snmainfUpdateSql = "update t_bd_snmainfile set fsnstatus = ?,foccupybillid = ?,foccupybillentryid = ?,foccupybilltype = ?,foccupybillentrytype = ?,fincreaseinvcounter = ?, fsubstractinvcounter = ?, ftraincreaseinvcounter = ?, ftrasubstractinvcounter = ? where fid = ?";
                    break;
                }
                case "4": {
                    invCounter = SNBillConfigHelper.getNegInvCounterEntity(this.opeAttrMap);
                    snmainfUpdateSql = "update t_bd_snmainfile set fsnstatus = ?,foccupybillid = ?,foccupybillentryid = ?,foccupybilltype = ?,foccupybillentrytype = ?,fincreaseinvcounter = ?, fsubstractinvcounter = ?, ftraincreaseinvcounter = ?, ftrasubstractinvcounter = ? where fid = ?";
                    break;
                }
                default: {
                    return;
                }
            }
            HashSet<String> hasHandleSNBill = new HashSet<String>(1000);
            try (DataSet serialNumberDataSet = this.getBillSNDataSet();){
                for (Row row : serialNumberDataSet) {
                    Long mainfileid = row.getLong("mainfileid");
                    Long billid = row.getLong("billid");
                    Long trackid = row.getLong("trackid");
                    String mainfileid_billid = "" + mainfileid + '.' + billid;
                    if (!hasHandleSNBill.contains(mainfileid_billid)) {
                        Object[] snmainfUpdateParam;
                        String sbInvFlu = row.getString("sbillinvfluctuation");
                        Integer incInvCounter = row.getInteger("increaseinvcounter") + invCounter.getInvIncrease();
                        Integer subInvCounter = row.getInteger("substractinvcounter") + invCounter.getInvSubstract();
                        Integer incTransCounter = row.getInteger("traincreaseinvcounter") + invCounter.getTransInvIncrease();
                        Integer subTransCounter = row.getInteger("trasubstractinvcounter") + invCounter.getTransInvSubstract();
                        String snstatus = statusCalHelper.calMainFileStatusWithCache(sbInvFlu, incInvCounter, subInvCounter, incTransCounter, subTransCounter);
                        if ("2".equals(this.operate)) {
                            snmainfUpdateParam = new Object[]{snstatus, 0L, 0L, " ", " ", mainfileid};
                            snmainfUpdateParams.add(snmainfUpdateParam);
                        } else {
                            snmainfUpdateParam = new Object[]{snstatus, 0L, 0L, " ", " ", incInvCounter, subInvCounter, incTransCounter, subTransCounter, mainfileid};
                            snmainfUpdateParams.add(snmainfUpdateParam);
                        }
                        hasHandleSNBill.add(mainfileid_billid);
                    }
                    if ("3".equals(this.operate)) {
                        sntrackUpdateIds.add(trackid);
                    } else {
                        sntrackDeleteIds.add(trackid);
                    }
                    if (snmainfUpdateParams.size() != 1000) continue;
                    SerialNumberOldOperator.executeBatchSql(snmainfUpdateParams, snmainfUpdateSql);
                }
                if (snmainfUpdateParams.size() > 0) {
                    SerialNumberOldOperator.executeBatchSql(snmainfUpdateParams, snmainfUpdateSql);
                }
                if (sntrackDeleteIds.size() > 0) {
                    DeleteServiceHelper.delete((String)"bd_snmovetrack_rel", (QFilter[])new QFilter("trackid", "in", sntrackDeleteIds).toArray());
                    DeleteServiceHelper.delete((String)"bd_snmovetrack", (QFilter[])new QFilter("id", "in", sntrackDeleteIds).toArray());
                }
                if (sntrackUpdateIds.size() > 0) {
                    SqlBuilder sntrackUpdateSqlBuilder = new SqlBuilder();
                    sntrackUpdateSqlBuilder.append("update t_bd_snmovetrack set fbillstatus = ?,fauditdate = ? where fsnmainfileid <> 0 and ", new Object[]{"C", new Date()}).appendIn("fid", sntrackUpdateIds.toArray());
                    DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)sntrackUpdateSqlBuilder);
                }
            }
        }
    }

    private DataSet getBillSNDataSet() {
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("billentryid", (DataType)DataType.LongType), new Field("materialmasterid", (DataType)DataType.LongType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(billentryRowMeta);
        HashSet<Long> materialmasterids = new HashSet<Long>(this.billentriesMap.size());
        for (DynamicObject billentry : this.billentriesMap.values()) {
            Long billentryid = billentry.getLong(this.entrypath + ".id");
            Long materialmasterid = billentry.getLong(this.materialmastercol);
            materialmasterids.add(materialmasterid);
            billentryDsBuilder.append(new Object[]{billentryid, materialmasterid});
        }
        DataSet billentryDataSet = billentryDsBuilder.build();
        DataSet billSnRelationDataSet = BillSNRelationHelper.getBillEntrySNRelationDataSet(this.billIds, this.billtype, this.entrytype, null);
        DataSet billSnRelWithMatDataSet = billSnRelationDataSet.join(billentryDataSet).on("entryid", "billentryid").select(new String[]{"billtype", "billid", "snnumber", "materialmasterid"}).finish();
        String snMainFileProps = "id as mainfileid,number as mfsnnumber, material as mfmaterialid,sbillinvfluctuation,increaseinvcounter,substractinvcounter,traincreaseinvcounter,trasubstractinvcounter";
        DataSet snMainFileDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_snmainfile", (String)snMainFileProps, (QFilter[])new QFilter("material", "in", materialmasterids).and("masterfiletype", "=", (Object)1401417099242528768L).toArray(), (String)"");
        billSnRelWithMatDataSet = billSnRelWithMatDataSet.join(snMainFileDataSet).on("snnumber", "mfsnnumber").on("materialmasterid", "mfmaterialid").select(billSnRelWithMatDataSet.getRowMeta().getFieldNames(), snMainFileDataSet.getRowMeta().getFieldNames()).finish().filter("snnumber is not null");
        SqlBuilder snmoveTrackSqlBuilder = new SqlBuilder();
        snmoveTrackSqlBuilder.append("select t.fid as trackid,t.fsnmainfileid as trk_mainfile,t.fbillid as trk_billid from t_bd_snmovetrack t where ", new Object[0]).appendIn("t.fbillid", this.billIds.toArray()).append(" and t.fsnmainfileid <> 0", new Object[0]);
        DataSet snmoveTrackDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)snmoveTrackSqlBuilder);
        billSnRelWithMatDataSet = billSnRelWithMatDataSet.join(snmoveTrackDataSet).on("mainfileid", "trk_mainfile").on("billid", "trk_billid").select(billSnRelWithMatDataSet.getRowMeta().getFieldNames(), new String[]{"trackid"}).finish();
        return billSnRelWithMatDataSet;
    }

    public static void clearOldmovetrack(Set<Long> billIds) {
        List oldTrackIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_snmovetrack", (QFilter[])new QFilter("billid", "in", billIds).and("snmainfile", "!=", (Object)0).toArray(), null, (int)-1);
        if (oldTrackIds.size() > 0) {
            DeleteServiceHelper.delete((String)"bd_snmovetrack_rel", (QFilter[])new QFilter("trackid", "in", (Object)oldTrackIds).toArray());
            DeleteServiceHelper.delete((String)"bd_snmovetrack", (QFilter[])new QFilter("id", "in", (Object)oldTrackIds).toArray());
        }
    }

    private static void executeBatchSql(List<Object[]> params, String sql) {
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
        params.clear();
    }
}

