/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.sn.relation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scmc.sbs.business.sn.InvBillCommonHelper;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;
import kd.scmc.sbs.business.sn.SNCarryingConfigHelper;
import kd.scmc.sbs.business.sn.billFiledMapper.BillFieldMapper;
import kd.scmc.sbs.business.sn.billFiledMapper.BillFieldMapperFactory;
import kd.scmc.sbs.business.sn.biz.SerialNumberDeletor;
import kd.scmc.sbs.common.util.IDGenerator;

public class BillSNRelationHelper {
    private static final String SELECTFIELD = "billtype, billid, entrykey, entryid, entryentity.seq as seq,entryentity.snnumber as snnumber, entryentity.snmainfileid as relmainfileid,entryentity.remark as remark,entryentity.invorg as sninvorg,entryentity.id as snrelentryid";
    private static final String SELECTFIELD_INCLUDESRC = "billtype, billid, entrykey, entryid, srcbilltype, srcbillid, srcentrykey, srcentryid, srcisreq, entryentity.seq as seq,entryentity.snnumber as snnumber, entryentity.snmainfileid as relmainfileid,entryentity.remark as remark,entryentity.invorg as sninvorg,entryentity.id as snrelentryid,entryentity.handlestatus as handlestatus";
    private static String DIM_PRE = "dim";

    public static Map<Object, DynamicObject> getSNRelationDynamicObject(String billType, Collection<Object> entryId) {
        QFilter filter = new QFilter("entryid", "in", entryId).and("billtype", "=", (Object)billType);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"sbs_billsnrelation", (String)"billtype,billid,entrykey,entryid,entryentity.snnumber,entryentity.snmainfileid", (QFilter[])filter.toArray());
        HashMap<Object, DynamicObject> snRelationObjMap = new HashMap<Object, DynamicObject>(objects.length);
        for (DynamicObject object : objects) {
            DynamicObjectCollection entryenties = object.getDynamicObjectCollection("entryentity");
            if (entryenties == null || entryenties.size() <= 0) continue;
            snRelationObjMap.put(object.get("entryid"), object);
        }
        return snRelationObjMap;
    }

    public static Map<Object, DynamicObject> getSNRelationDynamicObject(DynamicObject[] bills) {
        DynamicObject[] objects;
        String billType = bills[0].getDynamicObjectType().getName();
        HashSet<Object> billIds = new HashSet<Object>(bills.length);
        for (DynamicObject bill : bills) {
            billIds.add(bill.get("id"));
        }
        QFilter filter = new QFilter("billid", "in", billIds).and("billtype", "=", (Object)billType);
        HashMap<Object, DynamicObject> snRelationObjMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"sbs_billsnrelation", (String)"billtype,billid,entrykey,entryid,entryentity.snnumber,entryentity.snmainfileid", (QFilter[])filter.toArray())) {
            DynamicObjectCollection entryenties = object.getDynamicObjectCollection("entryentity");
            if (entryenties == null || entryenties.size() <= 0) continue;
            snRelationObjMap.put(object.get("entryid"), object);
        }
        return snRelationObjMap;
    }

    public static Map<Object, DynamicObject> getUpSNRelationDynamicObject(DynamicObject[] bills) {
        DynamicObject[] sourceSNRelations;
        HashMap<Object, DynamicObject> upSnRelationObjMap = new HashMap<Object, DynamicObject>();
        if (bills == null || bills.length == 0) {
            return upSnRelationObjMap;
        }
        String targettype = bills[0].getDynamicObjectType().getName();
        BillFieldMapper targetBillTypeMapper = BillFieldMapperFactory.getBillFieldMapper(targettype);
        String entrylkKey = targetBillTypeMapper.getBillEntryLkKey();
        if (entrylkKey == null) {
            return upSnRelationObjMap;
        }
        HashMap<Object, Object> sourceToTargetID = new HashMap<Object, Object>();
        HashMap<Object, Object> targetEntryIdToTargetBillId = new HashMap<Object, Object>();
        for (DynamicObject bill : bills) {
            Object targetBillId = bill.getPkValue();
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(targetBillTypeMapper.getBillEntryKey());
            for (DynamicObject entry : entries) {
                Object entryID = entry.getPkValue();
                DynamicObjectCollection linkRows = (DynamicObjectCollection)entry.get(entrylkKey);
                if (linkRows == null || linkRows.size() != 1) continue;
                Object sourceEntryID = ((DynamicObject)linkRows.get(0)).get(targetBillTypeMapper.getBillEntryLkSourceIDKey());
                sourceToTargetID.put(sourceEntryID, entryID);
                targetEntryIdToTargetBillId.put(entryID, targetBillId);
            }
        }
        if (sourceToTargetID.size() == 0) {
            return upSnRelationObjMap;
        }
        for (DynamicObject sourceRelation : sourceSNRelations = BusinessDataServiceHelper.load((String)"sbs_billsnrelation", (String)"entryid,billtype,billid,entrykey,entryentity.snnumber,entryentity.remark,entryentity.snmainfileid", (QFilter[])new QFilter("entryid", "in", sourceToTargetID.keySet()).toArray())) {
            DynamicObjectCollection entryenties = sourceRelation.getDynamicObjectCollection("entryentity");
            if (entryenties == null || entryenties.size() <= 0) continue;
            DynamicObject targetRelation = (DynamicObject)OrmUtils.clone((IDataEntityBase)sourceRelation, (boolean)false, (boolean)true);
            Object sourceEntryID = sourceRelation.get("entryid");
            Object targetEntryID = sourceToTargetID.get(sourceEntryID);
            targetRelation.set("billtype", (Object)targettype);
            targetRelation.set("billid", targetEntryIdToTargetBillId.get(targetEntryID));
            targetRelation.set("entrykey", (Object)"billentry");
            targetRelation.set("entryid", targetEntryID);
            upSnRelationObjMap.put(targetRelation.get("entryid"), targetRelation);
        }
        return upSnRelationObjMap;
    }

    public static Map<Object, DynamicObject> getSNRelationDynamicObjectWithUp(DynamicObject[] bills) {
        Map<Object, DynamicObject> snRelationMap = BillSNRelationHelper.getSNRelationDynamicObject(bills);
        if (snRelationMap == null || snRelationMap.size() == 0) {
            snRelationMap = BillSNRelationHelper.getUpSNRelationDynamicObject(bills);
        }
        return snRelationMap;
    }

    public static DataSet getBillSNRelationDataSet(Collection<Long> billIds, String billtype) {
        QFilter filter = new QFilter("billid", "in", billIds).and("billtype", "=", (Object)billtype);
        DataSet billSnRelationDataSet = QueryServiceHelper.queryDataSet((String)BillSNRelationHelper.class.getName(), (String)"sbs_billsnrelation", (String)SELECTFIELD, (QFilter[])filter.toArray(), (String)"billid asc");
        return billSnRelationDataSet;
    }

    public static DataSet getBillSNRelationDataSet(DynamicObject[] bills) {
        String billtype = bills[0].getDynamicObjectType().getName();
        ArrayList<Long> billIds = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            billIds.add(bill.getLong("id"));
        }
        return BillSNRelationHelper.getBillSNRelationDataSet(billIds, billtype);
    }

    public static DataSet getUpSNRelationDataSet(Map<String, List<DynamicObject>> entries, String billtype) {
        BillFieldMapper targetBillTypeMapper = BillFieldMapperFactory.getBillFieldMapper(billtype);
        String entrylkKey = targetBillTypeMapper.getBillEntryLkKey();
        if (entrylkKey == null) {
            return null;
        }
        RowMeta sourceMeta = new RowMeta(new Field[]{new Field("tbilltype", (DataType)DataType.StringType), new Field("tbillid", (DataType)DataType.LongType), new Field("tentrykey", (DataType)DataType.StringType), new Field("tentryid", (DataType)DataType.LongType), new Field("sentryid", (DataType)DataType.LongType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)BillSNRelationHelper.class.getName()).createDataSetBuilder(sourceMeta);
        HashMap<Object, Object> sourceToTargetID = new HashMap<Object, Object>(entries.size() * 20);
        for (Map.Entry<String, List<DynamicObject>> billentries : entries.entrySet()) {
            String[] key = billentries.getKey().split("\\.");
            Long targetBillId = Long.valueOf(key[0]);
            String entrykey = key[1];
            for (DynamicObject dynamicObject : billentries.getValue()) {
                Object entryID = dynamicObject.getPkValue();
                DynamicObjectCollection linkRows = (DynamicObjectCollection)dynamicObject.get(entrylkKey);
                if (linkRows == null || linkRows.size() != 1) continue;
                Object sourceEntryID = ((DynamicObject)linkRows.get(0)).get(targetBillTypeMapper.getBillEntryLkSourceIDKey());
                if ("sfc_processreportbill".equals(billtype)) {
                    sourceEntryID = dynamicObject.getDynamicObject("manufactureentryid").getPkValue();
                }
                sourceToTargetID.put(sourceEntryID, entryID);
                dataSetBuilder.append(new Object[]{billtype, targetBillId, entrykey, entryID, sourceEntryID});
            }
        }
        DataSet targetBillMeta = dataSetBuilder.build();
        QFilter filter = new QFilter("entryid", "in", sourceToTargetID.keySet());
        DataSet billSnRelationDataSet = QueryServiceHelper.queryDataSet((String)BillSNRelationHelper.class.getName(), (String)"sbs_billsnrelation", (String)SELECTFIELD, (QFilter[])filter.toArray(), (String)"billid asc");
        billSnRelationDataSet = billSnRelationDataSet.leftJoin(targetBillMeta).on("entryid", "sentryid").select(new String[]{"seq", "snnumber", "relmainfileid", "sninvorg"}, new String[]{"tbilltype as billtype", "tbillid as billid", "tentrykey as entrykey", "tentryid as entryid", "billtype as srcbilltype", "billid as srcbillid", "entrykey as srcentrykey", "entryid as srcentryid"}).finish().addField("true", "isNeedSave").filter("snnumber is not null");
        String srcbilltype = null;
        HashSet<Long> srcbillids = new HashSet<Long>(entries.size());
        Throwable throwable = null;
        try (DataSet srcbillsDataSet = QueryServiceHelper.queryDataSet((String)BillSNRelationHelper.class.getName(), (String)"sbs_billsnrelation", (String)"billtype,billid", (QFilter[])filter.toArray(), (String)"");){
            for (Object row : srcbillsDataSet) {
                if (srcbilltype == null) {
                    srcbilltype = row.getString("billtype");
                }
                srcbillids.add(row.getLong("billid"));
            }
        }
        catch (Throwable entryID) {
            Throwable throwable2 = entryID;
            throw entryID;
        }
        RowMeta reqbillMeta = new RowMeta(new Field[]{new Field("reqbillid", (DataType)DataType.LongType), new Field("srcisreq", (DataType)DataType.BooleanType), new Field("occupymove", (DataType)DataType.BooleanType), new Field("invflu", (DataType)DataType.StringType)});
        DataSetBuilder dataSetBuilder2 = Algo.create((String)BillSNRelationHelper.class.getName()).createDataSetBuilder(reqbillMeta);
        Collection<DynamicObject> cfgs = SNBillConfigHelper.getSNBillConfig(srcbilltype);
        for (DynamicObject cfg : cfgs) {
            if (srcbillids.isEmpty()) break;
            QFilter reqfilter = new QFilter("id", "in", srcbillids);
            QFilter reqcfgFilter = SNBillConfigHelper.parseBillFilter(cfg.getString("billfilter"), srcbilltype);
            if (reqcfgFilter != null) {
                reqfilter.and(reqcfgFilter);
            }
            Boolean snReqBill = cfg.getBoolean("snreqbill");
            Boolean ocCupyMove = cfg.getBoolean("occupymove");
            String invFlu = cfg.getString("invflu");
            DynamicObjectCollection reqbills = QueryServiceHelper.query((String)srcbilltype, (String)"id", (QFilter[])reqfilter.toArray());
            for (DynamicObject reqbill : reqbills) {
                Long reqbillid = reqbill.getLong("id");
                dataSetBuilder2.append(new Object[]{reqbillid, snReqBill, ocCupyMove, invFlu});
                srcbillids.remove(reqbillid);
            }
        }
        DataSet reqbillDataSet = dataSetBuilder2.build();
        billSnRelationDataSet = billSnRelationDataSet.leftJoin(reqbillDataSet).on("srcbillid", "reqbillid").select(billSnRelationDataSet.getRowMeta().getFieldNames(), reqbillDataSet.getRowMeta().getFieldNames()).finish();
        return billSnRelationDataSet;
    }

    public static DataSet getUpSNRelationFilterDataSet(List<DynamicObject> targetBills, BillFieldMapper mapper, String billtype, DynamicObject config) {
        Object snUnqctrl;
        Object split22;
        BillFieldMapper targetBillTypeMapper = BillFieldMapperFactory.getBillFieldMapper(billtype);
        String entrylkKey = targetBillTypeMapper.getBillEntryLkKey();
        if (entrylkKey == null) {
            return null;
        }
        Map<String, Object> configMap = BillSNRelationHelper.carryingConfigHandle(config);
        RowMeta sourceMeta = new RowMeta(new Field[]{new Field("tbilltype", (DataType)DataType.StringType), new Field("tbillid", (DataType)DataType.LongType), new Field("tentrykey", (DataType)DataType.StringType), new Field("tentryid", (DataType)DataType.LongType), new Field("sentryid", (DataType)DataType.LongType), new Field("materialid", (DataType)DataType.LongType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)BillSNRelationHelper.class.getName()).createDataSetBuilder(sourceMeta);
        Map<String, List<DynamicObject>> parseBillEntryBySerailNumber = InvBillCommonHelper.parseBillEntryBySerailNumber(targetBills, mapper);
        HashMap<Object, Object> sourceToTargetID = new HashMap<Object, Object>(targetBills.size() * 20);
        for (Map.Entry<String, List<DynamicObject>> billentries : parseBillEntryBySerailNumber.entrySet()) {
            String[] key = billentries.getKey().split("\\.");
            Long targetBillId = Long.valueOf(key[0]);
            String entrykey = key[1];
            String materialKey = key[2];
            for (DynamicObject dynamicObject : billentries.getValue()) {
                Object entryID = dynamicObject.getPkValue();
                DynamicObjectCollection linkRows = (DynamicObjectCollection)dynamicObject.get(entrylkKey);
                if (linkRows == null || linkRows.size() != 1) continue;
                Object sourceEntryID = ((DynamicObject)linkRows.get(0)).get(targetBillTypeMapper.getBillEntryLkSourceIDKey());
                if ("sfc_processreportbill".equals(billtype)) {
                    sourceEntryID = dynamicObject.getDynamicObject("manufactureentryid").getPkValue();
                }
                Long material = dynamicObject.getDynamicObject(materialKey).getLong("masterid.masterid");
                sourceToTargetID.put(sourceEntryID, entryID);
                dataSetBuilder.append(new Object[]{billtype, targetBillId, entrykey, entryID, sourceEntryID, material});
            }
        }
        DataSet targetBillMeta = dataSetBuilder.build();
        QFilter filter = new QFilter("entryid", "in", sourceToTargetID.keySet());
        DataSet billSnRelationDataSet = QueryServiceHelper.queryDataSet((String)BillSNRelationHelper.class.getName(), (String)"sbs_billsnrelation", (String)SELECTFIELD, (QFilter[])filter.toArray(), (String)"billid asc");
        DataSet billSnRelationDataSetCopy = billSnRelationDataSet.copy();
        HashMap<Long, String> srcInfoMap = new HashMap<Long, String>();
        HashMap<Long, Set> srcBillEnteyIdMap = new HashMap<Long, Set>();
        ArrayList<String> snNumber = new ArrayList<String>();
        for (Row row : billSnRelationDataSetCopy) {
            snNumber.add(row.getString("snnumber"));
            Long srcBillId = row.getLong("billid");
            if (!srcInfoMap.containsKey(srcBillId)) {
                srcInfoMap.put(srcBillId, row.getString("billtype") + "," + row.getString("entrykey"));
            }
            srcBillEnteyIdMap.computeIfAbsent(srcBillId, i -> new HashSet()).add(row.getLong("entryid"));
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("srcentryid", (DataType)DataType.LongType), new Field("srcinvorg", (DataType)DataType.LongType)});
        DataSetBuilder srcInvOrgBuilder = Algo.create((String)BillSNRelationHelper.class.getName()).createDataSetBuilder(rowMeta);
        if (srcBillEnteyIdMap != null && !srcBillEnteyIdMap.isEmpty()) {
            HashMap<Long, String> srcInvOrgCols = new HashMap<Long, String>();
            HashMap<Long, Long> srcInvOrgs = new HashMap<Long, Long>();
            for (Map.Entry entry : srcInfoMap.entrySet()) {
                Long srcBillId = (Long)entry.getKey();
                String types = (String)entry.getValue();
                if (StringUtils.isEmpty((CharSequence)types) || ((String[])(split22 = types.split(","))).length != 2) continue;
                Long invOrgId = (Long)srcInvOrgs.get(srcBillId);
                if (invOrgId == null) {
                    DynamicObject srcBillInfo;
                    Object srcInvOrgCol = (String)srcInvOrgCols.get(srcBillId);
                    if (StringUtils.isEmpty((CharSequence)srcInvOrgCol)) {
                        String invOrgSrcCol;
                        DynamicObject srcSnBillConfig = SNBillConfigHelper.getSNBillConfigByBillId(split22[0], split22[1], srcBillId);
                        if (srcSnBillConfig == null || StringUtils.isEmpty((CharSequence)(invOrgSrcCol = SNBillConfigHelper.getInvOrgSrcCol(srcSnBillConfig)))) continue;
                        srcInvOrgCols.put(srcBillId, invOrgSrcCol);
                        srcInvOrgCol = invOrgSrcCol;
                    }
                    if ((srcBillInfo = QueryServiceHelper.queryOne((String)split22[0], (String)srcInvOrgCol, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcBillId)})) == null || (invOrgId = Long.valueOf(srcBillInfo.getLong((String)srcInvOrgCol))) == null) continue;
                    srcInvOrgs.put(srcBillId, invOrgId);
                }
                if (!srcBillEnteyIdMap.containsKey(srcBillId)) continue;
                for (Long srcEntryId : (Set)srcBillEnteyIdMap.get(srcBillId)) {
                    srcInvOrgBuilder.append(new Object[]{srcEntryId, invOrgId});
                }
            }
        }
        DataSet srcInvOrgDataSet = srcInvOrgBuilder.build();
        billSnRelationDataSet = billSnRelationDataSet.leftJoin(srcInvOrgDataSet).on("entryid", "srcentryid").select(new String[]{"billtype", "billid", "entrykey", "entryid", "seq", "snnumber", "relmainfileid", "remark", "snrelentryid"}, new String[]{"case when sninvorg is null or sninvorg = 0 then srcinvorg else sninvorg end sninvorg"}).finish();
        billSnRelationDataSet = billSnRelationDataSet.leftJoin(targetBillMeta).on("entryid", "sentryid").select(new String[]{"seq", "snnumber", "relmainfileid", "sninvorg"}, new String[]{"tbilltype as billtype", "tbillid as billid", "tentrykey as entrykey", "tentryid as entryid", "billtype as srcbilltype", "billid as srcbillid", "entrykey as srcentrykey", "entryid as srcentryid", "materialid"}).finish().addField("true", "isNeedSave").filter("snnumber is not null and materialid is not null");
        QFilter mainFileFilter = (QFilter)configMap.get("snrangefilter_tag");
        if (mainFileFilter != null) {
            QFilter snFilter = BillSNRelationHelper.getSNMainFileFilter(targetBills, mapper, billtype, snNumber);
            if (snFilter != null) {
                mainFileFilter = mainFileFilter.and(snFilter);
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)BillSNRelationHelper.class.getName(), (String)"bd_snmainfile", (String)"id mainfileid,invorg,material,number", (QFilter[])new QFilter[]{mainFileFilter}, (String)"");
            JoinDataSet billSnRelationJoinDataSet = billSnRelationDataSet.leftJoin(dataSet).on("snnumber", "number").on("materialid", "material");
            snUnqctrl = SNBillConfigHelper.getSnUnqctrl();
            split22 = snUnqctrl.iterator();
            while (split22.hasNext()) {
                String unqctrl = (String)split22.next();
                if (!unqctrl.equals("1")) continue;
                billSnRelationJoinDataSet = billSnRelationJoinDataSet.on("sninvorg", "invorg");
            }
            billSnRelationDataSet = billSnRelationJoinDataSet.select(billSnRelationDataSet.getRowMeta().getFieldNames(), new String[]{"number", "material"}).finish().filter(" number is not null");
        }
        String srcbilltype = null;
        HashSet<Long> hashSet = new HashSet<Long>(targetBills.size());
        DataSet srcbillsDataSet = QueryServiceHelper.queryDataSet((String)BillSNRelationHelper.class.getName(), (String)"sbs_billsnrelation", (String)"billtype,billid", (QFilter[])filter.toArray(), (String)"");
        snUnqctrl = null;
        try {
            for (Object row : srcbillsDataSet) {
                if (srcbilltype == null) {
                    srcbilltype = row.getString("billtype");
                }
                hashSet.add(row.getLong("billid"));
            }
        }
        catch (Throwable split22) {
            snUnqctrl = split22;
            throw split22;
        }
        finally {
            if (srcbillsDataSet != null) {
                if (snUnqctrl != null) {
                    try {
                        srcbillsDataSet.close();
                    }
                    catch (Throwable split22) {
                        ((Throwable)snUnqctrl).addSuppressed(split22);
                    }
                } else {
                    srcbillsDataSet.close();
                }
            }
        }
        RowMeta reqbillMeta = new RowMeta(new Field[]{new Field("reqbillid", (DataType)DataType.LongType), new Field("srcisreq", (DataType)DataType.BooleanType), new Field("occupymove", (DataType)DataType.BooleanType), new Field("invflu", (DataType)DataType.StringType)});
        DataSetBuilder reqbillDSBuilder = Algo.create((String)BillSNRelationHelper.class.getName()).createDataSetBuilder(reqbillMeta);
        Collection<DynamicObject> cfgs = SNBillConfigHelper.getSNBillConfig(srcbilltype);
        for (DynamicObject cfg : cfgs) {
            if (hashSet.isEmpty()) break;
            QFilter reqfilter = new QFilter("id", "in", hashSet);
            QFilter reqcfgFilter = SNBillConfigHelper.parseBillFilter(cfg.getString("billfilter"), srcbilltype);
            if (reqcfgFilter != null) {
                reqfilter.and(reqcfgFilter);
            }
            Boolean snReqBill = cfg.getBoolean("snreqbill");
            Boolean ocCupyMove = cfg.getBoolean("occupymove");
            String invFlu = cfg.getString("invflu");
            DynamicObjectCollection reqbills = QueryServiceHelper.query((String)srcbilltype, (String)"id", (QFilter[])reqfilter.toArray());
            for (DynamicObject reqbill : reqbills) {
                Long reqbillid = reqbill.getLong("id");
                reqbillDSBuilder.append(new Object[]{reqbillid, snReqBill, ocCupyMove, invFlu});
                hashSet.remove(reqbillid);
            }
        }
        DataSet reqbillDataSet = reqbillDSBuilder.build();
        billSnRelationDataSet = billSnRelationDataSet.leftJoin(reqbillDataSet).on("srcbillid", "reqbillid").select(billSnRelationDataSet.getRowMeta().getFieldNames(), reqbillDataSet.getRowMeta().getFieldNames()).finish();
        return billSnRelationDataSet;
    }

    private static QFilter getSNMainFileFilter(List<DynamicObject> targetBills, BillFieldMapper mapper, String billType, List<String> snNumber) {
        QFilter snFilter = null;
        String billEntryKey = mapper.getBillEntryKey();
        String materialKey = mapper.getMaterialKey();
        for (DynamicObject targetBill : targetBills) {
            DynamicObjectCollection billEntries = targetBill.getDynamicObjectCollection(billEntryKey);
            HashSet<Long> materialIds = new HashSet<Long>(billEntries.size());
            for (DynamicObject billEntry : billEntries) {
                Long materialId;
                DynamicObject material = billEntry.getDynamicObject(materialKey);
                if (material == null || (materialId = Long.valueOf(material.getLong("masterid.masterid"))) == null) continue;
                materialIds.add(materialId);
            }
            if (materialIds.isEmpty()) continue;
            QFilter filter = new QFilter("material", "in", materialIds);
            snFilter = snFilter == null ? filter : snFilter.or(filter);
            snFilter.and("number", "in", (Object)snNumber.toArray());
        }
        return snFilter;
    }

    private static Map<String, Object> carryingConfigHandle(DynamicObject config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sourceBillType = config.getString("sourcebilltype");
        result.put("sourcebilltype", sourceBillType);
        String targetBillType = config.getString("targetbilltype");
        result.put("targetbilltype", targetBillType);
        String preconditionStr = config.getString("preconditionfilter_tag");
        QFilter preQFilter = SNCarryingConfigHelper.parseBillFilter(preconditionStr, targetBillType);
        result.put("precondition", preQFilter);
        String mainFileStr = config.getString("snrangefilter_tag");
        QFilter mainFileFilter = SNCarryingConfigHelper.parseBillFilter(mainFileStr, "bd_snmainfile");
        result.put("snrangefilter_tag", mainFileFilter);
        return result;
    }

    public static void generateSNByBotpPush(DynamicObject[] targetbills) {
        String billtype = targetbills[0].getDataEntityType().getName();
        BillFieldMapper mapper = BillFieldMapperFactory.getBillFieldMapper(billtype);
        Map<String, List<DynamicObject>> parseBillEntryBySerailNumber = InvBillCommonHelper.parseBillEntryBySerailNumber(Arrays.asList(targetbills), mapper);
        DataSet upSNRelationDataSet = BillSNRelationHelper.getUpSNRelationDataSet(parseBillEntryBySerailNumber, billtype);
        BillSNRelationHelper.saveSerialNumberDataSet(upSNRelationDataSet, billtype);
    }

    public static void saveSerialNumberDataSet(DataSet sNRelationDataSet, String billtype) {
        if (sNRelationDataSet == null) {
            return;
        }
        int maxhandlesize = 1000;
        int headsize = sNRelationDataSet.copy().count("entryid", true);
        long[] headIds = DB.genLongIds((String)"T_SBS_BILLSQNRELATION", (int)headsize);
        HashMap<Long, Long> entryIdToId = new HashMap<Long, Long>(headsize);
        int headcount = 0;
        ArrayList<Object[]> headParam = new ArrayList<Object[]>(headcount);
        String insertHeadSql = "insert into T_SBS_BILLSQNRELATION (FID,FBILLTYPE,FENTRYKEY,FBILLID,FENTRYID,FSRCBILLTYPE,FSRCENTRYKEY,FSRCBILLID,FSRCENTRYID,FSRCISREQ,FSRCISOCCUPYMOVE,FSRCINVFLU)values(?,?,?,?,?,?,?,?,?,?,?,?)";
        int snnumbers = sNRelationDataSet.copy().count("snnumber", true);
        long[] snnumberIds = DB.genLongIds((String)"T_SBS_BILLSQNRELATION_E", (int)snnumbers);
        int snnumberCount = 0;
        String insertEntrySql = "insert into T_SBS_BILLSQNRELATION_E (FID,FENTRYID,FSEQ,FSNNUMBER,FSNMAINFILEID,FINVORG,FHANDLESTATUS)values(?,?,?,?,?,?,?)";
        IDGenerator idGenerator = new IDGenerator();
        DBRoute route = new DBRoute("im");
        ArrayList<Object[]> entryNumber = new ArrayList<Object[]>(maxhandlesize);
        while (sNRelationDataSet.hasNext()) {
            Row row = sNRelationDataSet.next();
            Long billid = row.getLong("billid");
            String entrykey = row.getString("entrykey");
            Long entryid = row.getLong("entryid");
            String srcbilltype = row.getString("srcbilltype");
            Long srcbillid = row.getLong("srcbillid");
            String srcentrykey = row.getString("srcentrykey");
            Long srcentryid = row.getLong("srcentryid");
            Long reqbillid = row.getLong("reqbillid");
            Boolean srcIsReq = row.getBoolean("srcisreq");
            Boolean ocCupyMove = row.getBoolean("occupymove");
            String invFlu = row.getString("invflu");
            Long id = (Long)entryIdToId.get(entryid);
            if (id == null) {
                if (headcount >= headIds.length) {
                    id = idGenerator.getGlobalId();
                } else {
                    id = headIds[headcount];
                    ++headcount;
                }
                entryIdToId.put(entryid, id);
                Object[] param = new Object[]{id, billtype, entrykey, billid, entryid, srcbilltype, srcentrykey, srcbillid, srcentryid, srcIsReq, ocCupyMove, invFlu};
                headParam.add(param);
            }
            Integer seq = row.getInteger("seq");
            String snnumber = row.getString("snnumber");
            Long mainFileId = row.getLong("relmainfileid");
            Long sninvorg = row.getLong("sninvorg");
            Long subid = null;
            if (snnumberCount >= snnumberIds.length) {
                subid = idGenerator.getGlobalId();
            } else {
                subid = snnumberIds[snnumberCount];
                ++snnumberCount;
            }
            Object[] entryparam = new Object[]{id, subid, seq, snnumber, mainFileId, sninvorg, "A"};
            entryNumber.add(entryparam);
            if (headParam.size() == maxhandlesize) {
                BillSNRelationHelper.executeSql(headParam, insertHeadSql, route);
            }
            if (entryNumber.size() != maxhandlesize) continue;
            BillSNRelationHelper.executeSql(entryNumber, insertEntrySql, route);
        }
        if (headParam.size() > 0) {
            BillSNRelationHelper.executeSql(headParam, insertHeadSql, route);
        }
        if (entryNumber.size() > 0) {
            BillSNRelationHelper.executeSql(entryNumber, insertEntrySql, route);
        }
    }

    private static void executeSql(List<Object[]> headParam, String insertHeadSql, DBRoute route) {
        DB.executeBatch((DBRoute)route, (String)insertHeadSql, headParam);
        headParam.clear();
    }

    public static void deleteRelationByBill(DynamicObject[] bills) {
        if (bills == null || bills.length == 0) {
            return;
        }
        String billType = bills[0].getDataEntityType().getName();
        ArrayList<Object> billIds = new ArrayList<Object>(bills.length);
        for (DynamicObject bill : bills) {
            Object id = bill.getPkValue();
            billIds.add(id);
        }
        BillSNRelationHelper.deleteRelationByBillIds(billType, billIds.toArray(new Object[billIds.size()]));
    }

    public static void deleteRelationByBillIds(String billType, Object[] ids) {
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (Object id : ids) {
            idsList.add(Long.parseLong(id.toString()));
        }
        QFilter filter = new QFilter("billtype", "=", (Object)billType).and("billid", "in", idsList);
        DeleteServiceHelper.delete((String)"sbs_billsnrelation", (QFilter[])filter.toArray());
    }

    public static void deleteSurplusRelation(String billType, Set<Object> billIds, Set<Object> keepEntryIds) {
        if (billIds == null || billIds.size() == 0) {
            return;
        }
        HashSet<Long> newbillIds = new HashSet<Long>(billIds.size());
        for (Object object : billIds) {
            newbillIds.add(Long.parseLong(object.toString()));
        }
        if (keepEntryIds == null || keepEntryIds.size() == 0) {
            BillSNRelationHelper.deleteRelationByBillIds(billType, billIds.toArray());
            if (TX.inTX()) {
                CommonParam param = new CommonParam();
                param.put((Object)"billtype", (Object)billType);
                param.put((Object)"newbillIds", newbillIds);
                param.put((Object)"flag", (Object)"1");
                BillSNRelationHelper.doRegisterDelTX(param);
            } else {
                SerialNumberDeletor.execDeleteByBills(billType, newbillIds);
            }
        } else {
            HashSet<Long> newkeepEntryIds = new HashSet<Long>(keepEntryIds.size());
            for (Object pk : keepEntryIds) {
                newkeepEntryIds.add(Long.parseLong(pk.toString()));
            }
            QFilter qFilter = new QFilter("billtype", "=", (Object)billType).and("billid", "in", newbillIds).and("entryid", "not in", newkeepEntryIds);
            DeleteServiceHelper.delete((String)"sbs_billsnrelation", (QFilter[])qFilter.toArray());
            if (TX.inTX()) {
                CommonParam param = new CommonParam();
                param.put((Object)"billtype", (Object)billType);
                param.put((Object)"newbillIds", newbillIds);
                param.put((Object)"newkeepEntryIds", newkeepEntryIds);
                param.put((Object)"flag", (Object)"2");
                BillSNRelationHelper.doRegisterDelTX(param);
            } else {
                SerialNumberDeletor.execDeleteBySurplusEntries(billType, newbillIds, newkeepEntryIds);
            }
        }
    }

    public static void doRegisterDelTX(CommonParam param) {
        ECGlobalSession.begin((String)"scm_bill_save", (DBRoute)DBRoute.of((String)"sys"), (Propagation)Propagation.REQUIRES_NEW);
        Set newbillIds = (Set)param.get((Object)"newbillIds");
        String billType = (String)param.get((Object)"billtype");
        ECGlobalSession.register((String)"scmc", (String)"sbs", (String)"DeleteMoveTrackService", (Param)param, (String)"handleDeleteSnMoveTrack");
        ECGlobalSession.setBusinessType((String)"snDeleteMoveTrackService");
        ArrayList<String> businessInfoList = new ArrayList<String>(newbillIds.size());
        for (Object billId : newbillIds) {
            businessInfoList.add(billType + "#" + billId.toString());
        }
        ECGlobalSession.setBusinessInfo(businessInfoList);
        ECGlobalSession.setAsync((boolean)false);
    }

    public static DataSet getBillEntrySNRelationDataSet(Collection<Long> billIds, String billtype, String entrytype, Map<Integer, Map<String, Object>> dims) {
        StringBuilder selects = new StringBuilder(SELECTFIELD_INCLUDESRC);
        if (dims != null && !dims.isEmpty()) {
            for (Map.Entry<Integer, Map<String, Object>> dim : dims.entrySet()) {
                Integer seq = dim.getKey();
                String dimkey = DIM_PRE + seq;
                Map<String, Object> dimval = dim.getValue();
                String relcolumn = (String)dimval.get("relcolumn");
                selects.append(",entryentity.").append(relcolumn).append(" as ").append(dimkey);
            }
        }
        QFilter filter = new QFilter("billid", "in", billIds).and("billtype", "=", (Object)billtype).and("entrykey", "=", (Object)entrytype);
        DataSet billSnRelationDataSet = QueryServiceHelper.queryDataSet((String)BillSNRelationHelper.class.getName(), (String)"sbs_billsnrelation", (String)selects.toString(), (QFilter[])filter.toArray(), (String)"");
        return billSnRelationDataSet;
    }

    public static void writeSNrelations(String billtype, Map<Long, Map<String, Object>> snrelations) {
        if (snrelations == null || snrelations.isEmpty()) {
            return;
        }
        DeleteServiceHelper.delete((String)"sbs_billsnrelation", (QFilter[])new QFilter("entryid", "in", snrelations.keySet()).toArray());
        DBRoute route = DBRoute.of((String)"scm");
        int headsize = snrelations.size();
        long[] headIds = DB.genLongIds((String)"T_SBS_BILLSQNRELATION", (int)headsize);
        int headIndex = 0;
        ArrayList<Object[]> headParams = new ArrayList<Object[]>(1000);
        String insertHeadSql = "insert into T_SBS_BILLSQNRELATION (FID,FBILLTYPE,FENTRYKEY,FBILLID,FENTRYID,FSRCBILLTYPE,FSRCENTRYKEY,FSRCBILLID,FSRCENTRYID,FSRCISREQ)values(?,?,?,?,?,?,?,?,?,?)";
        int entrysize = snrelations.values().stream().mapToInt(item -> item.size()).sum();
        long[] entryIds = DB.genLongIds((String)"T_SBS_BILLSQNRELATION_E", (int)entrysize);
        int entryIndex = 0;
        String insertEntrySql = "insert into T_SBS_BILLSQNRELATION_E (FID,FENTRYID,FSEQ,FSNNUMBER,FSNMAINFILEID,FINVORG,FHANDLESTATUS)values(?,?,?,?,?,?,?)";
        ArrayList<Object[]> entryParams = new ArrayList<Object[]>(1000);
        for (Map.Entry<Long, Map<String, Object>> entry : snrelations.entrySet()) {
            List snentries;
            Map<String, Object> relattrs = entry.getValue();
            Object[] headParam = new Object[10];
            if (headIndex >= headIds.length) {
                headParam[0] = headIds[headIndex];
                ++headIndex;
            } else {
                headParam[0] = SNBillConfigHelper.genId("T_SBS_BILLSQNRELATION");
            }
            headParam[1] = billtype;
            headParam[2] = relattrs.get("ENTRYKEY");
            headParam[3] = relattrs.get("BILLID");
            headParam[4] = entry.getKey();
            headParam[5] = relattrs.getOrDefault("SRCBILLTYPE", " ");
            headParam[6] = relattrs.getOrDefault("SRCENTRYKEY", " ");
            headParam[7] = relattrs.getOrDefault("SRCBILLID", 0L);
            headParam[8] = relattrs.getOrDefault("SRCENTRYID", 0L);
            headParam[9] = relattrs.getOrDefault("SRCISREQ", "0");
            headParams.add(headParam);
            if (headParams.size() == 1000) {
                BillSNRelationHelper.executeSql(headParams, insertHeadSql, route);
            }
            if ((snentries = (List)relattrs.get("SNENTRIES")) == null || snentries.size() <= 0) continue;
            for (Map snentry : snentries) {
                Object[] entryParam = new Object[7];
                entryParam[0] = headParam[0];
                if (entryIndex >= entryIds.length) {
                    entryParam[1] = entryIds[entryIndex];
                    ++entryIndex;
                } else {
                    entryParam[1] = SNBillConfigHelper.genId("T_SBS_BILLSQNRELATION_E");
                }
                entryParam[2] = snentry.get("SEQ");
                entryParam[3] = snentry.get("SNNUMBER");
                entryParam[4] = 0;
                entryParam[5] = snentry.getOrDefault("INVORG", 0L);
                entryParam[6] = "A";
                entryParams.add(entryParam);
                if (entryParams.size() != 1000) continue;
                BillSNRelationHelper.executeSql(entryParams, insertEntrySql, route);
            }
        }
        if (headParams.size() > 0) {
            BillSNRelationHelper.executeSql(headParams, insertHeadSql, route);
        }
        if (entryParams.size() > 0) {
            BillSNRelationHelper.executeSql(entryParams, insertEntrySql, route);
        }
    }
}

