/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.common.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.sbs.business.common.colsAssist.SelectParams;

public class FormUtil {
    public static DynamicObject getAndCheckF7Value(IDataModel model, String colName) {
        DynamicObject value = model.getDataEntity().getDynamicObject(colName);
        if (value == null) {
            MainEntityType type = model.getDataEntityType();
            DynamicProperty pro = type.getProperty(colName);
            String msg = pro == null ? String.format(FormUtil.getMsgFormNoFiled(), colName) : String.format(FormUtil.getMsgFormChoose(), pro.getDisplayName());
            throw new KDBizException(msg);
        }
        return value;
    }

    private static String getMsgFormNoFiled() {
        return ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"FormUtil_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getMsgFormChoose() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%1$s\u201d\u3002", (String)"FormUtil_1", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    public static FormShowParameter readyColsTreePage(SelectParams params, CloseCallBack callBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sbs_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(callBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    private static String getMsgAbstractFormException() {
        return ResManager.loadKDString((String)"%s\u63d2\u4ef6\u4e0d\u662fkd.bos.form.plugin.AbstractFormPlugin\u5b50\u7c7b\uff0c\u4e0d\u80fd\u4f7f\u7528FormUtils.addF7Listener\u3002", (String)"FormUtil_2", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    public static void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        if (!(form instanceof AbstractFormPlugin)) {
            throw new KDBizException(String.format(FormUtil.getMsgAbstractFormException(), form.getClass().getSimpleName()));
        }
        AbstractFormPlugin loaclForm = (AbstractFormPlugin)form;
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)loaclForm.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }
}

