/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.common.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;

public class MultiLangUtils {
    public static Map<String, String> getEntityKeyWithLang(String langName, MainEntityType dt, String ... fieldKeys) {
        HashMap<String, String> maps = new HashMap<String, String>(fieldKeys.length);
        for (String fieldKey : fieldKeys) {
            String name = MultiLangUtils.getEntityKeyWithLang(langName, dt, fieldKey);
            maps.put(fieldKey, name);
        }
        return maps;
    }

    public static String getEntityKeyWithLang(String langName, MainEntityType dt, String fieldKey) {
        String[] splitKey = fieldKey.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < splitKey.length; ++i) {
            IDataEntityProperty property;
            String curSplitKey;
            String name = curSplitKey = splitKey[i];
            if (builder.length() != 0) {
                builder.append('.');
            }
            if ((property = dt.findProperty(curSplitKey)) == null && i > 0) {
                IDataEntityProperty preProperty = dt.findProperty(splitKey[i - 1]);
                if (preProperty instanceof BasedataProp) {
                    BasedataProp prop = (BasedataProp)preProperty;
                    MainEntityType baseDt = EntityMetadataCache.getDataEntityType((String)prop.getBaseEntityId());
                    IDataEntityProperty baseProperty = baseDt.findProperty(curSplitKey);
                    name = (String)baseProperty.getDisplayName().get((Object)langName);
                }
            } else if (property != null) {
                name = (String)property.getDisplayName().get((Object)langName);
            }
            builder.append(name);
        }
        return builder.toString();
    }

    public static String getEntityKeyWithLang(String entityName, String fieldKey) {
        String langName = RequestContext.get().getLang().name();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        return MultiLangUtils.getEntityKeyWithLang(langName, dt, fieldKey);
    }

    public static Map<String, String> getEntityKey(String entityName, String ... fieldKeys) {
        String langName = RequestContext.get().getLang().name();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        return MultiLangUtils.getEntityKeyWithLang(langName, dt, fieldKeys);
    }

    public static Map<String, String> getEntityKey(MainEntityType dt, String ... fieldKeys) {
        String langName = RequestContext.get().getLang().name();
        return MultiLangUtils.getEntityKeyWithLang(langName, dt, fieldKeys);
    }
}

