/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formlugin.reservation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.scmc.paramentity.bizrule.reserve.pojo.ReserveOrBillInfo;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.sbs.business.reservation.ReserceCreateHelper;
import kd.scmc.sbs.business.reservation.ReserveHelper;
import kd.scmc.sbs.business.reservation.model.ReserveLinkDeamndRow;
import kd.scmc.sbs.business.reservation.model.ReserveLinkSelectRow;
import kd.scmc.sbs.business.reservation.model.ReserveLinkSupplyRow;
import kd.scmc.sbs.business.reservation.model.ReserveSchemeInfo;
import kd.scmc.sbs.common.consts.ReservePrcType;
import kd.scmc.sbs.common.consts.ReserveType;
import kd.scmc.sbs.common.pagemodel.ImInvacc;

public class ReserveCreatingPlugin
extends AbstractFormPlugin {
    private static final String KEY_DEMANDENTRY = "entryentity";
    private static final String KEY_INVACCSUBENTRY = "invaccsubentry";
    private static final String KEY_RESERVEQTY = "basereservedqty";
    private static final String KEY_RESERVEDQTY = "reservedqty";
    private static final String KEY_RESERVEDUNIT2NDQTY = "reservedunit2ndqty";
    private static final String KEY_SEQ = "seq";
    private static final String KEY_DEMANDSEQ = "demandseq";
    private static final String KEY_REALASEQTY = "realbaseqty";
    private static final String KEY_REALQTY = "realqty";
    private static final String KEY_REALUNIT2NDQTY = "realunit2ndqty";
    private static final String KEY_DEMANFORMID = "demandformid";
    private static final String KEY_DEMANDID = "demandinterid";
    private static final String KEY_DEMANDENTRRYID = "demandentryid";
    private static final String KEY_INVACCID = "invaccid";
    private static final String KEY_BASEACTSUPPLYQTY = "reserveaccqty";
    private static final String KEY_RESERVEACCUNITQTY = "reserveaccunitqty";
    private static final String KEY_RESERVEACCUNIT2NDQTY = "reserveaccunit2ndqty";
    private static final String KEY_BTSAVE = "btsave";
    private static final String KEY_BTAUTOASSIGN = "autoassign";
    private static final String KEY_SUPPLYAUXPTY = "supplyauxpty";
    private boolean qtyChanged;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTSAVE, KEY_BTAUTOASSIGN});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billInfos = (String)this.getView().getFormShowParameter().getCustomParam("orbillinfo");
        List orBillInfos = SerializationUtils.fromJsonStringToList((String)billInfos, ReserveOrBillInfo.class);
        ReserveSchemeInfo reserveSchemeInfo = this.getReserveSchemeInfo();
        Map<String, Object> data = null;
        try {
            data = ReserceCreateHelper.getReserceCreateInfos(orBillInfos, reserveSchemeInfo);
        }
        catch (Exception exc) {
            this.getView().showErrorNotification(exc.getMessage());
            return;
        }
        Object reseult = data.get("reserveresult");
        if (StringUtils.isNotBlank((Object)reseult)) {
            this.getView().showErrorNotification(String.valueOf(reseult));
            return;
        }
        if (StringUtils.isNotBlank(data)) {
            IFormView view = this.getView();
            IDataModel model = view.getModel();
            model.beginInit();
            HashMap<String, BigDecimal> unitRateMap = new HashMap<String, BigDecimal>();
            this.fillDemandEntry(data, orBillInfos, reserveSchemeInfo.getColsMap(), model, unitRateMap);
            this.fillSubSupplyEntry(data, model);
            model.endInit();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        String opkey = btn.getKey();
        IDataModel model = this.getView().getModel();
        switch (opkey) {
            case "btsave": {
                this.doSave(model);
                break;
            }
            case "autoassign": {
                this.doAssign(model);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int index = this.getModel().getEntryCurrentRowIndex(KEY_DEMANDENTRY);
        int subIndex = this.getModel().getEntryCurrentRowIndex(KEY_INVACCSUBENTRY);
        Object newValue = e.getChangeSet()[0].getNewValue();
        DynamicObject materialDyc = (DynamicObject)this.getModel().getValue("materiel", index);
        DynamicObject baseUnitDyc = (DynamicObject)this.getModel().getValue("demanbasedunit", index);
        DynamicObject unitDyc = (DynamicObject)this.getModel().getValue("demandunit", index);
        BigDecimal unitRateConv = ReserveHelper.getUnitRateConv(materialDyc, unitDyc, baseUnitDyc);
        DynamicObjectCollection subDycs = this.getModel().getEntryEntity(KEY_INVACCSUBENTRY);
        DynamicObject subMaterialDyc = null;
        DynamicObject subBaseUnitDyc = null;
        DynamicObject subUnitDyc = null;
        BigDecimal subUnitRateConv = null;
        if (subDycs.size() > 0) {
            subMaterialDyc = ((DynamicObject)subDycs.get(subIndex)).getDynamicObject("material");
            subMaterialDyc = this.getMaterialByMatBiz(subMaterialDyc);
            subBaseUnitDyc = ((DynamicObject)subDycs.get(subIndex)).getDynamicObject("baseunit");
            subUnitDyc = ((DynamicObject)subDycs.get(subIndex)).getDynamicObject("unit");
            subUnitRateConv = ReserveHelper.getUnitRateConv(subMaterialDyc, subUnitDyc, subBaseUnitDyc);
        }
        materialDyc = this.getMaterialByMatBiz(materialDyc);
        switch (key) {
            case "realqty": {
                if (this.qtyChanged) break;
                this.qtyChanged = true;
                this.changeRealQty(index, (BigDecimal)newValue, materialDyc, unitRateConv);
                break;
            }
            case "realunit2ndqty": {
                if (this.qtyChanged) break;
                this.qtyChanged = true;
                this.changeReal2ndQty(index, (BigDecimal)newValue, materialDyc, unitRateConv);
                break;
            }
            case "reserveaccunitqty": {
                if (this.qtyChanged) break;
                this.qtyChanged = true;
                this.changeAccQty(index, subIndex, (BigDecimal)newValue, subDycs, subMaterialDyc, subUnitRateConv);
                break;
            }
            case "reserveaccunit2ndqty": {
                if (this.qtyChanged) break;
                this.qtyChanged = true;
                this.changeAcc2ndQty(index, subIndex, (BigDecimal)newValue, subDycs, subMaterialDyc, subUnitRateConv);
                break;
            }
        }
    }

    protected void changeAcc2ndQty(int index, int subIndex, BigDecimal newValue, DynamicObjectCollection subDycs, DynamicObject subMaterialDyc, BigDecimal subUnitRateConv) {
        if (this.checkDir(subMaterialDyc, "B")) {
            BigDecimal unit2ndRate = this.getRateCache(index);
            BigDecimal subQty = unit2ndRate.compareTo(BigDecimal.ZERO) != 0 ? newValue.multiply(unit2ndRate).divide(subUnitRateConv) : BigDecimal.ZERO;
            this.getModel().setValue(KEY_RESERVEACCUNITQTY, (Object)subQty, subIndex, index);
        }
    }

    protected void changeAccQty(int index, int subIndex, BigDecimal newValue, DynamicObjectCollection subDycs, DynamicObject subMaterialDyc, BigDecimal subUnitRateConv) {
        this.getModel().setValue(KEY_BASEACTSUPPLYQTY, (Object)subUnitRateConv.multiply(newValue), subIndex, index);
        if (this.checkDir(subMaterialDyc, "A")) {
            BigDecimal unit2ndRate = this.getRateCache(index);
            BigDecimal subUnit2ndQty = unit2ndRate.compareTo(BigDecimal.ZERO) != 0 ? newValue.multiply(subUnitRateConv).divide(unit2ndRate, 4) : BigDecimal.ZERO;
            this.getModel().setValue(KEY_RESERVEACCUNIT2NDQTY, (Object)subUnit2ndQty, subIndex, index);
        }
    }

    protected void changeReal2ndQty(int index, BigDecimal newValue, DynamicObject materialDyc, BigDecimal unitRateConv) {
        if (this.checkDir(materialDyc, "B")) {
            BigDecimal unit2ndRate = this.getRateCache(index);
            BigDecimal realQty = unit2ndRate.compareTo(BigDecimal.ZERO) != 0 ? newValue.multiply(unit2ndRate).divide(unitRateConv) : BigDecimal.ZERO;
            this.getModel().setValue(KEY_REALQTY, (Object)realQty, index);
            this.getModel().setValue(KEY_REALASEQTY, (Object)unitRateConv.multiply(realQty), index);
        }
    }

    protected void changeRealQty(int index, BigDecimal newValue, DynamicObject materialDyc, BigDecimal unitRateConv) {
        this.getModel().setValue(KEY_REALASEQTY, (Object)unitRateConv.multiply(newValue), index);
        if (this.checkDir(materialDyc, "A")) {
            BigDecimal unit2ndRate = this.getRateCache(index);
            BigDecimal unit2ndQty = unit2ndRate.compareTo(BigDecimal.ZERO) != 0 ? newValue.multiply(unitRateConv).divide(unit2ndRate, 4) : BigDecimal.ZERO;
            this.getModel().setValue(KEY_REALUNIT2NDQTY, (Object)unit2ndQty, index);
        }
    }

    protected boolean checkDir(DynamicObject material, String dir) {
        if (material == null) {
            return false;
        }
        String unitConvertDir = material.getString("unitconvertdir");
        Object auxptyUnitId = material.get("auxptyunit");
        boolean isUseAuxptyUnit = auxptyUnitId != null && unitConvertDir != null;
        return isUseAuxptyUnit && (unitConvertDir.equalsIgnoreCase(dir) || "C".equalsIgnoreCase(unitConvertDir));
    }

    private static String getMsgReserveUnitQtyReq() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u9700\u6c42\u4fe1\u606f-\u53ef\u9884\u7559\u6570\u91cf", (String)"ReserveCreatingPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private void doSave(IDataModel model) {
        if (this.checkReserveQty()) {
            this.getView().showErrorNotification(ReserveCreatingPlugin.getMsgReserveUnitQtyReq());
            return;
        }
        String msg = this.checkSupplyOverDemand();
        if (!msg.isEmpty()) {
            this.getView().showMessage(msg);
            return;
        }
        String result = this.saveReserveLink(model);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            this.getView().showMessage(result);
            return;
        }
        this.getView().close();
    }

    private void doAssign(IDataModel model) {
        if (this.checkReserveQty()) {
            this.getView().showErrorNotification(ReserveCreatingPlugin.getMsgReserveUnitQtyReq());
            return;
        }
        this.getModel().beginInit();
        this.assignQty(model);
        this.getModel().endInit();
    }

    private boolean checkReserveQty() {
        DynamicObjectCollection demandEntry = this.getView().getModel().getEntryEntity(KEY_DEMANDENTRY);
        for (DynamicObject dynamicObject : demandEntry) {
            BigDecimal realDemandQty = dynamicObject.getBigDecimal(KEY_REALASEQTY);
            if (realDemandQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            return false;
        }
        return true;
    }

    private void assignQty(IDataModel model) {
        DynamicObjectCollection demandEntry = model.getEntryEntity(KEY_DEMANDENTRY);
        ArrayList<Map<String, Object>> lstMap = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < demandEntry.size(); ++i) {
            DynamicObject demand = (DynamicObject)demandEntry.get(i);
            this.getModel().setEntryCurrentRowIndex(KEY_DEMANDENTRY, i);
            DynamicObjectCollection supplyDycs = demand.getDynamicObjectCollection(KEY_INVACCSUBENTRY);
            this.setSupplyQty(lstMap, i, demand.getBigDecimal(KEY_REALASEQTY), KEY_BASEACTSUPPLYQTY, "avbbaseqty", supplyDycs);
            this.setSupplyQty(lstMap, i, demand.getBigDecimal(KEY_REALQTY), KEY_RESERVEACCUNITQTY, "avbqty", supplyDycs);
            this.setSupplyQty(lstMap, i, demand.getBigDecimal(KEY_REALUNIT2NDQTY), KEY_RESERVEACCUNIT2NDQTY, "avbqty2nd", supplyDycs);
        }
        this.getView().updateView(KEY_INVACCSUBENTRY);
    }

    protected void setSupplyQty(List<Map<String, Object>> lstMap, int entryIndex, BigDecimal realDemandQty, String supplyQtyf, String avbSupplyf, DynamicObjectCollection supplyDycs) {
        if (realDemandQty.compareTo(BigDecimal.ZERO) > 0) {
            for (int j = 0; j < supplyDycs.size(); ++j) {
                DynamicObject supplyDyc = (DynamicObject)supplyDycs.get(j);
                BigDecimal assignQty = this.getAssignQty(realDemandQty, supplyDyc, avbSupplyf, lstMap);
                this.getModel().setValue(supplyQtyf, (Object)assignQty, j, entryIndex);
                realDemandQty = realDemandQty.subtract(assignQty);
                if (realDemandQty.compareTo(BigDecimal.ZERO) < 0) break;
            }
        }
    }

    private static String getMsgReserveBaseUnit() {
        return ResManager.loadKDString((String)"(\u57fa\u672c\u5355\u4f4d)", (String)"ReserveCreatingPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getMsgReserveUnit() {
        return ResManager.loadKDString((String)"(\u8ba1\u91cf\u5355\u4f4d)", (String)"ReserveCreatingPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getMsgReserveUnit2nd() {
        return ResManager.loadKDString((String)"(\u8f85\u52a9\u5355\u4f4d)", (String)"ReserveCreatingPlugin_3", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getMsgReserveReqGtInfo() {
        return ResManager.loadKDString((String)"\u9700\u6c42\u4fe1\u606f\u7b2c%s\u884c\u9884\u7559\u7684\u53ef\u9884\u7559\u6570\u91cf\u5927\u4e8e\u4f9b\u5e94\u4fe1\u606f-\u9884\u7559\u6570\u91cf\uff0c\u8bf7\u8c03\u6574\u9700\u6c42\u4fe1\u606f-\u53ef\u9884\u7559\u6570\u91cf\u3002\r\n", (String)"ReserveCreatingPlugin_4", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getMsgReserveReqGtBaseUnitInfo() {
        return ResManager.loadKDString((String)"\u9700\u6c42\u4fe1\u606f\u7b2c%s\u884c\u9884\u7559\u7684\u53ef\u9884\u7559\u6570\u91cf(\u57fa\u672c\u5355\u4f4d)\u5927\u4e8e\u4f9b\u5e94\u4fe1\u606f-\u9884\u7559\u6570\u91cf(\u57fa\u672c\u5355\u4f4d)\uff0c\u8bf7\u8c03\u6574\u9700\u6c42\u4fe1\u606f-\u53ef\u9884\u7559\u6570\u91cf(\u57fa\u672c\u5355\u4f4d)\u3002\r\n", (String)"ReserveCreatingPlugin_5", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getMsgReserveReqUnit2ndInfo() {
        return ResManager.loadKDString((String)"\u9700\u6c42\u4fe1\u606f\u7b2c%s\u884c\u9884\u7559\u7684\u53ef\u9884\u7559\u6570\u91cf(\u8f85\u52a9\u5355\u4f4d)\u5927\u4e8e\u4f9b\u5e94\u4fe1\u606f-\u9884\u7559\u6570\u91cf(\u8f85\u52a9\u5355\u4f4d)\uff0c\u8bf7\u8c03\u6574\u9700\u6c42\u4fe1\u606f-\u53ef\u9884\u7559\u6570\u91cf(\u8f85\u52a9\u5355\u4f4d)\u3002\r\n", (String)"ReserveCreatingPlugin_6", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private String saveReserveLink(IDataModel model) {
        ArrayList<ReserveLinkSelectRow> lstReserveLinkSelectRow = new ArrayList<ReserveLinkSelectRow>();
        DynamicObjectCollection demandEntry = model.getEntryEntity(KEY_DEMANDENTRY);
        ArrayList<Map<String, Object>> lstMap = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < demandEntry.size(); ++i) {
            boolean notRes;
            DynamicObject demand = (DynamicObject)demandEntry.get(i);
            BigDecimal realDemandQty = demand.getBigDecimal(KEY_REALASEQTY);
            BigDecimal realDemandUnitQty = demand.getBigDecimal(KEY_REALQTY);
            BigDecimal realDemand2ndQty = demand.getBigDecimal(KEY_REALUNIT2NDQTY);
            boolean bl = notRes = realDemandQty.compareTo(BigDecimal.ZERO) <= 0 && realDemandUnitQty.compareTo(BigDecimal.ZERO) <= 0 && realDemand2ndQty.compareTo(BigDecimal.ZERO) <= 0;
            if (notRes) continue;
            ReserveLinkSelectRow selectRow = new ReserveLinkSelectRow();
            this.setReserveLinkDeamndRow(demand, selectRow.getDemand());
            model.setEntryCurrentRowIndex(KEY_DEMANDENTRY, i);
            BigDecimal realSupplyQty = new BigDecimal(0);
            BigDecimal realSupplyUnitQty = new BigDecimal(0);
            BigDecimal realSupply2ndQty = new BigDecimal(0);
            DynamicObjectCollection supplyCol = demand.getDynamicObjectCollection(KEY_INVACCSUBENTRY);
            for (int j = 0; j < supplyCol.size(); ++j) {
                boolean notResSupply;
                DynamicObject supply = (DynamicObject)supplyCol.get(j);
                BigDecimal realSubSupplyQty = supply.getBigDecimal(KEY_BASEACTSUPPLYQTY);
                BigDecimal realSubSupplyUnitQty = supply.getBigDecimal(KEY_RESERVEACCUNITQTY);
                BigDecimal realSubSupply2ndQty = supply.getBigDecimal(KEY_RESERVEACCUNIT2NDQTY);
                boolean bl2 = notResSupply = realSubSupplyQty.compareTo(BigDecimal.ZERO) <= 0 && realSubSupplyUnitQty.compareTo(BigDecimal.ZERO) <= 0 && realSubSupply2ndQty.compareTo(BigDecimal.ZERO) <= 0;
                if (notResSupply) continue;
                realSupplyQty = realSupplyQty.add(realSubSupplyQty);
                realSupplyUnitQty = realSupplyUnitQty.add(realSubSupplyUnitQty);
                realSupply2ndQty = realSupply2ndQty.add(realSubSupply2ndQty);
                Map<String, Object> baseChk = this.validateSameSupplyIsOver(lstMap, supply, i, j, KEY_BASEACTSUPPLYQTY, "avbbaseqty");
                Map<String, Object> unitChk = this.validateSameSupplyIsOver(lstMap, supply, i, j, KEY_RESERVEACCUNITQTY, "avbqty");
                Map<String, Object> unit2ndChk = this.validateSameSupplyIsOver(lstMap, supply, i, j, KEY_RESERVEACCUNIT2NDQTY, "avbqty2nd");
                StringBuilder msgBuilder = new StringBuilder();
                Object errormsg = baseChk.get("errormsg");
                if (errormsg != null) {
                    msgBuilder.append(errormsg).append(ReserveCreatingPlugin.getMsgReserveBaseUnit());
                }
                if ((errormsg = unitChk.get("errormsg")) != null) {
                    msgBuilder.append(errormsg).append(ReserveCreatingPlugin.getMsgReserveUnit());
                }
                if ((errormsg = unit2ndChk.get("errormsg")) != null) {
                    msgBuilder.append(errormsg).append(ReserveCreatingPlugin.getMsgReserveUnit2nd());
                }
                if (msgBuilder.length() > 0) {
                    return msgBuilder.toString();
                }
                ReserveLinkSupplyRow supplyRow = new ReserveLinkSupplyRow();
                this.setReserveLinkSupplyRow(supply, supplyRow);
                selectRow.getSupplyRows().add(supplyRow);
            }
            StringBuilder msgBuilder = new StringBuilder();
            if (realDemandUnitQty.compareTo(realSupplyUnitQty) > 0) {
                msgBuilder.append(String.format(ReserveCreatingPlugin.getMsgReserveReqGtInfo(), i + 1));
            }
            if (realDemandQty.compareTo(realSupplyQty) > 0) {
                msgBuilder.append(String.format(ReserveCreatingPlugin.getMsgReserveReqGtBaseUnitInfo(), i + 1));
            }
            if (realDemand2ndQty.compareTo(realSupply2ndQty) > 0) {
                msgBuilder.append(String.format(ReserveCreatingPlugin.getMsgReserveReqUnit2ndInfo(), i + 1));
            }
            if (msgBuilder.length() > 0) {
                return msgBuilder.toString();
            }
            lstReserveLinkSelectRow.add(selectRow);
        }
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"ReserveService", (String)"onReserveViewCreating", (Object[])new Object[]{lstReserveLinkSelectRow});
        return null;
    }

    private void setReserveLinkSupplyRow(DynamicObject supply, ReserveLinkSupplyRow supplyRow) {
        supplyRow.setSupplyOrgID(this.getDynamicPk(supply, "org", 0L));
        supplyRow.setReservePcType(ReservePrcType.RESERVE.getNumber());
        supplyRow.setBaseSupplyQty(supply.getBigDecimal(KEY_BASEACTSUPPLYQTY));
        supplyRow.setBaseSupplyUnitID(this.getDynamicPk(supply, "baseunit", 0L));
        supplyRow.setSupplyQty(supply.getBigDecimal(KEY_RESERVEACCUNITQTY));
        supplyRow.setSupplyUnitID(this.getDynamicPk(supply, "unit", 0L));
        supplyRow.setSupply2ndQty(supply.getBigDecimal(KEY_RESERVEACCUNIT2NDQTY));
        supplyRow.setSupplyUnit2ndID(this.getDynamicPk(supply, "unit2nd", 0L));
        supplyRow.setSupplyAuxpropID(this.getDynamicPk(supply, KEY_SUPPLYAUXPTY, 0L));
        supplyRow.setSupplyDate(supply.getDate("producedate"));
        supplyRow.setSupplyLotNumber(supply.getString("lotnumber"));
        supplyRow.setSupplyStockID(this.getDynamicPk(supply, "warehouse", 0L));
        supplyRow.setSupplyStockLocID(this.getDynamicPk(supply, "location", 0L));
        ReserveOrBillInfo supplyOrBillInfo = supplyRow.getSupplyBillInfo();
        supplyOrBillInfo.setFormId(ImInvacc.getBalTb());
        supplyOrBillInfo.setInterID((String)supply.get(KEY_INVACCID));
        supplyOrBillInfo.setEntryID((String)supply.get(KEY_INVACCID));
    }

    private void setReserveLinkDeamndRow(DynamicObject demand, ReserveLinkDeamndRow demnadRow) {
        demnadRow.setDemandOrgID(this.getDynamicPk(demand, "demandorg", 0L));
        demnadRow.setDemandDate(demand.getDate("demanddate"));
        demnadRow.setDemandSeq(demand.getLong(KEY_DEMANDSEQ));
        demnadRow.setDemandMaterialID(this.getDynamicPk(demand, "materiel", 0L));
        demnadRow.setBaseUnitId(this.getDynamicPk(demand, "demanbasedunit", 0L));
        demnadRow.setBaseDemandQty(demand.getBigDecimal(KEY_REALASEQTY));
        demnadRow.setUnitId(this.getDynamicPk(demand, "demandunit", 0L));
        demnadRow.setDemandQty(demand.getBigDecimal(KEY_REALQTY));
        demnadRow.setUnit2ndId(this.getDynamicPk(demand, "demandunit2nd", 0L));
        demnadRow.setDemand2ndQty(demand.getBigDecimal(KEY_REALUNIT2NDQTY));
        demnadRow.setReserveType(ReserveType.BILLRESERVE.getNumber());
        demnadRow.setReservecust(this.getDynamicPk(demand, "reservecust", 0L));
        demnadRow.setReveredept(this.getDynamicPk(demand, "reveredept", 0L));
        demnadRow.setReserveoperate(this.getDynamicPk(demand, "reserveoperate", 0L));
        ReserveOrBillInfo demandOrBillInfo = demnadRow.getDemandInfo();
        demandOrBillInfo.setBillNo((String)demand.get("demandnumber"));
        demandOrBillInfo.setEntryID((String)demand.get(KEY_DEMANDENTRRYID));
        demandOrBillInfo.setInterID((String)demand.get(KEY_DEMANDID));
        demandOrBillInfo.setFormId(this.getDynamicPk(demand, KEY_DEMANFORMID, ""));
    }

    private <T> T getDynamicPk(DynamicObject obj, String key, T t) {
        return (T)(ObjectUtils.isEmpty((Object)obj.getDynamicObject(key)) ? t : obj.getDynamicObject(key).getPkValue());
    }

    private static String getMsgReserveInfoResetKey() {
        return ResManager.loadKDString((String)"\u4ece\u9700\u6c42\u4fe1\u606f\u7b2c%1$s\u884c\u5f00\u59cb\uff0c\u5bf9\u4f9b\u5e94\u4fe1\u606f\u7b2c%2$s\u884c\u540c\u4e00\u4f9b\u5e94\u5355\u636e\u7684\u9884\u7559\u5df2\u8d85\u8fc7\u4e86\u8be5\u5355\u636e\u7684\u4f9b\u5e94\u91cf\uff0c\u8bf7\u91cd\u65b0\u8bbe\u503c\u3002", (String)"ReserveCreatingPlugin_7", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private Map<String, Object> validateSameSupplyIsOver(List<Map<String, Object>> lstMAP, DynamicObject supply, int i, int j, String supplyResQtyf, String avbQtyf) {
        HashMap<String, Object> result = null;
        String supplyID = supply.getString(KEY_INVACCID);
        BigDecimal realSubSupplyQty = supply.getBigDecimal(supplyResQtyf);
        for (Map<String, Object> item : lstMAP) {
            if (!String.valueOf(item.get(KEY_INVACCID)).equals(supplyID) || item.get(supplyResQtyf) == null) continue;
            BigDecimal sumSupplyQty = ((BigDecimal)item.get(supplyResQtyf)).add(realSubSupplyQty);
            if (sumSupplyQty.compareTo((BigDecimal)supply.get(avbQtyf)) > 0) {
                item.put("errormsg", String.format(ReserveCreatingPlugin.getMsgReserveInfoResetKey(), i, j));
            }
            item.put("supplySumQty", sumSupplyQty);
            return item;
        }
        result = new HashMap<String, Object>();
        result.put(KEY_INVACCID, supplyID);
        result.put(supplyResQtyf, realSubSupplyQty);
        lstMAP.add(result);
        return result;
    }

    private List<Object> getIds(List<Object> invaccIds, Set<Object> accIds) {
        ArrayList<Object> ids = new ArrayList<Object>();
        if (invaccIds != null) {
            for (Object id : invaccIds) {
                if (!accIds.contains(id)) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    private void fillSubSupplyEntry(Map<String, Object> infos, IDataModel model) {
        Map lstInaccInfoMap = (Map)infos.get("invaccinfos");
        ArrayList lstInaccInfos = new ArrayList(lstInaccInfoMap.values());
        Set<Object> accIds = lstInaccInfoMap.keySet();
        Map matchInvaccs = (Map)infos.get("billmatchinvacc");
        DynamicObjectCollection parCol = model.getEntryEntity(KEY_DEMANDENTRY);
        block0: for (int i = 0; i < parCol.size(); ++i) {
            model.setEntryCurrentRowIndex(KEY_DEMANDENTRY, i);
            Long billEntryId = ((DynamicObject)parCol.get(i)).getLong(KEY_DEMANDENTRRYID);
            List<Object> invaccIds = (List<Object>)matchInvaccs.get(billEntryId);
            invaccIds = this.getIds(invaccIds, accIds);
            if (ObjectUtils.isEmpty(invaccIds)) continue;
            int count = invaccIds.size();
            model.batchCreateNewEntryRow(KEY_INVACCSUBENTRY, count);
            for (int j = 0; j < count; ++j) {
                String accId = invaccIds.get(j).toString();
                Optional<DynamicObject> defaultObj = lstInaccInfos.stream().filter(p -> p.getPkValue().toString().equals(accId)).findFirst();
                if (!defaultObj.isPresent()) continue block0;
                DynamicObject invacc = defaultObj.get();
                model.setValue("baseqty", (Object)invacc.getBigDecimal("baseqty"), j, i);
                BigDecimal reserveQty = invacc.getBigDecimal("baseqty").subtract(invacc.getBigDecimal("avbbaseqty"));
                model.setValue("lockbaseqty", (Object)reserveQty, j, i);
                model.setValue("avbbaseqty", (Object)invacc.getBigDecimal("avbbaseqty"), j, i);
                model.setValue("qty", (Object)invacc.getBigDecimal("qty"), j, i);
                BigDecimal reserveUnitQty = invacc.getBigDecimal("qty").subtract(invacc.getBigDecimal("avbqty"));
                model.setValue("lockqty", (Object)reserveUnitQty, j, i);
                model.setValue("avbqty", (Object)invacc.getBigDecimal("avbqty"), j, i);
                model.setValue("qty2nd", (Object)invacc.getBigDecimal("qty2nd"), j, i);
                BigDecimal reserve2ndQty = invacc.getBigDecimal("qty2nd").subtract(invacc.getBigDecimal("avbqty2nd"));
                model.setValue("lockqty2nd", (Object)reserve2ndQty, j, i);
                model.setValue("avbqty2nd", (Object)invacc.getBigDecimal("avbqty2nd"), j, i);
                model.setValue("baseunit", (Object)invacc.getDynamicObject("baseunit"), j, i);
                model.setValue("unit", (Object)invacc.getDynamicObject("unit"), j, i);
                model.setValue("unit2nd", (Object)invacc.getDynamicObject("unit2nd"), j, i);
                model.setValue("org", (Object)invacc.getDynamicObject("org"), j, i);
                model.setValue("lotnumber", (Object)invacc.getString("lotnum"), j, i);
                model.setValue("warehouse", (Object)invacc.getDynamicObject("warehouse"), j, i);
                model.setValue("location", (Object)invacc.getDynamicObject("location"), j, i);
                model.setValue("invstatus", (Object)invacc.getDynamicObject("invstatus"), j, i);
                model.setValue("project", (Object)invacc.getDynamicObject("project"), j, i);
                model.setValue("producedate", (Object)invacc.getDate("producedate"), j, i);
                model.setValue("expirydate", (Object)invacc.getDate("expirydate"), j, i);
                model.setValue("invtype", (Object)invacc.getDynamicObject("invtype"), j, i);
                model.setValue("ownertype", (Object)invacc.getString("ownertype"), j, i);
                model.setValue("owner", (Object)invacc.getDynamicObject("owner"), j, i);
                model.setValue("keepertype", (Object)invacc.getString("keepertype"), j, i);
                model.setValue("keeper", (Object)invacc.getDynamicObject("keeper"), j, i);
                model.setValue("material", (Object)invacc.getDynamicObject("material"), j, i);
                model.setValue(KEY_SUPPLYAUXPTY, (Object)invacc.getDynamicObject("auxpty"), j, i);
                model.setValue(KEY_INVACCID, invacc.getPkValue(), j, i);
            }
        }
    }

    private void fillDemandEntry(Map<String, Object> infos, List<ReserveOrBillInfo> orBillInfos, Map<String, String> paramSetting, IDataModel model, Map<String, BigDecimal> unitRateMap) {
        List lstDemandInfos = (List)infos.get("orbilldymicobjs");
        Map mapHaveRserve = (Map)infos.get("havingreserveentry");
        int count = orBillInfos.size();
        model.batchCreateNewEntryRow(KEY_DEMANDENTRY, count);
        HashMap<String, DynamicObject> lstDemandInfoMap = new HashMap<String, DynamicObject>(lstDemandInfos.size());
        for (DynamicObject lstDemandInfo : lstDemandInfos) {
            lstDemandInfoMap.put(lstDemandInfo.getPkValue().toString(), lstDemandInfo);
        }
        Map matchInvaccs = (Map)infos.get("billmatchinvacc");
        if (matchInvaccs == null || matchInvaccs.isEmpty()) {
            return;
        }
        int row = 0;
        for (int i = 0; i < count; ++i) {
            ReserveOrBillInfo orBillInfo = orBillInfos.get(i);
            DynamicObject demandinfo = (DynamicObject)lstDemandInfoMap.get(orBillInfo.getInterID());
            if (demandinfo == null) continue;
            DynamicObjectCollection entrys = demandinfo.getDynamicObjectCollection(paramSetting.get("billentry"));
            DynamicObject item = null;
            Optional<DynamicObject> first = entrys.stream().filter(p -> p.getPkValue().toString().equals(orBillInfo.getEntryID())).findFirst();
            if (!first.isPresent() || !matchInvaccs.containsKey((item = first.get()).getPkValue())) continue;
            String entryId = String.valueOf(item.getPkValue());
            model.setValue(KEY_RESERVEQTY, mapHaveRserve.get(entryId + "," + "reservebaseqty"), row);
            model.setValue(KEY_RESERVEDQTY, mapHaveRserve.get(entryId + "," + "reserveqty"), row);
            model.setValue(KEY_RESERVEDUNIT2NDQTY, mapHaveRserve.get(entryId + "," + "reserveunit2ndqty"), row);
            model.setValue(KEY_DEMANDID, demandinfo.getPkValue(), row);
            model.setValue(KEY_DEMANDENTRRYID, (Object)entryId, row);
            model.setValue(KEY_DEMANDSEQ, (Object)item.getInt(KEY_SEQ), row);
            model.setValue(KEY_DEMANFORMID, (Object)demandinfo.getDataEntityType().getName(), row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "demandorg", row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "demanddate", row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "reservecust", row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "reveredept", row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "reserveoperate", row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "demandnumber", row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "materiel", row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "demanbasedunit", row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "demandbaseunitqty", row);
            model.setValue(KEY_REALASEQTY, (Object)this.getBigDeciamlAbs((BigDecimal)model.getValue("demandbaseunitqty", row)).subtract((BigDecimal)model.getValue(KEY_RESERVEQTY, row)), row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "demandunit", row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "demandqty", row);
            model.setValue(KEY_REALQTY, (Object)this.getBigDeciamlAbs((BigDecimal)model.getValue("demandqty", row)).subtract((BigDecimal)model.getValue(KEY_RESERVEDQTY, row)), row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "demandunit2nd", row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "demandunit2ndqty", row);
            model.setValue(KEY_REALUNIT2NDQTY, (Object)this.getBigDeciamlAbs((BigDecimal)model.getValue("demandunit2ndqty", row)).subtract((BigDecimal)model.getValue(KEY_RESERVEDUNIT2NDQTY, row)), row);
            this.setDemandEntry(model, demandinfo, item, paramSetting, "auxpty", row);
            ++row;
        }
    }

    private void setDemandEntry(IDataModel model, DynamicObject demandinfo, DynamicObject demandEntryinfo, Map<String, String> paramSetting, String setValueKey, int i) {
        String entryKey = paramSetting.get("billentry");
        String mapKey = paramSetting.get(setValueKey);
        if (ObjectUtils.isEmpty((Object)mapKey)) {
            return;
        }
        if (mapKey.contains(entryKey)) {
            Object setValue;
            String[] key = mapKey.split("\\.");
            String field = key[key.length - 1];
            if (setValueKey.equals("materiel")) {
                setValue = demandEntryinfo.get(mapKey.replace(entryKey + ".", ""));
                this.setUnit2ndRate((DynamicObject)setValue, i);
                setValue = ReserveHelper.getMasterMaterial((DynamicObject)setValue);
            } else {
                setValue = demandEntryinfo.get(field);
            }
            if (setValue instanceof BigDecimal) {
                model.setValue(setValueKey, (Object)((BigDecimal)setValue).abs(), i);
            } else {
                model.setValue(setValueKey, setValue, i);
            }
        } else {
            model.setValue(setValueKey, demandinfo.get(mapKey), i);
        }
    }

    private BigDecimal getAssignQty(BigDecimal demandQty, DynamicObject supplyDyc, String avbSupplyf, List<Map<String, Object>> lstMap) {
        BigDecimal supplyQty = supplyDyc.getBigDecimal(avbSupplyf);
        String supplyId = (String)supplyDyc.get(KEY_INVACCID);
        for (Map<String, Object> item : lstMap) {
            BigDecimal hasAssignQty = (BigDecimal)item.get(avbSupplyf);
            if (hasAssignQty == null || !String.valueOf(item.get(KEY_INVACCID)).equals(supplyId)) continue;
            if (supplyQty.compareTo(hasAssignQty) > 0) {
                BigDecimal canAssignQty = supplyQty.subtract(hasAssignQty);
                BigDecimal assignQty = demandQty.compareTo(canAssignQty) > 0 ? canAssignQty : demandQty;
                item.put(avbSupplyf, assignQty);
                return assignQty;
            }
            return BigDecimal.ZERO;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_INVACCID, supplyId);
        lstMap.add(map);
        BigDecimal assignQty = demandQty.compareTo(supplyQty) > 0 ? supplyQty : demandQty;
        map.put(avbSupplyf, assignQty);
        return assignQty;
    }

    private ReserveSchemeInfo getReserveSchemeInfo() {
        String schemeId = (String)this.getView().getFormShowParameter().getCustomParam("reservescheme");
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"sbs_reserve_st");
        ReserveSchemeInfo schemeInfo = new ReserveSchemeInfo(schemeObj);
        return schemeInfo;
    }

    private static String getMsgReserveReqQtyResetKey() {
        return ResManager.loadKDString((String)"\u9700\u6c42\u4fe1\u606f\u7b2c%s\u884c\uff0c\u8bbe\u7f6e\u7684\u4f9b\u5e94\u201c\u9884\u7559\u6570\u91cf\u201d\u603b\u548c\u5927\u4e8e\u9700\u6c42\u201c\u53ef\u9884\u7559\u6570\u91cf\u201d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u503c\u3002", (String)"ReserveCreatingPlugin_8", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getMsgReserveReqBaseQtyResetKey() {
        return ResManager.loadKDString((String)"\u9700\u6c42\u4fe1\u606f\u7b2c%s\u884c\uff0c\u8bbe\u7f6e\u7684\u4f9b\u5e94\u201c\u9884\u7559\u6570\u91cf(\u57fa\u672c\u5355\u4f4d)\u201d\u603b\u548c\u5927\u4e8e\u9700\u6c42\u201c\u53ef\u9884\u7559\u6570\u91cf(\u57fa\u672c\u5355\u4f4d)\u201d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u503c\u3002", (String)"ReserveCreatingPlugin_9", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private static String getMsgReserveReqUnit2ndResetKey() {
        return ResManager.loadKDString((String)"\u9700\u6c42\u4fe1\u606f\u7b2c%s\u884c\uff0c\u8bbe\u7f6e\u7684\u4f9b\u5e94\u201c\u9884\u7559\u6570\u91cf(\u8f85\u52a9\u5355\u4f4d)\u201d\u603b\u548c\u5927\u4e8e\u9700\u6c42\u201c\u53ef\u9884\u7559\u6570\u91cf(\u8f85\u52a9\u5355\u4f4d)\u201d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u503c\u3002", (String)"ReserveCreatingPlugin_10", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    protected String checkSupplyOverDemand() {
        StringBuilder msgBuilder = new StringBuilder();
        DynamicObjectCollection demandEntry = this.getView().getModel().getEntryEntity(KEY_DEMANDENTRY);
        for (int i = 0; i < demandEntry.size(); ++i) {
            BigDecimal realDemandQty = ((DynamicObject)demandEntry.get(i)).getBigDecimal(KEY_REALASEQTY);
            BigDecimal realDemandUnitQty = ((DynamicObject)demandEntry.get(i)).getBigDecimal(KEY_REALQTY);
            BigDecimal realDemand2ndQty = ((DynamicObject)demandEntry.get(i)).getBigDecimal(KEY_REALUNIT2NDQTY);
            this.getModel().setEntryCurrentRowIndex(KEY_DEMANDENTRY, i);
            DynamicObjectCollection supplyDycs = ((DynamicObject)demandEntry.get(i)).getDynamicObjectCollection(KEY_INVACCSUBENTRY);
            for (int j = 0; j < supplyDycs.size(); ++j) {
                realDemandQty = realDemandQty.subtract(((DynamicObject)supplyDycs.get(j)).getBigDecimal(KEY_BASEACTSUPPLYQTY));
                realDemandUnitQty = realDemandUnitQty.subtract(((DynamicObject)supplyDycs.get(j)).getBigDecimal(KEY_RESERVEACCUNITQTY));
                realDemand2ndQty = realDemand2ndQty.subtract(((DynamicObject)supplyDycs.get(j)).getBigDecimal(KEY_RESERVEACCUNIT2NDQTY));
            }
            if (realDemandUnitQty.compareTo(BigDecimal.ZERO) < 0) {
                msgBuilder.append(String.format(ReserveCreatingPlugin.getMsgReserveReqQtyResetKey() + "\r\n", i + 1));
            }
            if (realDemandQty.compareTo(BigDecimal.ZERO) < 0) {
                msgBuilder.append(String.format(ReserveCreatingPlugin.getMsgReserveReqBaseQtyResetKey() + "\r\n", i + 1));
            }
            if (realDemand2ndQty.compareTo(BigDecimal.ZERO) >= 0) continue;
            msgBuilder.append(String.format(ReserveCreatingPlugin.getMsgReserveReqUnit2ndResetKey() + "\r\n", i + 1));
        }
        return msgBuilder.toString();
    }

    private void setUnit2ndRate(DynamicObject material, int row) {
        DynamicObject masterMaterial = this.getMaterialByMatBiz(material);
        if (masterMaterial == null) {
            return;
        }
        DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
        DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
        if (baseUnit == null || auxptyUnit == null) {
            return;
        }
        BigDecimal unit2ndRate = ReserveHelper.getUnitRateConv(masterMaterial, auxptyUnit, baseUnit);
        if (unit2ndRate == null) {
            return;
        }
        this.getPageCache().put("unit2ndrate_" + row, unit2ndRate.toString());
    }

    private DynamicObject getMaterialByMatBiz(DynamicObject material) {
        if (material == null) {
            return null;
        }
        if ("bd_materialinventoryinfo".equals(material.getDataEntityType().getName()) || "bd_materialpurchaseinfo".equals(material.getDataEntityType().getName()) || "bd_materialsalinfo".equals(material.getDataEntityType().getName())) {
            QFilter qFilter1 = new QFilter("id", "=", material.getDynamicObject("masterid").getPkValue());
            material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{qFilter1});
        } else {
            QFilter qFilter1 = new QFilter("id", "=", material.getPkValue());
            material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{qFilter1});
        }
        return material;
    }

    private BigDecimal getRateCache(int row) {
        String rateCache = this.getPageCache().get("unit2ndrate_" + row);
        BigDecimal unit2ndRate = BigDecimal.ZERO;
        if (StringUtils.isBlank((CharSequence)rateCache)) {
            return unit2ndRate;
        }
        unit2ndRate = new BigDecimal(rateCache);
        unit2ndRate = unit2ndRate.setScale(10);
        return unit2ndRate;
    }

    private BigDecimal getBigDeciamlAbs(BigDecimal value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value.abs();
    }
}

