/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formlugin.reservation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;

public class ReserveListPlugin
extends AbstractListPlugin {
    private static final String KEY_reservebaseqty = "reservebaseqty";

    public void filterContainerInit(FilterContainerInitArgs args) {
        List<ComboItem> orgItem = this.getHasPermissionOrgFilterColumns(((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId());
        if (orgItem == null || orgItem.isEmpty()) {
            return;
        }
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Boolean isLink = (Boolean)this.getView().getFormShowParameter().getCustomParam("link");
        for (FilterColumn filterColumn : filterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"demandorg.number".equals(fieldName)) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            commonFilterColumn.setComboItems(orgItem);
            String defaultOrgid = this.getDefaultId(orgItem);
            commonFilterColumn.setDefaultValue(defaultOrgid);
            if (isLink == null || !isLink.booleanValue()) continue;
            commonFilterColumn.setDefaultValue(null);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter qtyFilter = new QFilter(KEY_reservebaseqty, ">", (Object)0);
        e.getQFilters().add(qtyFilter);
    }

    private String getDefaultId(List<ComboItem> items) {
        Long currOrgId = RequestContext.get().getOrgId();
        for (int i = 0; i < items.size(); ++i) {
            Long nextId;
            if (null == items.get(i) || items.get(i).getValue().length() == 0 || (nextId = Long.valueOf(items.get(i).getValue())).longValue() != currOrgId.longValue()) continue;
            return currOrgId.toString();
        }
        String defaultStr = items.get(0).getValue();
        return defaultStr;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)this.getControl("billlistap");
        args.setCancel(true);
        ListSelectedRowCollection allRowCollection = list.getCurrentListAllRowCollection();
        int selectRowIndex = args.getRowIndex();
        ListSelectedRow pkIds = allRowCollection.get(selectRowIndex);
        DynamicObject selectRowEntry = BusinessDataServiceHelper.loadSingle((Object)pkIds.getPrimaryKeyValue(), (String)list.getBillFormId(), (String)"demandformid,demandid");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(selectRowEntry.getDynamicObject("demandformid").getString("number"));
        showParameter.setPkId((Object)Long.valueOf(selectRowEntry.getString("demandid")));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<ComboItem> getHasPermissionOrgFilterColumns(String entityName) {
        List orgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)"15");
        if (orgs == null || orgs.isEmpty()) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        int len = orgs.size();
        ArrayList<ComboItem> orgItem = new ArrayList<ComboItem>(orgs.size());
        int myOrgIndex = -1;
        Map tempOrg = null;
        for (int i = 0; i < len; ++i) {
            tempOrg = (Map)orgs.get(i);
            orgItem.add(new ComboItem(new LocaleString((String)tempOrg.get("name")), (String)tempOrg.get("id")));
            if (myOrgIndex >= 0 || !Long.valueOf((String)tempOrg.get("id")).equals(orgId)) continue;
            myOrgIndex = i;
        }
        if (myOrgIndex > 0) {
            ComboItem myOrg = (ComboItem)orgItem.set(myOrgIndex, (ComboItem)orgItem.get(0));
            orgItem.set(0, myOrg);
        }
        return orgItem;
    }
}

