/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formlugin.reservation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.scmc.sbs.business.common.colsAssist.DefaultSelectStrategy;
import kd.scmc.sbs.business.common.colsAssist.IColsSelectStrategy;
import kd.scmc.sbs.business.common.colsAssist.MetaHelper;
import kd.scmc.sbs.business.common.colsAssist.NoLowerAttrStategy;
import kd.scmc.sbs.business.common.colsAssist.SelectParams;
import kd.scmc.sbs.common.pagemodel.ImInvacc;
import kd.scmc.sbs.common.util.ColsTreeUtil;
import kd.scmc.sbs.common.util.F7Utils;
import kd.scmc.sbs.common.util.FormUtil;
import org.apache.commons.lang3.StringUtils;

public class ReserveSTEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String C_reservefilterinfo = "reservefilterinfo";
    private static final String C_stockfilterinfo = "stockfilterinfo";
    private static final String BT_addsortcols = "addsortcols";
    private static final String PAGE = "sbs_colstree_select";
    private static final String[] STOCK_COLS_NAME = new String[]{"stocksortno", "stocksortname", "sorttype"};
    private static String[] INV_COLS_NAME = new String[]{"invaccountname", "invaccountno", "requirebillmatchno", "requirebillmatchname", "reservematchflag"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"requirestockorgname", "requirestockdatename", "invaccountname", "requirebillmatchname", "stocksortname", BT_addsortcols});
        this.addItemClickListeners(new String[]{"sortentrytool"});
        FormUtil.addF7Listener(this, "requirebill", "billsetting");
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addsortcols": {
                this.clickAddSortCols((EventObject)evt, key);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "requirestockorgname": {
                this.clickStockOrg(evt, key);
                break;
            }
            case "requirestockdatename": {
                this.clickStockDate(evt, key);
                break;
            }
            case "invaccountname": {
                this.clickInvAccount(evt, key);
                break;
            }
            case "requirebillmatchname": {
                this.clickRequireBillMatch(evt, key);
                break;
            }
        }
    }

    private void clickAddSortCols(EventObject evt, String key) {
        MetaHelper metaHelper = new MetaHelper(ImInvacc.getBalTb());
        String colsJosnTree = metaHelper.buildTree2JSON();
        SelectParams params = new SelectParams();
        params.setJsonTree(colsJosnTree);
        params.setMulti(true);
        this.showSelectColsPage(params, new CloseCallBack((IFormPlugin)this, key));
    }

    private void clickRequireBillMatch(EventObject evt, String key) {
        this.checkRequireBill();
        MainEntityType mainEntityType = this.getRequireBillMainEntityType();
        MetaHelper metaHelper = new MetaHelper((IColsSelectStrategy)new NoLowerAttrStategy(), mainEntityType);
        String colsJosnTree = metaHelper.buildTree2JSON();
        SelectParams params = new SelectParams();
        params.setJsonTree(colsJosnTree);
        this.showSelectColsPage(params, new CloseCallBack((IFormPlugin)this, key));
    }

    private void clickInvAccount(EventObject evt, String key) {
        MetaHelper metaHelper = new MetaHelper((IColsSelectStrategy)new NoLowerAttrStategy(), ImInvacc.getBalTb());
        String colsJosnTree = metaHelper.buildTree2JSON();
        SelectParams params = new SelectParams();
        params.setJsonTree(colsJosnTree);
        this.showSelectColsPage(params, new CloseCallBack((IFormPlugin)this, key));
    }

    private void clickStockOrg(EventObject evt, String key) {
        this.checkRequireBill();
        String colsJosnTree = this.getRequireBillCols(new OrgColStrategy());
        SelectParams params = new SelectParams();
        params.setJsonTree(colsJosnTree);
        this.showSelectColsPage(params, new CloseCallBack((IFormPlugin)this, key));
    }

    private String getRequireBillCols(IColsSelectStrategy strategy) {
        MainEntityType mainEntityType = this.getRequireBillMainEntityType();
        TreeNode nodes = new MetaHelper(strategy, mainEntityType).buildTree();
        return SerializationUtils.toJsonString((Object)nodes);
    }

    private void clickStockDate(EventObject evt, String key) {
        this.checkRequireBill();
        String colsJosnTree = this.getRequireBillCols(new DateColStrategy());
        SelectParams params = new SelectParams();
        params.setJsonTree(colsJosnTree);
        this.showSelectColsPage(params, new CloseCallBack((IFormPlugin)this, key));
    }

    private void showSelectColsPage(SelectParams params, CloseCallBack callBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(PAGE);
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(callBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private static String getMsgCheckRequireBill() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u9700\u6c42\u5355\u636e\u201d\u3002", (String)"ReserveSTEdit_0", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }

    private void checkRequireBill() {
        if (!this.hasRequireBill()) {
            throw new KDBizException(ReserveSTEdit.getMsgCheckRequireBill());
        }
    }

    private boolean hasRequireBill() {
        IDataModel model = this.getModel();
        DynamicObject requireBill = model.getDataEntity().getDynamicObject("requirebill");
        return requireBill != null;
    }

    private MainEntityType getRequireBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject requireBill = model.getDataEntity().getDynamicObject("requirebill");
        String metaDataNo = requireBill.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
        return mainEntityType;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setCols4ReserveFilterGrid();
        this.setCols4StockFilterGrid();
        this.bindUnParseCols();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisiableAfterBind(e);
    }

    private void setVisiableAfterBind(EventObject e) {
        this.setAutoReserveVisible();
    }

    private void setCols4ReserveFilterGrid() {
        MainEntityType entityType = null;
        if (this.hasRequireBill()) {
            entityType = this.getRequireBillMainEntityType();
        }
        this.setCols4FilterGrid(entityType, C_reservefilterinfo);
    }

    private void setCols4StockFilterGrid() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ImInvacc.getBalTb());
        this.setCols4FilterGrid(entityType, C_stockfilterinfo);
    }

    private void setCols4FilterGrid(MainEntityType entityType, String controlName) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(controlName);
        EntityTypeUtil helper = new EntityTypeUtil();
        if (entityType == null) {
            filterGrid.setFilterColumns(Collections.EMPTY_LIST);
        } else {
            List cols = helper.getFilterColumns((IDataEntityType)entityType);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView(controlName);
    }

    private void bindUnParseCols() {
        this.bindReserveFs();
        this.bindStockFs();
        this.bindStockMatch();
        this.bindStockSeq();
    }

    private void bindStockSeq() {
        String stockSeqStr = this.getModel().getDataEntity().getString("stockseq");
        JSONObject entry = null;
        if (StringUtils.isNotBlank((CharSequence)stockSeqStr)) {
            entry = JSON.parseObject((String)stockSeqStr);
        }
        this.batchSetEntry("stocksortentity", entry);
    }

    private void batchSetEntry(String entryName, JSONObject entry) {
        IDataModel model = this.getModel();
        model.deleteEntryData(entryName);
        if (entry == null) {
            return;
        }
        Set cols = entry.keySet();
        JSONArray colValues = null;
        int[] indexs = null;
        int size = 0;
        for (String col : cols) {
            colValues = entry.getJSONArray(col);
            size = colValues.size();
            if (indexs == null) {
                indexs = model.batchCreateNewEntryRow(entryName, size);
            }
            for (int i = 0; i < size; ++i) {
                model.setValue(col, colValues.get(i), indexs[i]);
            }
        }
    }

    private void bindStockMatch() {
        String stockMatchStr = this.getModel().getDataEntity().getString("stockmatch");
        JSONObject entry = null;
        if (StringUtils.isNotBlank((CharSequence)stockMatchStr)) {
            entry = JSON.parseObject((String)stockMatchStr);
        }
        this.batchSetEntry("stockmatchentry", entry);
    }

    private void bindStockFs() {
        String stockFsStr = this.getModel().getDataEntity().getString("stockfilter");
        FilterCondition condition = null;
        condition = StringUtils.isBlank((CharSequence)stockFsStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)stockFsStr, FilterCondition.class);
        this.setFilterGrid(C_stockfilterinfo, condition);
    }

    private void bindReserveFs() {
        String reserveFsStr = this.getModel().getDataEntity().getString("reservefilter");
        FilterCondition condition = null;
        condition = StringUtils.isBlank((CharSequence)reserveFsStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)reserveFsStr, FilterCondition.class);
        this.setFilterGrid(C_reservefilterinfo, condition);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave(e);
                break;
            }
        }
    }

    private void beforeSave(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        String reserveFs = this.parseReserveFs();
        model.setValue("reservefilter", (Object)reserveFs);
        String stockFs = this.parseStockFs();
        model.setValue("stockfilter", (Object)stockFs);
        String stockMatch = this.parse2Json(INV_COLS_NAME, "stockmatchentry");
        model.setValue("stockmatch", (Object)stockMatch);
        String stockSeq = this.parse2Json(STOCK_COLS_NAME, "stocksortentity");
        model.setValue("stockseq", (Object)stockSeq);
    }

    private String parse2Json(String[] colsName, String entryName) {
        int len = colsName.length;
        if (len == 0) {
            return null;
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryName);
        if (rows.isEmpty()) {
            return null;
        }
        JSONObject json = new JSONObject(colsName.length);
        JSONArray values = null;
        for (String col : colsName) {
            values = new JSONArray(rows.size());
            for (DynamicObject row : rows) {
                values.add((Object)row.getString(col));
            }
            json.put(col, (Object)values);
        }
        return json.toJSONString();
    }

    private String parseStockFs() {
        return this.getFilterGridCondition(C_stockfilterinfo);
    }

    private String getFilterGridCondition(String gridName) {
        FilterGrid grid = (FilterGrid)this.getControl(gridName);
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }

    private String parseReserveFs() {
        return this.getFilterGridCondition(C_reservefilterinfo);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "requirebill": {
                this.requireBillChanged();
                break;
            }
            case "isautoreserve": {
                this.autoReserveChanged();
                break;
            }
        }
    }

    private void autoReserveChanged() {
        this.setAutoReserveVisible();
    }

    protected void setAutoReserveVisible() {
        boolean isautoreserve = this.getModel().getDataEntity().getBoolean("isautoreserve");
        this.getView().setVisible(Boolean.valueOf(isautoreserve), new String[]{"autoreservemsg"});
        this.getView().setVisible(Boolean.valueOf(isautoreserve), new String[]{"stockseqap"});
    }

    private void requireBillChanged() {
        IDataModel model = this.getModel();
        model.setValue("requirestockdatename", null);
        model.setValue("requirestockdateno", null);
        model.setValue("requirestockorgname", null);
        model.setValue("requirestockorgno", null);
        model.setValue("billsetting", null);
        model.deleteEntryData("stockmatchentry");
        this.setCols4ReserveFilterGrid();
        this.setFilterGrid(C_reservefilterinfo, new FilterCondition());
    }

    protected void setFilterGrid(String gridName, FilterCondition condition) {
        FilterGrid reserveFilter = (FilterGrid)this.getControl(gridName);
        reserveFilter.SetValue(condition);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "requirestockdatename": {
                this.callBack4StockDate(e);
                break;
            }
            case "requirestockorgname": {
                this.callBack4StockOrg(e);
                break;
            }
            case "requirebillmatchname": {
                this.callBack4RequireBillMatch(e);
                break;
            }
            case "invaccountname": {
                this.callBack4InvAccount(e);
                break;
            }
            case "addsortcols": {
                this.callBack4AddSortCols(e);
                break;
            }
        }
    }

    private void callBack4AddSortCols(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        Set<String> exsistSortCols = this.getExsistSortCols();
        JSONObject info = null;
        for (int i = 0; i < data.size(); ++i) {
            info = data.getJSONObject(i);
            if (exsistSortCols.contains(info.getString("id"))) continue;
            int index = model.createNewEntryRow("stocksortentity");
            model.setValue("stocksortno", (Object)info.getString("id"), index);
            model.setValue("stocksortname", (Object)info.getString("text"), index);
        }
    }

    private void callBack4InvAccount(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        if ("org".equals(data.getJSONObject(0).getString("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u5728\u65b9\u6848\u4fe1\u606f\u4e2d\u5df2\u914d\u7f6e\uff0c\u5339\u914d\u6761\u4ef6\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e\u3002", (String)"ReserveSTEdit_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex("stockmatchentry");
        this.handleValue(index, "invaccountno", "invaccountname", data.getJSONObject(0));
    }

    private void callBack4RequireBillMatch(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex("stockmatchentry");
        this.handleValue(index, "requirebillmatchno", "requirebillmatchname", data.getJSONObject(0));
    }

    private void handleValue(int index, String id, String text, JSONObject info) {
        IDataModel model = this.getModel();
        model.setValue(id, (Object)info.getString("id"), index);
        model.setValue(text, (Object)info.getString("text"), index);
    }

    private void callBack4StockDate(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        this.handleValue("requirestockdateno", "requirestockdatename", data.getJSONObject(0));
    }

    private void handleValue(String id, String text, JSONObject info) {
        IDataModel model = this.getModel();
        model.setValue(id, (Object)info.getString("id"));
        model.setValue(text, (Object)info.getString("text"));
    }

    private void callBack4StockOrg(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        this.handleValue("requirestockorgno", "requirestockorgname", data.getJSONObject(0));
    }

    private Set<String> getExsistSortCols() {
        HashSet<String> sortCols = new HashSet<String>();
        DynamicObjectCollection sortList = this.getModel().getEntryEntity("stocksortentity");
        for (DynamicObject row : sortList) {
            sortCols.add(row.getString("stocksortno"));
        }
        return sortCols;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        IDataEntityProperty p = e.getProperty();
        switch (key = p.getName()) {
            case "requirebill": {
                this.beforeRequireBill(e);
                break;
            }
            case "billsetting": {
                this.beforeBillSetting(e);
                break;
            }
        }
    }

    private void beforeBillSetting(BeforeF7SelectEvent e) {
        DynamicObject requirebill = FormUtil.getAndCheckF7Value(this.getModel(), "requirebill");
        QFilter fs = new QFilter("requirebill", "=", requirebill.getPkValue());
        fs.and("reservebill", "=", (Object)"sbs_reservation");
        F7Utils.addF7Filter(e, fs);
    }

    private void beforeRequireBill(BeforeF7SelectEvent e) {
        QFilter fs = F7Utils.getMetaTypeFs("BillFormModel", "BaseFormModel");
        F7Utils.addF7Filter(e, fs);
    }

    private static class DateColStrategy
    extends DefaultSelectStrategy {
        private DateColStrategy() {
        }

        @Override
        public boolean filterPro(IDataEntityProperty pro) {
            return pro instanceof DateTimeProp;
        }

        @Override
        public Set<String> getNeedColsOfBaseData(String baseDataNo, BasedataProp basedataProp) {
            return Collections.EMPTY_SET;
        }
    }

    private static class OrgColStrategy
    extends DefaultSelectStrategy {
        private OrgColStrategy() {
        }

        @Override
        public boolean filterPro(IDataEntityProperty pro) {
            return pro instanceof OrgProp;
        }

        @Override
        public Set<String> getNeedColsOfBaseData(String baseDataNo, BasedataProp basedataProp) {
            return Collections.EMPTY_SET;
        }
    }
}

