/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.balanceinv;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.sbs.business.balanceinv.FilterConditionHelper;
import kd.scmc.sbs.constants.balanceinv.EntityFieldTypeEnum;

public class BalanceInvRegisterModelEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
CellClickListener {
    private static final String BUSINESSENTITY = "businessentity";
    private static final String OUTPUTTYPE = "outputtype";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SIGNID = "signid";
    private static final String SIGNNAME = "signname";
    private static final String DATATYPE = "datatype";
    private static final String MODELTYPE = "modeltype";
    private static final String DEMAND = "2";
    private static final String SUPPLY = "1";
    private static final String BILLFIELDMAP = "billfieldmap";
    private static final String SRCBILLDS = "srcbillds";
    private static final String FILTERDESCDS = "filterdescds";
    private static final String FILTERVALUEDS = "filtervalueds";
    private static final String ENTRYENTITYDS = "entryentityds";
    private static final String ISPRESET = "ispreset";
    private static final String NEWENTRY = "newentry";
    private static final String DELETEENTRY = "deleteentry";
    private static final String MOVEENTRYUP = "moveentryup";
    private static final String MOVEENTRYDOWN = "moveentrydown";
    private static final String ISENABLE = "isenable";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBaseDataF7Listener(BUSINESSENTITY, OUTPUTTYPE, BILLFIELDMAP);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITYDS);
        if (entryGrid != null) {
            entryGrid.addCellClickListener((CellClickListener)this);
        }
    }

    private void addBaseDataF7Listener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setHeadEnable();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection targetObjEntry = model.getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        MainEntityType dataEntityType = this.getMainEntityType(BUSINESSENTITY);
        for (int i = 0; i < targetObjEntry.size(); ++i) {
            DynamicObject targetObj = (DynamicObject)targetObjEntry.get(i);
            String[] signIds = targetObj.getString(SIGNID).split("\\.");
            String signId = signIds.length > 1 ? signIds[signIds.length - 1] : signIds[0];
            DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(signId);
            if (findProperty == null) continue;
            String signName = findProperty.getDisplayName().getLocaleValue();
            String signValue = signName.length() > 50 ? signName.substring(0, 47).concat("...") : signName;
            model.setValue(SIGNNAME, (Object)signValue, i);
            String dataType = BalanceInvRegisterModelEditPlugin.getMetaDataFieldType(findProperty);
            if (dataType == null) continue;
            String dataTypeValue = dataType.length() > 50 ? dataType.substring(0, 47).concat("...") : dataType;
            model.setValue(DATATYPE, (Object)dataTypeValue, i);
        }
        DynamicObjectCollection dataSourceConfig = model.getDataEntity(true).getDynamicObjectCollection(ENTRYENTITYDS);
        for (int i = 0; i < dataSourceConfig.size(); ++i) {
            DynamicObject dataSource = (DynamicObject)dataSourceConfig.get(i);
            String billNumber = dataSource.getDynamicObject(BILLFIELDMAP).getString("sourcebill.number");
            MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
            String filterValue = dataSource.getString(FILTERVALUEDS);
            if (!StringUtils.isNotEmpty((CharSequence)filterValue)) continue;
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterValue, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(billEntityType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            String value = scripts[1].length() >= 2000 ? scripts[1].substring(0, 1996).concat("...") : scripts[1];
            model.setValue(FILTERDESCDS, (Object)value, i);
        }
        model.setDataChanged(false);
    }

    private void setHeadEnable() {
        Object modelType = this.getModel().getValue(MODELTYPE);
        if (modelType == null) {
            return;
        }
        if (SUPPLY.equals(modelType.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{OUTPUTTYPE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{OUTPUTTYPE});
        }
        Object preset = this.getModel().getValue(ISPRESET);
        if (preset == null) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(!Boolean.parseBoolean(preset.toString())), new String[]{NEWENTRY, DELETEENTRY, MOVEENTRYDOWN, MOVEENTRYUP});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "businessentity": {
                this.beforeBusinessEntitySelect(e);
                break;
            }
            case "outputtype": {
                this.beforeOutputTypeSelect(e);
                break;
            }
            case "billfieldmap": {
                this.beforeBillFieldMap(e);
                break;
            }
        }
    }

    private void beforeBillFieldMap(BeforeF7SelectEvent e) {
        Object businessEntity = this.getModel().getValue(BUSINESSENTITY);
        if (businessEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u5b9e\u4f53\u3002", (String)"BalanceInvRegisterModelEditPlugin_6", (String)"scmc-sbs-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("targetobj", "=", (Object)((DynamicObject)businessEntity).getString("number"));
        qFilter.and(ISENABLE, "=", (Object)SUPPLY);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeOutputTypeSelect(BeforeF7SelectEvent e) {
        Object bizType = this.getModel().getValue("biztype");
        if (bizType != null && SUPPLY.equals(bizType.toString())) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("number", "in", (Object)"im_balanceinv_advice"));
        }
    }

    private void beforeBusinessEntitySelect(BeforeF7SelectEvent e) {
        Object modelType = this.getModel().getValue(MODELTYPE);
        if (modelType == null || modelType.toString().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u578b\u7c7b\u578b\u3002", (String)"BalanceInvRegisterModelEditPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = null;
        if (DEMAND.equals(modelType.toString())) {
            qFilter = new QFilter("number", "=", (Object)"balanceinv_demandbill");
        } else if (SUPPLY.equals(modelType.toString())) {
            qFilter = new QFilter("number", "=", (Object)"balanceinv_supplybill");
        }
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "businessentity": {
                this.queryMetaDataInfo(newValue, rowIndex);
                break;
            }
            case "billfieldmap": {
                this.changeBillFieldMap(newValue, rowIndex);
                break;
            }
            case "modeltype": {
                this.changeModelType(newValue, oldValue);
                break;
            }
        }
    }

    private void changeModelType(Object newValue, Object oldValue) {
        HashMap<String, Object> confirmParam = new HashMap<String, Object>();
        confirmParam.put("newVal", newValue);
        confirmParam.put("oldVal", oldValue);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6a21\u578b\u7c7b\u578b\u5c06\u6e05\u7a7a\u76ee\u6807\u5b9e\u4f53\u3001\u76ee\u6807\u5b9e\u4f53\u8be6\u60c5\u5206\u5f55\u3001\u6570\u636e\u6e90\u914d\u7f6e\u5206\u5f55\u7b49\u76f8\u5173\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"BalanceInvRegisterModelEditPlugin_7", (String)"scmc-sbs-form", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("changemodeltype"), null, SerializationUtils.toJsonString(confirmParam));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        IDataModel model = this.getModel();
        switch (callBackId = e.getCallBackId()) {
            case "changemodeltype": {
                Map paramMap = (Map)SerializationUtils.fromJsonString((String)e.getCustomVaule(), Map.class);
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    Object newValue = paramMap.get("newVal");
                    model.setValue(BUSINESSENTITY, null);
                    if (null == newValue) {
                        return;
                    }
                    if (SUPPLY.equals(newValue.toString())) {
                        model.setValue(OUTPUTTYPE, null);
                        this.getView().setVisible(Boolean.FALSE, new String[]{OUTPUTTYPE});
                        break;
                    }
                    if (!DEMAND.equals(newValue.toString())) break;
                    this.getView().setVisible(Boolean.TRUE, new String[]{OUTPUTTYPE});
                    break;
                }
                Object oldVal = paramMap.get("oldVal");
                model.beginInit();
                model.setValue(MODELTYPE, oldVal);
                model.endInit();
                this.getView().updateView(MODELTYPE);
                break;
            }
        }
    }

    private void changeBillFieldMap(Object newValue, int rowIndex) {
        if (newValue == null) {
            this.getModel().setValue(SRCBILLDS, null, rowIndex);
            this.getModel().setValue(FILTERDESCDS, null, rowIndex);
            return;
        }
        DynamicObject mapNumDy = (DynamicObject)newValue;
        DynamicObject srcBill = mapNumDy.getDynamicObject("sourcebill");
        this.getModel().setValue(SRCBILLDS, (Object)srcBill, rowIndex);
    }

    private void queryMetaDataInfo(Object newValue, int rowIndex) {
        Map allFields;
        DynamicObjectCollection dataSrcEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITYDS);
        for (DynamicObject srcEntry : dataSrcEntry) {
            srcEntry.set(BILLFIELDMAP, null);
            srcEntry.set(SRCBILLDS, null);
            srcEntry.set(FILTERDESCDS, null);
            srcEntry.set(FILTERVALUEDS, null);
        }
        this.getView().updateView(ENTRYENTITYDS);
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (newValue == null) {
            this.getView().updateView(ENTRYENTITY);
            return;
        }
        MainEntityType dataEntityType = this.getMainEntityType(BUSINESSENTITY);
        if (dataEntityType != null && (allFields = dataEntityType.getAllFields()) != null && allFields.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, allFields.size());
            int index = 0;
            this.getModel().beginInit();
            for (String field : allFields.keySet()) {
                this.buildRow(dataEntityType, index, field);
                ++index;
            }
            this.getModel().endInit();
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void buildRow(MainEntityType dataEntityType, int rowIndex, String signid) {
        DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(signid);
        this.getModel().setValue(SIGNID, (Object)signid, rowIndex);
        if (findProperty.getParent() instanceof EntryType) {
            EntryType entry = (EntryType)findProperty.getParent();
            this.getModel().setValue(SIGNID, (Object)(entry.getName() + '.' + signid), rowIndex);
        } else {
            this.getModel().setValue(SIGNID, (Object)signid, rowIndex);
        }
        LocaleString signName = findProperty.getDisplayName();
        this.getModel().setValue(SIGNNAME, (Object)signName, rowIndex);
        String dataType = BalanceInvRegisterModelEditPlugin.getMetaDataFieldType(findProperty);
        this.getModel().setValue(DATATYPE, (Object)dataType, rowIndex);
    }

    public static String getMetaDataFieldType(DynamicProperty dynamicProperty) {
        String typeName = null;
        if (dynamicProperty instanceof TimeProp) {
            typeName = EntityFieldTypeEnum.getName(TimeProp.class);
        } else if (dynamicProperty instanceof LargeTextProp) {
            typeName = EntityFieldTypeEnum.getName(LargeTextProp.class);
        } else if (dynamicProperty instanceof MuliLangTextProp) {
            typeName = EntityFieldTypeEnum.getName(MuliLangTextProp.class);
        } else if (dynamicProperty instanceof TextAreaProp) {
            typeName = EntityFieldTypeEnum.getName(TextAreaProp.class);
        } else if (dynamicProperty instanceof TextProp) {
            typeName = EntityFieldTypeEnum.getName(TextProp.class);
        } else if (dynamicProperty instanceof BigIntProp) {
            typeName = EntityFieldTypeEnum.getName(BigIntProp.class);
        } else if (dynamicProperty instanceof IntegerProp) {
            typeName = EntityFieldTypeEnum.getName(IntegerProp.class);
        } else if (dynamicProperty instanceof PriceProp) {
            typeName = EntityFieldTypeEnum.getName(PriceProp.class);
        } else if (dynamicProperty instanceof DateTimeProp) {
            typeName = EntityFieldTypeEnum.getName(DateTimeProp.class);
        } else if (dynamicProperty instanceof QtyProp) {
            typeName = EntityFieldTypeEnum.getName(QtyProp.class);
        } else if (dynamicProperty instanceof BooleanProp) {
            typeName = EntityFieldTypeEnum.getName(BooleanProp.class);
        } else if (dynamicProperty instanceof CreaterProp) {
            typeName = EntityFieldTypeEnum.getName(CreaterProp.class);
        } else if (dynamicProperty instanceof ModifierProp) {
            typeName = EntityFieldTypeEnum.getName(ModifierProp.class);
        } else if (dynamicProperty instanceof OrgProp) {
            typeName = EntityFieldTypeEnum.getName(OrgProp.class);
        } else if (dynamicProperty instanceof MainOrgProp) {
            typeName = EntityFieldTypeEnum.getName(MainOrgProp.class);
        } else if (dynamicProperty instanceof MaterielProp) {
            typeName = EntityFieldTypeEnum.getName(MaterielProp.class);
        } else if (dynamicProperty instanceof GroupProp) {
            typeName = EntityFieldTypeEnum.getName(GroupProp.class);
        } else if (dynamicProperty instanceof FlexProp) {
            typeName = EntityFieldTypeEnum.getName(FlexProp.class);
        } else if (dynamicProperty instanceof UserProp) {
            typeName = EntityFieldTypeEnum.getName(UserProp.class);
        } else if (dynamicProperty instanceof BasedataProp) {
            typeName = EntityFieldTypeEnum.getName(BasedataProp.class);
        } else if (dynamicProperty instanceof ItemClassTypeProp) {
            typeName = EntityFieldTypeEnum.getName(ItemClassTypeProp.class);
        } else if (dynamicProperty instanceof ComboProp) {
            typeName = EntityFieldTypeEnum.getName(ComboProp.class);
        }
        return typeName;
    }

    private MainEntityType getMainEntityType(String entityname) {
        DynamicObject accEntity = (DynamicObject)this.getModel().getValue(entityname);
        if (accEntity != null) {
            Object billEntityPkValue = accEntity.getPkValue();
            return MetadataServiceHelper.getDataEntityType((String)billEntityPkValue.toString());
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5c5e\u4e8e\u5b9e\u4f53F7\u7c7b\u578b\u7684\u5b57\u6bb5\u3002", (String)"BalanceInvRegisterModelEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]), entityname));
    }

    public void cellClick(CellClickEvent e) {
        String fieldKey = e.getFieldKey();
        int row = e.getRow();
        if (FILTERDESCDS.equals(fieldKey)) {
            DynamicObject billMap = (DynamicObject)this.getModel().getValue(BILLFIELDMAP, row);
            if (billMap == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u7f16\u7801\u201d\u3002", (String)"BalanceInvRegisterModelEditPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
                return;
            }
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            boolean isPreset = (Boolean)this.getModel().getValue(ISPRESET);
            if (isPreset || OperationStatus.VIEW.equals((Object)status)) {
                return;
            }
            this.openConditionSet(row, billMap);
        }
    }

    private void openConditionSet(int row, DynamicObject bill) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("balanceinv_conditionsetup");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "conditionsetcallback"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Object filterds = this.getModel().getValue(FILTERVALUEDS, row);
        if (bill != null) {
            String number = bill.getString("sourcebill.number");
            params.put("number", number);
        }
        params.put("filter", filterds);
        params.put("row", row);
        fsp.setCustomParams(params);
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map data;
        super.closedCallBack(event);
        if ("conditionsetcallback".equals(event.getActionId()) && (data = (Map)event.getReturnData()) != null) {
            String filter = (String)data.get("filter");
            String number = (String)data.get("number");
            int row = (Integer)data.get("row");
            String filterDesc = FilterConditionHelper.translateJsonString(filter, number);
            this.getModel().setValue(FILTERVALUEDS, (Object)filter, row);
            this.getModel().setValue(FILTERDESCDS, (Object)filterDesc, row);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

