/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.balanceinv;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.sbs.business.balanceinv.FilterConditionHelper;

public class BalanceInvSchemeEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBaseDataF7Listener("invlevel", "supplyrelation", "invstrategy", "demandmodel", "supplymodel", "mappingdimen", "autoputbotp", "demoutputbotp", "demandorg");
        this.addClickListeners(new String[]{"entrydemandname", "filtercondition", "demandfield", "supplyfield"});
        BalanceInvSchemeEditPlugin.showConvertRuleEdit(this.getView(), "autoputbotp");
        BalanceInvSchemeEditPlugin.showConvertRuleEdit(this.getView(), "demoutputbotp");
    }

    public static void showConvertRuleEdit(final IFormView view, String botpKey) {
        BasedataEdit botpIdEdit = (BasedataEdit)view.getControl(botpKey);
        if (botpIdEdit == null) {
            return;
        }
        botpIdEdit.addBeforeF7ViewDetailListener((Consumer)new Consumer<BeforeF7ViewDetailEvent>(){

            @Override
            public void accept(BeforeF7ViewDetailEvent t) {
                t.setCancel(true);
                Object pkId = t.getPkId();
                DynamicObject botpObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)"botp_crlist");
                String srcEntity = botpObj.getString("sourceentitynumber.number");
                String tgtEntity = botpObj.getString("targetentitynumber.number");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("botp_convertrule");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("SourceBill", (Object)srcEntity);
                showParameter.setCustomParam("TargetBill", (Object)tgtEntity);
                showParameter.setCustomParam("ruleId", pkId);
                showParameter.getCustomParams().put("checkRightAppId", "bpm");
                showParameter.setPageId(pkId + "_" + srcEntity + "_" + tgtEntity);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setAppId("sbs");
                showParameter.addCustPlugin("kd.scmc.sbs.formplugin.balanceinv.BalInvConvertRuleLockEditPlugin");
                view.showForm(showParameter);
            }
        });
    }

    private void addBaseDataF7Listener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "entrydemandname": {
                this.clickSrcCol();
                break;
            }
            case "filtercondition": {
                this.openConditionSet();
                break;
            }
            case "demandfield": {
                this.openFieldSelect("balanceinv_demandbill", "demandfield", "demandfieldkey");
                break;
            }
            case "supplyfield": {
                this.openFieldSelect("balanceinv_supplybill", "supplyfield", "supplyfieldkey");
                break;
            }
        }
    }

    private void openFieldSelect(String billEntity, String field, String fieldKey) {
        MainEntityType supplyEntityType = MetadataServiceHelper.getDataEntityType((String)billEntity);
        Set<String> supplyFields = this.getMappingField(billEntity);
        DynamicObjectCollection entries = this.getModel().getEntryEntity("matchentry");
        for (DynamicObject entry : entries) {
            String fieldName = entry.getString(fieldKey);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fieldName)) continue;
            String[] splitArr = fieldName.split("\\.");
            supplyFields.remove(splitArr[splitArr.length - 1]);
        }
        this.clickMatchCol(supplyEntityType, field, supplyFields);
    }

    private Set<String> getMappingField(String entityNum) {
        DynamicObject mappingDim = (DynamicObject)this.getModel().getValue("mappingdimen");
        HashSet<String> fields = new HashSet<String>();
        if (mappingDim != null) {
            DynamicObjectCollection colmaps = mappingDim.getDynamicObjectCollection("colsmap");
            String targetNum = mappingDim.getDynamicObject("targetobj").getString("id");
            String field = entityNum.equals(targetNum) ? "targetobjcol" : "sourcebillcol";
            for (DynamicObject colmap : colmaps) {
                String[] fieldArr = colmap.getString(field).split("\\.");
                fields.add(fieldArr[fieldArr.length - 1]);
            }
        }
        return fields;
    }

    private String getTargetField(String entityNum, String sourceField) {
        DynamicObject mappingDim = (DynamicObject)this.getModel().getValue("mappingdimen");
        String returnField = null;
        if (mappingDim != null) {
            String targetField;
            String field;
            DynamicObjectCollection colmaps = mappingDim.getDynamicObjectCollection("colsmap");
            String targetNum = mappingDim.getDynamicObject("targetobj").getString("id");
            if (entityNum.equals(targetNum)) {
                field = "targetobjcol";
                targetField = "sourcebillcol";
            } else {
                field = "sourcebillcol";
                targetField = "targetobjcol";
            }
            for (DynamicObject colmap : colmaps) {
                if (!sourceField.equals(colmap.get(field))) continue;
                returnField = colmap.getString(targetField);
            }
        }
        return returnField;
    }

    private void clickSrcCol() {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("dempriorityentry");
        MainEntityType srcEntityType = BalanceInvSchemeEditPlugin.getMainEntityType(model, index, "demandentity");
        PropTreeBuildOption ops = new PropTreeBuildOption();
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcEntityType, (PropTreeBuildOption)ops);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("dempriorityentry");
        HashSet<String> configed = new HashSet<String>(16);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry;
            String key;
            if (i == index || (key = (entry = (DynamicObject)entryEntity.get(i)).getString("entrydemandlogo")) == null || key.isEmpty()) continue;
            if (key.contains("entryentity")) {
                key = key.substring(key.indexOf(".") + 1);
            }
            configed.add(key);
        }
        this.removeTreeNode(srcBillNode, configed);
        this.showSelectFieldForm(srcBillNode, "entrydemandname");
    }

    private void clickMatchCol(MainEntityType entityType, String fieldName, Set cols) {
        PropTreeBuildOption ops = new PropTreeBuildOption();
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)entityType, (PropTreeBuildOption)ops);
        this.filterTreeNode(srcBillNode, cols);
        this.showSelectFieldForm(srcBillNode, fieldName);
    }

    private void filterTreeNode(TreeNode node, Set<String> field) {
        List children = node.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            boolean deleted = false;
            if (!field.contains(child.getId()) && (child.getChildren() == null || child.getChildren().isEmpty())) {
                deleted = true;
                iterator.remove();
            } else if (child.getChildren() != null && !child.getChildren().isEmpty()) {
                this.filterTreeNode(child, field);
            }
            if (deleted || field.contains(child.getId()) || child.getChildren() != null && !child.getChildren().isEmpty()) continue;
            iterator.remove();
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "entrydemandname": {
                this.callBackDemCol(actionId, (String)returnData);
                break;
            }
            case "conditionsetcallback": {
                this.callConditionSetup(returnData);
                break;
            }
            case "demandfield": {
                this.callDemandMatchField((String)returnData);
                break;
            }
            case "supplyfield": {
                this.callBackSupplyMatchField((String)returnData);
                break;
            }
        }
    }

    private void callBackSupplyMatchField(String returnData) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)returnData)) {
            return;
        }
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex("matchentry");
        String source = "balanceinv_supplybill";
        if (returnData.equals(source) || returnData.equals("entryentity")) {
            return;
        }
        MainEntityType sourceType = EntityMetadataCache.getDataEntityType((String)source);
        String supplyField = this.getFullCol(sourceType, returnData);
        model.setValue("supplyfieldkey", (Object)supplyField, row);
        model.setValue("supplyfield", (Object)this.getColName(sourceType, returnData), row);
        String demandField = this.getTargetField("balanceinv_supplybill", supplyField);
        model.setValue("demandfieldkey", (Object)demandField, row);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)demandField) && demandField != null) {
            String[] splitArr = demandField.split("\\.");
            String demandFieldName = this.getColName(EntityMetadataCache.getDataEntityType((String)"balanceinv_demandbill"), splitArr[splitArr.length - 1]);
            model.setValue("demandfield", (Object)demandFieldName, row);
        }
    }

    private void callDemandMatchField(String returnData) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)returnData)) {
            return;
        }
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex("matchentry");
        String source = "balanceinv_demandbill";
        if (returnData.equals(source) || returnData.equals("entryentity")) {
            return;
        }
        MainEntityType sourceType = EntityMetadataCache.getDataEntityType((String)source);
        String demandField = this.getFullCol(sourceType, returnData);
        String supplyField = this.getTargetField("balanceinv_demandbill", demandField);
        model.setValue("supplyfieldkey", (Object)supplyField, row);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)supplyField) && supplyField != null) {
            String[] splitArr = supplyField.split("\\.");
            String supplyFieldName = this.getColName(EntityMetadataCache.getDataEntityType((String)"balanceinv_supplybill"), splitArr[splitArr.length - 1]);
            model.setValue("supplyfield", (Object)supplyFieldName, row);
        }
        model.setValue("demandfieldkey", (Object)demandField, row);
        model.setValue("demandfield", (Object)this.getColName(sourceType, returnData), row);
    }

    private void callConditionSetup(Object returnData) {
        Map data = (Map)returnData;
        if (data != null) {
            String filter = (String)data.get("filter");
            String number = (String)data.get("number");
            int row = (Integer)data.get("row");
            String filterDesc = FilterConditionHelper.translateJsonString(filter, number);
            this.getModel().setValue("filtervalue", (Object)filter, row);
            this.getModel().setValue("filtercondition", (Object)filterDesc, row);
        }
    }

    private void callBackDemCol(String colFlag, String returnCol) {
        int row;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)returnCol)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject entity = (DynamicObject)model.getValue("demandentity", row = model.getEntryCurrentRowIndex("dempriorityentry"));
        String source = entity.getString("id");
        if (returnCol.equals(source) || returnCol.equals("billhead")) {
            return;
        }
        MainEntityType sourceType = EntityMetadataCache.getDataEntityType((String)source);
        model.setValue("entrydemandlogo", (Object)this.getFullCol(sourceType, returnCol), row);
        model.setValue("entrydemandname", (Object)this.getColName(sourceType, returnCol), row);
    }

    private String getFullCol(MainEntityType srcEntity, String col) {
        block3: {
            IDataEntityProperty pro;
            String simpleName = col;
            int index = col.indexOf(".");
            if (index > 0) {
                simpleName = col.substring(0, index);
            }
            if ((pro = srcEntity.findProperty(simpleName)) == null) {
                return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u3002", (String)"BalanceInvSchemeEditPlugin_6", (String)"scmc-sbs-form", (Object[])new Object[0]), col);
            }
            IDataEntityType parent = null;
            int count = 0;
            do {
                IDataEntityType iDataEntityType = parent = parent == null ? pro.getParent() : parent.getParent();
                if (parent instanceof MainEntityType) break block3;
                col = parent.getName() + "." + col;
                simpleName = parent.getName() + "." + simpleName;
            } while (++count <= 4);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u5faa\u73af\u89e3\u6790\u8d85\u8fc74\u5c42\uff0c\u4e0d\u80fd\u518d\u89e3\u6790\u3002", (String)"BalanceInvSchemeEditPlugin_7", (String)"scmc-sbs-form", (Object[])new Object[0]), col));
        }
        return col;
    }

    private String getColName(MainEntityType entity, String col) {
        if (kd.bos.util.StringUtils.isBlank((String)col)) {
            return null;
        }
        String[] proCols = col.split("\\.");
        IDataEntityProperty pro = entity.findProperty(proCols[0]);
        StringBuilder name = new StringBuilder(pro.getDisplayName().getLocaleValue());
        if (proCols.length > 1) {
            BasedataProp basePro = null;
            for (int i = 1; i < proCols.length && pro instanceof BasedataProp; ++i) {
                MainEntityType type;
                String subName = null;
                String propSubContent = proCols[i];
                subName = pro instanceof FlexProp ? ("id".equals(propSubContent) ? ResManager.loadKDString((String)"\u5185\u7801", (String)"BalanceInvSchemeEditPlugin_5", (String)"scmc-sbs-form", (Object[])new Object[0]) : propSubContent) : ((pro = (type = MetadataServiceHelper.getDataEntityType((String)(basePro = (BasedataProp)pro).getBaseEntityId())).findProperty(propSubContent)).getDisplayName() == null ? ("id".equals(pro.getName()) ? ResManager.loadKDString((String)"\u5185\u7801", (String)"BalanceInvSchemeEditPlugin_5", (String)"scmc-sbs-form", (Object[])new Object[0]) : "") : pro.getDisplayName().getLocaleValue());
                name.append('.').append(subName);
            }
        }
        return name.toString();
    }

    private void removeTreeNode(TreeNode node, Set<String> field) {
        List children = node.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            if ("billhead".equals(child.getId())) {
                iterator.remove();
            }
            if (field.contains(child.getId())) {
                iterator.remove();
                continue;
            }
            if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
            this.removeTreeNode(child, field);
        }
    }

    public static MainEntityType getMainEntityType(IDataModel model, int index, String fieldName) {
        Object entity = model.getValue(fieldName, index);
        if (entity == null) {
            IDataEntityProperty pro = model.getDataEntityType().findProperty(fieldName);
            String proName = pro.getDisplayName().getLocaleValue();
            throw new KDBizException(ResManager.loadKDString((String)"\u5148\u9009\u62e9{0}", (String)"BalanceInvSchemeEditPlugin_8", (String)"scmc-sbs-form", (Object[])new Object[]{proName}));
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)((DynamicObject)entity).getString("id"));
        if (type == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e{0}\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"BalanceInvSchemeEditPlugin_4", (String)"scmc-sbs-form", (Object[])new Object[]{fieldName}));
        }
        return type;
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setAutoPutEntryEnable();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setAutoPutEntryEnable();
    }

    private void setAutoPutEntryEnable() {
        DynamicObjectCollection autoPutEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("autoputparamentry");
        for (int i = 0; i < autoPutEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)autoPutEntry.get(i);
            Boolean autoPut = entry.getBoolean("autoput");
            this.getView().setEnable(autoPut, i, new String[]{"targetputbill", "autoputbotp", "targetbillop"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "invlevel": {
                this.beforeInvLevelSelect(e);
                break;
            }
            case "supplyrelation": 
            case "invstrategy": {
                this.beforeOrgParamSelect(e);
                break;
            }
            case "demandmodel": {
                this.beforeModelSelect(e, "2");
                break;
            }
            case "supplymodel": {
                this.beforeModelSelect(e, "1");
                break;
            }
            case "mappingdimen": {
                this.beforeMappingDimenSelect(e);
                break;
            }
            case "demoutputbotp": {
                this.beforeDemOutputBotpSelect(e);
                break;
            }
            case "autoputbotp": {
                this.beforeAutoPutBotp(e);
                break;
            }
            case "demandorg": {
                this.beforeDemandOrg(e);
                break;
            }
        }
    }

    private void beforeDemandOrg(BeforeF7SelectEvent e) {
        DynamicObject entity = this.getModel().getDataEntity(true);
        if (entity == null || entity.getDynamicObjectCollection("orgentryentity") == null) {
            return;
        }
        DynamicObjectCollection orgEntries = entity.getDynamicObjectCollection("orgentryentity");
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("orgentryentity");
        HashSet<Object> orgIds = new HashSet<Object>(orgEntries.size());
        for (int i = 0; i < orgEntries.size(); ++i) {
            DynamicObject orgEntry = (DynamicObject)orgEntries.get(i);
            DynamicObject invOrg = orgEntry.getDynamicObject("demandorg");
            if (invOrg == null || invOrg.getPkValue() == null || currentRowIndex == i) continue;
            orgIds.add(invOrg.getPkValue());
        }
        if (!orgIds.isEmpty()) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", orgIds));
        }
    }

    private void beforeAutoPutBotp(BeforeF7SelectEvent e) {
        int row = e.getRow();
        Object targetBill = this.getModel().getValue("targetputbill", row);
        Object outType = this.getModel().getValue("demoutputtype");
        if (targetBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u76ee\u6807\u5355\u636e\u201d\u3002", (String)"BalanceInvSchemeEditPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (outType == null) {
            e.setCancel(true);
            return;
        }
        DynamicObject outTypeDy = (DynamicObject)outType;
        DynamicObject targetBillDy = (DynamicObject)targetBill;
        QFilter qFilter = new QFilter("sourceentitynumber", "=", outTypeDy.getPkValue());
        qFilter.and("targetentitynumber", "=", targetBillDy.getPkValue());
        qFilter.and("enabled", "=", (Object)"1");
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeDemOutputBotpSelect(BeforeF7SelectEvent e) {
        int row = e.getRow();
        Object demandSrc = this.getModel().getValue("demandsrc", row);
        if (demandSrc == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7b2c%s\u884c\uff0c\u8bf7\u5148\u586b\u5199\u9700\u6c42\u6765\u6e90\u5b9e\u4f53\u3002", (String)"BalanceInvSchemeEditPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]), row + 1));
            e.setCancel(true);
            return;
        }
        Object outType = this.getModel().getValue("demoutputtype");
        DynamicObject outTypeDy = (DynamicObject)outType;
        DynamicObject demandSrcDy = (DynamicObject)demandSrc;
        if (outTypeDy == null) {
            e.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("sourceentitynumber", "=", demandSrcDy.getPkValue());
        qFilter.and("targetentitynumber", "=", outTypeDy.getPkValue());
        qFilter.and("enabled", "=", (Object)"1");
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeMappingDimenSelect(BeforeF7SelectEvent e) {
        String[] dimen = new String[]{"balanceinv_demandbill", "balanceinv_supplybill"};
        QFilter qFilter = new QFilter("bizapp", "=", (Object)"=9Q86DR2P+Q");
        qFilter.and("targetobj", "in", (Object)dimen);
        qFilter.and("sourcebill", "in", (Object)dimen);
        qFilter.and("isenable", "=", (Object)"1");
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeModelSelect(BeforeF7SelectEvent e, String modelType) {
        QFilter qFilter = new QFilter("modeltype", "=", (Object)modelType);
        qFilter.and("enable", "=", (Object)"1");
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeOrgParamSelect(BeforeF7SelectEvent e) {
        int row = e.getRow();
        Object value = this.getModel().getValue("demandorg", row);
        if (value == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u53c2\u6570\u7b2c%s\u884c\u7684\u201c\u9700\u6c42\u7ec4\u7ec7\u201d\u3002", (String)"BalanceInvSchemeEditPlugin_9", (String)"scmc-sbs-form", (Object[])new Object[0]), row + 1));
            e.setCancel(true);
            return;
        }
        DynamicObject demandOrg = (DynamicObject)value;
        QFilter qFilter = new QFilter("demandorgunit.id", "=", demandOrg.getPkValue());
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeInvLevelSelect(BeforeF7SelectEvent e) {
        Object balanceInvOrg = this.getModel().getValue("balanceinvorg");
        if (balanceInvOrg != null) {
            DynamicObject balanceInvOrgDy = (DynamicObject)balanceInvOrg;
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"msplan_invlevel", (Long)((Long)balanceInvOrgDy.getPkValue()));
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(baseDataFilter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5229\u5e93\u7ec4\u7ec7\u3002", (String)"BalanceInvSchemeEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "demandmodel": {
                this.changeDemandModel(oldValue, newValue, "demandsrcentry", "demandsrc", propName);
                break;
            }
            case "supplymodel": {
                this.changeDemandModel(oldValue, newValue, "supplysrcentry", "supplysrc", propName);
                break;
            }
            case "autoaudittarget": {
                this.changeAutoAudit(oldValue, newValue, rowIndex);
                break;
            }
            case "autoput": {
                this.changeAutoPut(oldValue, newValue, rowIndex);
                break;
            }
            case "demandorg": {
                this.changedDemandOrg(rowIndex);
                break;
            }
            case "targetputbill": {
                this.changedTargetPutBill(rowIndex);
                break;
            }
            case "entrydemandname": {
                this.changedEntryDemandName(rowIndex);
                break;
            }
            case "filtercondition": {
                this.changedFilterCondition(rowIndex);
                break;
            }
            case "demandfield": {
                if (newValue != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("demandfieldkey", null, rowIndex);
                break;
            }
            case "supplyfield": {
                if (newValue != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("supplyfieldkey", null, rowIndex);
                break;
            }
            case "mappingdimen": {
                if ((newValue == null || newValue.equals(oldValue)) && newValue != null) break;
                this.getModel().deleteEntryData("matchentry");
            }
        }
    }

    private void changedFilterCondition(int rowIndex) {
        IDataModel model = this.getModel();
        Object value = model.getValue("filtercondition");
        if (value == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value.toString())) {
            this.getModel().setValue("filtervalue", null, rowIndex);
        }
    }

    private void changedEntryDemandName(int rowIndex) {
        String val = (String)this.getModel().getValue("entrydemandname", rowIndex);
        if (StringUtils.isBlank((CharSequence)val)) {
            this.getModel().setValue("entrydemandlogo", null, rowIndex);
        }
    }

    private void changedTargetPutBill(int rowIndex) {
        this.getModel().setValue("autoputbotp", null, rowIndex);
    }

    private void changedDemandOrg(int rowIndex) {
        this.getModel().setValue("supplyrelation", null, rowIndex);
        this.getModel().setValue("invstrategy", null, rowIndex);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryKey;
        super.afterAddRow(e);
        switch (entryKey = e.getEntryProp().getName()) {
            case "autoputparamentry": {
                this.initEntry(e);
                break;
            }
            case "dempriorityentry": {
                this.addMappingRow(e);
                break;
            }
        }
    }

    private void initEntry(AfterAddRowEventArgs e) {
        RowDataEntity[] rows;
        for (RowDataEntity row : rows = e.getRowDataEntities()) {
            int rowIndex = row.getRowIndex();
            this.getModel().setValue("targetbillop", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"targetputbill", "autoputbotp", "targetbillop"});
        }
    }

    private void addMappingRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rows;
        for (RowDataEntity row : rows = e.getRowDataEntities()) {
            this.getModel().setValue("demandentity", (Object)"balanceinv_demandbill", row.getRowIndex());
        }
    }

    private void changeAutoPut(Object oldValue, Object newValue, int rowIndex) {
        if (newValue == null) {
            return;
        }
        if (Boolean.parseBoolean(newValue.toString())) {
            this.getModel().beginInit();
            this.getModel().setValue("autoaudittarget", (Object)true, rowIndex);
            this.getModel().endInit();
            this.getModel().setValue("targetbillop", (Object)Character.valueOf('A'), rowIndex);
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"targetputbill", "autoputbotp", "targetbillop"});
            this.getView().updateView("autoaudittarget", rowIndex);
        } else {
            this.getModel().setValue("targetputbill", null, rowIndex);
            this.getModel().setValue("autoputbotp", null, rowIndex);
            this.getModel().setValue("targetbillop", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"targetputbill", "autoputbotp", "targetbillop"});
        }
        this.getView().updateView("targetputbill", rowIndex);
        this.getView().updateView("autoputbotp", rowIndex);
        this.getView().updateView("targetbillop", rowIndex);
    }

    private void changeAutoAudit(Object oldValue, Object newValue, int rowIndex) {
        if (newValue == null) {
            return;
        }
        if (!Boolean.parseBoolean(newValue.toString())) {
            this.getModel().setValue("autoput", (Object)false, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"targetputbill", "autoputbotp"});
            this.getView().updateView("targetputbill", rowIndex);
            this.getView().updateView("autoputbotp", rowIndex);
        }
    }

    private void changeDemandModel(Object oldValue, Object newValue, String targetEntryKey, String propKey, String propName) {
        DynamicObjectCollection dataSrcCfg;
        EntryGrid dataSrcEntity = (EntryGrid)this.getView().getControl(targetEntryKey);
        HashMap<String, String> srcBillEntityNumToBotpId = new HashMap<String, String>(4);
        if ("demandmodel".equals(propName)) {
            this.cacheDemandEntryBotp(this.getModel().getEntryEntity(targetEntryKey), srcBillEntityNumToBotpId);
        }
        dataSrcEntity.getModel().deleteEntryData(targetEntryKey);
        if (newValue == null) {
            if ("demandmodel".equals(propName)) {
                this.getModel().setValue("demoutputtype", null);
            }
            return;
        }
        DynamicObject demandModel = (DynamicObject)newValue;
        if ("demandmodel".equals(propName)) {
            DynamicObject outputType = demandModel.getDynamicObject("outputtype");
            this.getModel().setValue("demoutputtype", (Object)outputType);
        }
        if ((dataSrcCfg = demandModel.getDynamicObjectCollection("entryentityds")).isEmpty()) {
            return;
        }
        int safeStockDsCount = (int)dataSrcCfg.stream().map(daraSrc -> daraSrc.getDynamicObject("srcbillds")).filter(srcBillType -> "invp_safestock_record".equals(srcBillType.get("id"))).count();
        this.batchCreateEntryRows(dataSrcEntity, targetEntryKey, dataSrcCfg.getRowCount() - safeStockDsCount);
        this.setEntryValue(dataSrcEntity, dataSrcCfg, propKey, srcBillEntityNumToBotpId);
    }

    private void cacheDemandEntryBotp(DynamicObjectCollection entryEntity, Map<String, String> srcBillEntityToBotpId) {
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        for (DynamicObject entry : entryEntity) {
            DynamicObject srcBill = entry.getDynamicObject("demandsrc");
            DynamicObject botp = entry.getDynamicObject("demoutputbotp");
            if (srcBill == null || botp == null) continue;
            String billEntityNum = srcBill.getString("number");
            String botpId = botp.getString("id");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billEntityNum) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)botpId)) continue;
            srcBillEntityToBotpId.put(billEntityNum, botpId);
        }
    }

    private void setEntryValue(EntryGrid dataSrcEntity, DynamicObjectCollection dataSrcCfg, String propKey, Map<String, String> srcBillEntityNumToBotpId) {
        int row = 0;
        for (DynamicObject dynamicObject : dataSrcCfg) {
            Object entityNum;
            DynamicObject srcBill = dynamicObject.getDynamicObject("srcbillds");
            if (srcBill == null || "invp_safestock_record".equals(entityNum = srcBill.get("id"))) continue;
            dataSrcEntity.getModel().setValue(propKey, (Object)srcBill, row);
            if (srcBillEntityNumToBotpId.containsKey(entityNum.toString())) {
                dataSrcEntity.getModel().setValue("demoutputbotp", (Object)srcBillEntityNumToBotpId.remove(entityNum.toString()), row);
            }
            ++row;
        }
    }

    private void batchCreateEntryRows(EntryGrid dataSrcEntity, String targetEntryKey, int rowCount) {
        int dataSrcEntityCount = this.getModel().getEntryRowCount(targetEntryKey);
        if (dataSrcEntityCount < rowCount) {
            dataSrcEntity.getModel().batchCreateNewEntryRow(targetEntryKey, rowCount - dataSrcEntityCount);
        }
    }

    private void openConditionSet() {
        int row = this.getModel().getEntryCurrentRowIndex("autoputparamentry");
        DynamicObject outputType = (DynamicObject)this.getModel().getValue("demoutputtype", row);
        if (outputType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8f93\u51fa\u7ed3\u679c\u7c7b\u578b\u201d\u3002", (String)"BalanceInvSchemeEditPlugin_10", (String)"scmc-sbs-form", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("balanceinv_conditionsetup");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "conditionsetcallback"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Object filterDs = this.getModel().getValue("filtervalue", row);
        String number = outputType.getString("number");
        params.put("number", number);
        params.put("filter", filterDs);
        params.put("row", row);
        fsp.setCustomParams(params);
        this.getView().showForm(fsp);
    }
}

