/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.balanceinv;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class InvSupplyPolicyEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String INVTYPE = "invtype";
    private static final String INVSTATUS = "invstatus";
    private static final String INVTYPE_ENTRY = "invtypeentry";
    private static final String INVSTATUS_ENTRY = "invstatusentry";
    private static final String PRIORITY = "priority";
    private static final String SUPPLY_PRIORITY = "supplypriority";
    private static final String WAREHOUSE_ENTRY = "warehouseentry";
    private static final String ADDSETUPENTRY = "addsetup";
    private static final String DELETESETUPENTRY = "deletesetup";
    private static final String ORGENTITY = "orgentity";
    private static final String ORG = "org";
    private static final String WAREHOUSE_INVORG = "warehouseinvorg";
    private static final String INVORG = "invorg";
    private static final String WAREHOUSE = "warehouse";
    private static final String WAREHOUSEINVORG = "warehouseinvorg";
    private static final String PREFIX = ".";
    private static final String ID = "id";
    private static final String LOCATION = "location";
    private static final String ALLLOCATION = "isalllocation";
    private static final String WAREHOUSEADDR = "warehouseaddr";
    private static final String WAREHOUSE_SETUP_GROUP = "warehousesetup";
    private static final String WAREHOUSE_SETUP_GROUP_All = "1";
    private static final String WAREHOUSE_SETUP_GROUP_NONE = "3";
    private static final String DELETE_SETUP = "deletesetup";
    private static final String ADD_SETUP = "addsetup";
    private static final String DELETEORGENTRY = "deleteorgentry";
    private static final String ISSTATUSCAL = "isstatuscal";
    private static final String INVSTATUSPRIORITY = "invstatuspriority";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit invType = (BasedataEdit)this.getControl(INVTYPE);
        invType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit invStatus = (BasedataEdit)this.getControl(INVSTATUS);
        invStatus.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit warehouseInvOrg = (BasedataEdit)this.getControl("warehouseinvorg");
        warehouseInvOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit warehouse = (BasedataEdit)this.getControl(WAREHOUSE);
        warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit location = (BasedataEdit)this.getControl(LOCATION);
        location.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit invOrg = (BasedataEdit)this.getControl(INVORG);
        invOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{DELETEORGENTRY});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.getView().setVisible(Boolean.valueOf(!OperationStatus.ADDNEW.equals((Object)status)), new String[]{"bar_delete"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setEntryEnable();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setEntryEnable();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "save": {
                if (e.getOperationResult().isSuccess() && OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_delete"});
                }
                this.setEntryEnable();
                break;
            }
        }
    }

    private void setEntryEnable() {
        Object groupButton = this.getModel().getValue(WAREHOUSE_SETUP_GROUP);
        boolean equals = WAREHOUSE_SETUP_GROUP_All.equals(groupButton.toString());
        this.getView().setEnable(Boolean.valueOf(!equals), new String[]{"deletesetup", "addsetup"});
        DynamicObjectCollection whSetupEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(WAREHOUSE_ENTRY);
        for (int i = 0; i < whSetupEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)whSetupEntry.get(i);
            DynamicObject warehouse = entry.getDynamicObject(WAREHOUSE);
            if (warehouse == null) continue;
            boolean allLocation = entry.getBoolean(ALLLOCATION);
            boolean isOpenLocation = warehouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isOpenLocation), i, new String[]{ALLLOCATION});
            if (allLocation || !isOpenLocation) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{LOCATION});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, i, new String[]{LOCATION});
        }
        DynamicObjectCollection invStatusEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(INVSTATUS_ENTRY);
        for (int i = 0; i < invStatusEntry.size(); ++i) {
            DynamicObject statusEntry = (DynamicObject)invStatusEntry.get(i);
            this.getView().setEnable(Boolean.valueOf(statusEntry.getBoolean(ISSTATUSCAL)), i, new String[]{INVSTATUSPRIORITY});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "invtype": {
                this.beforeInvSelect(e, INVTYPE, INVTYPE_ENTRY);
                break;
            }
            case "invstatus": {
                this.beforeInvSelect(e, INVSTATUS, INVSTATUS_ENTRY);
                break;
            }
            case "warehouseinvorg": {
                this.beforeWhInvOrgSelect(e);
                break;
            }
            case "warehouse": {
                this.beforeWarehouseSelect(e);
                break;
            }
            case "location": {
                this.beforeLocationSelect(e);
                break;
            }
            case "invorg": {
                this.beforeInvOrgSelect(e);
                break;
            }
        }
    }

    private void beforeInvOrgSelect(BeforeF7SelectEvent e) {
        DynamicObject entity = this.getModel().getDataEntity(true);
        if (entity == null) {
            return;
        }
        DynamicObjectCollection orgEntries = entity.getDynamicObjectCollection(ORGENTITY);
        if (orgEntries == null || orgEntries.isEmpty()) {
            return;
        }
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ORGENTITY);
        HashSet<Object> orgIds = new HashSet<Object>(orgEntries.size());
        for (int i = 0; i < orgEntries.size(); ++i) {
            DynamicObject orgEntry = (DynamicObject)orgEntries.get(i);
            DynamicObject invOrg = orgEntry.getDynamicObject(INVORG);
            if (invOrg == null || invOrg.getPkValue() == null || currentRowIndex == i) continue;
            orgIds.add(invOrg.getPkValue());
        }
        if (!orgIds.isEmpty()) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(new QFilter(ID, "not in", orgIds));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "warehouse": {
                this.changeWarehouse(newValue, oldValue, rowIndex);
                break;
            }
            case "warehousesetup": {
                this.changeWarehouseSetupGroup(oldValue, newValue);
                break;
            }
            case "warehouseinvorg": {
                this.changeWarehouseInvOrg(rowIndex);
                break;
            }
            case "isalllocation": {
                this.changeAllLocation(newValue, rowIndex);
                break;
            }
            case "isstatuscal": {
                this.changeIsStatusCal(newValue, rowIndex);
                break;
            }
        }
    }

    private void changeIsStatusCal(Object newValue, int rowIndex) {
        boolean isCal = Boolean.parseBoolean(newValue.toString());
        if (!isCal) {
            this.getModel().setValue(INVSTATUSPRIORITY, null, rowIndex);
            this.getView().updateView(INVSTATUSPRIORITY, rowIndex);
        }
        this.getView().setEnable(Boolean.valueOf(isCal), rowIndex, new String[]{INVSTATUSPRIORITY});
    }

    private void changeAllLocation(Object newValue, int rowIndex) {
        if (newValue == null) {
            return;
        }
        boolean allLocation = (Boolean)newValue;
        if (allLocation) {
            this.getModel().setValue(LOCATION, null, rowIndex);
        }
        this.getView().setEnable(Boolean.valueOf(!allLocation), rowIndex, new String[]{LOCATION});
    }

    private void changeWarehouseInvOrg(int rowIndex) {
        this.getModel().setValue(WAREHOUSE, null, rowIndex);
        this.getModel().setValue(LOCATION, null, rowIndex);
        this.getModel().setValue(WAREHOUSEADDR, null, rowIndex);
    }

    private void changeWarehouseSetupGroup(Object oldValue, Object newValue) {
        if (WAREHOUSE_SETUP_GROUP_All.equals(newValue)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(WAREHOUSE_ENTRY);
            if (!entryEntity.isEmpty()) {
                ConfirmCallBackListener cb = new ConfirmCallBackListener("clearWarehouseSetupEntry", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e3a\u201c\u5168\u90e8\u4ed3\u5e93\u201d\u5c06\u6e05\u9664\u5f53\u524d\u4ed3\u5e93\u8bbe\u7f6e\u5206\u5f55\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"InvSupplyPolicyEditPlugin_3", (String)"scmc-sbs-form", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, oldValue == null ? "" : oldValue.toString());
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{WAREHOUSE_ENTRY, "addsetup", "deletesetup", "deletesetup", "addsetup"});
            }
        } else {
            if (WAREHOUSE_SETUP_GROUP_NONE.equals(newValue)) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(WAREHOUSE_ENTRY);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    this.getModel().setValue(SUPPLY_PRIORITY, null, i);
                }
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{WAREHOUSE_ENTRY, "addsetup", "deletesetup", "deletesetup", "addsetup"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        String callBackId = e.getCallBackId();
        if ("clearWarehouseSetupEntry".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{WAREHOUSE_ENTRY, "addsetup", "deletesetup", "deletesetup", "addsetup"});
                EntryGrid whSetupEntity = (EntryGrid)this.getView().getControl(WAREHOUSE_ENTRY);
                whSetupEntity.getModel().deleteEntryData(WAREHOUSE_ENTRY);
            } else {
                this.getModel().setValue(WAREHOUSE_SETUP_GROUP, (Object)e.getCustomVaule());
            }
        }
    }

    private void changeWarehouse(Object newValue, Object oldValue, int rowIndex) {
        this.getModel().setValue(LOCATION, null, rowIndex);
        this.getModel().setValue(WAREHOUSEADDR, null, rowIndex);
        this.getModel().setValue(ALLLOCATION, (Object)"0", rowIndex);
        if (newValue == null) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{LOCATION, ALLLOCATION});
            return;
        }
        DynamicObject warehouse = (DynamicObject)newValue;
        boolean isOenLocation = warehouse.getBoolean("isopenlocation");
        this.getView().setEnable(Boolean.valueOf(isOenLocation), rowIndex, new String[]{LOCATION, ALLLOCATION});
        Object address = warehouse.get("detailaddress");
        this.getModel().setValue(WAREHOUSEADDR, address, rowIndex);
    }

    private void beforeLocationSelect(BeforeF7SelectEvent e) {
        int idx = e.getRow();
        Object whOrgObj = this.getModel().getValue("warehouseinvorg", idx);
        if (whOrgObj == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%s\u884c\uff0c\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InvSupplyPolicyEditPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]), idx + 1));
            e.setCancel(true);
            return;
        }
        Object warehouseObj = this.getModel().getValue(WAREHOUSE, idx);
        if (warehouseObj == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%s\u884c\uff0c\u8bf7\u5148\u9009\u62e9\u4ed3\u5e93\u3002", (String)"InvSupplyPolicyEditPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]), idx + 1));
            e.setCancel(true);
            return;
        }
        DynamicObject whOrg = (DynamicObject)whOrgObj;
        DynamicObject warehouse = (DynamicObject)warehouseObj;
        DynamicObjectCollection whEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(WAREHOUSE_ENTRY);
        HashSet<Object> removeIds = new HashSet<Object>(whEntry.size());
        for (int i = 0; i < whEntry.size(); ++i) {
            if (i == idx) continue;
            DynamicObject entry = (DynamicObject)whEntry.get(i);
            DynamicObject entryWhOrg = entry.getDynamicObject("warehouseinvorg");
            DynamicObject entryWarehouse = entry.getDynamicObject(WAREHOUSE);
            DynamicObject entryLocation = entry.getDynamicObject(LOCATION);
            if (entryWhOrg == null || entryWarehouse == null || entryLocation == null || !entryWarehouse.getPkValue().equals(warehouse.getPkValue()) || !entryWhOrg.getPkValue().equals(whOrg.getPkValue())) continue;
            removeIds.add(entryLocation.getPkValue());
        }
        DynamicObjectCollection locationEntry = warehouse.getDynamicObjectCollection("entryentity");
        HashSet<Object> locationIds = new HashSet<Object>(4);
        for (DynamicObject entry : locationEntry) {
            if (entry == null || entry.get(LOCATION) == null) continue;
            locationIds.add(entry.get("location.id"));
        }
        locationIds.removeAll(removeIds);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(new QFilter(ID, "in", locationIds));
    }

    private void beforeWarehouseSelect(BeforeF7SelectEvent e) {
        int idx = e.getRow();
        Object orgVal = this.getModel().getValue("warehouseinvorg", idx);
        if (orgVal == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%s\u884c\uff0c\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InvSupplyPolicyEditPlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]), idx + 1));
            e.setCancel(true);
            return;
        }
        DynamicObject invOrg = (DynamicObject)orgVal;
        QFilter filter = new QFilter(ORG, "=", invOrg.getPkValue()).and("startstatus", "=", (Object)"B");
        DataSet invStarts = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_invstart", (String)"warehouse.id", (QFilter[])filter.toArray(), null);
        HashSet<Long> whIds = new HashSet<Long>(16);
        while (invStarts.hasNext()) {
            Row invStart = invStarts.next();
            whIds.add(invStart.getLong("warehouse.id"));
        }
        DynamicObjectCollection whsEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(WAREHOUSE_ENTRY);
        HashSet<Object> excludedEntryWhs = new HashSet<Object>(whsEntry.size());
        for (int i = 0; i < whsEntry.size(); ++i) {
            boolean openLocation;
            DynamicObject wh;
            DynamicObject entry;
            DynamicObject org;
            if (i == idx || (org = (entry = (DynamicObject)whsEntry.get(i)).getDynamicObject("warehouseinvorg")) == null || org.getPkValue() != invOrg.getPkValue() || (wh = entry.getDynamicObject(WAREHOUSE)) == null || (openLocation = wh.getBoolean("isopenlocation"))) continue;
            excludedEntryWhs.add(wh.getPkValue());
        }
        whIds.removeAll(excludedEntryWhs);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(new QFilter(ID, "in", whIds));
    }

    private void beforeWhInvOrgSelect(BeforeF7SelectEvent e) {
        DynamicObjectCollection orgEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ORGENTITY);
        HashSet<Long> orgs = new HashSet<Long>(4);
        for (DynamicObject orgEntry : orgEntries) {
            if (orgEntry.get(INVORG) == null) continue;
            orgs.add(orgEntry.getDynamicObject(INVORG).getLong(ID));
        }
        if (orgs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5e93\u5b58\u7ec4\u7ec7\u201d\u3002", (String)"InvSupplyPolicyEditPlugin_6", (String)"scmc-sbs-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter(ID, "in", orgs);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeInvSelect(BeforeF7SelectEvent e, String propKey, String entryKey) {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
        HashSet<Object> invTypeIds = new HashSet<Object>(4);
        for (DynamicObject entry : entries) {
            DynamicObject invType;
            if (entry == null || entry.get(propKey) == null || (invType = entry.getDynamicObject(propKey)) == null) continue;
            invTypeIds.add(invType.getPkValue());
        }
        QFilter qFilter = new QFilter(ID, "not in", invTypeIds);
        qFilter.and("enable", "=", (Object)WAREHOUSE_SETUP_GROUP_All);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        super.beforeFieldPostBack(e);
        switch (key = e.getKey()) {
            case "priority": {
                this.validateInput(e, PRIORITY, ORGENTITY);
                break;
            }
            case "supplypriority": {
                this.validateInput(e, SUPPLY_PRIORITY, WAREHOUSE_ENTRY);
                break;
            }
            case "invstatuspriority": {
                this.validateInput(e, INVSTATUSPRIORITY, INVSTATUS_ENTRY);
                break;
            }
        }
    }

    private void validateInput(BeforeFieldPostBackEvent e, String propKey, String entryKey) {
        Object value = e.getValue();
        if (value == null) {
            return;
        }
        int rowIndex = e.getRowIndex();
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
        HashSet<Long> priorities = new HashSet<Long>(4);
        for (DynamicObject entry : entries) {
            if (entry == null || entry.get(propKey) == null) continue;
            priorities.add(entry.getLong(propKey));
        }
        if (priorities.contains(Long.valueOf(value.toString()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u8d27\u4f18\u5148\u7ea7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"InvSupplyPolicyEditPlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
            this.getView().updateView(propKey, rowIndex);
            e.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setEntryEnable();
    }

    private void batchCreateEntryRows(EntryGrid statusgrid, EntryGrid typegrid, DataSet invType, DataSet invStatus) {
        int statusSize = this.getModel().getEntryRowCount(INVSTATUS_ENTRY);
        int typeSize = this.getModel().getEntryRowCount(INVTYPE_ENTRY);
        int invTypeCount = invType.copy().count(ID, true);
        int invStatusCount = invStatus.copy().count(ID, true);
        if (statusSize < invStatusCount) {
            statusgrid.getModel().batchCreateNewEntryRow(INVSTATUS_ENTRY, invStatusCount - statusSize);
        }
        if (typeSize < invTypeCount) {
            typegrid.getModel().batchCreateNewEntryRow(INVTYPE_ENTRY, invTypeCount - typeSize);
        }
    }

    private void setEntryValue(EntryGrid statusgrid, EntryGrid typegrid, DataSet invType, DataSet invStatus) {
        this.setEntryGridValue(statusgrid, INVTYPE, invType);
        this.setEntryGridValue(typegrid, INVSTATUS, invStatus);
        statusgrid.setPageIndex(1);
        typegrid.setPageIndex(1);
    }

    private void setEntryGridValue(EntryGrid grid, String columnNum, DataSet collection) {
        int row = 0;
        while (collection.hasNext()) {
            Object id = collection.next().get(ID);
            grid.getModel().setValue(columnNum, id, row++);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryKey = e.getEntryProp().getName();
        if (WAREHOUSE_ENTRY.equals(entryKey)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            this.getModel().setValue(SUPPLY_PRIORITY, null, rowDataEntities[0].getRowIndex());
            this.getView().setEnable(Boolean.valueOf(false), rowDataEntities[0].getRowIndex(), new String[]{ALLLOCATION, LOCATION});
            int insertRow = e.getInsertRow();
            if (insertRow < 1) {
                return;
            }
            Object parentOrgVal = this.getModel().getValue("warehouseinvorg", insertRow - 1);
            Object whVal = this.getModel().getValue(WAREHOUSE, insertRow - 1);
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int insertRowIndex = rowDataEntity.getRowIndex();
                if (this.getModel().getValue(WAREHOUSE, insertRowIndex) == null) {
                    this.getModel().setValue(WAREHOUSE, whVal, insertRowIndex);
                }
                this.getModel().beginInit();
                this.getModel().setValue("warehouseinvorg", parentOrgVal, insertRowIndex);
                this.getModel().endInit();
                this.getView().updateView("warehouseinvorg", insertRowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "deleteorgentry": {
                this.validateDeleteRow(args);
                break;
            }
        }
    }

    private void validateDeleteRow(BeforeDoOperationEventArgs args) {
        int[] selectRows = ((EntryGrid)this.getView().getControl(ORGENTITY)).getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int selectRow : selectRows) {
            DynamicObject invOrgDy;
            String msg;
            Object invOrg = this.getModel().getValue(INVORG, selectRow);
            if (invOrg == null || StringUtils.isEmpty((CharSequence)(msg = this.validateUsage(selectRow, invOrgDy = (DynamicObject)invOrg)))) continue;
            sb.append(msg);
        }
        if (!sb.toString().isEmpty()) {
            this.getView().showTipNotification(sb.toString());
            args.setCancel(true);
        }
    }

    private String validateUsage(int selectRow, DynamicObject invOrg) {
        DynamicObjectCollection whEntry = this.getModel().getEntryEntity(WAREHOUSE_ENTRY);
        long invOrgPk = invOrg.getLong(ID);
        String msg = "";
        for (DynamicObject entry : whEntry) {
            DynamicObject whOrg = entry.getDynamicObject("warehouseinvorg");
            if (invOrgPk != whOrg.getLong(ID)) continue;
            msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u5e93\u5b58\u7ec4\u7ec7\u201c%2$s\u201d\u8bbe\u7f6e\u4e86\u4ed3\u5e93\u5206\u5f55\u884c\uff0c\u8bf7\u5148\u6e05\u9664\u5bf9\u5e94\u7684\u4ed3\u5e93\u5206\u5f55\u884c\u3002\n", (String)"InvSupplyPolicyEditPlugin_7", (String)"scmc-sbs-form", (Object[])new Object[0]), selectRow + 1, invOrg.getLocaleString("name"));
        }
        return msg;
    }
}

