/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.sn;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.sbs.lang.SNLang;

public class ImportSNPlugin
extends AbstractFormPlugin
implements UploadListener {
    public static final String BD_MATERIALINVENTORYINFO = "bd_materialinventoryinfo";
    public static final String ENABLESERIAL = "enableserial";
    private static final Log logger = LogFactory.getLog(ImportSNPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"downloadtpl"});
        this.addClickListeners(new String[]{"btnok"});
        Button uploaddata = (Button)this.getControl("uploaddata");
        uploaddata.addUploadListener((UploadListener)this);
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        String formId = (String)customParams.get("formId");
        Boolean isimportline = (Boolean)model.getValue("isimportline");
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "downloadtpl": {
                this.downExcelTpl(isimportline);
                break;
            }
            case "btnok": {
                if ("sbs_snsupplement".equals(formId)) {
                    this.returnImportSnResult();
                    break;
                }
                this.handleBtnokEvent(model);
                break;
            }
        }
    }

    private void returnImportSnResult() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection import_entryentity = this.getModel().getEntryEntity("entryentity");
        int count = import_entryentity.size();
        RowMeta snRowMeta = new RowMeta(new Field[]{new Field("sn", (DataType)DataType.StringType), new Field("note", (DataType)DataType.StringType)});
        DataSetBuilder snRowMetaDsBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(snRowMeta);
        LinkedList<String> snList = new LinkedList<String>();
        if (count == 0) {
            this.getView().returnDataToParent((Object)SNLang.importInfoIsEmpty());
            return;
        }
        for (DynamicObject dynamicObject : import_entryentity) {
            String sn = dynamicObject.getString("sn");
            String note = dynamicObject.getString("note");
            snRowMetaDsBuilder.append(new Object[]{sn, note});
            snList.add(dynamicObject.getString("sn"));
        }
        DataSet build = snRowMetaDsBuilder.build();
        QFilter qfs = new QFilter("number", "in", snList);
        QFilter qfsMaterial = new QFilter("material.id", "=", customParams.get("material"));
        DataSet snMainDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_snmainfile", (String)"number,invorg", (QFilter[])qfs.and(qfsMaterial).toArray(), null);
        DataSet on = build.leftJoin(snMainDataSet).on("sn", "number").select(new String[]{"sn", "note"}, new String[]{"invorg"}).finish();
        this.getView().returnDataToParent((Object)on);
        this.getView().close();
    }

    private void handleBtnokEvent(IDataModel model) {
        Boolean isimportbill = (Boolean)model.getValue("isimportbill");
        if (!isimportbill.booleanValue()) {
            this.importOneEntrySn(model);
        } else {
            this.importAllEntrySn(model);
        }
    }

    private void importOneEntrySn(IDataModel model) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject sbs_billsnrelation = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"sbs_billsnrelation"));
        sbs_billsnrelation.set("billtype", customParams.get("billtype"));
        sbs_billsnrelation.set("unit", customParams.get("unit"));
        sbs_billsnrelation.set("material", customParams.get("material"));
        sbs_billsnrelation.set("billid", customParams.get("billid"));
        sbs_billsnrelation.set("qty", customParams.get("qty"));
        sbs_billsnrelation.set("entryid", customParams.get("entryid"));
        sbs_billsnrelation.set("entrykey", customParams.get("entrykey"));
        Object org = customParams.get("invorg");
        DynamicObjectCollection sbs_billsnrelation_entryentity = sbs_billsnrelation.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection import_entryentity = model.getEntryEntity("entryentity");
        int count = import_entryentity.size();
        if (count == 0) {
            this.getView().showTipNotification(SNLang.importInfoIsEmpty());
            return;
        }
        BigDecimal qty = sbs_billsnrelation.getBigDecimal("qty");
        if (qty != null && qty.compareTo(new BigDecimal(count)) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u6570\u91cf[{0}]\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7269\u6599\u6570\u91cf[{1}]\u3002", (String)"SBS-W-027536", (String)"scmc-sbs-form", (Object[])new Object[]{count, qty}));
            return;
        }
        if (customParams.get("billsnrelationid") == null) {
            for (int i = 0; i < count; ++i) {
                DynamicObject newEntryEntity = sbs_billsnrelation_entryentity.addNew();
                newEntryEntity.set("snnumber", ((DynamicObject)import_entryentity.get(i)).get("sn"));
                newEntryEntity.set("invorg", org);
                newEntryEntity.set("handlestatus", (Object)"A");
                newEntryEntity.set("remark", ((DynamicObject)import_entryentity.get(i)).get("note"));
                newEntryEntity.set("seq", (Object)(i + 1));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sbs_billsnrelation});
            this.getView().returnDataToParent((Object)SNLang.importSuccess());
            this.getView().close();
        } else {
            ArrayList<SqlParameter[]> sbsBillSqnrelationEDataList = new ArrayList<SqlParameter[]>(count);
            long billsnrelationid = (Long)customParams.get("billsnrelationid");
            DataSet sbs_relation = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sbs_billsnrelation", (String)"max(entryentity.seq)", (QFilter[])new QFilter("id", "=", (Object)billsnrelationid).toArray(), null);
            Object maxSeq = sbs_relation.next().get(0);
            int maxSeqInt = 0;
            if (maxSeq instanceof BigDecimal) {
                maxSeqInt = ((BigDecimal)maxSeq).intValue();
            } else if (maxSeq instanceof Long) {
                maxSeqInt = ((Long)maxSeq).intValue();
            }
            long[] fentryIds = DB.genLongIds((String)"t_sbs_billsqnrelation_e", (int)count);
            for (int i = 0; i < count; ++i) {
                ArrayList<SqlParameter> sqlParam = new ArrayList<SqlParameter>(7);
                sqlParam.add(new SqlParameter(-5, (Object)billsnrelationid));
                sqlParam.add(new SqlParameter(-5, (Object)fentryIds[i]));
                sqlParam.add(new SqlParameter(-5, (Object)(++maxSeqInt)));
                sqlParam.add(new SqlParameter(-9, ((DynamicObject)import_entryentity.get(i)).get("sn")));
                sqlParam.add(new SqlParameter(-5, org));
                sqlParam.add(new SqlParameter(-9, ((DynamicObject)import_entryentity.get(i)).get("note")));
                sqlParam.add(new SqlParameter(-9, (Object)"A"));
                sbsBillSqnrelationEDataList.add(sqlParam.toArray(new SqlParameter[sqlParam.size()]));
            }
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)this.getSbsBillSqnrelationESql(), sbsBillSqnrelationEDataList);
            this.getView().returnDataToParent((Object)SNLang.importSuccess());
            this.getView().close();
        }
    }

    private void importAllEntrySn(IDataModel model) {
        DynamicObjectCollection parentModelEntryEntity;
        IDataModel parentModel = this.getView().getParentView().getModel();
        String billtype = parentModel.getDataEntityType().getName();
        DynamicObject bill = parentModel.getDataEntity();
        String entryKey = (String)this.getView().getFormShowParameter().getCustomParam("entrykey");
        if (StringUtils.isBlank((CharSequence)entryKey)) {
            entryKey = "billentry";
        }
        if ((parentModelEntryEntity = parentModel.getEntryEntity(entryKey)).size() == 0) {
            return;
        }
        try {
            this.checkMaterialEnableSn(billtype, bill, entryKey);
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u542f\u7528\u5e8f\u5217\u53f7\u5931\u8d25", (Throwable)e);
        }
        Long parentBillId = (Long)parentModel.getDataEntity().getPkValue();
        DynamicObject org = ImportSNPlugin.getBillMainOrg(bill, billtype);
        HashMap<Long, List<Map<String, Object>>> allEntrySerials = new HashMap<Long, List<Map<String, Object>>>(parentModelEntryEntity.size());
        for (DynamicObject parentEntry : parentModelEntryEntity) {
            long entryid = (Long)parentEntry.getPkValue();
            if (entryid <= 0L) continue;
            Integer seq = parentEntry.getInt("seq");
            ArrayList serialList = new ArrayList(1);
            HashMap<String, Object> serial = new HashMap<String, Object>(2);
            serial.put("seq", seq);
            serial.put("invorg", org != null ? org.getPkValue() : null);
            serialList.add(serial);
            allEntrySerials.put(entryid, serialList);
        }
        if (!allEntrySerials.isEmpty()) {
            this.importSnInfoParam(billtype, parentBillId, "billentry", allEntrySerials, model);
        }
    }

    private void checkMaterialEnableSn(String billtype, DynamicObject bill, String entryKey) {
        String materialCol;
        DynamicObject cfg = this.getSNBillConfigByBillId(billtype, entryKey, bill.getLong("id"));
        if (cfg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SerialNumberOpUtil_4", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        String materialInvCol = cfg.getString("materialcol");
        if (StringUtils.isNotBlank((CharSequence)materialInvCol)) {
            materialInvCol = materialInvCol.substring(materialInvCol.indexOf(entryKey) + entryKey.length() + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)(materialCol = cfg.getString("materialmastercol")))) {
            materialCol = materialCol.substring(materialCol.indexOf(entryKey) + entryKey.length() + 1);
        }
        String invOrgCol = ImportSNPlugin.getOrgCol(cfg.getDynamicObjectCollection("snmainfentry"));
        DynamicObjectCollection entries = this.getView().getParentView().getModel().getEntryEntity(entryKey);
        HashMap<Integer, Boolean> entryEnableSNMap = new HashMap<Integer, Boolean>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            QFilter qFilter;
            DynamicObject materialInvInfo;
            DynamicObject entry = (DynamicObject)entries.get(i);
            if (StringUtils.isNotBlank((CharSequence)materialInvCol)) {
                DynamicObject materialInvInfo2 = entry.getDynamicObject(materialInvCol);
                if (materialInvInfo2 == null || !BD_MATERIALINVENTORYINFO.equals(materialInvInfo2.getDataEntityType().getName())) continue;
                entryEnableSNMap.put(i + 1, materialInvInfo2.getBoolean(ENABLESERIAL));
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)materialCol) || !StringUtils.isNotBlank((CharSequence)invOrgCol)) continue;
            DynamicObject materialInfo = entry.getDynamicObject(materialCol);
            DynamicObject orgInfo = (DynamicObject)this.getValueByName(bill, entry, invOrgCol);
            if (materialInfo == null || orgInfo == null || (materialInvInfo = QueryServiceHelper.queryOne((String)BD_MATERIALINVENTORYINFO, (String)ENABLESERIAL, (QFilter[])(qFilter = new QFilter("masterid", "=", materialInfo.getPkValue()).and(BaseDataServiceHelper.getBaseDataFilter((String)BD_MATERIALINVENTORYINFO, (Long)((Long)orgInfo.getPkValue())))).toArray())) == null) continue;
            entryEnableSNMap.put(i + 1, materialInvInfo.getBoolean(ENABLESERIAL));
        }
        HashSet<Integer> errorIndexes = new HashSet<Integer>(16);
        entries = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entries) {
            int seq = entry.getInt("materiallineno");
            Boolean enableSN = (Boolean)entryEnableSNMap.get(seq);
            if (enableSN != null && enableSN.booleanValue()) continue;
            errorIndexes.add(seq);
        }
        StringBuilder errorBuilder = new StringBuilder();
        for (Integer errorIndex : errorIndexes) {
            errorBuilder.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u7269\u6599\u4e3a\u7a7a\u6216\u672a\u542f\u7528\u5e8f\u5217\u53f7\uff0c\u4e0d\u80fd\u5bfc\u5165\u5e8f\u5217\u53f7\u3002", (String)"SBS-E-135806", (String)"scmc-sbs-form", (Object[])new Object[]{errorIndex}));
        }
        if (errorBuilder.length() > 0) {
            throw new KDBizException(errorBuilder.toString());
        }
    }

    private void importSnInfoParam(String billType, Long parentBillId, String entryName, Map<Long, List<Map<String, Object>>> allEntrySerials, IDataModel model) {
        DynamicObjectCollection import_entryentity = model.getEntryEntity("entryentity");
        if (import_entryentity.size() == 0) {
            this.getView().showTipNotification(SNLang.importInfoIsEmpty());
            return;
        }
        MainEntityType importSnMain = EntityMetadataCache.getDataEntityType((String)"sbs_importsn");
        Map entryentity = ((EntityType)importSnMain.getAllEntities().get("entryentity")).getFields();
        HashMap<Long, List<Map<String, Object>>> importEntryInfoMap = new HashMap<Long, List<Map<String, Object>>>(import_entryentity.size());
        LinkedList importSnInfoList = new LinkedList();
        for (DynamicObject importEntry : import_entryentity) {
            LinkedHashMap infoMap = new LinkedHashMap(import_entryentity.size());
            for (Map.Entry entry : entryentity.entrySet()) {
                infoMap.put(entry.getKey(), importEntry.get((String)entry.getKey()));
            }
            importSnInfoList.add(infoMap);
        }
        for (Map.Entry<Long, List<Map<String, Object>>> entrySerials : allEntrySerials.entrySet()) {
            Long entryId = entrySerials.getKey();
            List<Map<String, Object>> value = entrySerials.getValue();
            for (Map<String, Object> stringObjectMap : value) {
                int seq = (Integer)stringObjectMap.get("seq");
                LinkedList<Map> newImportMap = new LinkedList<Map>();
                for (Map map : importSnInfoList) {
                    int materiallineno = (Integer)map.get("materiallineno");
                    if (materiallineno == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6574\u5355\u5e8f\u5217\u53f7\u65f6\uff0c\u7269\u6599\u660e\u7ec6\u884c\u5fc5\u5f55\uff0c\u8bf7\u53d6\u6d88\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ImportSNPlugin_0", (String)"scmc-sbs-form", (Object[])new Object[0]));
                    }
                    if (seq != materiallineno) continue;
                    newImportMap.add(map);
                    importEntryInfoMap.put(entryId, newImportMap);
                }
            }
        }
        this.insertBillSnRelation(billType, parentBillId, entryName, allEntrySerials, importEntryInfoMap, entryentity);
    }

    private void insertBillSnRelation(String billType, Long parentBillId, String entryName, Map<Long, List<Map<String, Object>>> allEntrySerials, Map<Long, List<Map<String, Object>>> importEntryInfoMap, Map<String, IDataEntityProperty> entryentity) {
        HashSet<String> standFilds = new HashSet<String>(4);
        standFilds.add("sn");
        standFilds.add("materiallineno");
        standFilds.add("note");
        QFilter filter = new QFilter("billtype", "=", (Object)billType).and("entrykey", "=", (Object)entryName).and("billid", "=", (Object)parentBillId).and("entryid", "in", allEntrySerials.keySet());
        Map billSNRelationsById = BusinessDataServiceHelper.loadFromCache((String)"sbs_billsnrelation", (QFilter[])filter.toArray());
        HashMap<Long, DynamicObject> billSNRelationsByEntryId = new HashMap<Long, DynamicObject>(billSNRelationsById.size());
        for (DynamicObject billSNRelation : billSNRelationsById.values()) {
            Long entryId = billSNRelation.getLong("entryid");
            billSNRelationsByEntryId.put(entryId, billSNRelation);
        }
        ArrayList<DynamicObject> billSNRelationsForSave = new ArrayList<DynamicObject>(allEntrySerials.size());
        for (Map.Entry<Long, List<Map<String, Object>>> entrySerials : allEntrySerials.entrySet()) {
            Long entryId = entrySerials.getKey();
            List<Map<String, Object>> serialList = entrySerials.getValue();
            DynamicObject billSNRelation = (DynamicObject)billSNRelationsByEntryId.get(entryId);
            if (billSNRelation == null) {
                billSNRelation = BusinessDataServiceHelper.newDynamicObject((String)"sbs_billsnrelation");
                billSNRelation.set("billtype", (Object)billType);
                billSNRelation.set("entrykey", (Object)entryName);
                billSNRelation.set("billid", (Object)parentBillId);
                billSNRelation.set("entryid", (Object)entryId);
            }
            DynamicObjectCollection sbs_billsnrelation_entryentity = billSNRelation.getDynamicObjectCollection("entryentity");
            for (Map<String, Object> stringObjectMap : serialList) {
                List<Map<String, Object>> importInfo = importEntryInfoMap.get(entryId);
                if (importInfo == null) continue;
                for (Map<String, Object> objectMap : importInfo) {
                    DynamicObject newEntryEntity = sbs_billsnrelation_entryentity.addNew();
                    newEntryEntity.set("handlestatus", (Object)"A");
                    newEntryEntity.set("invorg", stringObjectMap.get("invorg"));
                    newEntryEntity.set("snnumber", objectMap.get("sn"));
                    newEntryEntity.set("remark", objectMap.get("note"));
                    for (Map.Entry<String, IDataEntityProperty> entry : entryentity.entrySet()) {
                        if (standFilds.contains(entry.getKey())) continue;
                        newEntryEntity.set(entry.getKey(), objectMap.get(entry.getKey()));
                    }
                }
            }
            billSNRelationsForSave.add(billSNRelation);
        }
        if (!billSNRelationsForSave.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])billSNRelationsForSave.toArray(new DynamicObject[0]));
        }
        this.getView().returnDataToParent((Object)SNLang.importSuccess());
        this.getView().close();
    }

    private static DynamicObject getBillMainOrg(DynamicObject bill, String billtype) {
        DynamicObject org = "im_transdirbill".equals(billtype) ? (DynamicObject)bill.get("outorg") : (DynamicObject)bill.get("org");
        return org;
    }

    private String getSbsBillSqnrelationESql() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO t_sbs_billsqnrelation_e (FID,FENTRYID,FSEQ,FSNNUMBER,FINVORG,FREMARK,FHANDLESTATUS");
        sb.append(" ) ");
        sb.append(" VALUES (?,?,?,?,?,?,?");
        sb.append(" ) ");
        return sb.toString();
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            String fileUrl = urls[0].toString();
            this.loadXLSXFile(fileUrl);
        }
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        TextProp snProp = (TextProp)dataEntityType.findProperty("sn");
        TextProp noteProp = (TextProp)dataEntityType.findProperty("note");
        int snPropMaxLenth = snProp.getMaxLenth();
        int notePropMaxLenth = noteProp.getMaxLenth();
        DynamicObjectCollection import_entryentity = this.getModel().getEntryEntity("entryentity");
        int count = import_entryentity.size();
        if (count == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"IM-W-174102", (String)"scmc-sbs-form", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < count; ++i) {
            String sn = (String)((DynamicObject)import_entryentity.get(i)).get("sn");
            String note = (String)((DynamicObject)import_entryentity.get(i)).get("note");
            int snLength = sn.length();
            int noteLength = note.length();
            if (snLength > snPropMaxLenth) {
                sn = sn.substring(0, snPropMaxLenth);
                this.getModel().setValue("sn", (Object)sn, i);
            }
            if (noteLength <= notePropMaxLenth) continue;
            note = note.substring(0, notePropMaxLenth);
            this.getModel().setValue("note", (Object)note, i);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadXLSXFile(String fileUrl) {
        void var14_18;
        IFormView view = this.getView();
        ExcelReader reader = new ExcelReader();
        FileService service = FileServiceFactory.getAttachmentFileService();
        final ArrayList realData = new ArrayList();
        final ArrayList identifyMap = new ArrayList(4);
        final HashSet setSn = new HashSet();
        final HashMap repeat = new HashMap();
        final int[] snSeq = new int[]{0};
        try {
            reader.read(service.getInputStream(fileUrl), new SheetHandler(){
                private boolean isOldModel = false;
                String imptFormId = null;

                public void handleRow(SheetHandler.ParsedRow paramParsedRow) {
                    int rowNum = paramParsedRow.getRowNum() + 1;
                    if (rowNum == 1) {
                        String[] split;
                        String value;
                        Map mapData = paramParsedRow.getData();
                        if (!mapData.isEmpty() && StringUtils.isNotBlank((CharSequence)(value = (String)mapData.get(snSeq[0]))) && (split = value.split("#")).length > 1) {
                            this.imptFormId = split[1].trim();
                        }
                        if (StringUtils.isBlank((CharSequence)this.imptFormId)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u7684\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u6a21\u677f\u91cd\u65b0\u5bfc\u5165\u3002", (String)"SBS-E-116764", (String)"scmc-sbs-form", (Object[])new Object[0]));
                        }
                        return;
                    }
                    if (rowNum == 2) {
                        return;
                    }
                    Map mapData = paramParsedRow.getData();
                    if (!mapData.isEmpty()) {
                        String value = (String)mapData.get(snSeq[0]);
                        if (rowNum == 3) {
                            HashSet colVals = new HashSet(mapData.values());
                            if (!colVals.contains("serialnumber") || !colVals.contains("serialcomment")) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u7684\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u6a21\u677f\u91cd\u65b0\u5bfc\u5165\u3002", (String)"SBS-E-116764", (String)"scmc-sbs-form", (Object[])new Object[0]));
                            }
                            if ("im_serialnuminptnew".equals(this.imptFormId) && !colVals.contains("materiallineno")) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u7684\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u6a21\u677f\u91cd\u65b0\u5bfc\u5165\u3002", (String)"SBS-E-116764", (String)"scmc-sbs-form", (Object[])new Object[0]));
                            }
                            if (StringUtils.isEmpty((CharSequence)value)) {
                                return;
                            }
                            for (Map.Entry integerStringEntry : mapData.entrySet()) {
                                if (!"serialnumber".equals(integerStringEntry.getValue())) continue;
                                snSeq[0] = (Integer)integerStringEntry.getKey();
                            }
                            this.isOldModel = value.contains("#");
                            identifyMap.add(mapData);
                            return;
                        }
                        if (StringUtils.isEmpty((CharSequence)value)) {
                            return;
                        }
                        if (rowNum == 4 && !this.isOldModel) {
                            return;
                        }
                        int snNumber = 0;
                        for (Map dataRowMap : identifyMap) {
                            for (Map.Entry integerStringEntry : dataRowMap.entrySet()) {
                                if (!"serialnumber".equals(integerStringEntry.getValue())) continue;
                                snNumber = (Integer)integerStringEntry.getKey();
                            }
                        }
                        if (setSn.contains(mapData.get(snNumber))) {
                            repeat.put(rowNum, mapData.get(snNumber));
                            return;
                        }
                        setSn.add(mapData.get(snNumber));
                        realData.add(mapData);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        MainEntityType importSnMain = EntityMetadataCache.getDataEntityType((String)"sbs_importsn");
        Map entryentity = ((EntityType)importSnMain.getAllEntities().get("entryentity")).getFields();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (Map.Entry entry : entryentity.entrySet()) {
            vs.addField((String)entry.getKey(), new Object[0]);
        }
        HashMap valueMap = new HashMap(3);
        for (Map integerStringMap : identifyMap) {
            for (Map.Entry integerStringEntry : integerStringMap.entrySet()) {
                valueMap.put(integerStringEntry.getValue(), integerStringEntry.getKey());
            }
        }
        boolean bl = false;
        while (var14_18 < realData.size()) {
            Object[] realDataValue = new Object[vs.getFields().size()];
            int j = 0;
            for (String field : vs.getFields()) {
                String identify = "sn".equals(field) ? "serialnumber" : ("note".equals(field) ? "serialcomment" : field);
                if (!StringUtils.isNotEmpty((CharSequence)identify)) continue;
                realDataValue[j] = ((Map)realData.get((int)var14_18)).get(valueMap.get(identify));
                ++j;
            }
            vs.addRow(realDataValue);
            ++var14_18;
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        abstractFormDataModel.batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        if (!repeat.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry map : repeat.entrySet()) {
                sb.append(SNLang.theSNLine((Integer)map.getKey(), (String)map.getValue())).append(",");
            }
            sb.append(SNLang.hasRepeat());
            this.getView().showTipNotification(sb.toString(), Integer.valueOf(10000));
        }
    }

    private void downExcelTpl(Boolean isimportline) {
        String url;
        String billFormId = "";
        String t = null;
        if (isimportline.booleanValue()) {
            billFormId = "im_serialnumimpttpl";
            t = "802615422636752896";
        } else {
            billFormId = "im_serialnuminptnew";
            t = "1574724221253198848";
        }
        String extendData = null;
        LocalDate now = LocalDate.now();
        DynamicObject templateData = null;
        String ctxPath = RequestContext.get().getClientFullContextPath();
        templateData = BusinessDataServiceHelper.loadSingle((Object)t, (String)"bos_importtemplate");
        String fileName = SNLang.prein() + templateData.get("name");
        try {
            url = ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + t + "&formid=" + billFormId + "&plugin=&filename=" + URLEncoder.encode(fileName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth()) + ".xlsx", StandardCharsets.UTF_8.name()) + "&extenddata=" + extendData + "&routeappid=" + this.getView().getFormShowParameter().getServiceAppId() + "&a=t";
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(e.getMessage());
        }
        this.getView().download(url);
        this.getView().sendFormAction(this.getView());
    }

    private DynamicObject getSNBillConfigByBillId(String billtype, String entrytype, Long billid) {
        Collection<DynamicObject> cfgs = this.getSNBillConfig(billtype, entrytype);
        for (DynamicObject cfg : cfgs) {
            DynamicObject result;
            QFilter filter = new QFilter("id", "=", (Object)billid);
            QFilter cfgFilter = this.parseBillFilter(cfg.getString("billfilter"), billtype);
            if (cfgFilter != null) {
                filter.and(cfgFilter);
            }
            if ((result = QueryServiceHelper.queryOne((String)billtype, (String)"id", (QFilter[])filter.toArray())) == null) continue;
            return cfg;
        }
        return null;
    }

    private Collection<DynamicObject> getSNBillConfig(String billtype, String entrytype) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"sbs_snbillconfig", (QFilter[])new QFilter("srcbillobj", "=", (Object)billtype).and("srcbillentry", "=", (Object)entrytype).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return cfgs.values().stream().sorted((cfg1, cfg2) -> {
            Long result = (Long)cfg1.getPkValue() - (Long)cfg2.getPkValue();
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }).collect(Collectors.toList());
    }

    private QFilter parseBillFilter(String jsonCondition, String billtype) {
        if (jsonCondition == null || jsonCondition.isEmpty() || billtype == null) {
            return null;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billtype), condition);
        fb.buildFilter();
        return fb.getQFilter();
    }

    private Object getValueByName(DynamicObject bill, DynamicObject entry, String colName) {
        if (colName.contains(".")) {
            return entry.get(this.getPureKey(colName));
        }
        return bill.get(colName);
    }

    private String getPureKey(String currentKey) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)currentKey) && currentKey.lastIndexOf(46) != -1) {
            return currentKey.substring(currentKey.lastIndexOf(46) + 1);
        }
        return currentKey;
    }

    public static String getOrgCol(DynamicObjectCollection snMainColEntry) {
        if (snMainColEntry == null || snMainColEntry.isEmpty()) {
            return "";
        }
        String invOrgCol = "";
        for (DynamicObject object : snMainColEntry) {
            if (!"invorg".equals(object.getString("snmainfcol"))) continue;
            invOrgCol = object.getString("snmainfsrcbillcol");
            break;
        }
        return invOrgCol;
    }
}

