/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.formplugin.sn;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class InvAccSnMainFilePlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static int MAX_SELECT_RECORDS = 5000;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Object ids = customParams.get("invaccid");
        Long id = this.typeConverSion(ids);
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(MAX_SELECT_RECORDS).append(" t.fid as snmainid ,r.fid as relid,t.fbillid as billid,t.fnumber as number,t.fsnstatus as snstatus,t.finvorgid as invorg,t.fsourcebilltype as sourcebilltype ").append("from t_bd_snmovetrack trk join t_bd_snmovetrack_rel r").append(" on trk.fid = r.ftrackid").append(" join t_bd_snmainfile t on r.fsnmainfileid = t.fid and r.fid = t.ffinalaudittrailid").append(" where trk.fnowinvaccid = ").append(id);
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (String)sql.toString());
        if (dataSet.hasNext()) {
            model.deleteEntryData("entryentity");
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("snmainid", new Object[0]);
            vs.addField("relid", new Object[0]);
            vs.addField("snumber", new Object[0]);
            vs.addField("snstatus", new Object[0]);
            vs.addField("invorg", new Object[0]);
            vs.addField("howsupple", new Object[0]);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long billid = (Long)row.get("billid");
                Object sourcebilltype = row.get("sourcebilltype");
                String howsupple = billid.longValue() == id.longValue() && "sbs_snsupplement".equals(sourcebilltype) ? "1" : "0";
                vs.addRow(new Object[]{row.get("snmainid"), row.get("relid"), row.getString("number"), row.getString("snstatus"), row.getString("invorg"), howsupple});
            }
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
            if (vs.getCount() >= MAX_SELECT_RECORDS) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u6b21\u67e5\u8be2\u7684\u8bb0\u5f55\u8fc7\u591a,\u53ea\u8fd4\u56de\u524d%d\u6761\u7ed3\u679c\u3002", (String)"InvAccSnMainFilePlugin_3", (String)"scmc-sbs-form", (Object[])new Object[0]), MAX_SELECT_RECORDS));
            }
        }
    }

    private Long typeConverSion(Object value) {
        long qty = 0L;
        if (value instanceof Long) {
            qty = (Long)value;
        } else if (value != null) {
            qty = Long.parseLong(value.toString());
        }
        return qty;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("deletedate".equals(operateKey)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_delete", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u5e8f\u5217\u53f7\u5173\u8054\u4fe1\u606f\uff1f", (String)"InvAccSnMainFilePlugin_1", (String)"scmc-sbs-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object materialid = customParams.get("material");
        String snumber = (String)this.getModel().getValue("snumber", rowIndex);
        DynamicObject invorg = (DynamicObject)this.getModel().getValue("invorg", rowIndex);
        Object pkValue = invorg.getPkValue();
        QFilter qFilter1 = new QFilter("number", "=", (Object)snumber);
        QFilter qFilter2 = new QFilter("invorg", "=", pkValue);
        QFilter qFilter3 = new QFilter("material", "=", materialid);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_snmainfile", (String)"id", (QFilter[])new QFilter[]{qFilter1.and(qFilter2).and(qFilter3)});
        if (dynamicObject != null) {
            long id = dynamicObject.getLong("id");
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("bd_snmainfile");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setPkId((Object)id);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        MessageBoxResult result = event.getResult();
        if ("btn_delete".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            Object invaccid;
            Long relId;
            EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryEntity.getSelectRows();
            StringBuilder errors = new StringBuilder();
            Long snumber = (Long)this.getModel().getValue("snmainid", selectRows[0]);
            List error = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"SerialNumberService", (String)"handleSNBySuppleDelete", (Object[])new Object[]{snumber, relId = (Long)this.getModel().getValue("relid", selectRows[0]), invaccid = customParams.get("invaccid")});
            if (!error.isEmpty()) {
                for (String s : error) {
                    errors.append(s);
                    errors.append("\n");
                }
                throw new KDBizException(errors.toString());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"InvAccSnMainFilePlugin_2", (String)"scmc-sbs-form", (Object[])new Object[0]));
            this.getModel().deleteEntryRow("entryentity", selectRows[0]);
        }
    }
}

